/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.utils;

import com.jetbrains.jdbc.base.utils.Uninitialized;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001f\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J*\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00062\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u0014\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/jdbc/base/utils/InvalidatableLazy;", "T", "Lkotlin/Lazy;", "initializer", "Lkotlin/Function0;", "lock", "", "(Lkotlin/jvm/functions/Function0;Ljava/lang/Object;)V", "innerValue", "value", "getValue", "()Ljava/lang/Object;", "invalidate", "", "isInitialized", "", "setValue", "any", "property", "Lkotlin/reflect/KProperty;", "t", "(Ljava/lang/Object;Lkotlin/reflect/KProperty;Ljava/lang/Object;)V", "toString", "", "Frontend"})
public final class InvalidatableLazy<T>
implements Lazy<T> {
    @NotNull
    private final Function0<T> initializer;
    @Nullable
    private volatile Object innerValue;
    @NotNull
    private final Object lock;

    public InvalidatableLazy(@NotNull Function0<? extends T> initializer, @Nullable Object lock) {
        Intrinsics.checkNotNullParameter(initializer, "initializer");
        this.initializer = initializer;
        this.innerValue = Uninitialized.INSTANCE;
        Object object = lock;
        if (object == null) {
            object = this;
        }
        this.lock = object;
    }

    public /* synthetic */ InvalidatableLazy(Function0 function0, Object object, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            object = null;
        }
        this(function0, object);
    }

    public final void invalidate() {
        this.innerValue = Uninitialized.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getValue() {
        Object object;
        Object v1 = this.innerValue;
        if (v1 != Uninitialized.INSTANCE) {
            return (T)v1;
        }
        Object object2 = this.lock;
        synchronized (object2) {
            Object object3;
            boolean bl = false;
            Object v2 = this.innerValue;
            if (v2 != Uninitialized.INSTANCE) {
                object3 = v2;
            } else {
                T typedValue = this.initializer.invoke();
                this.innerValue = typedValue;
                object3 = typedValue;
            }
            object = object3;
        }
        return (T)object;
    }

    @Override
    public boolean isInitialized() {
        return this.innerValue != Uninitialized.INSTANCE;
    }

    @NotNull
    public String toString() {
        return this.isInitialized() ? String.valueOf(this.getValue()) : "Lazy value is not initialized yet.";
    }

    public final void setValue(@NotNull Object any2, @NotNull KProperty<?> property, T t) {
        Intrinsics.checkNotNullParameter(any2, "any");
        Intrinsics.checkNotNullParameter(property, "property");
        this.innerValue = t;
    }
}

