/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.statements.parameters;

import com.jetbrains.jdbc.base.factories.IParametersFactory;
import com.jetbrains.jdbc.base.models.RdGetValueResponse;
import com.jetbrains.jdbc.base.models.RdStatementParameterMetadata;
import com.jetbrains.jdbc.base.models.RdStatementWithParams;
import com.jetbrains.jdbc.base.statements.parameters.IStatementParameter;
import com.jetbrains.jdbc.base.utils.InvalidatableLazy;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import com.jetbrains.jdbc.base.utils.protocol.RdStatementExtKt;
import com.jetbrains.jdbc.base.utils.protocol.initialization.ParameterInitializationData;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u0012\u0010\u001d\u001a\u00020\u001a2\n\u0010\u001e\u001a\u00060\rj\u0002`\u001fJ\u000e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!J\u0014\u0010\"\u001a\u00060\rj\u0002`#2\u0006\u0010 \u001a\u00020!H\u0002J\u0006\u0010$\u001a\u00020\u001cR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0016\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u00050\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/jetbrains/jdbc/base/statements/parameters/StatementParameters;", "", "rdStatementWithParams", "Lcom/jetbrains/jdbc/base/models/RdStatementWithParams;", "rdParameters", "", "Lcom/jetbrains/jdbc/base/utils/protocol/initialization/ParameterInitializationData;", "parametersFactory", "Lcom/jetbrains/jdbc/base/factories/IParametersFactory;", "statementLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "(Lcom/jetbrains/jdbc/base/models/RdStatementWithParams;Ljava/util/List;Lcom/jetbrains/jdbc/base/factories/IParametersFactory;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "count", "", "getCount", "()I", "metadata", "Lcom/jetbrains/jdbc/base/models/RdStatementParameterMetadata;", "getMetadata", "()Ljava/util/List;", "metadata$delegate", "Lkotlin/Lazy;", "outValues", "Lcom/jetbrains/jdbc/base/utils/InvalidatableLazy;", "Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;", "parameters", "Lcom/jetbrains/jdbc/base/statements/parameters/IStatementParameter;", "clearPendingValues", "", "getParameter", "index", "Lcom/jetbrains/jdbc/base/OneBasedIndex;", "name", "", "getParameterIndex", "Lcom/jetbrains/jdbc/base/ZeroBasedIndex;", "statementExecuted", "Frontend"})
public final class StatementParameters {
    @NotNull
    private final RdStatementWithParams rdStatementWithParams;
    @NotNull
    private final List<IStatementParameter> parameters;
    @NotNull
    private final Lazy metadata$delegate;
    @NotNull
    private final InvalidatableLazy<List<RdGetValueResponse>> outValues;
    private final int count;

    public StatementParameters(@NotNull RdStatementWithParams rdStatementWithParams, @NotNull List<ParameterInitializationData> rdParameters, @NotNull IParametersFactory parametersFactory2, @NotNull Lifetime statementLifetime) {
        Intrinsics.checkNotNullParameter(rdStatementWithParams, "rdStatementWithParams");
        Intrinsics.checkNotNullParameter(rdParameters, "rdParameters");
        Intrinsics.checkNotNullParameter(parametersFactory2, "parametersFactory");
        Intrinsics.checkNotNullParameter(statementLifetime, "statementLifetime");
        this.rdStatementWithParams = rdStatementWithParams;
        this.metadata$delegate = LazyKt.lazy((Function0)new Function0<List<? extends RdStatementParameterMetadata>>(this, statementLifetime){
            final /* synthetic */ StatementParameters this$0;
            final /* synthetic */ Lifetime $statementLifetime;
            {
                this.this$0 = $receiver;
                this.$statementLifetime = $statementLifetime;
                super(0);
            }

            @NotNull
            public final List<RdStatementParameterMetadata> invoke() {
                return RdStatementExtKt.getParameterMetadata(StatementParameters.access$getRdStatementWithParams$p(this.this$0), this.$statementLifetime);
            }
        });
        this.outValues = new InvalidatableLazy(new Function0<List<? extends RdGetValueResponse>>(this, statementLifetime){
            final /* synthetic */ StatementParameters this$0;
            final /* synthetic */ Lifetime $statementLifetime;
            {
                this.this$0 = $receiver;
                this.$statementLifetime = $statementLifetime;
                super(0);
            }

            @NotNull
            public final List<RdGetValueResponse> invoke() {
                return RdStatementExtKt.getOutValues(StatementParameters.access$getRdStatementWithParams$p(this.this$0), this.$statementLifetime);
            }
        }, null, 2, null);
        List params = new ArrayList();
        int n = rdParameters.size();
        for (int i = 0; i < n; ++i) {
            IStatementParameter parameter2 = parametersFactory2.createStatementParameter(i, rdParameters.get(i), statementLifetime, (Function1<? super Integer, RdStatementParameterMetadata>)new Function1<Integer, RdStatementParameterMetadata>(this){
                final /* synthetic */ StatementParameters this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final RdStatementParameterMetadata invoke(int index) {
                    return this.this$0.getMetadata().get(index);
                }
            }, (Function1<? super Integer, ? extends RdGetValueResponse>)new Function1<Integer, RdGetValueResponse>(this){
                final /* synthetic */ StatementParameters this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final RdGetValueResponse invoke(int index) {
                    return (RdGetValueResponse)((List)StatementParameters.access$getOutValues$p(this.this$0).getValue()).get(index);
                }
            });
            params.add(parameter2);
        }
        this.parameters = params;
        this.count = this.parameters.size();
    }

    @NotNull
    public final List<RdStatementParameterMetadata> getMetadata() {
        Lazy lazy = this.metadata$delegate;
        return (List)lazy.getValue();
    }

    public final int getCount() {
        return this.count;
    }

    @NotNull
    public final IStatementParameter getParameter(int index) {
        if (index - 1 >= this.parameters.size()) {
            throw ExceptionsKt.parameterNotFound(index);
        }
        return this.parameters.get(index - 1);
    }

    @NotNull
    public final IStatementParameter getParameter(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        int index = this.getParameterIndex(name);
        if (index == -1) {
            throw ExceptionsKt.parameterNotFound(name);
        }
        return this.parameters.get(index);
    }

    public final void clearPendingValues() {
        for (IStatementParameter parameter2 : this.parameters) {
            parameter2.clearPendingValue();
        }
    }

    public final void statementExecuted() {
        this.outValues.invalidate();
    }

    private final int getParameterIndex(String name) {
        int index = -1;
        int n = this.parameters.size();
        for (int i = 0; i < n; ++i) {
            RdStatementParameterMetadata parameterMetadata = this.getMetadata().get(i);
            if (Intrinsics.areEqual(parameterMetadata.getName(), name)) {
                index = i;
                break;
            }
            if (index != -1 || !StringsKt.equals(parameterMetadata.getName(), name, true)) continue;
            index = i;
        }
        return index;
    }

    public static final /* synthetic */ RdStatementWithParams access$getRdStatementWithParams$p(StatementParameters $this) {
        return $this.rdStatementWithParams;
    }

    public static final /* synthetic */ InvalidatableLazy access$getOutValues$p(StatementParameters $this) {
        return $this.outValues;
    }
}

