/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.statements.parameters;

import com.jetbrains.jdbc.base.conversions.get.ValueGetter;
import com.jetbrains.jdbc.base.conversions.set.ValueSetter;
import com.jetbrains.jdbc.base.models.RdGetValueResponse;
import com.jetbrains.jdbc.base.models.RdSetValueRequest;
import com.jetbrains.jdbc.base.models.RdStatementParameter;
import com.jetbrains.jdbc.base.models.RdStatementParameterInitialState;
import com.jetbrains.jdbc.base.models.RdStatementParameterMetadata;
import com.jetbrains.jdbc.base.statements.parameters.IStatementParameter;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import com.jetbrains.jdbc.base.utils.protocol.JdbcModelExtKt;
import com.jetbrains.jdbc.base.utils.protocol.pooling.IStatementParameterPool;
import com.jetbrains.jdbc.base.utils.protocol.properties.RdAsyncProperty;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISignal;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Calendar;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b4\u0018\u00002\u00020\u0001B\u0085\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012!\u0010\f\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u00110\r\u0012#\u0010\u0012\u001a\u001f\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00130\r\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u001d\u001a\u00020\u001eH\u0016J/\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H 0\u001a\"\u0004\b\u0000\u0010 2\u0006\u0010!\u001a\u0002H 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H 0#H\u0002\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020(H\u0016J\n\u0010)\u001a\u0004\u0018\u00010*H\u0016J\u0019\u0010+\u001a\u0004\u0018\u00010,2\b\u0010-\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010.J\n\u0010/\u001a\u0004\u0018\u00010*H\u0016J\n\u00100\u001a\u0004\u0018\u000101H\u0016J\u000f\u00102\u001a\u0004\u0018\u00010&H\u0016\u00a2\u0006\u0002\u00103J\u000f\u00104\u001a\u0004\u0018\u000105H\u0016\u00a2\u0006\u0002\u00106J\n\u00107\u001a\u0004\u0018\u000108H\u0016J\n\u00109\u001a\u0004\u0018\u00010:H\u0016J\n\u0010;\u001a\u0004\u0018\u00010<H\u0016J\u000f\u0010=\u001a\u0004\u0018\u00010>H\u0016\u00a2\u0006\u0002\u0010?J\u000f\u0010@\u001a\u0004\u0018\u00010AH\u0016\u00a2\u0006\u0002\u0010BJ\u000f\u0010C\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010DJ\n\u0010E\u001a\u0004\u0018\u00010FH\u0016J\n\u0010G\u001a\u0004\u0018\u00010HH\u0016J\n\u0010I\u001a\u0004\u0018\u00010JH\u0016J\u000f\u0010K\u001a\u0004\u0018\u00010LH\u0016\u00a2\u0006\u0002\u0010MJ\b\u0010N\u001a\u00020\u0011H\u0016J\n\u0010O\u001a\u0004\u0018\u00010:H\u0016J\n\u0010P\u001a\u0004\u0018\u00010QH\u0016J\n\u0010R\u001a\u0004\u0018\u00010SH\u0016J\n\u0010T\u001a\u0004\u0018\u00010UH\u0016J#\u0010T\u001a\u0004\u0018\u0001H \"\u0004\b\u0000\u0010 2\f\u0010V\u001a\b\u0012\u0004\u0012\u0002H 0WH\u0016\u00a2\u0006\u0002\u0010XJ\n\u0010Y\u001a\u0004\u0018\u00010ZH\u0016J\n\u0010[\u001a\u0004\u0018\u00010\\H\u0016J\b\u0010]\u001a\u00020\u0013H\u0002J\b\u0010^\u001a\u00020_H\u0016J\b\u0010`\u001a\u00020aH\u0016J\u000f\u0010b\u001a\u0004\u0018\u00010cH\u0016\u00a2\u0006\u0002\u0010dJ\u0014\u0010e\u001a\u0004\u0018\u00010f2\b\u0010g\u001a\u0004\u0018\u00010hH\u0016J\n\u0010i\u001a\u0004\u0018\u00010jH\u0016J\n\u0010k\u001a\u0004\u0018\u00010SH\u0016J\u0014\u0010l\u001a\u0004\u0018\u00010m2\b\u0010g\u001a\u0004\u0018\u00010hH\u0016J\u0014\u0010n\u001a\u0004\u0018\u00010o2\b\u0010g\u001a\u0004\u0018\u00010hH\u0016J\b\u0010p\u001a\u00020qH\u0016J\n\u0010r\u001a\u0004\u0018\u00010sH\u0016J\n\u0010t\u001a\u0004\u0018\u00010uH\u0016J\u0010\u0010v\u001a\u00020\u001e2\u0006\u0010V\u001a\u00020\u0003H\u0016J\u0012\u0010w\u001a\u00020\u001e2\b\u0010x\u001a\u0004\u0018\u00010(H\u0016J!\u0010y\u001a\u00020\u001e2\b\u0010x\u001a\u0004\u0018\u00010*2\b\u0010z\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010{J\u0012\u0010|\u001a\u00020\u001e2\b\u0010x\u001a\u0004\u0018\u00010,H\u0016J!\u0010}\u001a\u00020\u001e2\b\u0010x\u001a\u0004\u0018\u00010*2\b\u0010z\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010{J\u0012\u0010~\u001a\u00020\u001e2\b\u0010x\u001a\u0004\u0018\u000101H\u0016J\u0018\u0010\u007f\u001a\u00020\u001e2\b\u0010x\u001a\u0004\u0018\u00010&H\u0016\u00a2\u0006\u0003\u0010\u0080\u0001J\u0019\u0010\u0081\u0001\u001a\u00020\u001e2\b\u0010x\u001a\u0004\u0018\u000105H\u0016\u00a2\u0006\u0003\u0010\u0082\u0001J\u0013\u0010\u0083\u0001\u001a\u00020\u001e2\b\u0010x\u001a\u0004\u0018\u000108H\u0016J#\u0010\u0084\u0001\u001a\u00020\u001e2\b\u0010x\u001a\u0004\u0018\u00010:2\b\u0010z\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0003\u0010\u0085\u0001J\u0013\u0010\u0086\u0001\u001a\u00020\u001e2\b\u0010x\u001a\u0004\u0018\u00010<H\u0016J\u0019\u0010\u0087\u0001\u001a\u00020\u001e2\b\u0010x\u001a\u0004\u0018\u00010>H\u0016\u00a2\u0006\u0003\u0010\u0088\u0001J\u0019\u0010\u0089\u0001\u001a\u00020\u001e2\b\u0010x\u001a\u0004\u0018\u00010AH\u0016\u00a2\u0006\u0003\u0010\u008a\u0001J\u0019\u0010\u008b\u0001\u001a\u00020\u001e2\b\u0010x\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0003\u0010\u008c\u0001J\u0011\u0010\u008d\u0001\u001a\u00020\u001e2\u0006\u0010x\u001a\u00020FH\u0016J\u0011\u0010\u008e\u0001\u001a\u00020\u001e2\u0006\u0010x\u001a\u00020HH\u0016J\u0011\u0010\u008f\u0001\u001a\u00020\u001e2\u0006\u0010x\u001a\u00020JH\u0016J\u0019\u0010\u0090\u0001\u001a\u00020\u001e2\b\u0010x\u001a\u0004\u0018\u00010LH\u0016\u00a2\u0006\u0003\u0010\u0091\u0001J#\u0010\u0092\u0001\u001a\u00020\u001e2\b\u0010x\u001a\u0004\u0018\u00010:2\b\u0010z\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0003\u0010\u0085\u0001J\u0013\u0010\u0093\u0001\u001a\u00020\u001e2\b\u0010x\u001a\u0004\u0018\u00010QH\u0016J\u0013\u0010\u0094\u0001\u001a\u00020\u001e2\b\u0010x\u001a\u0004\u0018\u00010SH\u0016J\u001a\u0010\u0095\u0001\u001a\u00020\u001e2\t\u0010\u0096\u0001\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0003\u0010\u008c\u0001J/\u0010\u0097\u0001\u001a\u00020\u001e2\b\u0010x\u001a\u0004\u0018\u00010U2\t\u0010\u0098\u0001\u001a\u0004\u0018\u00010\u00032\t\u0010\u0099\u0001\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0003\u0010\u009a\u0001J\u0013\u0010\u009b\u0001\u001a\u00020\u001e2\b\u0010x\u001a\u0004\u0018\u00010ZH\u0016J\u0013\u0010\u009c\u0001\u001a\u00020\u001e2\b\u0010x\u001a\u0004\u0018\u00010\\H\u0016J\u0013\u0010\u009d\u0001\u001a\u00020\u001e2\b\u0010x\u001a\u0004\u0018\u00010_H\u0016J\u0013\u0010\u009e\u0001\u001a\u00020\u001e2\b\u0010x\u001a\u0004\u0018\u00010aH\u0016J\u0013\u0010\u009f\u0001\u001a\u00020\u001e2\b\u0010x\u001a\u0004\u0018\u00010jH\u0016J\u0019\u0010\u00a0\u0001\u001a\u00020\u001e2\b\u0010x\u001a\u0004\u0018\u00010cH\u0016\u00a2\u0006\u0003\u0010\u00a1\u0001J\u001d\u0010\u00a2\u0001\u001a\u00020\u001e2\b\u0010x\u001a\u0004\u0018\u00010f2\b\u0010g\u001a\u0004\u0018\u00010hH\u0016J\u0013\u0010\u00a3\u0001\u001a\u00020\u001e2\b\u0010x\u001a\u0004\u0018\u00010SH\u0016J\u001d\u0010\u00a4\u0001\u001a\u00020\u001e2\b\u0010x\u001a\u0004\u0018\u00010m2\b\u0010g\u001a\u0004\u0018\u00010hH\u0016J\u001d\u0010\u00a5\u0001\u001a\u00020\u001e2\b\u0010x\u001a\u0004\u0018\u00010o2\b\u0010g\u001a\u0004\u0018\u00010hH\u0016J\u0013\u0010\u00a6\u0001\u001a\u00020\u001e2\b\u0010x\u001a\u0004\u0018\u00010qH\u0016J\"\u0010\u00a7\u0001\u001a\u00020\u001e2\b\u0010x\u001a\u0004\u0018\u00010*2\b\u0010z\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010{J\u001d\u0010\u00a8\u0001\u001a\u00020\u001e2\b\u0010x\u001a\u0004\u0018\u00010u2\b\u0010g\u001a\u0004\u0018\u00010hH\u0016R)\u0010\f\u001a\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0004\u0012\u00020\u00110\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0012\u001a\u001f\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00130\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00a9\u0001"}, d2={"Lcom/jetbrains/jdbc/base/statements/parameters/StatementParameter;", "Lcom/jetbrains/jdbc/base/statements/parameters/IStatementParameter;", "myIndex", "", "rdParameter", "Lcom/jetbrains/jdbc/base/models/RdStatementParameter;", "initialState", "Lcom/jetbrains/jdbc/base/models/RdStatementParameterInitialState;", "parameterPool", "Lcom/jetbrains/jdbc/base/utils/protocol/pooling/IStatementParameterPool;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getMyMetadata", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "index", "Lcom/jetbrains/jdbc/base/models/RdStatementParameterMetadata;", "getMyOutValue", "Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;", "valueGetter", "Lcom/jetbrains/jdbc/base/conversions/get/ValueGetter;", "valueSetter", "Lcom/jetbrains/jdbc/base/conversions/set/ValueSetter;", "(ILcom/jetbrains/jdbc/base/models/RdStatementParameter;Lcom/jetbrains/jdbc/base/models/RdStatementParameterInitialState;Lcom/jetbrains/jdbc/base/utils/protocol/pooling/IStatementParameterPool;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lcom/jetbrains/jdbc/base/conversions/get/ValueGetter;Lcom/jetbrains/jdbc/base/conversions/set/ValueSetter;)V", "inputValue", "Lcom/jetbrains/jdbc/base/utils/protocol/properties/RdAsyncProperty;", "Lcom/jetbrains/jdbc/base/models/RdSetValueRequest;", "outParameterType", "clearPendingValue", "", "createProperty", "T", "initialValue", "signal", "Lcom/jetbrains/rd/util/reactive/ISignal;", "(Ljava/lang/Object;Lcom/jetbrains/rd/util/reactive/ISignal;)Lcom/jetbrains/jdbc/base/utils/protocol/properties/RdAsyncProperty;", "expectsOutputValue", "", "getArray", "Ljava/sql/Array;", "getAsciiStream", "Ljava/io/InputStream;", "getBigDecimal", "Ljava/math/BigDecimal;", "scale", "(Ljava/lang/Integer;)Ljava/math/BigDecimal;", "getBinaryStream", "getBlob", "Ljava/sql/Blob;", "getBoolean", "()Ljava/lang/Boolean;", "getByte", "", "()Ljava/lang/Byte;", "getBytes", "", "getCharacterStream", "Ljava/io/Reader;", "getClob", "Ljava/sql/Clob;", "getDouble", "", "()Ljava/lang/Double;", "getFloat", "", "()Ljava/lang/Float;", "getInt", "()Ljava/lang/Integer;", "getLocalDate", "Ljava/time/LocalDate;", "getLocalDateTime", "Ljava/time/LocalDateTime;", "getLocalTime", "Ljava/time/LocalTime;", "getLong", "", "()Ljava/lang/Long;", "getMetadata", "getNCharacterStream", "getNClob", "Ljava/sql/NClob;", "getNString", "", "getObject", "", "type", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljava/lang/Object;", "getOffsetDateTime", "Ljava/time/OffsetDateTime;", "getOffsetTime", "Ljava/time/OffsetTime;", "getOutputValue", "getRef", "Ljava/sql/Ref;", "getRowId", "Ljava/sql/RowId;", "getShort", "", "()Ljava/lang/Short;", "getSqlDate", "Ljava/sql/Date;", "cal", "Ljava/util/Calendar;", "getSqlXml", "Ljava/sql/SQLXML;", "getString", "getTime", "Ljava/sql/Time;", "getTimestamp", "Ljava/sql/Timestamp;", "getURL", "Ljava/net/URL;", "getUUID", "Ljava/util/UUID;", "getUtilDate", "Ljava/util/Date;", "markAsOut", "setArray", "value", "setAsciiStream", "length", "(Ljava/io/InputStream;Ljava/lang/Integer;)V", "setBigDecimal", "setBinaryStream", "setBlob", "setBoolean", "(Ljava/lang/Boolean;)V", "setByte", "(Ljava/lang/Byte;)V", "setBytes", "setCharacterStream", "(Ljava/io/Reader;Ljava/lang/Integer;)V", "setClob", "setDouble", "(Ljava/lang/Double;)V", "setFloat", "(Ljava/lang/Float;)V", "setInt", "(Ljava/lang/Integer;)V", "setLocalDate", "setLocalDateTime", "setLocalTime", "setLong", "(Ljava/lang/Long;)V", "setNCharacterStream", "setNClob", "setNString", "setNull", "targetType", "setObject", "targetSqlType", "scaleOrLength", "(Ljava/lang/Object;Ljava/lang/Integer;Ljava/lang/Integer;)V", "setOffsetDateTime", "setOffsetTime", "setRef", "setRowId", "setSQLXML", "setShort", "(Ljava/lang/Short;)V", "setSqlDate", "setString", "setTime", "setTimestamp", "setURL", "setUnicodeStream", "setUtilDate", "Frontend"})
public final class StatementParameter
implements IStatementParameter {
    private final int myIndex;
    @NotNull
    private final RdStatementParameter rdParameter;
    @NotNull
    private final Function1<Integer, RdStatementParameterMetadata> getMyMetadata;
    @NotNull
    private final Function1<Integer, RdGetValueResponse> getMyOutValue;
    @NotNull
    private final ValueGetter valueGetter;
    @NotNull
    private final ValueSetter valueSetter;
    @NotNull
    private final RdAsyncProperty<RdSetValueRequest> inputValue;
    @NotNull
    private final RdAsyncProperty<Integer> outParameterType;

    public StatementParameter(int myIndex, @NotNull RdStatementParameter rdParameter, @NotNull RdStatementParameterInitialState initialState, final @NotNull IStatementParameterPool parameterPool, @NotNull Lifetime lifetime, @NotNull Function1<? super Integer, RdStatementParameterMetadata> getMyMetadata, @NotNull Function1<? super Integer, ? extends RdGetValueResponse> getMyOutValue, @NotNull ValueGetter valueGetter, @NotNull ValueSetter valueSetter) {
        Intrinsics.checkNotNullParameter(rdParameter, "rdParameter");
        Intrinsics.checkNotNullParameter(initialState, "initialState");
        Intrinsics.checkNotNullParameter(parameterPool, "parameterPool");
        Intrinsics.checkNotNullParameter(lifetime, "lifetime");
        Intrinsics.checkNotNullParameter(getMyMetadata, "getMyMetadata");
        Intrinsics.checkNotNullParameter(getMyOutValue, "getMyOutValue");
        Intrinsics.checkNotNullParameter(valueGetter, "valueGetter");
        Intrinsics.checkNotNullParameter(valueSetter, "valueSetter");
        this.myIndex = myIndex;
        this.rdParameter = rdParameter;
        this.getMyMetadata = getMyMetadata;
        this.getMyOutValue = getMyOutValue;
        this.valueGetter = valueGetter;
        this.valueSetter = valueSetter;
        this.inputValue = this.createProperty(initialState.getInputValue(), this.rdParameter.getSetInputValue());
        this.outParameterType = this.createProperty(initialState.getOutParameterType(), this.rdParameter.getSetOutParameterType());
        lifetime.onTermination(new Function0<Unit>(){

            @Override
            public final void invoke() {
                parameterPool.returnParameter(rdParameter);
            }
        });
    }

    @Override
    public void markAsOut(int type2) {
        this.outParameterType.set(type2);
    }

    @Override
    @NotNull
    public RdStatementParameterMetadata getMetadata() {
        return this.getMyMetadata.invoke(this.myIndex);
    }

    @Override
    public void clearPendingValue() {
        this.inputValue.set(null);
    }

    @Override
    public void setNull(@Nullable Integer targetType) {
        RdSetValueRequest pendingValue = this.valueSetter.setNull(targetType);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setBoolean(@Nullable Boolean value2) {
        RdSetValueRequest pendingValue = ValueSetter.setBoolean$default(this.valueSetter, value2, null, 2, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setByte(@Nullable Byte value2) {
        RdSetValueRequest pendingValue = ValueSetter.setByte$default(this.valueSetter, value2, null, 2, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setShort(@Nullable Short value2) {
        RdSetValueRequest pendingValue = ValueSetter.setShort$default(this.valueSetter, value2, null, 2, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setInt(@Nullable Integer value2) {
        RdSetValueRequest pendingValue = ValueSetter.setInt$default(this.valueSetter, value2, null, 2, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setLong(@Nullable Long value2) {
        RdSetValueRequest pendingValue = ValueSetter.setLong$default(this.valueSetter, value2, null, 2, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setFloat(@Nullable Float value2) {
        RdSetValueRequest pendingValue = ValueSetter.setFloat$default(this.valueSetter, value2, null, 2, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setDouble(@Nullable Double value2) {
        RdSetValueRequest pendingValue = ValueSetter.setDouble$default(this.valueSetter, value2, null, 2, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setBigDecimal(@Nullable BigDecimal value2) {
        RdSetValueRequest pendingValue = ValueSetter.setBigDecimal$default(this.valueSetter, value2, null, 2, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setString(@Nullable String value2) {
        RdSetValueRequest pendingValue = ValueSetter.setString$default(this.valueSetter, value2, null, 2, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setBytes(@Nullable byte[] value2) {
        RdSetValueRequest pendingValue = ValueSetter.setBytes$default(this.valueSetter, value2, null, 2, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setSqlDate(@Nullable Date value2, @Nullable Calendar cal) {
        RdSetValueRequest pendingValue = ValueSetter.setSqlDate$default(this.valueSetter, value2, cal, null, 4, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setUtilDate(@Nullable java.util.Date value2, @Nullable Calendar cal) {
        RdSetValueRequest pendingValue = ValueSetter.setUtilDate$default(this.valueSetter, value2, cal, null, 4, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setTime(@Nullable Time value2, @Nullable Calendar cal) {
        RdSetValueRequest pendingValue = ValueSetter.setTime$default(this.valueSetter, value2, cal, null, 4, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setTimestamp(@Nullable Timestamp value2, @Nullable Calendar cal) {
        RdSetValueRequest pendingValue = ValueSetter.setTimestamp$default(this.valueSetter, value2, cal, null, 4, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setLocalDateTime(@NotNull LocalDateTime value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        RdSetValueRequest pendingValue = ValueSetter.setLocalDateTime$default(this.valueSetter, value2, null, 2, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setLocalDate(@NotNull LocalDate value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        RdSetValueRequest pendingValue = ValueSetter.setLocalDate$default(this.valueSetter, value2, null, 2, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setLocalTime(@NotNull LocalTime value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        RdSetValueRequest pendingValue = ValueSetter.setLocalTime$default(this.valueSetter, value2, null, 2, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setOffsetDateTime(@Nullable OffsetDateTime value2) {
        RdSetValueRequest pendingValue = ValueSetter.setOffsetDateTime$default(this.valueSetter, value2, null, 2, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setOffsetTime(@Nullable OffsetTime value2) {
        RdSetValueRequest pendingValue = ValueSetter.setOffsetTime$default(this.valueSetter, value2, null, 2, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setAsciiStream(@Nullable InputStream value2, @Nullable Integer length) {
        RdSetValueRequest pendingValue = ValueSetter.setAsciiStream$default(this.valueSetter, value2, length, null, 4, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setUnicodeStream(@Nullable InputStream value2, @Nullable Integer length) {
        RdSetValueRequest pendingValue = ValueSetter.setUnicodeStream$default(this.valueSetter, value2, length, null, 4, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setBinaryStream(@Nullable InputStream value2, @Nullable Integer length) {
        RdSetValueRequest pendingValue = ValueSetter.setBinaryStream$default(this.valueSetter, value2, length, null, 4, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setCharacterStream(@Nullable Reader value2, @Nullable Integer length) {
        RdSetValueRequest pendingValue = ValueSetter.setCharacterStream$default(this.valueSetter, value2, length, null, 4, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setBlob(@Nullable Blob value2) {
        RdSetValueRequest pendingValue = ValueSetter.setBlob$default(this.valueSetter, value2, null, 2, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setClob(@Nullable Clob value2) {
        RdSetValueRequest pendingValue = ValueSetter.setClob$default(this.valueSetter, value2, null, 2, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setNString(@Nullable String value2) {
        RdSetValueRequest pendingValue = ValueSetter.setNString$default(this.valueSetter, value2, null, 2, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setNClob(@Nullable NClob value2) {
        RdSetValueRequest pendingValue = ValueSetter.setNClob$default(this.valueSetter, value2, null, 2, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setSQLXML(@Nullable SQLXML value2) {
        RdSetValueRequest pendingValue = ValueSetter.setSQLXML$default(this.valueSetter, value2, null, 2, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setNCharacterStream(@Nullable Reader value2, @Nullable Integer length) {
        RdSetValueRequest pendingValue = ValueSetter.setNCharacterStream$default(this.valueSetter, value2, length, null, 4, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setURL(@Nullable URL value2) {
        RdSetValueRequest pendingValue = ValueSetter.setURL$default(this.valueSetter, value2, null, 2, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setRowId(@Nullable RowId value2) {
        RdSetValueRequest pendingValue = ValueSetter.setRowId$default(this.valueSetter, value2, null, 2, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setRef(@Nullable Ref value2) {
        RdSetValueRequest pendingValue = ValueSetter.setRef$default(this.valueSetter, value2, null, 2, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setArray(@Nullable Array value2) {
        RdSetValueRequest pendingValue = ValueSetter.setArray$default(this.valueSetter, value2, null, 2, null);
        this.inputValue.set(pendingValue);
    }

    @Override
    public void setObject(@Nullable Object value2, @Nullable Integer targetSqlType, @Nullable Integer scaleOrLength) {
        Integer n = targetSqlType;
        if (n == null) {
            n = this.outParameterType.get();
        }
        Integer targetType = n;
        RdSetValueRequest pendingValue = this.valueSetter.setObject(value2, targetType, scaleOrLength);
        this.inputValue.set(pendingValue);
    }

    @Override
    @Nullable
    public String getString() {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getString(outputValue);
    }

    @Override
    @Nullable
    public Boolean getBoolean() {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getBoolean(outputValue);
    }

    @Override
    @Nullable
    public Byte getByte() {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getByte(outputValue);
    }

    @Override
    @Nullable
    public Short getShort() {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getShort(outputValue);
    }

    @Override
    @Nullable
    public Integer getInt() {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getInt(outputValue);
    }

    @Override
    @Nullable
    public Long getLong() {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getLong(outputValue);
    }

    @Override
    @Nullable
    public Float getFloat() {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getFloat(outputValue);
    }

    @Override
    @Nullable
    public Double getDouble() {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getDouble(outputValue);
    }

    @Override
    @Nullable
    public BigDecimal getBigDecimal(@Nullable Integer scale) {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getBigDecimal(outputValue, scale);
    }

    @Override
    @Nullable
    public byte[] getBytes() {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getBytes(outputValue);
    }

    @Override
    @Nullable
    public Date getSqlDate(@Nullable Calendar cal) {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getSqlDate(outputValue, cal);
    }

    @Override
    @Nullable
    public java.util.Date getUtilDate() {
        RdGetValueResponse outputValue = this.getOutputValue();
        return ValueGetter.getTimestamp$default(this.valueGetter, outputValue, null, 2, null);
    }

    @Override
    @Nullable
    public Time getTime(@Nullable Calendar cal) {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getTime(outputValue, cal);
    }

    @Override
    @Nullable
    public Timestamp getTimestamp(@Nullable Calendar cal) {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getTimestamp(outputValue, cal);
    }

    @Override
    @Nullable
    public LocalDateTime getLocalDateTime() {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getLocalDateTime(outputValue);
    }

    @Override
    @Nullable
    public LocalDate getLocalDate() {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getLocalDate(outputValue);
    }

    @Override
    @Nullable
    public LocalTime getLocalTime() {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getLocalTime(outputValue);
    }

    @Override
    @Nullable
    public OffsetDateTime getOffsetDateTime() {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getOffsetDateTime(outputValue);
    }

    @Override
    @Nullable
    public OffsetTime getOffsetTime() {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getOffsetTime(outputValue);
    }

    @Override
    @Nullable
    public InputStream getAsciiStream() {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getAsciiStream(outputValue);
    }

    @Override
    @Nullable
    public InputStream getBinaryStream() {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getBinaryStream(outputValue);
    }

    @Override
    @Nullable
    public Reader getCharacterStream() {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getCharacterStream(outputValue);
    }

    @Override
    @Nullable
    public String getNString() {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getNString(outputValue);
    }

    @Override
    @Nullable
    public Reader getNCharacterStream() {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getNCharacterStream(outputValue);
    }

    @Override
    @Nullable
    public Blob getBlob() {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getBlob(outputValue);
    }

    @Override
    @Nullable
    public Clob getClob() {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getClob(outputValue);
    }

    @Override
    @NotNull
    public Array getArray() {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getArray(outputValue);
    }

    @Override
    @NotNull
    public URL getURL() {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getURL(outputValue);
    }

    @Override
    @NotNull
    public RowId getRowId() {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getRowId(outputValue);
    }

    @Override
    @NotNull
    public Ref getRef() {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getRef(outputValue);
    }

    @Override
    @Nullable
    public NClob getNClob() {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getNClob(outputValue);
    }

    @Override
    @Nullable
    public SQLXML getSqlXml() {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getSqlXml(outputValue);
    }

    @Override
    @Nullable
    public UUID getUUID() {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getUUID(outputValue);
    }

    @Override
    @Nullable
    public Object getObject() {
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getObject(outputValue);
    }

    @Override
    @Nullable
    public <T> T getObject(@NotNull Class<T> type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        RdGetValueResponse outputValue = this.getOutputValue();
        return this.valueGetter.getObject(outputValue, type2);
    }

    private final RdGetValueResponse getOutputValue() {
        if (!this.expectsOutputValue()) {
            throw ExceptionsKt.parameterIsNotOutput(this.myIndex);
        }
        RdGetValueResponse rdGetValueResponse = this.getMyOutValue.invoke(this.myIndex);
        if (rdGetValueResponse == null) {
            throw ExceptionsKt.noOutputValueForParameter(this.myIndex);
        }
        return rdGetValueResponse;
    }

    private final boolean expectsOutputValue() {
        return this.outParameterType.get() != null;
    }

    private final <T> RdAsyncProperty<T> createProperty(T initialValue, ISignal<T> signal) {
        return new RdAsyncProperty<T>(initialValue, JdbcModelExtKt.getScheduler(this.rdParameter), signal);
    }
}

