/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.statements.parameters;

import com.jetbrains.jdbc.base.models.RdStatementParameterMetadata;
import com.jetbrains.jdbc.base.statements.parameters.StatementParameters;
import com.jetbrains.jdbc.base.utils.translators.IJdbcToJavaTypeTranslator;
import com.jetbrains.jdbc.base.utils.translators.IJdbcToNativeTypeTranslator;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0002J\u0014\u0010\u000e\u001a\u00020\u000f2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\b\u0010\u0010\u001a\u00020\fH\u0016J\u0014\u0010\u0011\u001a\u00020\f2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0014\u0010\u0012\u001a\u00020\f2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0014\u0010\u0014\u001a\u00020\f2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0014\u0010\u0015\u001a\u00020\f2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0014\u0010\u0016\u001a\u00020\f2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0014\u0010\u0017\u001a\u00020\u00182\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0016\u0010\u0019\u001a\u00020\u00182\f\u0010\u001a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001bH\u0016J%\u0010\u001c\u001a\u0004\u0018\u0001H\u001d\"\u0004\b\u0000\u0010\u001d2\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u0002H\u001d\u0018\u00010\u001bH\u0016\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/jdbc/base/statements/parameters/ProtocolParameterMetadata;", "Ljava/sql/ParameterMetaData;", "parameters", "Lcom/jetbrains/jdbc/base/statements/parameters/StatementParameters;", "nativeTypeTranslator", "Lcom/jetbrains/jdbc/base/utils/translators/IJdbcToNativeTypeTranslator;", "javaTypeTranslator", "Lcom/jetbrains/jdbc/base/utils/translators/IJdbcToJavaTypeTranslator;", "(Lcom/jetbrains/jdbc/base/statements/parameters/StatementParameters;Lcom/jetbrains/jdbc/base/utils/translators/IJdbcToNativeTypeTranslator;Lcom/jetbrains/jdbc/base/utils/translators/IJdbcToJavaTypeTranslator;)V", "getMetadata", "Lcom/jetbrains/jdbc/base/models/RdStatementParameterMetadata;", "param", "", "Lcom/jetbrains/jdbc/base/OneBasedIndex;", "getParameterClassName", "", "getParameterCount", "getParameterMode", "getParameterType", "getParameterTypeName", "getPrecision", "getScale", "isNullable", "isSigned", "", "isWrapperFor", "iface", "Ljava/lang/Class;", "unwrap", "T", "(Ljava/lang/Class;)Ljava/lang/Object;", "Frontend"})
public class ProtocolParameterMetadata
implements ParameterMetaData {
    @NotNull
    private final StatementParameters parameters;
    @NotNull
    private final IJdbcToNativeTypeTranslator nativeTypeTranslator;
    @NotNull
    private final IJdbcToJavaTypeTranslator javaTypeTranslator;

    public ProtocolParameterMetadata(@NotNull StatementParameters parameters2, @NotNull IJdbcToNativeTypeTranslator nativeTypeTranslator, @NotNull IJdbcToJavaTypeTranslator javaTypeTranslator) {
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        Intrinsics.checkNotNullParameter(nativeTypeTranslator, "nativeTypeTranslator");
        Intrinsics.checkNotNullParameter(javaTypeTranslator, "javaTypeTranslator");
        this.parameters = parameters2;
        this.nativeTypeTranslator = nativeTypeTranslator;
        this.javaTypeTranslator = javaTypeTranslator;
    }

    @Override
    @Nullable
    public <T> T unwrap(@Nullable Class<T> iface) {
        T t = null;
        if (iface == null) {
            return t;
        }
        try {
            iface.cast(this);
        }
        catch (ClassCastException e) {
            throw new SQLException(e.getMessage());
        }
        return t;
    }

    @Override
    public boolean isWrapperFor(@Nullable Class<?> iface) {
        Class<?> clazz = iface;
        return clazz != null ? clazz.isInstance(this) : false;
    }

    @Override
    public int getParameterCount() {
        return this.parameters.getCount();
    }

    @Override
    public int isNullable(int param) {
        return this.getMetadata(param).isNullable();
    }

    @Override
    public boolean isSigned(int param) {
        return this.getMetadata(param).isSigned();
    }

    @Override
    public int getPrecision(int param) {
        return this.getMetadata(param).getPrecision();
    }

    @Override
    public int getScale(int param) {
        return this.getMetadata(param).getScale();
    }

    @Override
    public int getParameterType(int param) {
        Integer n = this.nativeTypeTranslator.fromNativeToJdbc(this.getMetadata(param).getType()).getVendorTypeNumber();
        Intrinsics.checkNotNullExpressionValue(n, "nativeTypeTranslator.fro\u2026m).type).vendorTypeNumber");
        return ((Number)n).intValue();
    }

    @Override
    @Nullable
    public String getParameterTypeName(int param) {
        return this.getMetadata(param).getTypeName();
    }

    @Override
    @NotNull
    public String getParameterClassName(int param) {
        RdStatementParameterMetadata column = this.getMetadata(param);
        return this.javaTypeTranslator.fromNativeToJava(column.getType());
    }

    @Override
    public int getParameterMode(int param) {
        return this.getMetadata(param).getMode();
    }

    private final RdStatementParameterMetadata getMetadata(int param) {
        return this.parameters.getParameter(param).getMetadata();
    }
}

