/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.statements;

import com.jetbrains.jdbc.base.factories.IParametersFactory;
import com.jetbrains.jdbc.base.factories.jdbc.JdbcFactory;
import com.jetbrains.jdbc.base.models.JdbcModel;
import com.jetbrains.jdbc.base.models.RdStatement;
import com.jetbrains.jdbc.base.models.RdStatementInitialState;
import com.jetbrains.jdbc.base.models.RdStatementWithParams;
import com.jetbrains.jdbc.base.models.RdStatementWithParamsInitialState;
import com.jetbrains.jdbc.base.statements.IStatementParser;
import com.jetbrains.jdbc.base.statements.ProtocolStatement;
import com.jetbrains.jdbc.base.statements.models.ExecutionResult;
import com.jetbrains.jdbc.base.statements.parameters.IStatementParameter;
import com.jetbrains.jdbc.base.statements.parameters.StatementParameters;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import com.jetbrains.jdbc.base.utils.protocol.RdStatementExtKt;
import com.jetbrains.jdbc.base.utils.protocol.initialization.ParameterInitializationData;
import com.jetbrains.jdbc.base.utils.protocol.initialization.ResultSetInitializationData;
import com.jetbrains.jdbc.base.utils.protocol.pooling.IStatementPool;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00040\u0003Ba\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e\u0012\u0006\u0010\u000f\u001a\u00028\u0000\u0012\u0006\u0010\u0010\u001a\u00020\u0004\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\b\u0010!\u001a\u00020\u001eH\u0016J\u0006\u0010\"\u001a\u00020\u001eJ\b\u0010#\u001a\u00020$H\u0016J\u0012\u0010#\u001a\u00020$2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J)\u0010#\u001a\u00020$2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0010\u0010%\u001a\f\u0012\u0006\b\u0001\u0012\u00020 \u0018\u00010&H\u0016\u00a2\u0006\u0002\u0010'J\u001a\u0010#\u001a\u00020$2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010(\u001a\u00020)H\u0016J\u001c\u0010#\u001a\u00020$2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\b\u0010,\u001a\u00020+H\u0016J\n\u0010-\u001a\u0004\u0018\u00010.H\u0016J\u0012\u0010-\u001a\u00020.2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\b\u0010/\u001a\u00020)H\u0016J\u0012\u0010/\u001a\u00020)2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J)\u0010/\u001a\u00020)2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0010\u0010%\u001a\f\u0012\u0006\b\u0001\u0012\u00020 \u0018\u00010&H\u0016\u00a2\u0006\u0002\u00100J\u001a\u0010/\u001a\u00020)2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010(\u001a\u00020)H\u0016J\u001c\u0010/\u001a\u00020)2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\u0006\u00101\u001a\u000202J\u0006\u00103\u001a\u000204J\u0018\u00105\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\b\u00107\u001a\u0004\u0018\u000108J\u0018\u00109\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\b\u00107\u001a\u0004\u0018\u00010:J \u00109\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\b\u00107\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020)J \u00109\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\b\u00107\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020<J\u0016\u0010=\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020>J\u0018\u0010?\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\b\u00107\u001a\u0004\u0018\u00010:J \u0010?\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\b\u00107\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020)J \u0010?\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\b\u00107\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020<J\u0016\u0010@\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\u0006\u0010A\u001a\u00020:J\u001e\u0010@\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\u0006\u0010A\u001a\u00020:2\u0006\u0010;\u001a\u00020<J\u0016\u0010@\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020BJ\u0016\u0010C\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020$J\u0016\u0010D\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020EJ\u0018\u0010F\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\b\u00107\u001a\u0004\u0018\u00010GJ\u0018\u0010H\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\b\u0010I\u001a\u0004\u0018\u00010JJ \u0010H\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\b\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010;\u001a\u00020)J \u0010H\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\b\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010;\u001a\u00020<J\u0016\u0010K\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\u0006\u0010I\u001a\u00020JJ\u001e\u0010K\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\u0006\u0010I\u001a\u00020J2\u0006\u0010;\u001a\u00020<J\u0016\u0010K\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020LJ\u0018\u0010M\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\b\u00107\u001a\u0004\u0018\u00010NJ\"\u0010M\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\b\u00107\u001a\u0004\u0018\u00010N2\b\u0010O\u001a\u0004\u0018\u00010PJ\u0016\u0010Q\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020RJ\u0016\u0010S\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020TJ\u0016\u0010U\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020)J\u0016\u0010V\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020<J\u0018\u0010W\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\b\u0010I\u001a\u0004\u0018\u00010JJ \u0010W\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\b\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010;\u001a\u00020<J\u0016\u0010X\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\u0006\u0010I\u001a\u00020JJ\u001e\u0010X\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\u0006\u0010I\u001a\u00020J2\u0006\u0010;\u001a\u00020<J\u0016\u0010X\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\u0006\u0010Y\u001a\u00020ZJ\u0018\u0010[\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\b\u0010\\\u001a\u0004\u0018\u00010 J\u0016\u0010]\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\u0006\u0010^\u001a\u00020)J \u0010]\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\u0006\u0010^\u001a\u00020)2\b\u0010_\u001a\u0004\u0018\u00010 J\u0018\u0010`\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\b\u00107\u001a\u0004\u0018\u00010aJ \u0010`\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\b\u00107\u001a\u0004\u0018\u00010a2\u0006\u0010b\u001a\u00020)J(\u0010`\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\b\u00107\u001a\u0004\u0018\u00010a2\u0006\u0010b\u001a\u00020)2\u0006\u0010c\u001a\u00020)J\u0018\u0010d\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\b\u00107\u001a\u0004\u0018\u00010eJ\u0018\u0010f\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\b\u00107\u001a\u0004\u0018\u00010gJ\u0018\u0010h\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\b\u0010i\u001a\u0004\u0018\u00010jJ\u0016\u0010k\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020lJ\u0018\u0010m\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\b\u00107\u001a\u0004\u0018\u00010 J\u0018\u0010n\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\b\u00107\u001a\u0004\u0018\u00010oJ\"\u0010n\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\b\u00107\u001a\u0004\u0018\u00010o2\b\u0010O\u001a\u0004\u0018\u00010PJ\u0018\u0010p\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\b\u00107\u001a\u0004\u0018\u00010qJ\"\u0010p\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\b\u00107\u001a\u0004\u0018\u00010q2\b\u0010O\u001a\u0004\u0018\u00010PJ\u0018\u0010r\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\b\u0010s\u001a\u0004\u0018\u00010tJ \u0010u\u001a\u00020\u001e2\u0006\u00106\u001a\u00020)2\b\u00107\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020)R\u0014\u0010\u0019\u001a\u00020\u001aX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006v"}, d2={"Lcom/jetbrains/jdbc/base/statements/ProtocolStatementWithParameters;", "T", "Lcom/jetbrains/jdbc/base/models/RdStatementWithParams;", "Lcom/jetbrains/jdbc/base/statements/ProtocolStatement;", "Lcom/jetbrains/jdbc/base/models/RdStatementWithParamsInitialState;", "connection", "Ljava/sql/Connection;", "lifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "jdbcFactory", "Lcom/jetbrains/jdbc/base/factories/jdbc/JdbcFactory;", "parametersFactory", "Lcom/jetbrains/jdbc/base/factories/IParametersFactory;", "statementPool", "Lcom/jetbrains/jdbc/base/utils/protocol/pooling/IStatementPool;", "remoteStatement", "initialState", "rdModel", "Lcom/jetbrains/jdbc/base/models/JdbcModel;", "rdParameters", "", "Lcom/jetbrains/jdbc/base/utils/protocol/initialization/ParameterInitializationData;", "statementParser", "Lcom/jetbrains/jdbc/base/statements/IStatementParser;", "(Ljava/sql/Connection;Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;Lcom/jetbrains/jdbc/base/factories/jdbc/JdbcFactory;Lcom/jetbrains/jdbc/base/factories/IParametersFactory;Lcom/jetbrains/jdbc/base/utils/protocol/pooling/IStatementPool;Lcom/jetbrains/jdbc/base/models/RdStatementWithParams;Lcom/jetbrains/jdbc/base/models/RdStatementWithParamsInitialState;Lcom/jetbrains/jdbc/base/models/JdbcModel;Ljava/util/List;Lcom/jetbrains/jdbc/base/statements/IStatementParser;)V", "parameters", "Lcom/jetbrains/jdbc/base/statements/parameters/StatementParameters;", "getParameters", "()Lcom/jetbrains/jdbc/base/statements/parameters/StatementParameters;", "addBatch", "", "sql", "", "clearBatch", "clearParameters", "execute", "", "columnNames", "", "(Ljava/lang/String;[Ljava/lang/String;)Z", "autoGeneratedKeys", "", "columnIndexes", "", "executeBatch", "executeQuery", "Ljava/sql/ResultSet;", "executeUpdate", "(Ljava/lang/String;[Ljava/lang/String;)I", "getMetaData", "Ljava/sql/ResultSetMetaData;", "getParameterMetaData", "Ljava/sql/ParameterMetaData;", "setArray", "parameterIndex", "x", "Ljava/sql/Array;", "setAsciiStream", "Ljava/io/InputStream;", "length", "", "setBigDecimal", "Ljava/math/BigDecimal;", "setBinaryStream", "setBlob", "inputStream", "Ljava/sql/Blob;", "setBoolean", "setByte", "", "setBytes", "", "setCharacterStream", "reader", "Ljava/io/Reader;", "setClob", "Ljava/sql/Clob;", "setDate", "Ljava/sql/Date;", "cal", "Ljava/util/Calendar;", "setDouble", "", "setFloat", "", "setInt", "setLong", "setNCharacterStream", "setNClob", "nClob", "Ljava/sql/NClob;", "setNString", "value", "setNull", "sqlType", "typeName", "setObject", "", "targetSqlType", "scale", "setRef", "Ljava/sql/Ref;", "setRowId", "Ljava/sql/RowId;", "setSQLXML", "xmlObject", "Ljava/sql/SQLXML;", "setShort", "", "setString", "setTime", "Ljava/sql/Time;", "setTimestamp", "Ljava/sql/Timestamp;", "setURL", "url", "Ljava/net/URL;", "setUnicodeStream", "Frontend"})
public abstract class ProtocolStatementWithParameters<T extends RdStatementWithParams>
extends ProtocolStatement<T, RdStatementWithParamsInitialState> {
    @NotNull
    private final StatementParameters parameters;

    public ProtocolStatementWithParameters(@NotNull Connection connection, @NotNull LifetimeDefinition lifetimeDefinition, @NotNull JdbcFactory jdbcFactory, @NotNull IParametersFactory parametersFactory2, @NotNull IStatementPool<T> statementPool, @NotNull T remoteStatement, @NotNull RdStatementWithParamsInitialState initialState, @NotNull JdbcModel rdModel, @NotNull List<ParameterInitializationData> rdParameters, @NotNull IStatementParser statementParser) {
        Intrinsics.checkNotNullParameter(connection, "connection");
        Intrinsics.checkNotNullParameter(lifetimeDefinition, "lifetimeDefinition");
        Intrinsics.checkNotNullParameter(jdbcFactory, "jdbcFactory");
        Intrinsics.checkNotNullParameter(parametersFactory2, "parametersFactory");
        Intrinsics.checkNotNullParameter(statementPool, "statementPool");
        Intrinsics.checkNotNullParameter(remoteStatement, "remoteStatement");
        Intrinsics.checkNotNullParameter(initialState, "initialState");
        Intrinsics.checkNotNullParameter(rdModel, "rdModel");
        Intrinsics.checkNotNullParameter(rdParameters, "rdParameters");
        Intrinsics.checkNotNullParameter(statementParser, "statementParser");
        super(connection, (RdStatement)remoteStatement, (RdStatementInitialState)initialState, rdModel, statementPool, lifetimeDefinition, jdbcFactory, statementParser);
        this.parameters = new StatementParameters((RdStatementWithParams)remoteStatement, rdParameters, parametersFactory2, lifetimeDefinition.getLifetime());
    }

    @NotNull
    protected final StatementParameters getParameters() {
        return this.parameters;
    }

    @Nullable
    public ResultSet executeQuery() {
        this.throwIfClosed();
        this.clearCurrentResult();
        ResultSetInitializationData receivedResultSet = RdStatementExtKt.executeQuery((RdStatementWithParams)this.getRemoteStatement(), this.getLifetimeDefinition().getLifetime(), this.getRdModel());
        this.setCurrentResultSet(receivedResultSet != null ? this.getJdbcFactory().createResultSet(this.getLifetimeDefinition().getLifetime(), receivedResultSet, this) : null);
        return this.getCurrentResultSet();
    }

    public int executeUpdate() {
        this.throwIfClosed();
        this.clearCurrentResult();
        return RdStatementExtKt.executePreparedUpdate((RdStatementWithParams)this.getRemoteStatement(), this.getLifetimeDefinition().getLifetime());
    }

    public boolean execute() {
        boolean bl;
        this.throwIfClosed();
        this.clearCurrentResult();
        ExecutionResult executionResult = RdStatementExtKt.sync((RdStatementWithParams)this.getRemoteStatement(), this.getLifetimeDefinition().getLifetime(), this.getRdModel());
        if (executionResult instanceof ExecutionResult.ResultSet) {
            this.setCurrentResultSet(this.getJdbcFactory().createResultSet(this.getLifetimeDefinition().getLifetime(), ((ExecutionResult.ResultSet)executionResult).getReceivedRs(), this));
            bl = true;
        } else if (executionResult instanceof ExecutionResult.UpdateCount) {
            this.setCurrentUpdateCount(((ExecutionResult.UpdateCount)executionResult).getCount());
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public final void addBatch() {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void clearBatch() {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    @NotNull
    public int[] executeBatch() {
        throw new SQLFeatureNotSupportedException();
    }

    public final void setNull(int parameterIndex, int sqlType) {
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setNull(sqlType);
    }

    public final void setNull(int parameterIndex, int sqlType, @Nullable String typeName) {
        this.throwIfClosed();
        this.setNull(parameterIndex, sqlType);
    }

    public final void setBoolean(int parameterIndex, boolean x) {
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setBoolean(x);
    }

    public final void setByte(int parameterIndex, byte x) {
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setByte(x);
    }

    public final void setShort(int parameterIndex, short x) {
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setShort(x);
    }

    public final void setInt(int parameterIndex, int x) {
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setInt(x);
    }

    public final void setLong(int parameterIndex, long x) {
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setLong(x);
    }

    public final void setFloat(int parameterIndex, float x) {
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setFloat(Float.valueOf(x));
    }

    public final void setDouble(int parameterIndex, double x) {
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setDouble(x);
    }

    public final void setBigDecimal(int parameterIndex, @NotNull BigDecimal x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setBigDecimal(x);
    }

    public final void setString(int parameterIndex, @Nullable String x) {
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setString(x);
    }

    public final void setBytes(int parameterIndex, @Nullable byte[] x) {
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setBytes(x);
    }

    public final void setDate(int parameterIndex, @Nullable Date x) {
        this.throwIfClosed();
        IStatementParameter.DefaultImpls.setSqlDate$default(this.parameters.getParameter(parameterIndex), x, null, 2, null);
    }

    public final void setDate(int parameterIndex, @Nullable Date x, @Nullable Calendar cal) {
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setSqlDate(x, cal);
    }

    public final void setTime(int parameterIndex, @Nullable Time x) {
        this.throwIfClosed();
        IStatementParameter.DefaultImpls.setTime$default(this.parameters.getParameter(parameterIndex), x, null, 2, null);
    }

    public final void setTime(int parameterIndex, @Nullable Time x, @Nullable Calendar cal) {
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setTime(x, cal);
    }

    public final void setTimestamp(int parameterIndex, @Nullable Timestamp x) {
        this.throwIfClosed();
        IStatementParameter.DefaultImpls.setTimestamp$default(this.parameters.getParameter(parameterIndex), x, null, 2, null);
    }

    public final void setTimestamp(int parameterIndex, @Nullable Timestamp x, @Nullable Calendar cal) {
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setTimestamp(x, cal);
    }

    public final void setAsciiStream(int parameterIndex, @Nullable InputStream x, int length) {
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setAsciiStream(x, length);
    }

    public final void setAsciiStream(int parameterIndex, @Nullable InputStream x, long length) {
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setAsciiStream(x, (int)length);
    }

    public final void setAsciiStream(int parameterIndex, @Nullable InputStream x) {
        this.throwIfClosed();
        IStatementParameter.DefaultImpls.setAsciiStream$default(this.parameters.getParameter(parameterIndex), x, null, 2, null);
    }

    public final void setUnicodeStream(int parameterIndex, @Nullable InputStream x, int length) {
        this.throwIfClosed();
        IStatementParameter.DefaultImpls.setUnicodeStream$default(this.parameters.getParameter(parameterIndex), x, null, 2, null);
    }

    public final void setBinaryStream(int parameterIndex, @Nullable InputStream x, int length) {
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setAsciiStream(x, length);
    }

    public final void setBinaryStream(int parameterIndex, @Nullable InputStream x, long length) {
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setBinaryStream(x, (int)length);
    }

    public final void setBinaryStream(int parameterIndex, @Nullable InputStream x) {
        this.throwIfClosed();
        IStatementParameter.DefaultImpls.setBinaryStream$default(this.parameters.getParameter(parameterIndex), x, null, 2, null);
    }

    public final void clearParameters() {
        this.throwIfClosed();
        this.parameters.clearPendingValues();
    }

    public final void setObject(int parameterIndex, @Nullable Object x, int targetSqlType, int scale) {
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setObject(x, targetSqlType, scale);
    }

    public final void setObject(int parameterIndex, @Nullable Object x, int targetSqlType) {
        this.throwIfClosed();
        IStatementParameter.DefaultImpls.setObject$default(this.parameters.getParameter(parameterIndex), x, targetSqlType, null, 4, null);
    }

    public final void setObject(int parameterIndex, @Nullable Object x) {
        this.throwIfClosed();
        IStatementParameter.DefaultImpls.setObject$default(this.parameters.getParameter(parameterIndex), x, null, null, 6, null);
    }

    public final void setCharacterStream(int parameterIndex, @Nullable Reader reader, int length) {
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setCharacterStream(reader, length);
    }

    public final void setCharacterStream(int parameterIndex, @Nullable Reader reader, long length) {
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setCharacterStream(reader, (int)length);
    }

    public final void setCharacterStream(int parameterIndex, @Nullable Reader reader) {
        this.throwIfClosed();
        IStatementParameter.DefaultImpls.setCharacterStream$default(this.parameters.getParameter(parameterIndex), reader, null, 2, null);
    }

    public final void setRef(int parameterIndex, @Nullable Ref x) {
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setRef(x);
    }

    public final void setBlob(int parameterIndex, @NotNull Blob x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setBlob(x);
    }

    public final void setBlob(int parameterIndex, @NotNull InputStream inputStream, long length) {
        Intrinsics.checkNotNullParameter(inputStream, "inputStream");
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setBinaryStream(inputStream, (int)length);
    }

    public final void setBlob(int parameterIndex, @NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter(inputStream, "inputStream");
        this.throwIfClosed();
        IStatementParameter.DefaultImpls.setBinaryStream$default(this.parameters.getParameter(parameterIndex), inputStream, null, 2, null);
    }

    public final void setClob(int parameterIndex, @NotNull Clob x) {
        Intrinsics.checkNotNullParameter(x, "x");
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setClob(x);
    }

    public final void setClob(int parameterIndex, @NotNull Reader reader, long length) {
        Intrinsics.checkNotNullParameter(reader, "reader");
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setCharacterStream(reader, (int)length);
    }

    public final void setClob(int parameterIndex, @NotNull Reader reader) {
        Intrinsics.checkNotNullParameter(reader, "reader");
        this.throwIfClosed();
        IStatementParameter.DefaultImpls.setCharacterStream$default(this.parameters.getParameter(parameterIndex), reader, null, 2, null);
    }

    public final void setArray(int parameterIndex, @Nullable Array x) {
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setArray(x);
    }

    public final void setNClob(int parameterIndex, @NotNull NClob nClob) {
        Intrinsics.checkNotNullParameter(nClob, "nClob");
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setNClob(nClob);
    }

    public final void setNClob(int parameterIndex, @NotNull Reader reader, long length) {
        Intrinsics.checkNotNullParameter(reader, "reader");
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setNCharacterStream(reader, (int)length);
    }

    public final void setNClob(int parameterIndex, @NotNull Reader reader) {
        Intrinsics.checkNotNullParameter(reader, "reader");
        this.throwIfClosed();
        IStatementParameter.DefaultImpls.setNCharacterStream$default(this.parameters.getParameter(parameterIndex), reader, null, 2, null);
    }

    public final void setURL(int parameterIndex, @Nullable URL url) {
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setURL(url);
    }

    public final void setRowId(int parameterIndex, @Nullable RowId x) {
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setRowId(x);
    }

    public final void setNString(int parameterIndex, @Nullable String value2) {
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setNString(value2);
    }

    public final void setNCharacterStream(int parameterIndex, @Nullable Reader reader, long length) {
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setNCharacterStream(reader, (int)length);
    }

    public final void setNCharacterStream(int parameterIndex, @Nullable Reader reader) {
        this.throwIfClosed();
        IStatementParameter.DefaultImpls.setNCharacterStream$default(this.parameters.getParameter(parameterIndex), reader, null, 2, null);
    }

    public final void setSQLXML(int parameterIndex, @Nullable SQLXML xmlObject) {
        this.throwIfClosed();
        this.parameters.getParameter(parameterIndex).setSQLXML(xmlObject);
    }

    @NotNull
    public final ResultSetMetaData getMetaData() {
        throw new SQLFeatureNotSupportedException();
    }

    @NotNull
    public final ParameterMetaData getParameterMetaData() {
        this.throwIfClosed();
        return this.getJdbcFactory().createStatementParameterMetadata(this.parameters);
    }

    @Override
    @NotNull
    public ResultSet executeQuery(@Nullable String sql) {
        throw ExceptionsKt.methodCannotTakeParameters("executeQuery");
    }

    @Override
    public int executeUpdate(@Nullable String sql) {
        throw ExceptionsKt.methodCannotTakeParameters("executeUpdate");
    }

    @Override
    public int executeUpdate(@Nullable String sql, int autoGeneratedKeys) {
        throw ExceptionsKt.methodCannotTakeParameters("executeUpdate");
    }

    @Override
    public int executeUpdate(@Nullable String sql, @Nullable int[] columnIndexes) {
        throw ExceptionsKt.methodCannotTakeParameters("executeUpdate");
    }

    @Override
    public int executeUpdate(@Nullable String sql, @Nullable String[] columnNames) {
        throw ExceptionsKt.methodCannotTakeParameters("executeUpdate");
    }

    @Override
    public boolean execute(@Nullable String sql) {
        throw ExceptionsKt.methodCannotTakeParameters("execute");
    }

    @Override
    public boolean execute(@Nullable String sql, int autoGeneratedKeys) {
        throw ExceptionsKt.methodCannotTakeParameters("execute");
    }

    @Override
    public boolean execute(@Nullable String sql, @Nullable int[] columnIndexes) {
        throw ExceptionsKt.methodCannotTakeParameters("execute");
    }

    @Override
    public boolean execute(@Nullable String sql, @Nullable String[] columnNames) {
        throw ExceptionsKt.methodCannotTakeParameters("execute");
    }

    @Override
    public void addBatch(@Nullable String sql) {
        throw ExceptionsKt.methodCannotTakeParameters("addBatch");
    }
}

