/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.statements;

import com.jetbrains.jdbc.base.factories.jdbc.JdbcFactory;
import com.jetbrains.jdbc.base.models.JdbcModel;
import com.jetbrains.jdbc.base.models.RdServerInformationMessage;
import com.jetbrains.jdbc.base.models.RdStatement;
import com.jetbrains.jdbc.base.models.RdStatementInitialState;
import com.jetbrains.jdbc.base.statements.IStatementParser;
import com.jetbrains.jdbc.base.statements.models.ExecutionResult;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import com.jetbrains.jdbc.base.utils.exceptions.WarningsContainer;
import com.jetbrains.jdbc.base.utils.protocol.JdbcModelExtKt;
import com.jetbrains.jdbc.base.utils.protocol.RdStatementExtKt;
import com.jetbrains.jdbc.base.utils.protocol.pooling.IStatementPool;
import com.jetbrains.jdbc.base.utils.protocol.properties.RdAsyncProperty;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.framework.base.RdBindableBase;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.ISignal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u0005BK\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00028\u0000\u0012\u0006\u0010\t\u001a\u00028\u0001\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\b\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u000209H\u0004J\b\u0010;\u001a\u000209H\u0016J\b\u0010<\u001a\u000209H\u0016J\b\u0010=\u001a\u000209H\u0016J/\u0010>\u001a\b\u0012\u0004\u0012\u0002H\u00010#\"\u0004\b\u0002\u0010\u00012\u0006\u0010?\u001a\u0002H\u00012\f\u0010@\u001a\b\u0012\u0004\u0012\u0002H\u00010AH\u0002\u00a2\u0006\u0002\u0010BJ\b\u0010C\u001a\u00020\u0007H\u0016J\b\u0010D\u001a\u00020\u001cH\u0016J\b\u0010E\u001a\u00020\u001cH\u0016J\b\u0010F\u001a\u00020\u0016H\u0016J\b\u0010G\u001a\u00020\u001cH\u0016J\b\u0010H\u001a\u00020\u001cH\u0016J\b\u0010I\u001a\u00020JH\u0016J\u0010\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020\u001cH\u0016J\b\u0010L\u001a\u00020\u001cH\u0016J\n\u0010M\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010N\u001a\u00020\u001cH\u0016J\b\u0010O\u001a\u00020\u001cH\u0016J\b\u0010P\u001a\u00020\u001cH\u0016J\b\u0010Q\u001a\u00020\u001cH\u0016J\n\u0010R\u001a\u0004\u0018\u00010SH\u0016J\b\u0010T\u001a\u00020JH\u0016J\b\u0010U\u001a\u00020JH\u0016J\b\u0010V\u001a\u00020JH\u0016J\u0016\u0010W\u001a\u00020J2\f\u0010X\u001a\b\u0012\u0002\b\u0003\u0018\u00010YH\u0016J\u0012\u0010Z\u001a\u0002092\b\u0010[\u001a\u0004\u0018\u00010\\H\u0016J\u0010\u0010]\u001a\u0002092\u0006\u0010^\u001a\u00020JH\u0016J\u0010\u0010_\u001a\u0002092\u0006\u0010`\u001a\u00020\u001cH\u0016J\u0010\u0010a\u001a\u0002092\u0006\u0010b\u001a\u00020\u001cH\u0016J\u0010\u0010c\u001a\u0002092\u0006\u0010d\u001a\u00020\u001cH\u0016J\u0010\u0010e\u001a\u0002092\u0006\u0010d\u001a\u00020\u001cH\u0016J\u0010\u0010f\u001a\u0002092\u0006\u0010g\u001a\u00020JH\u0016J\u0010\u0010h\u001a\u0002092\u0006\u0010i\u001a\u00020\u001cH\u0016J\b\u0010j\u001a\u000209H\u0004J%\u0010k\u001a\u0004\u0018\u0001H\u0001\"\u0004\b\u0002\u0010\u00012\u000e\u0010X\u001a\n\u0012\u0004\u0012\u0002H\u0001\u0018\u00010YH\u0016\u00a2\u0006\u0002\u0010lR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010!\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001c0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u00028\u0001X\u0084\u0004\u00a2\u0006\n\n\u0002\u0010'\u001a\u0004\b%\u0010&R\u0014\u0010\u0010\u001a\u00020\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010\u000e\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001c0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001c0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001c0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0016\u0010\b\u001a\u00028\u0000X\u0084\u0004\u00a2\u0006\n\n\u0002\u00103\u001a\u0004\b1\u00102R\u0014\u0010\u0012\u001a\u00020\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006m"}, d2={"Lcom/jetbrains/jdbc/base/statements/ProtocolStatement;", "T", "Lcom/jetbrains/jdbc/base/models/RdStatement;", "TState", "Lcom/jetbrains/jdbc/base/models/RdStatementInitialState;", "Ljava/sql/Statement;", "connection", "Ljava/sql/Connection;", "remoteStatement", "initialState", "rdModel", "Lcom/jetbrains/jdbc/base/models/JdbcModel;", "statementPool", "Lcom/jetbrains/jdbc/base/utils/protocol/pooling/IStatementPool;", "lifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "jdbcFactory", "Lcom/jetbrains/jdbc/base/factories/jdbc/JdbcFactory;", "statementParser", "Lcom/jetbrains/jdbc/base/statements/IStatementParser;", "(Ljava/sql/Connection;Lcom/jetbrains/jdbc/base/models/RdStatement;Lcom/jetbrains/jdbc/base/models/RdStatementInitialState;Lcom/jetbrains/jdbc/base/models/JdbcModel;Lcom/jetbrains/jdbc/base/utils/protocol/pooling/IStatementPool;Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;Lcom/jetbrains/jdbc/base/factories/jdbc/JdbcFactory;Lcom/jetbrains/jdbc/base/statements/IStatementParser;)V", "currentResultSet", "Ljava/sql/ResultSet;", "getCurrentResultSet", "()Ljava/sql/ResultSet;", "setCurrentResultSet", "(Ljava/sql/ResultSet;)V", "currentUpdateCount", "", "getCurrentUpdateCount", "()Ljava/lang/Integer;", "setCurrentUpdateCount", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "fetchDirection", "Lcom/jetbrains/jdbc/base/utils/protocol/properties/RdAsyncProperty;", "fetchSize", "getInitialState", "()Lcom/jetbrains/jdbc/base/models/RdStatementInitialState;", "Lcom/jetbrains/jdbc/base/models/RdStatementInitialState;", "getJdbcFactory", "()Lcom/jetbrains/jdbc/base/factories/jdbc/JdbcFactory;", "getLifetimeDefinition", "()Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "maxFieldSize", "maxRows", "queryTimeout", "getRdModel", "()Lcom/jetbrains/jdbc/base/models/JdbcModel;", "getRemoteStatement", "()Lcom/jetbrains/jdbc/base/models/RdStatement;", "Lcom/jetbrains/jdbc/base/models/RdStatement;", "getStatementParser", "()Lcom/jetbrains/jdbc/base/statements/IStatementParser;", "warningsContainer", "Lcom/jetbrains/jdbc/base/utils/exceptions/WarningsContainer;", "cancel", "", "clearCurrentResult", "clearWarnings", "close", "closeOnCompletion", "createProperty", "initialValue", "signal", "Lcom/jetbrains/rd/util/reactive/ISignal;", "(Ljava/lang/Object;Lcom/jetbrains/rd/util/reactive/ISignal;)Lcom/jetbrains/jdbc/base/utils/protocol/properties/RdAsyncProperty;", "getConnection", "getFetchDirection", "getFetchSize", "getGeneratedKeys", "getMaxFieldSize", "getMaxRows", "getMoreResults", "", "current", "getQueryTimeout", "getResultSet", "getResultSetConcurrency", "getResultSetHoldability", "getResultSetType", "getUpdateCount", "getWarnings", "Ljava/sql/SQLWarning;", "isCloseOnCompletion", "isClosed", "isPoolable", "isWrapperFor", "iface", "Ljava/lang/Class;", "setCursorName", "name", "", "setEscapeProcessing", "enable", "setFetchDirection", "direction", "setFetchSize", "rows", "setMaxFieldSize", "max", "setMaxRows", "setPoolable", "poolable", "setQueryTimeout", "seconds", "throwIfClosed", "unwrap", "(Ljava/lang/Class;)Ljava/lang/Object;", "Frontend"})
public abstract class ProtocolStatement<T extends RdStatement, TState extends RdStatementInitialState>
implements Statement {
    @NotNull
    private final Connection connection;
    @NotNull
    private final T remoteStatement;
    @NotNull
    private final TState initialState;
    @NotNull
    private final JdbcModel rdModel;
    @NotNull
    private final IStatementPool<T> statementPool;
    @NotNull
    private final LifetimeDefinition lifetimeDefinition;
    @NotNull
    private final JdbcFactory jdbcFactory;
    @NotNull
    private final IStatementParser statementParser;
    @Nullable
    private ResultSet currentResultSet;
    @Nullable
    private Integer currentUpdateCount;
    @NotNull
    private final WarningsContainer warningsContainer;
    @NotNull
    private final RdAsyncProperty<Integer> fetchDirection;
    @NotNull
    private final RdAsyncProperty<Integer> fetchSize;
    @NotNull
    private final RdAsyncProperty<Integer> maxRows;
    @NotNull
    private final RdAsyncProperty<Integer> maxFieldSize;
    @NotNull
    private final RdAsyncProperty<Integer> queryTimeout;

    public ProtocolStatement(@NotNull Connection connection, @NotNull T remoteStatement, @NotNull TState initialState, @NotNull JdbcModel rdModel, @NotNull IStatementPool<T> statementPool, @NotNull LifetimeDefinition lifetimeDefinition, @NotNull JdbcFactory jdbcFactory, @NotNull IStatementParser statementParser) {
        Intrinsics.checkNotNullParameter(connection, "connection");
        Intrinsics.checkNotNullParameter(remoteStatement, "remoteStatement");
        Intrinsics.checkNotNullParameter(initialState, "initialState");
        Intrinsics.checkNotNullParameter(rdModel, "rdModel");
        Intrinsics.checkNotNullParameter(statementPool, "statementPool");
        Intrinsics.checkNotNullParameter(lifetimeDefinition, "lifetimeDefinition");
        Intrinsics.checkNotNullParameter(jdbcFactory, "jdbcFactory");
        Intrinsics.checkNotNullParameter(statementParser, "statementParser");
        this.connection = connection;
        this.remoteStatement = remoteStatement;
        this.initialState = initialState;
        this.rdModel = rdModel;
        this.statementPool = statementPool;
        this.lifetimeDefinition = lifetimeDefinition;
        this.jdbcFactory = jdbcFactory;
        this.statementParser = statementParser;
        JdbcModelExtKt.getScheduler(this.rdModel).invokeOrQueue(new Function0<Unit>(){

            @Override
            public final void invoke() {
                ((RdStatement)this.getRemoteStatement()).getInfoMessage().advise(this.getLifetimeDefinition().getLifetime(), new Function1<RdServerInformationMessage, Unit>(){

                    @Override
                    public final void invoke(@NotNull RdServerInformationMessage it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        warningsContainer.addWarning(new SQLWarning(it.getMessage(), it.getStatusCode(), it.getNumber()));
                    }
                });
            }
        });
        this.lifetimeDefinition.getLifetime().onTermination(new Function0<Unit>(){

            @Override
            public final void invoke() {
                this.clearCurrentResult();
                statementPool.returnStatement(this.getRemoteStatement());
            }
        });
        this.warningsContainer = new WarningsContainer();
        this.fetchDirection = this.createProperty(((RdStatementInitialState)this.initialState).getFetchDirection(), ((RdStatement)this.remoteStatement).getSetFetchDirection());
        this.fetchSize = this.createProperty(((RdStatementInitialState)this.initialState).getFetchSize(), ((RdStatement)this.remoteStatement).getSetFetchSize());
        this.maxRows = this.createProperty(((RdStatementInitialState)this.initialState).getMaxRows(), ((RdStatement)this.remoteStatement).getSetMaxRows());
        this.maxFieldSize = this.createProperty(((RdStatementInitialState)this.initialState).getMaxFieldSize(), ((RdStatement)this.remoteStatement).getSetMaxFieldSize());
        this.queryTimeout = this.createProperty(((RdStatementInitialState)this.initialState).getQueryTimeout(), ((RdStatement)this.remoteStatement).getSetQueryTimeout());
    }

    @NotNull
    protected final T getRemoteStatement() {
        return this.remoteStatement;
    }

    @NotNull
    protected final TState getInitialState() {
        return this.initialState;
    }

    @NotNull
    protected final JdbcModel getRdModel() {
        return this.rdModel;
    }

    @NotNull
    protected final LifetimeDefinition getLifetimeDefinition() {
        return this.lifetimeDefinition;
    }

    @NotNull
    protected final JdbcFactory getJdbcFactory() {
        return this.jdbcFactory;
    }

    @NotNull
    protected final IStatementParser getStatementParser() {
        return this.statementParser;
    }

    @Nullable
    protected final ResultSet getCurrentResultSet() {
        return this.currentResultSet;
    }

    protected final void setCurrentResultSet(@Nullable ResultSet resultSet) {
        this.currentResultSet = resultSet;
    }

    @Nullable
    protected final Integer getCurrentUpdateCount() {
        return this.currentUpdateCount;
    }

    protected final void setCurrentUpdateCount(@Nullable Integer n) {
        this.currentUpdateCount = n;
    }

    @Override
    @Nullable
    public <T> T unwrap(@Nullable Class<T> iface) {
        T t = null;
        if (iface == null) {
            return t;
        }
        try {
            iface.cast(this);
        }
        catch (ClassCastException e) {
            throw new SQLException(e.getMessage());
        }
        return t;
    }

    @Override
    public boolean isWrapperFor(@Nullable Class<?> iface) {
        Class<?> clazz = iface;
        return clazz != null ? clazz.isInstance(this) : false;
    }

    @Override
    public void close() {
        LifetimeDefinition.terminate$default(this.lifetimeDefinition, false, 1, null);
    }

    @Override
    public int getMaxFieldSize() {
        this.throwIfClosed();
        return ((Number)this.maxFieldSize.get()).intValue();
    }

    @Override
    public void setMaxFieldSize(int max) {
        this.throwIfClosed();
        this.maxFieldSize.set(max);
    }

    @Override
    public int getMaxRows() {
        this.throwIfClosed();
        return ((Number)this.maxRows.get()).intValue();
    }

    @Override
    public void setMaxRows(int max) {
        this.throwIfClosed();
        this.maxRows.set(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) {
        this.throwIfClosed();
    }

    @Override
    public int getQueryTimeout() {
        this.throwIfClosed();
        return ((Number)this.queryTimeout.get()).intValue();
    }

    @Override
    public void setQueryTimeout(int seconds) {
        this.throwIfClosed();
        this.queryTimeout.set(seconds);
    }

    @Override
    public void cancel() {
        this.throwIfClosed();
        IRdCall.DefaultImpls.sync$default(((RdStatement)this.remoteStatement).getCancel(), Unit.INSTANCE, null, 2, null);
    }

    @Override
    @Nullable
    public SQLWarning getWarnings() {
        this.throwIfClosed();
        return this.warningsContainer.getWarnings();
    }

    @Override
    public void clearWarnings() {
        this.throwIfClosed();
        this.warningsContainer.clearWarnings();
    }

    @Override
    public void setCursorName(@Nullable String name) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    @Nullable
    public ResultSet getResultSet() {
        this.throwIfClosed();
        return this.currentResultSet;
    }

    @Override
    public int getUpdateCount() {
        this.throwIfClosed();
        Integer n = this.currentUpdateCount;
        return n != null ? n : -1;
    }

    @Override
    public boolean getMoreResults() {
        boolean bl;
        this.throwIfClosed();
        this.clearCurrentResult();
        ExecutionResult executionResult = RdStatementExtKt.getNextResult(this.remoteStatement, this.lifetimeDefinition.getLifetime(), this.rdModel);
        if (executionResult instanceof ExecutionResult.ResultSet) {
            this.currentResultSet = this.jdbcFactory.createResultSet(this.lifetimeDefinition.getLifetime(), ((ExecutionResult.ResultSet)executionResult).getReceivedRs(), this);
            bl = true;
        } else if (executionResult instanceof ExecutionResult.UpdateCount) {
            this.currentUpdateCount = ((ExecutionResult.UpdateCount)executionResult).getCount();
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Override
    public boolean getMoreResults(int current) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setFetchDirection(int direction) {
        this.throwIfClosed();
        this.fetchDirection.set(direction);
    }

    @Override
    public int getFetchDirection() {
        this.throwIfClosed();
        return ((Number)this.fetchDirection.get()).intValue();
    }

    @Override
    public void setFetchSize(int rows) {
        this.throwIfClosed();
        this.fetchSize.set(rows);
    }

    @Override
    public int getFetchSize() {
        this.throwIfClosed();
        return ((Number)this.fetchSize.get()).intValue();
    }

    @Override
    public int getResultSetConcurrency() {
        this.throwIfClosed();
        return ((RdStatementInitialState)this.initialState).getConcurrency();
    }

    @Override
    public int getResultSetType() {
        this.throwIfClosed();
        return ((RdStatementInitialState)this.initialState).getType();
    }

    @Override
    @NotNull
    public Connection getConnection() {
        this.throwIfClosed();
        return this.connection;
    }

    @Override
    @NotNull
    public ResultSet getGeneratedKeys() {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetHoldability() {
        this.throwIfClosed();
        return ((RdStatementInitialState)this.initialState).getHoldability();
    }

    @Override
    public boolean isClosed() {
        return !RLifetimeKt.isAlive(this.lifetimeDefinition.getLifetime());
    }

    @Override
    public void setPoolable(boolean poolable) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isPoolable() {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void closeOnCompletion() {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isCloseOnCompletion() {
        throw new SQLFeatureNotSupportedException();
    }

    protected final void clearCurrentResult() {
        ResultSet resultSet = this.currentResultSet;
        if (resultSet != null) {
            resultSet.close();
        }
        this.currentResultSet = null;
        this.currentUpdateCount = null;
    }

    protected final void throwIfClosed() {
        if (this.isClosed()) {
            throw ExceptionsKt.statementIsClosed();
        }
    }

    private final <T> RdAsyncProperty<T> createProperty(T initialValue, ISignal<T> signal) {
        return new RdAsyncProperty<T>(initialValue, JdbcModelExtKt.getScheduler((RdBindableBase)this.remoteStatement), signal);
    }
}

