/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.statements;

import com.jetbrains.jdbc.base.factories.jdbc.JdbcFactory;
import com.jetbrains.jdbc.base.models.JdbcModel;
import com.jetbrains.jdbc.base.models.RdBasicStatement;
import com.jetbrains.jdbc.base.models.RdBasicStatementInitialState;
import com.jetbrains.jdbc.base.models.RdExecuteBatchFailure;
import com.jetbrains.jdbc.base.models.RdExecuteBatchResult;
import com.jetbrains.jdbc.base.models.RdExecuteBatchSuccess;
import com.jetbrains.jdbc.base.models.RdStatement;
import com.jetbrains.jdbc.base.models.RdStatementInitialState;
import com.jetbrains.jdbc.base.statements.IStatementParser;
import com.jetbrains.jdbc.base.statements.ProtocolStatement;
import com.jetbrains.jdbc.base.statements.models.ExecutionResult;
import com.jetbrains.jdbc.base.utils.protocol.RdStatementExtKt;
import com.jetbrains.jdbc.base.utils.protocol.initialization.ResultSetInitializationData;
import com.jetbrains.jdbc.base.utils.protocol.pooling.IBasicStatementPool;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004BE\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u001a\u001a\u00020\u0018H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J)\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0010\u0010\u001d\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0016\u0018\u00010\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fJ\u001a\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0006\u0010 \u001a\u00020!H\u0016J\u001c\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00162\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\b\u0010$\u001a\u00020#H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\u0010\u0010'\u001a\u00020!2\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J)\u0010'\u001a\u00020!2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0010\u0010\u001d\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0016\u0018\u00010\u001eH\u0016\u00a2\u0006\u0002\u0010(J\u001a\u0010'\u001a\u00020!2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0006\u0010 \u001a\u00020!H\u0016J\u001c\u0010'\u001a\u00020!2\b\u0010\u0019\u001a\u0004\u0018\u00010\u00162\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetbrains/jdbc/base/statements/ProtocolBasicStatement;", "Lcom/jetbrains/jdbc/base/statements/ProtocolStatement;", "Lcom/jetbrains/jdbc/base/models/RdBasicStatement;", "Lcom/jetbrains/jdbc/base/models/RdBasicStatementInitialState;", "Ljava/sql/Statement;", "connection", "Ljava/sql/Connection;", "remoteStatement", "initialState", "rdModel", "Lcom/jetbrains/jdbc/base/models/JdbcModel;", "basicStatementPool", "Lcom/jetbrains/jdbc/base/utils/protocol/pooling/IBasicStatementPool;", "lifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "jdbcFactory", "Lcom/jetbrains/jdbc/base/factories/jdbc/JdbcFactory;", "statementParser", "Lcom/jetbrains/jdbc/base/statements/IStatementParser;", "(Ljava/sql/Connection;Lcom/jetbrains/jdbc/base/models/RdBasicStatement;Lcom/jetbrains/jdbc/base/models/RdBasicStatementInitialState;Lcom/jetbrains/jdbc/base/models/JdbcModel;Lcom/jetbrains/jdbc/base/utils/protocol/pooling/IBasicStatementPool;Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;Lcom/jetbrains/jdbc/base/factories/jdbc/JdbcFactory;Lcom/jetbrains/jdbc/base/statements/IStatementParser;)V", "batchStatements", "", "", "addBatch", "", "sql", "clearBatch", "execute", "", "columnNames", "", "(Ljava/lang/String;[Ljava/lang/String;)Z", "autoGeneratedKeys", "", "columnIndexes", "", "executeBatch", "executeQuery", "Ljava/sql/ResultSet;", "executeUpdate", "(Ljava/lang/String;[Ljava/lang/String;)I", "Frontend"})
@SourceDebugExtension(value={"SMAP\nProtocolBasicStatement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolBasicStatement.kt\ncom/jetbrains/jdbc/base/statements/ProtocolBasicStatement\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,143:1\n37#2,2:144\n*S KotlinDebug\n*F\n+ 1 ProtocolBasicStatement.kt\ncom/jetbrains/jdbc/base/statements/ProtocolBasicStatement\n*L\n133#1:144,2\n*E\n"})
public class ProtocolBasicStatement
extends ProtocolStatement<RdBasicStatement, RdBasicStatementInitialState>
implements Statement {
    @NotNull
    private final List<String> batchStatements;

    public ProtocolBasicStatement(@NotNull Connection connection, @NotNull RdBasicStatement remoteStatement, @NotNull RdBasicStatementInitialState initialState, @NotNull JdbcModel rdModel, @NotNull IBasicStatementPool basicStatementPool2, @NotNull LifetimeDefinition lifetimeDefinition, @NotNull JdbcFactory jdbcFactory, @NotNull IStatementParser statementParser) {
        Intrinsics.checkNotNullParameter(connection, "connection");
        Intrinsics.checkNotNullParameter(remoteStatement, "remoteStatement");
        Intrinsics.checkNotNullParameter(initialState, "initialState");
        Intrinsics.checkNotNullParameter(rdModel, "rdModel");
        Intrinsics.checkNotNullParameter(basicStatementPool2, "basicStatementPool");
        Intrinsics.checkNotNullParameter(lifetimeDefinition, "lifetimeDefinition");
        Intrinsics.checkNotNullParameter(jdbcFactory, "jdbcFactory");
        Intrinsics.checkNotNullParameter(statementParser, "statementParser");
        super(connection, (RdStatement)remoteStatement, (RdStatementInitialState)initialState, rdModel, basicStatementPool2, lifetimeDefinition, jdbcFactory, statementParser);
        this.batchStatements = new ArrayList();
    }

    @Override
    public boolean execute(@NotNull String sql) {
        boolean bl;
        Intrinsics.checkNotNullParameter(sql, "sql");
        this.clearCurrentResult();
        String nativeSql = this.getStatementParser().translateSql(sql);
        ExecutionResult executionResult = RdStatementExtKt.sync(this.getRemoteStatement(), this.getLifetimeDefinition().getLifetime(), nativeSql, this.getRdModel());
        if (executionResult instanceof ExecutionResult.ResultSet) {
            this.setCurrentResultSet(this.getJdbcFactory().createResultSet(this.getLifetimeDefinition().getLifetime(), ((ExecutionResult.ResultSet)executionResult).getReceivedRs(), this));
            bl = true;
        } else if (executionResult instanceof ExecutionResult.UpdateCount) {
            this.setCurrentUpdateCount(((ExecutionResult.UpdateCount)executionResult).getCount());
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Override
    public boolean execute(@Nullable String sql, int autoGeneratedKeys) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(@Nullable String sql, @Nullable int[] columnIndexes) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(@Nullable String sql, @Nullable String[] columnNames) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    @NotNull
    public ResultSet executeQuery(@NotNull String sql) {
        Intrinsics.checkNotNullParameter(sql, "sql");
        this.throwIfClosed();
        this.clearCurrentResult();
        String nativeSql = this.getStatementParser().translateSql(sql);
        ResultSetInitializationData receivedResultSet = RdStatementExtKt.executeQuery(this.getRemoteStatement(), this.getLifetimeDefinition().getLifetime(), nativeSql, this.getRdModel());
        this.setCurrentResultSet(receivedResultSet != null ? this.getJdbcFactory().createResultSet(this.getLifetimeDefinition().getLifetime(), receivedResultSet, this) : null);
        ResultSet resultSet = this.getCurrentResultSet();
        Intrinsics.checkNotNull(resultSet);
        return resultSet;
    }

    @Override
    public int executeUpdate(@NotNull String sql) {
        int n;
        Intrinsics.checkNotNullParameter(sql, "sql");
        this.throwIfClosed();
        this.clearCurrentResult();
        String nativeSql = this.getStatementParser().translateSql(sql);
        int it = n = RdStatementExtKt.executeUpdate(this.getRemoteStatement(), this.getLifetimeDefinition().getLifetime(), nativeSql);
        boolean bl = false;
        this.setCurrentUpdateCount(it);
        return n;
    }

    @Override
    public int executeUpdate(@Nullable String sql, int autoGeneratedKeys) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(@Nullable String sql, @Nullable int[] columnIndexes) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(@Nullable String sql, @Nullable String[] columnNames) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void addBatch(@Nullable String sql) {
        this.throwIfClosed();
        if (sql == null) {
            return;
        }
        this.batchStatements.add(sql);
    }

    @Override
    public void clearBatch() {
        this.throwIfClosed();
        this.batchStatements.clear();
    }

    @Override
    @NotNull
    public int[] executeBatch() {
        this.throwIfClosed();
        Collection $this$toTypedArray$iv = this.batchStatements;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] statementsToExecute = thisCollection$iv.toArray(new String[0]);
        this.batchStatements.clear();
        RdExecuteBatchResult result2 = RdStatementExtKt.executeBatch(this.getRemoteStatement(), this.getLifetimeDefinition().getLifetime(), statementsToExecute);
        if (!(result2 instanceof RdExecuteBatchSuccess)) {
            if (result2 instanceof RdExecuteBatchFailure) {
                String string = ((RdExecuteBatchFailure)result2).getMessage();
                if (string == null) {
                    string = "Unknown failure";
                }
                throw new BatchUpdateException(string, result2.getStatementsResults());
            }
            throw new IllegalArgumentException("Unknown batch execution result: " + result2.getClass());
        }
        return result2.getStatementsResults();
    }
}

