/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.resultsets.models;

import com.jetbrains.jdbc.base.models.RdResultSetColumnMetadata;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010(\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0007\u001a\u00060\bj\u0002`\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\f\u001a\u00020\u00022\n\u0010\r\u001a\u00060\bj\u0002`\tJ\u000e\u0010\f\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000bJ\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0096\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/jdbc/base/resultsets/models/ResultSetRowMetadata;", "", "Lcom/jetbrains/jdbc/base/models/RdResultSetColumnMetadata;", "metadata", "", "([Lcom/jetbrains/jdbc/base/models/RdResultSetColumnMetadata;)V", "[Lcom/jetbrains/jdbc/base/models/RdResultSetColumnMetadata;", "getColumnIndex", "", "Lcom/jetbrains/jdbc/base/ZeroBasedIndex;", "name", "", "getMetadata", "index", "columnName", "iterator", "", "Frontend"})
public final class ResultSetRowMetadata
implements Iterable<RdResultSetColumnMetadata>,
KMappedMarker {
    @NotNull
    private final RdResultSetColumnMetadata[] metadata;

    public ResultSetRowMetadata(@NotNull RdResultSetColumnMetadata[] metadata2) {
        Intrinsics.checkNotNullParameter(metadata2, "metadata");
        this.metadata = metadata2;
    }

    public final int getColumnIndex(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        int firstIgnoreCaseMatch = -1;
        int n = this.metadata.length;
        for (int i = 0; i < n; ++i) {
            RdResultSetColumnMetadata columnMetadata = this.metadata[i];
            if (columnMetadata.getName() == name || columnMetadata.getLabel() == name) {
                return i;
            }
            if (firstIgnoreCaseMatch != -1 || !StringsKt.equals(columnMetadata.getName(), name, true) && !StringsKt.equals(columnMetadata.getLabel(), name, true)) continue;
            firstIgnoreCaseMatch = i;
        }
        if (firstIgnoreCaseMatch == -1) {
            throw ExceptionsKt.noSuchColumn(name);
        }
        return firstIgnoreCaseMatch;
    }

    @NotNull
    public final RdResultSetColumnMetadata getMetadata(int index) {
        return this.metadata[index];
    }

    @NotNull
    public final RdResultSetColumnMetadata getMetadata(@NotNull String columnName) {
        Intrinsics.checkNotNullParameter(columnName, "columnName");
        int index = this.getColumnIndex(columnName);
        return this.metadata[index];
    }

    @Override
    @NotNull
    public Iterator<RdResultSetColumnMetadata> iterator() {
        return ArrayIteratorKt.iterator(this.metadata);
    }
}

