/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.resultsets.cursors.moves.relative;

import com.jetbrains.jdbc.base.resultsets.cursors.CursorPosition;
import com.jetbrains.jdbc.base.resultsets.cursors.IRemoteCursor;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.CursorMoveResult;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.CursorState;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.relative.IRelativeMove;
import com.jetbrains.jdbc.base.resultsets.models.FetchWindowMoveResult;
import com.jetbrains.jdbc.base.resultsets.models.windows.IFetchWindow;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0002J(\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0002J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/relative/RelativeMove;", "Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/relative/IRelativeMove;", "()V", "afterLast", "Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/CursorMoveResult;", "remoteCursor", "Lcom/jetbrains/jdbc/base/resultsets/cursors/IRemoteCursor;", "steps", "", "state", "Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/CursorState;", "beforeFirst", "fetchBackward", "position", "stepsFromCurrentPosition", "stepsToScroll", "fetchForward", "inResultSet", "Frontend"})
public final class RelativeMove
implements IRelativeMove {
    @NotNull
    public static final RelativeMove INSTANCE = new RelativeMove();

    private RelativeMove() {
    }

    @Override
    @NotNull
    public CursorMoveResult beforeFirst(@NotNull IRemoteCursor remoteCursor, int steps, @NotNull CursorState state) {
        Intrinsics.checkNotNullParameter(remoteCursor, "remoteCursor");
        Intrinsics.checkNotNullParameter(state, "state");
        throw ExceptionsKt.noCurrentRow();
    }

    @Override
    @NotNull
    public CursorMoveResult afterLast(@NotNull IRemoteCursor remoteCursor, int steps, @NotNull CursorState state) {
        Intrinsics.checkNotNullParameter(remoteCursor, "remoteCursor");
        Intrinsics.checkNotNullParameter(state, "state");
        throw ExceptionsKt.noCurrentRow();
    }

    @Override
    @NotNull
    public CursorMoveResult inResultSet(@NotNull IRemoteCursor remoteCursor, int steps, @NotNull CursorState state) {
        Intrinsics.checkNotNullParameter(remoteCursor, "remoteCursor");
        Intrinsics.checkNotNullParameter(state, "state");
        IFetchWindow fetchWindow = state.getFetchWindow();
        int position = state.getPosition();
        if (steps == 0) {
            return new CursorMoveResult(true, position, fetchWindow);
        }
        if (steps > 0) {
            FetchWindowMoveResult result2 = fetchWindow.moveForward(steps);
            if (result2.reachedDestination()) {
                return new CursorMoveResult(true, position += steps, fetchWindow);
            }
            return this.fetchForward(remoteCursor, position, steps, fetchWindow.getPosition() - 1 + result2.getStepsLeftToReachDestination());
        }
        FetchWindowMoveResult result3 = fetchWindow.moveBackward(steps);
        if (result3.reachedDestination()) {
            return new CursorMoveResult(true, position += steps, fetchWindow);
        }
        return this.fetchBackward(remoteCursor, position, steps, result3.getStepsLeftToReachDestination());
    }

    private final CursorMoveResult fetchForward(IRemoteCursor remoteCursor, int position, int stepsFromCurrentPosition, int stepsToScroll) {
        IFetchWindow fetchWindow = remoteCursor.fetchForward(stepsToScroll);
        boolean hasMoreRows = fetchWindow.next().reachedDestination();
        int newPosition = hasMoreRows ? position + stepsFromCurrentPosition : CursorPosition.AfterLast.getValue();
        return new CursorMoveResult(hasMoreRows, newPosition, fetchWindow);
    }

    private final CursorMoveResult fetchBackward(IRemoteCursor remoteCursor, int position, int stepsFromCurrentPosition, int stepsToScroll) {
        IFetchWindow fetchWindow = remoteCursor.fetchBackward(stepsToScroll);
        boolean hasMoreRows = fetchWindow.next().reachedDestination();
        int newPosition = hasMoreRows ? position + stepsFromCurrentPosition : CursorPosition.BeforeFirst.getValue();
        return new CursorMoveResult(hasMoreRows, newPosition, fetchWindow);
    }

    @Override
    public boolean isSupported() {
        return IRelativeMove.DefaultImpls.isSupported(this);
    }
}

