/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.resultsets.cursors.moves.next;

import com.jetbrains.jdbc.base.resultsets.cursors.CursorPosition;
import com.jetbrains.jdbc.base.resultsets.cursors.IRemoteCursor;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.CursorMoveResult;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.CursorState;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.next.INextMove;
import com.jetbrains.jdbc.base.resultsets.models.FetchWindowMoveResult;
import com.jetbrains.jdbc.base.resultsets.models.windows.IFetchWindow;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/next/NextMove;", "Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/next/INextMove;", "()V", "afterLast", "Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/CursorMoveResult;", "remoteCursor", "Lcom/jetbrains/jdbc/base/resultsets/cursors/IRemoteCursor;", "state", "Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/CursorState;", "beforeFirst", "fetchNext", "position", "", "inResultSet", "Frontend"})
public final class NextMove
implements INextMove {
    @NotNull
    public static final NextMove INSTANCE = new NextMove();

    private NextMove() {
    }

    @Override
    @NotNull
    public CursorMoveResult beforeFirst(@NotNull IRemoteCursor remoteCursor, @NotNull CursorState state) {
        Intrinsics.checkNotNullParameter(remoteCursor, "remoteCursor");
        Intrinsics.checkNotNullParameter(state, "state");
        return this.fetchNext(remoteCursor, 0);
    }

    @Override
    @NotNull
    public CursorMoveResult afterLast(@NotNull IRemoteCursor remoteCursor, @NotNull CursorState state) {
        Intrinsics.checkNotNullParameter(remoteCursor, "remoteCursor");
        Intrinsics.checkNotNullParameter(state, "state");
        return new CursorMoveResult(false, CursorPosition.AfterLast.getValue(), state.getFetchWindow());
    }

    @Override
    @NotNull
    public CursorMoveResult inResultSet(@NotNull IRemoteCursor remoteCursor, @NotNull CursorState state) {
        Intrinsics.checkNotNullParameter(remoteCursor, "remoteCursor");
        Intrinsics.checkNotNullParameter(state, "state");
        IFetchWindow fetchWindow = state.getFetchWindow();
        int position = state.getPosition();
        FetchWindowMoveResult result2 = fetchWindow.next();
        if (result2.reachedDestination()) {
            return new CursorMoveResult(true, ++position, fetchWindow);
        }
        return this.fetchNext(remoteCursor, position);
    }

    private final CursorMoveResult fetchNext(IRemoteCursor remoteCursor, int position) {
        IFetchWindow fetchWindow = remoteCursor.fetchNext();
        boolean hasMoreRows = fetchWindow.next().reachedDestination();
        int newPosition = hasMoreRows ? position + 1 : CursorPosition.AfterLast.getValue();
        return new CursorMoveResult(hasMoreRows, newPosition, fetchWindow);
    }

    @Override
    public boolean isSupported() {
        return INextMove.DefaultImpls.isSupported(this);
    }
}

