/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.resultsets.cursors.moves.absolute;

import com.jetbrains.jdbc.base.resultsets.cursors.CursorPosition;
import com.jetbrains.jdbc.base.resultsets.cursors.IRemoteCursor;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.CursorMoveResult;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.CursorState;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.absolute.IAbsoluteMove;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.beforeFirst.IBeforeFirstMove;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.first.IFirstMove;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.last.ILastMove;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.relative.IRelativeMove;
import com.jetbrains.jdbc.base.resultsets.models.windows.IFetchWindow;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/absolute/AbsoluteMove;", "Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/absolute/IAbsoluteMove;", "beforeFirstMove", "Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/beforeFirst/IBeforeFirstMove;", "firstMove", "Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/first/IFirstMove;", "lastMove", "Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/last/ILastMove;", "relativeMove", "Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/relative/IRelativeMove;", "(Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/beforeFirst/IBeforeFirstMove;Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/first/IFirstMove;Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/last/ILastMove;Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/relative/IRelativeMove;)V", "afterLast", "Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/CursorMoveResult;", "remoteCursor", "Lcom/jetbrains/jdbc/base/resultsets/cursors/IRemoteCursor;", "rowPosition", "", "state", "Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/CursorState;", "beforeFirst", "fetchAbsolute", "rowsCount", "inResultSet", "Frontend"})
public final class AbsoluteMove
implements IAbsoluteMove {
    @NotNull
    private final IBeforeFirstMove beforeFirstMove;
    @NotNull
    private final IFirstMove firstMove;
    @NotNull
    private final ILastMove lastMove;
    @NotNull
    private final IRelativeMove relativeMove;

    public AbsoluteMove(@NotNull IBeforeFirstMove beforeFirstMove, @NotNull IFirstMove firstMove, @NotNull ILastMove lastMove, @NotNull IRelativeMove relativeMove) {
        Intrinsics.checkNotNullParameter(beforeFirstMove, "beforeFirstMove");
        Intrinsics.checkNotNullParameter(firstMove, "firstMove");
        Intrinsics.checkNotNullParameter(lastMove, "lastMove");
        Intrinsics.checkNotNullParameter(relativeMove, "relativeMove");
        this.beforeFirstMove = beforeFirstMove;
        this.firstMove = firstMove;
        this.lastMove = lastMove;
        this.relativeMove = relativeMove;
    }

    @Override
    @NotNull
    public CursorMoveResult beforeFirst(@NotNull IRemoteCursor remoteCursor, int rowPosition, @NotNull CursorState state) {
        Intrinsics.checkNotNullParameter(remoteCursor, "remoteCursor");
        Intrinsics.checkNotNullParameter(state, "state");
        return this.fetchAbsolute(remoteCursor, state.getRowsCount(), rowPosition);
    }

    @Override
    @NotNull
    public CursorMoveResult afterLast(@NotNull IRemoteCursor remoteCursor, int rowPosition, @NotNull CursorState state) {
        Intrinsics.checkNotNullParameter(remoteCursor, "remoteCursor");
        Intrinsics.checkNotNullParameter(state, "state");
        return this.fetchAbsolute(remoteCursor, state.getRowsCount(), rowPosition);
    }

    @Override
    @NotNull
    public CursorMoveResult inResultSet(@NotNull IRemoteCursor remoteCursor, int rowPosition, @NotNull CursorState state) {
        Intrinsics.checkNotNullParameter(remoteCursor, "remoteCursor");
        Intrinsics.checkNotNullParameter(state, "state");
        int position = state.getPosition();
        int rowsCount = state.getRowsCount();
        return switch (rowPosition) {
            case 0 -> this.beforeFirstMove.inResultSet(remoteCursor, state);
            case 1 -> this.firstMove.inResultSet(remoteCursor, state);
            case -1 -> this.lastMove.inResultSet(remoteCursor, state);
            default -> rowPosition > 0 ? this.relativeMove.inResultSet(remoteCursor, rowPosition - position, state) : this.fetchAbsolute(remoteCursor, rowsCount, rowPosition);
        };
    }

    private final CursorMoveResult fetchAbsolute(IRemoteCursor remoteCursor, int rowsCount, int rowPosition) {
        IFetchWindow fetchWindow = remoteCursor.fetchAbsolute(rowPosition);
        boolean hasMoreRows = fetchWindow.next().reachedDestination();
        int newPosition = hasMoreRows ? (rowPosition > 0 ? rowPosition : rowsCount + rowPosition + 1) : (rowPosition > 0 ? CursorPosition.AfterLast.getValue() : CursorPosition.BeforeFirst.getValue());
        return new CursorMoveResult(hasMoreRows, newPosition, fetchWindow);
    }

    @Override
    public boolean isSupported() {
        return IAbsoluteMove.DefaultImpls.isSupported(this);
    }
}

