/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.resultsets.cursors;

import com.jetbrains.jdbc.base.factories.IRowsAndColumnsFactory;
import com.jetbrains.jdbc.base.resultsets.cursors.Cursor;
import com.jetbrains.jdbc.base.resultsets.cursors.IRemoteCursor;
import com.jetbrains.jdbc.base.resultsets.cursors.crud.ICursorCrudExecutor;
import com.jetbrains.jdbc.base.resultsets.cursors.crud.NotSupportedCrudExecutor;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.absolute.IAbsoluteMove;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.absolute.NotSupportedAbsoluteMove;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.afterLast.IAfterLastMove;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.afterLast.NotSupportedAfterLastMove;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.beforeFirst.IBeforeFirstMove;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.beforeFirst.NotSupportedBeforeFirstMove;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.first.IFirstMove;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.first.NotSupportedFirstMove;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.last.ILastMove;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.last.NotSupportedLastMove;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.next.INextMove;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.next.NotSupportedNextMove;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.previous.IPreviousMove;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.previous.NotSupportedPreviousMove;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.refresh.IRefreshMove;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.refresh.NotSupportedRefreshMove;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.relative.IRelativeMove;
import com.jetbrains.jdbc.base.resultsets.cursors.moves.relative.NotSupportedRelativeMove;
import com.jetbrains.jdbc.base.resultsets.cursors.position.ICursorPositionChecker;
import com.jetbrains.jdbc.base.resultsets.cursors.position.NotSupportedPositionChecker;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010*\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010+\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/jetbrains/jdbc/base/resultsets/cursors/CursorBuilder;", "", "rowsCount", "", "rowsAndColumnsFactory", "Lcom/jetbrains/jdbc/base/factories/IRowsAndColumnsFactory;", "remoteCursor", "Lcom/jetbrains/jdbc/base/resultsets/cursors/IRemoteCursor;", "(ILcom/jetbrains/jdbc/base/factories/IRowsAndColumnsFactory;Lcom/jetbrains/jdbc/base/resultsets/cursors/IRemoteCursor;)V", "absoluteMove", "Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/absolute/IAbsoluteMove;", "afterLastMove", "Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/afterLast/IAfterLastMove;", "beforeFirstMove", "Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/beforeFirst/IBeforeFirstMove;", "crudExecutor", "Lcom/jetbrains/jdbc/base/resultsets/cursors/crud/ICursorCrudExecutor;", "firstMove", "Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/first/IFirstMove;", "lastMove", "Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/last/ILastMove;", "nextMove", "Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/next/INextMove;", "positionChecker", "Lcom/jetbrains/jdbc/base/resultsets/cursors/position/ICursorPositionChecker;", "previousMove", "Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/previous/IPreviousMove;", "refreshMove", "Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/refresh/IRefreshMove;", "relativeMove", "Lcom/jetbrains/jdbc/base/resultsets/cursors/moves/relative/IRelativeMove;", "build", "Lcom/jetbrains/jdbc/base/resultsets/cursors/Cursor;", "withAbsolute", "withAfterLast", "withBeforeFirst", "withCrudExecutor", "withFirst", "withLast", "withNext", "withPositionChecker", "withPrevious", "withRefresh", "withRelative", "Frontend"})
public final class CursorBuilder {
    private final int rowsCount;
    @NotNull
    private final IRowsAndColumnsFactory rowsAndColumnsFactory;
    @NotNull
    private final IRemoteCursor remoteCursor;
    @Nullable
    private INextMove nextMove;
    @Nullable
    private IFirstMove firstMove;
    @Nullable
    private ILastMove lastMove;
    @Nullable
    private IRelativeMove relativeMove;
    @Nullable
    private IAbsoluteMove absoluteMove;
    @Nullable
    private IPreviousMove previousMove;
    @Nullable
    private IBeforeFirstMove beforeFirstMove;
    @Nullable
    private IAfterLastMove afterLastMove;
    @Nullable
    private IRefreshMove refreshMove;
    @Nullable
    private ICursorPositionChecker positionChecker;
    @Nullable
    private ICursorCrudExecutor crudExecutor;

    public CursorBuilder(int rowsCount, @NotNull IRowsAndColumnsFactory rowsAndColumnsFactory, @NotNull IRemoteCursor remoteCursor) {
        Intrinsics.checkNotNullParameter(rowsAndColumnsFactory, "rowsAndColumnsFactory");
        Intrinsics.checkNotNullParameter(remoteCursor, "remoteCursor");
        this.rowsCount = rowsCount;
        this.rowsAndColumnsFactory = rowsAndColumnsFactory;
        this.remoteCursor = remoteCursor;
    }

    @NotNull
    public final CursorBuilder withNext(@NotNull INextMove nextMove) {
        Intrinsics.checkNotNullParameter(nextMove, "nextMove");
        this.nextMove = nextMove;
        return this;
    }

    @NotNull
    public final CursorBuilder withFirst(@NotNull IFirstMove firstMove) {
        Intrinsics.checkNotNullParameter(firstMove, "firstMove");
        this.firstMove = firstMove;
        return this;
    }

    @NotNull
    public final CursorBuilder withLast(@NotNull ILastMove lastMove) {
        Intrinsics.checkNotNullParameter(lastMove, "lastMove");
        this.lastMove = lastMove;
        return this;
    }

    @NotNull
    public final CursorBuilder withRelative(@NotNull IRelativeMove relativeMove) {
        Intrinsics.checkNotNullParameter(relativeMove, "relativeMove");
        this.relativeMove = relativeMove;
        return this;
    }

    @NotNull
    public final CursorBuilder withAbsolute(@NotNull IAbsoluteMove absoluteMove) {
        Intrinsics.checkNotNullParameter(absoluteMove, "absoluteMove");
        this.absoluteMove = absoluteMove;
        return this;
    }

    @NotNull
    public final CursorBuilder withPrevious(@NotNull IPreviousMove previousMove) {
        Intrinsics.checkNotNullParameter(previousMove, "previousMove");
        this.previousMove = previousMove;
        return this;
    }

    @NotNull
    public final CursorBuilder withBeforeFirst(@NotNull IBeforeFirstMove beforeFirstMove) {
        Intrinsics.checkNotNullParameter(beforeFirstMove, "beforeFirstMove");
        this.beforeFirstMove = beforeFirstMove;
        return this;
    }

    @NotNull
    public final CursorBuilder withAfterLast(@NotNull IAfterLastMove afterLastMove) {
        Intrinsics.checkNotNullParameter(afterLastMove, "afterLastMove");
        this.afterLastMove = afterLastMove;
        return this;
    }

    @NotNull
    public final CursorBuilder withRefresh(@NotNull IRefreshMove refreshMove) {
        Intrinsics.checkNotNullParameter(refreshMove, "refreshMove");
        this.refreshMove = refreshMove;
        return this;
    }

    @NotNull
    public final CursorBuilder withPositionChecker(@NotNull ICursorPositionChecker positionChecker) {
        Intrinsics.checkNotNullParameter(positionChecker, "positionChecker");
        this.positionChecker = positionChecker;
        return this;
    }

    @NotNull
    public final CursorBuilder withCrudExecutor(@NotNull ICursorCrudExecutor crudExecutor) {
        Intrinsics.checkNotNullParameter(crudExecutor, "crudExecutor");
        this.crudExecutor = crudExecutor;
        return this;
    }

    @NotNull
    public final Cursor build() {
        ICursorCrudExecutor iCursorCrudExecutor;
        ICursorPositionChecker iCursorPositionChecker;
        IRefreshMove iRefreshMove;
        IAfterLastMove iAfterLastMove;
        IBeforeFirstMove iBeforeFirstMove;
        IPreviousMove iPreviousMove;
        IAbsoluteMove iAbsoluteMove;
        IRelativeMove iRelativeMove;
        ILastMove iLastMove;
        IFirstMove iFirstMove;
        INextMove iNextMove = this.nextMove;
        if (iNextMove == null) {
            iNextMove = NotSupportedNextMove.INSTANCE;
        }
        if ((iFirstMove = this.firstMove) == null) {
            iFirstMove = NotSupportedFirstMove.INSTANCE;
        }
        if ((iLastMove = this.lastMove) == null) {
            iLastMove = NotSupportedLastMove.INSTANCE;
        }
        if ((iRelativeMove = this.relativeMove) == null) {
            iRelativeMove = NotSupportedRelativeMove.INSTANCE;
        }
        if ((iAbsoluteMove = this.absoluteMove) == null) {
            iAbsoluteMove = NotSupportedAbsoluteMove.INSTANCE;
        }
        if ((iPreviousMove = this.previousMove) == null) {
            iPreviousMove = NotSupportedPreviousMove.INSTANCE;
        }
        if ((iBeforeFirstMove = this.beforeFirstMove) == null) {
            iBeforeFirstMove = NotSupportedBeforeFirstMove.INSTANCE;
        }
        if ((iAfterLastMove = this.afterLastMove) == null) {
            iAfterLastMove = NotSupportedAfterLastMove.INSTANCE;
        }
        if ((iRefreshMove = this.refreshMove) == null) {
            iRefreshMove = NotSupportedRefreshMove.INSTANCE;
        }
        if ((iCursorPositionChecker = this.positionChecker) == null) {
            iCursorPositionChecker = NotSupportedPositionChecker.INSTANCE;
        }
        if ((iCursorCrudExecutor = this.crudExecutor) == null) {
            iCursorCrudExecutor = NotSupportedCrudExecutor.INSTANCE;
        }
        return new Cursor(iNextMove, iFirstMove, iLastMove, iRelativeMove, iAbsoluteMove, iPreviousMove, iBeforeFirstMove, iAfterLastMove, iRefreshMove, iCursorPositionChecker, iCursorCrudExecutor, this.remoteCursor, this.rowsAndColumnsFactory, this.rowsCount);
    }
}

