/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.models.sql.xml.states;

import com.jetbrains.jdbc.base.models.sql.xml.XmlApiProvider;
import com.jetbrains.jdbc.base.models.sql.xml.XmlResult;
import com.jetbrains.jdbc.base.models.sql.xml.apis.interfaces.XmlResultGetter;
import com.jetbrains.jdbc.base.models.sql.xml.states.ByteArrayOutputStreamToInputStream;
import com.jetbrains.jdbc.base.models.sql.xml.states.XmlState;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J'\u0010\r\u001a\u0002H\u000e\"\n\b\u0000\u0010\u000e*\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J'\u0010\u001a\u001a\u0002H\u000e\"\n\b\u0000\u0010\u000e*\u0004\u0018\u00010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0011H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0014H\u0016J\b\u0010\u001f\u001a\u00020\bH\u0002J\b\u0010 \u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/jdbc/base/models/sql/xml/states/SendingXmlState;", "Lcom/jetbrains/jdbc/base/models/sql/xml/states/XmlState;", "()V", "provider", "Lcom/jetbrains/jdbc/base/models/sql/xml/XmlApiProvider;", "value", "", "free", "", "getBinaryStream", "Ljava/io/InputStream;", "getCharacterStream", "Ljava/io/Reader;", "getSource", "T", "Ljavax/xml/transform/Source;", "sourceClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljavax/xml/transform/Source;", "getString", "", "getValue", "setBinaryStream", "Ljava/io/OutputStream;", "setCharacterStream", "Ljava/io/Writer;", "setResult", "Ljavax/xml/transform/Result;", "resultClass", "(Ljava/lang/Class;)Ljavax/xml/transform/Result;", "setString", "throwIfAlreadyWritten", "throwIfWasNotWritten", "Frontend"})
public final class SendingXmlState
implements XmlState {
    @NotNull
    private final XmlApiProvider provider = new XmlApiProvider();
    private Object value;

    @Override
    @NotNull
    public String getValue() {
        Object object;
        this.throwIfWasNotWritten();
        Object object2 = this.value;
        if (object2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("value");
            object2 = Unit.INSTANCE;
        }
        if ((object = object2) instanceof Document) {
            StringWriter writer = new StringWriter();
            TransformerFactory factory = null;
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Intrinsics.checkNotNullExpressionValue(transformerFactory, "newInstance()");
                factory = transformerFactory;
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                Transformer transformer = factory.newTransformer();
                Object object3 = this.value;
                if (object3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("value");
                    object3 = Unit.INSTANCE;
                }
                transformer.transform(new DOMSource((Document)object3), new StreamResult(writer));
            }
            catch (TransformerException e) {
                throw new Exception();
            }
            String string = writer.toString();
            Intrinsics.checkNotNullExpressionValue(string, "writer.toString()");
            return string;
        }
        if (object instanceof StringWriter) {
            Object object4 = this.value;
            if (object4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("value");
                object4 = Unit.INSTANCE;
            }
            return object4.toString();
        }
        if (object instanceof String) {
            Object object5 = this.value;
            if (object5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("value");
                object5 = Unit.INSTANCE;
            }
            return (String)object5;
        }
        if (object instanceof OutputStream) {
            Object object6 = this.value;
            if (object6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("value");
                object6 = Unit.INSTANCE;
            }
            byte[] bytes = ((ByteArrayOutputStreamToInputStream)object6).getInputStream().readAllBytes();
            Intrinsics.checkNotNullExpressionValue(bytes, "bytes");
            byte[] byArray = bytes;
            Charset charset = Charset.forName("UTF-16LE");
            Intrinsics.checkNotNullExpressionValue(charset, "forName(\"UTF-16LE\")");
            Charset charset2 = charset;
            return new String(byArray, charset2);
        }
        throw new Exception();
    }

    @Override
    public void free() {
    }

    @Override
    @NotNull
    public InputStream getBinaryStream() {
        throw ExceptionsKt.xmlIsWriteOnly();
    }

    @Override
    @NotNull
    public OutputStream setBinaryStream() {
        this.throwIfAlreadyWritten();
        this.value = new ByteArrayOutputStreamToInputStream();
        Object object = this.value;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException("value");
            object = Unit.INSTANCE;
        }
        return (OutputStream)object;
    }

    @Override
    @NotNull
    public Reader getCharacterStream() {
        throw ExceptionsKt.xmlIsWriteOnly();
    }

    @Override
    @NotNull
    public Writer setCharacterStream() {
        this.throwIfAlreadyWritten();
        this.value = new StringWriter();
        Object object = this.value;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException("value");
            object = Unit.INSTANCE;
        }
        return (StringWriter)object;
    }

    @Override
    @NotNull
    public String getString() {
        throw ExceptionsKt.xmlIsWriteOnly();
    }

    @Override
    public void setString(@NotNull String value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        this.throwIfAlreadyWritten();
        this.value = value2;
    }

    @Override
    public <T extends Source> T getSource(@NotNull Class<T> sourceClass) {
        Intrinsics.checkNotNullParameter(sourceClass, "sourceClass");
        throw ExceptionsKt.xmlIsWriteOnly();
    }

    @Override
    public <T extends Result> T setResult(@NotNull Class<T> resultClass) {
        Intrinsics.checkNotNullParameter(resultClass, "resultClass");
        this.throwIfAlreadyWritten();
        XmlResultGetter<T> getter = this.provider.getResultGetter(resultClass);
        XmlResult<T> xmlResult = getter.getResult();
        this.value = xmlResult.getValueToTrack();
        return (T)((Result)xmlResult.getResult());
    }

    private final void throwIfAlreadyWritten() {
        if (this.value != null) {
            throw ExceptionsKt.xmlWasAlreadyWritten();
        }
    }

    private final void throwIfWasNotWritten() {
        if (this.value == null) {
            throw ExceptionsKt.xmlWasNotWritten();
        }
    }
}

