/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.models.sql.xml.states;

import com.jetbrains.jdbc.base.models.sql.xml.XmlApiProvider;
import com.jetbrains.jdbc.base.models.sql.xml.apis.interfaces.XmlSourceGetter;
import com.jetbrains.jdbc.base.models.sql.xml.states.XmlState;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J'\u0010\u000f\u001a\u0002H\u0010\"\n\b\u0000\u0010\u0010*\u0004\u0018\u00010\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0003H\u0016J\b\u0010\u0016\u001a\u00020\u0003H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J'\u0010\u001b\u001a\u0002H\u0010\"\n\b\u0000\u0010\u0010*\u0004\u0018\u00010\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0013H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010 \u001a\u00020\nH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/jdbc/base/models/sql/xml/states/ReceivingXmlState;", "Lcom/jetbrains/jdbc/base/models/sql/xml/states/XmlState;", "value", "", "(Ljava/lang/String;)V", "provider", "Lcom/jetbrains/jdbc/base/models/sql/xml/XmlApiProvider;", "wasRead", "", "free", "", "getBinaryStream", "Ljava/io/InputStream;", "getCharacterStream", "Ljava/io/Reader;", "getSource", "T", "Ljavax/xml/transform/Source;", "sourceClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Ljavax/xml/transform/Source;", "getString", "getValue", "setBinaryStream", "Ljava/io/OutputStream;", "setCharacterStream", "Ljava/io/Writer;", "setResult", "Ljavax/xml/transform/Result;", "resultClass", "(Ljava/lang/Class;)Ljavax/xml/transform/Result;", "setString", "throwIfAlreadyRead", "Frontend"})
public final class ReceivingXmlState
implements XmlState {
    @NotNull
    private final String value;
    @NotNull
    private final XmlApiProvider provider;
    private boolean wasRead;

    public ReceivingXmlState(@NotNull String value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        this.value = value2;
        this.provider = new XmlApiProvider();
    }

    @Override
    public void free() {
    }

    @Override
    @NotNull
    public InputStream getBinaryStream() {
        this.throwIfAlreadyRead();
        this.wasRead = true;
        String string = this.value;
        Charset charset = Charset.forName("UTF-16LE");
        Intrinsics.checkNotNullExpressionValue(charset, "forName(\"UTF-16LE\")");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        byte[] bytes = byArray;
        return new ByteArrayInputStream(bytes);
    }

    @Override
    @NotNull
    public OutputStream setBinaryStream() {
        throw ExceptionsKt.xmlIsReadOnly();
    }

    @Override
    @NotNull
    public Reader getCharacterStream() {
        this.throwIfAlreadyRead();
        this.wasRead = true;
        return new StringReader(this.value);
    }

    @Override
    @NotNull
    public Writer setCharacterStream() {
        throw ExceptionsKt.xmlIsReadOnly();
    }

    @Override
    @NotNull
    public String getString() {
        this.throwIfAlreadyRead();
        this.wasRead = true;
        return this.value;
    }

    @Override
    public void setString(@NotNull String value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        throw ExceptionsKt.xmlIsReadOnly();
    }

    @Override
    public <T extends Source> T getSource(@NotNull Class<T> sourceClass) {
        Intrinsics.checkNotNullParameter(sourceClass, "sourceClass");
        this.throwIfAlreadyRead();
        this.wasRead = true;
        XmlSourceGetter<T> getter = this.provider.getSourceGetter(sourceClass);
        return (T)((Source)getter.getSource(this.value));
    }

    @Override
    public <T extends Result> T setResult(@NotNull Class<T> resultClass) {
        Intrinsics.checkNotNullParameter(resultClass, "resultClass");
        throw ExceptionsKt.xmlIsReadOnly();
    }

    @Override
    @NotNull
    public String getValue() {
        throw ExceptionsKt.xmlIsReadOnly();
    }

    private final void throwIfAlreadyRead() {
        if (this.wasRead) {
            throw ExceptionsKt.xmlWasAlreadyRead();
        }
    }
}

