/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.models.sql;

import com.jetbrains.jdbc.base.models.sql.ProtocolInMemoryClobBase;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\r\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/jdbc/base/models/sql/ClobWriter;", "Ljava/io/Writer;", "clob", "Lcom/jetbrains/jdbc/base/models/sql/ProtocolInMemoryClobBase;", "streamPos", "", "(Lcom/jetbrains/jdbc/base/models/sql/ProtocolInMemoryClobBase;J)V", "isClosed", "", "checkClosed", "", "close", "flush", "write", "cbuf", "", "off", "", "len", "b", "str", "", "Frontend"})
public final class ClobWriter
extends Writer {
    @NotNull
    private ProtocolInMemoryClobBase clob;
    private long streamPos;
    private boolean isClosed;

    public ClobWriter(@NotNull ProtocolInMemoryClobBase clob, long streamPos) {
        Intrinsics.checkNotNullParameter(clob, "clob");
        this.clob = clob;
        this.streamPos = streamPos;
    }

    @Override
    public void write(@NotNull char[] cbuf) {
        Intrinsics.checkNotNullParameter(cbuf, "cbuf");
        this.checkClosed();
        this.write(new String(cbuf));
    }

    @Override
    public void write(@NotNull char[] cbuf, int off, int len) {
        Intrinsics.checkNotNullParameter(cbuf, "cbuf");
        this.checkClosed();
        this.write(new String(cbuf, off, len));
    }

    @Override
    public void write(int b) {
        this.checkClosed();
        char[] c = new char[]{(char)b};
        this.write(new String(c));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(@NotNull String str, int off, int len) {
        long l;
        long l2;
        Intrinsics.checkNotNullParameter(str, "str");
        this.checkClosed();
        long l3 = this.streamPos;
        ClobWriter clobWriter = this;
        try {
            ClobWriter clobWriter2 = clobWriter;
            l2 = l3;
            int charsWritten = this.clob.setString(this.streamPos, str, off, len);
            l = charsWritten;
        }
        catch (SQLException sQLException) {
            void ex;
            ClobWriter clobWriter3 = clobWriter;
            long l4 = l3;
            throw new IOException(ex.getMessage());
        }
        clobWriter2.streamPos = l2 + l;
    }

    @Override
    public void write(@NotNull String str) {
        Intrinsics.checkNotNullParameter(str, "str");
        this.checkClosed();
        this.write(str, 0, str.length());
    }

    @Override
    public void flush() {
        this.checkClosed();
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    private final void checkClosed() {
        if (this.isClosed) {
            throw ExceptionsKt.clobClosed();
        }
    }
}

