/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.conversions.set;

import com.jetbrains.jdbc.base.conversions.set.SetValueConverter;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import java.sql.SQLType;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\bR*\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0004`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/jdbc/base/conversions/set/SetValueConverterProvider;", "", "converters", "", "Lcom/jetbrains/jdbc/base/conversions/set/SetValueConverter;", "([Lcom/jetbrains/jdbc/base/conversions/set/SetValueConverter;)V", "map", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "getConverter", "targetType", "Frontend"})
public final class SetValueConverterProvider {
    @NotNull
    private final HashMap<Integer, SetValueConverter> map;

    public SetValueConverterProvider(SetValueConverter ... converters) {
        Intrinsics.checkNotNullParameter(converters, "converters");
        this.map = new HashMap();
        for (SetValueConverter converter : converters) {
            for (SQLType type2 : converter.getTo()) {
                if (this.map.containsKey(type2.getVendorTypeNumber())) {
                    throw ExceptionsKt.duplicateConverterFound(type2);
                }
                Map map2 = this.map;
                Integer n = type2.getVendorTypeNumber();
                Intrinsics.checkNotNullExpressionValue(n, "type.vendorTypeNumber");
                map2.put(n, converter);
            }
        }
    }

    @NotNull
    public final SetValueConverter getConverter(int targetType) {
        SetValueConverter setValueConverter = this.map.get(targetType);
        if (setValueConverter == null) {
            throw ExceptionsKt.cantSetValueToType(targetType);
        }
        return setValueConverter;
    }
}

