/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.conversions.get;

import com.jetbrains.jdbc.base.models.RdGetValueResponse;
import com.jetbrains.jdbc.base.models.sql.ProtocolInMemoryBlob;
import com.jetbrains.jdbc.base.models.sql.ProtocolInMemoryClob;
import com.jetbrains.jdbc.base.models.sql.ProtocolInMemoryNClob;
import com.jetbrains.jdbc.base.models.sql.xml.ProtocolXml;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00f6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u0015J\u0017\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u0018J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0017\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010!J\u0017\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010$J\u0017\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010'J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0017\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u00100J\u0012\u00101\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u00102\u001a\u0004\u0018\u0001032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u00104\u001a\u0004\u0018\u0001052\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u00106\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u000bH&J)\u00106\u001a\u0004\u0018\u0001H7\"\u0004\b\u0000\u001072\u0006\u0010\n\u001a\u00020\u000b2\f\u00108\u001a\b\u0012\u0004\u0012\u0002H709\u00a2\u0006\u0002\u0010:J\u0012\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010=\u001a\u0004\u0018\u00010>2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010?\u001a\u00020@2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010A\u001a\u00020B2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0017\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010EJ\u001a\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010H\u001a\u00020IH\u0016J\u0012\u0010J\u001a\u0004\u0018\u00010K2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010L\u001a\u0004\u0018\u0001052\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010M\u001a\u0004\u0018\u00010N2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010H\u001a\u00020IH\u0016J\u001a\u0010O\u001a\u0004\u0018\u00010P2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010H\u001a\u00020IH\u0016J\u0010\u0010Q\u001a\u00020R2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010S\u001a\u0004\u0018\u00010T2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010U\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010V\u001a\u0004\u0018\u00010W2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006X"}, d2={"Lcom/jetbrains/jdbc/base/conversions/get/GetValueConverter;", "", "()V", "from", "", "Ljava/sql/SQLType;", "getFrom", "()Ljava/util/List;", "getArray", "Ljava/sql/Array;", "response", "Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;", "getAsciiStream", "Ljava/io/InputStream;", "getBigDecimal", "Ljava/math/BigDecimal;", "getBinaryStream", "getBlob", "Ljava/sql/Blob;", "getBoolean", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Boolean;", "getByte", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Byte;", "getBytes", "", "getCharacterStream", "Ljava/io/Reader;", "getClob", "Ljava/sql/Clob;", "getDouble", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Double;", "getFloat", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Float;", "getInt", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Integer;", "getLocalDate", "Ljava/time/LocalDate;", "getLocalDateTime", "Ljava/time/LocalDateTime;", "getLocalTime", "Ljava/time/LocalTime;", "getLong", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Long;", "getNCharacterStream", "getNClob", "Ljava/sql/NClob;", "getNString", "", "getObject", "T", "type", "Ljava/lang/Class;", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;Ljava/lang/Class;)Ljava/lang/Object;", "getOffsetDateTime", "Ljava/time/OffsetDateTime;", "getOffsetTime", "Ljava/time/OffsetTime;", "getRef", "Ljava/sql/Ref;", "getRowId", "Ljava/sql/RowId;", "getShort", "", "(Lcom/jetbrains/jdbc/base/models/RdGetValueResponse;)Ljava/lang/Short;", "getSqlDate", "Ljava/sql/Date;", "timeZone", "Ljava/util/TimeZone;", "getSqlXml", "Ljava/sql/SQLXML;", "getString", "getTime", "Ljava/sql/Time;", "getTimestamp", "Ljava/sql/Timestamp;", "getURL", "Ljava/net/URL;", "getUUID", "Ljava/util/UUID;", "getUnicodeStream", "getUtilDate", "Ljava/util/Date;", "Frontend"})
public abstract class GetValueConverter {
    @NotNull
    public abstract List<SQLType> getFrom();

    @Nullable
    public String getString(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = String.class.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "String::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Nullable
    public Boolean getBoolean(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = Boolean.TYPE.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "Boolean::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Nullable
    public Byte getByte(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = Byte.TYPE.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "Byte::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Nullable
    public Short getShort(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = Short.TYPE.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "Short::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Nullable
    public Integer getInt(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = Integer.TYPE.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "Int::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Nullable
    public Long getLong(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = Long.TYPE.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "Long::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Nullable
    public Float getFloat(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = Float.TYPE.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "Float::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Nullable
    public Double getDouble(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = Double.TYPE.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "Double::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Nullable
    public BigDecimal getBigDecimal(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = BigDecimal.class.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "BigDecimal::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Nullable
    public byte[] getBytes(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = byte[].class.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "ByteArray::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Nullable
    public Date getSqlDate(@NotNull RdGetValueResponse response, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter(response, "response");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = Date.class.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "Date::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Nullable
    public java.util.Date getUtilDate(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = Date.class.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "Date::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Nullable
    public Time getTime(@NotNull RdGetValueResponse response, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter(response, "response");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = Time.class.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "Time::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Nullable
    public Timestamp getTimestamp(@NotNull RdGetValueResponse response, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter(response, "response");
        Intrinsics.checkNotNullParameter(timeZone, "timeZone");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = Timestamp.class.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "Timestamp::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Nullable
    public LocalDateTime getLocalDateTime(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = LocalDateTime.class.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "LocalDateTime::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Nullable
    public LocalDate getLocalDate(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = LocalDate.class.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "LocalDate::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Nullable
    public LocalTime getLocalTime(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = LocalTime.class.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "LocalTime::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Nullable
    public OffsetDateTime getOffsetDateTime(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = OffsetDateTime.class.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "OffsetDateTime::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Nullable
    public OffsetTime getOffsetTime(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = OffsetTime.class.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "OffsetTime::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Nullable
    public InputStream getAsciiStream(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = InputStream.class.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "InputStream::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Nullable
    public InputStream getBinaryStream(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = InputStream.class.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "InputStream::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Nullable
    public InputStream getUnicodeStream(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = InputStream.class.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "InputStream::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Nullable
    public Reader getCharacterStream(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = Reader.class.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "Reader::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Nullable
    public String getNString(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = String.class.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "String::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Nullable
    public Reader getNCharacterStream(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = Reader.class.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "Reader::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Nullable
    public Blob getBlob(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = Blob.class.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "Blob::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Nullable
    public Clob getClob(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = Clob.class.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "Clob::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @NotNull
    public Array getArray(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = Array.class.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "Array::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @NotNull
    public URL getURL(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = URL.class.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "URL::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @NotNull
    public RowId getRowId(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = RowId.class.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "RowId::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @NotNull
    public Ref getRef(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = Ref.class.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "Ref::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Nullable
    public NClob getNClob(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = NClob.class.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "NClob::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Nullable
    public SQLXML getSqlXml(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = SQLXML.class.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "SQLXML::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Nullable
    public UUID getUUID(@NotNull RdGetValueResponse response) {
        Intrinsics.checkNotNullParameter(response, "response");
        String string = this.getFrom().get(0).getName();
        Intrinsics.checkNotNullExpressionValue(string, "from[0].name");
        String string2 = UUID.class.getName();
        Intrinsics.checkNotNullExpressionValue(string2, "UUID::class.java.name");
        throw ExceptionsKt.notSupportedConversion(string, string2);
    }

    @Nullable
    public abstract Object getObject(@NotNull RdGetValueResponse var1);

    @Nullable
    public final <T> T getObject(@NotNull RdGetValueResponse response, @NotNull Class<T> type2) {
        Intrinsics.checkNotNullParameter(response, "response");
        Intrinsics.checkNotNullParameter(type2, "type");
        Object returnValue = null;
        Class<T> clazz = type2;
        if (Intrinsics.areEqual(clazz, String.class)) {
            returnValue = this.getString(response);
        } else if (Intrinsics.areEqual(clazz, Byte.class)) {
            returnValue = this.getByte(response);
        } else if (Intrinsics.areEqual(clazz, Short.class)) {
            returnValue = this.getShort(response);
        } else if (Intrinsics.areEqual(clazz, Integer.class)) {
            returnValue = this.getInt(response);
        } else if (Intrinsics.areEqual(clazz, Long.class)) {
            returnValue = this.getLong(response);
        } else if (Intrinsics.areEqual(clazz, BigDecimal.class)) {
            returnValue = this.getBigDecimal(response);
        } else if (Intrinsics.areEqual(clazz, Boolean.class)) {
            returnValue = this.getBoolean(response);
        } else if (Intrinsics.areEqual(clazz, Date.class)) {
            TimeZone timeZone = TimeZone.getDefault();
            Intrinsics.checkNotNullExpressionValue(timeZone, "getDefault()");
            returnValue = this.getSqlDate(response, timeZone);
        } else if (Intrinsics.areEqual(clazz, java.util.Date.class)) {
            returnValue = this.getUtilDate(response);
        } else if (Intrinsics.areEqual(clazz, Time.class)) {
            TimeZone timeZone = TimeZone.getDefault();
            Intrinsics.checkNotNullExpressionValue(timeZone, "getDefault()");
            returnValue = this.getTime(response, timeZone);
        } else if (Intrinsics.areEqual(clazz, Timestamp.class)) {
            TimeZone timeZone = TimeZone.getDefault();
            Intrinsics.checkNotNullExpressionValue(timeZone, "getDefault()");
            returnValue = this.getTimestamp(response, timeZone);
        } else if (Intrinsics.areEqual(clazz, LocalDateTime.class)) {
            returnValue = this.getLocalDateTime(response);
        } else if (Intrinsics.areEqual(clazz, LocalDate.class)) {
            returnValue = this.getLocalDate(response);
        } else if (Intrinsics.areEqual(clazz, LocalTime.class)) {
            returnValue = this.getLocalTime(response);
        } else if (Intrinsics.areEqual(clazz, OffsetDateTime.class)) {
            returnValue = this.getOffsetDateTime(response);
        } else if (Intrinsics.areEqual(clazz, OffsetTime.class)) {
            returnValue = this.getOffsetTime(response);
        } else if (Intrinsics.areEqual(clazz, SQLXML.class) ? true : Intrinsics.areEqual(clazz, ProtocolXml.class)) {
            returnValue = this.getSqlXml(response);
        } else if (Intrinsics.areEqual(clazz, Blob.class) ? true : Intrinsics.areEqual(clazz, ProtocolInMemoryBlob.class)) {
            returnValue = this.getBlob(response);
        } else if (Intrinsics.areEqual(clazz, Clob.class) ? true : Intrinsics.areEqual(clazz, ProtocolInMemoryClob.class)) {
            returnValue = this.getClob(response);
        } else if (Intrinsics.areEqual(clazz, NClob.class) ? true : Intrinsics.areEqual(clazz, ProtocolInMemoryNClob.class)) {
            returnValue = this.getNClob(response);
        } else if (Intrinsics.areEqual(clazz, byte[].class)) {
            returnValue = this.getBytes(response);
        } else if (Intrinsics.areEqual(clazz, Float.class)) {
            returnValue = this.getFloat(response);
        } else if (Intrinsics.areEqual(clazz, Double.class)) {
            returnValue = this.getDouble(response);
        } else if (Intrinsics.areEqual(clazz, UUID.class)) {
            returnValue = this.getUUID(response);
        } else if (Intrinsics.areEqual(clazz, Reader.class)) {
            returnValue = this.getCharacterStream(response);
        } else if (Intrinsics.areEqual(clazz, Object.class)) {
            returnValue = this.getObject(response);
        } else {
            throw ExceptionsKt.notSupportedConversion(type2);
        }
        return type2.cast(returnValue);
    }
}

