/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdbc.base.connections;

import com.jetbrains.jdbc.base.factories.jdbc.JdbcFactory;
import com.jetbrains.jdbc.base.models.JdbcModel;
import com.jetbrains.jdbc.base.models.RdDatabaseMetadata;
import com.jetbrains.jdbc.base.models.RdGetAttributesRequest;
import com.jetbrains.jdbc.base.models.RdGetBestRowIdentifierRequest;
import com.jetbrains.jdbc.base.models.RdGetColumnPrivilegesRequest;
import com.jetbrains.jdbc.base.models.RdGetColumnsRequest;
import com.jetbrains.jdbc.base.models.RdGetCrossReferenceRequest;
import com.jetbrains.jdbc.base.models.RdGetFunctionColumnsRequest;
import com.jetbrains.jdbc.base.models.RdGetFunctionsRequest;
import com.jetbrains.jdbc.base.models.RdGetIndexInfoRequest;
import com.jetbrains.jdbc.base.models.RdGetKeysRequest;
import com.jetbrains.jdbc.base.models.RdGetProcedureColumnsRequest;
import com.jetbrains.jdbc.base.models.RdGetProceduresRequest;
import com.jetbrains.jdbc.base.models.RdGetPseudoColumnsRequest;
import com.jetbrains.jdbc.base.models.RdGetSchemasRequest;
import com.jetbrains.jdbc.base.models.RdGetSuperTablesRequest;
import com.jetbrains.jdbc.base.models.RdGetSuperTypesRequest;
import com.jetbrains.jdbc.base.models.RdGetTablePrivilegesRequest;
import com.jetbrains.jdbc.base.models.RdGetTablesRequest;
import com.jetbrains.jdbc.base.models.RdGetUDTsRequest;
import com.jetbrains.jdbc.base.models.RdGetVersionColumnsRequest;
import com.jetbrains.jdbc.base.utils.exceptions.ExceptionsKt;
import com.jetbrains.jdbc.base.utils.protocol.RdDatabaseMetadataExtKt;
import com.jetbrains.jdbc.base.utils.protocol.initialization.ResultSetInitializationData;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b&\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ0\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0012H\u0016J6\u0010\u0016\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0010H\u0016J\b\u0010\u001e\u001a\u00020\u0010H\u0016J0\u0010\u001f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u00122\b\u0010 \u001a\u0004\u0018\u00010\u0012H\u0016J0\u0010!\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\"\u001a\u0004\u0018\u00010\u00122\b\u0010 \u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010#\u001a\u00020\u0005H\u0016JD\u0010$\u001a\u00020\u00102\b\u0010%\u001a\u0004\u0018\u00010\u00122\b\u0010&\u001a\u0004\u0018\u00010\u00122\b\u0010'\u001a\u0004\u0018\u00010\u00122\b\u0010(\u001a\u0004\u0018\u00010\u00122\b\u0010)\u001a\u0004\u0018\u00010\u00122\b\u0010*\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010+\u001a\u00020\u001aH\u0016J\b\u0010,\u001a\u00020\u001aH\u0016J\b\u0010-\u001a\u00020\u0012H\u0016J&\u0010.\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u0012H\u0016J0\u0010/\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u00100\u001a\u0004\u0018\u00010\u00122\b\u0010 \u001a\u0004\u0018\u00010\u0012H\u0016J&\u00101\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u00100\u001a\u0004\u0018\u00010\u0012H\u0016J&\u00102\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u0012H\u0016J6\u00103\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u00122\u0006\u00104\u001a\u00020\u001c2\u0006\u00105\u001a\u00020\u001cH\u0016J\b\u00106\u001a\u00020\u001aH\u0016J&\u00107\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u0012H\u0016J0\u00108\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u00109\u001a\u0004\u0018\u00010\u00122\b\u0010 \u001a\u0004\u0018\u00010\u0012H\u0016J&\u0010:\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u00109\u001a\u0004\u0018\u00010\u0012H\u0016J0\u0010;\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\"\u001a\u0004\u0018\u00010\u00122\b\u0010 \u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010<\u001a\u00020\u0010H\u0016J\u001c\u0010<\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0016J&\u0010=\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\"\u001a\u0004\u0018\u00010\u0012H\u0016J&\u0010>\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0012H\u0016J&\u0010?\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\"\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010@\u001a\u00020\u0010H\u0016J;\u0010A\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\"\u001a\u0004\u0018\u00010\u00122\u000e\u0010B\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010CH\u0016\u00a2\u0006\u0002\u0010DJ\b\u0010E\u001a\u00020\u0010H\u0016J0\u0010F\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u00122\b\u0010B\u001a\u0004\u0018\u00010GH\u0016J\b\u0010H\u001a\u00020\u0012H\u0016J\b\u0010I\u001a\u00020\u0012H\u0016J&\u0010J\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u0012H\u0016J\u0016\u0010K\u001a\u00020\u001c2\f\u0010L\u001a\b\u0012\u0002\b\u0003\u0018\u00010MH\u0016J\b\u0010N\u001a\u00020OH\u0002J%\u0010P\u001a\u0004\u0018\u0001HQ\"\u0004\b\u0000\u0010Q2\u000e\u0010L\u001a\n\u0012\u0004\u0012\u0002HQ\u0018\u00010MH\u0016\u00a2\u0006\u0002\u0010RR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lcom/jetbrains/jdbc/base/connections/ProtocolDatabaseMetaData;", "Ljava/sql/DatabaseMetaData;", "lifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "connection", "Ljava/sql/Connection;", "remoteDatabaseMetaData", "Lcom/jetbrains/jdbc/base/models/RdDatabaseMetadata;", "rdModel", "Lcom/jetbrains/jdbc/base/models/JdbcModel;", "jdbcFactory", "Lcom/jetbrains/jdbc/base/factories/jdbc/JdbcFactory;", "(Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;Ljava/sql/Connection;Lcom/jetbrains/jdbc/base/models/RdDatabaseMetadata;Lcom/jetbrains/jdbc/base/models/JdbcModel;Lcom/jetbrains/jdbc/base/factories/jdbc/JdbcFactory;)V", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getAttributes", "Ljava/sql/ResultSet;", "catalog", "", "schemaPattern", "typeNamePattern", "attributeNamePattern", "getBestRowIdentifier", "schema", "table", "scope", "", "nullable", "", "getCatalogs", "getClientInfoProperties", "getColumnPrivileges", "columnNamePattern", "getColumns", "tableNamePattern", "getConnection", "getCrossReference", "parentCatalog", "parentSchema", "parentTable", "foreignCatalog", "foreignSchema", "foreignTable", "getDatabaseMajorVersion", "getDatabaseMinorVersion", "getDatabaseProductVersion", "getExportedKeys", "getFunctionColumns", "functionNamePattern", "getFunctions", "getImportedKeys", "getIndexInfo", "unique", "approximate", "getMaxConnections", "getPrimaryKeys", "getProcedureColumns", "procedureNamePattern", "getProcedures", "getPseudoColumns", "getSchemas", "getSuperTables", "getSuperTypes", "getTablePrivileges", "getTableTypes", "getTables", "types", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Ljava/sql/ResultSet;", "getTypeInfo", "getUDTs", "", "getURL", "getUserName", "getVersionColumns", "isWrapperFor", "iface", "Ljava/lang/Class;", "throwIfClosed", "", "unwrap", "T", "(Ljava/lang/Class;)Ljava/lang/Object;", "Frontend"})
public abstract class ProtocolDatabaseMetaData
implements DatabaseMetaData {
    @NotNull
    private final Connection connection;
    @NotNull
    private final RdDatabaseMetadata remoteDatabaseMetaData;
    @NotNull
    private final JdbcModel rdModel;
    @NotNull
    private final JdbcFactory jdbcFactory;
    @NotNull
    private final Lifetime lifetime;

    public ProtocolDatabaseMetaData(@NotNull LifetimeDefinition lifetimeDefinition, @NotNull Connection connection, @NotNull RdDatabaseMetadata remoteDatabaseMetaData, @NotNull JdbcModel rdModel, @NotNull JdbcFactory jdbcFactory) {
        Intrinsics.checkNotNullParameter(lifetimeDefinition, "lifetimeDefinition");
        Intrinsics.checkNotNullParameter(connection, "connection");
        Intrinsics.checkNotNullParameter(remoteDatabaseMetaData, "remoteDatabaseMetaData");
        Intrinsics.checkNotNullParameter(rdModel, "rdModel");
        Intrinsics.checkNotNullParameter(jdbcFactory, "jdbcFactory");
        this.connection = connection;
        this.remoteDatabaseMetaData = remoteDatabaseMetaData;
        this.rdModel = rdModel;
        this.jdbcFactory = jdbcFactory;
        this.lifetime = lifetimeDefinition.getLifetime();
    }

    @Override
    @Nullable
    public <T> T unwrap(@Nullable Class<T> iface) {
        T t = null;
        if (iface == null) {
            return t;
        }
        try {
            iface.cast(this);
        }
        catch (ClassCastException e) {
            throw new SQLException(e.getMessage());
        }
        return t;
    }

    @Override
    public boolean isWrapperFor(@Nullable Class<?> iface) {
        Class<?> clazz = iface;
        return clazz != null ? clazz.isInstance(this) : false;
    }

    @Override
    @NotNull
    public String getURL() {
        this.throwIfClosed();
        return RdDatabaseMetadataExtKt.getUrl(this.remoteDatabaseMetaData, this.lifetime);
    }

    @Override
    @NotNull
    public String getUserName() {
        this.throwIfClosed();
        return RdDatabaseMetadataExtKt.getUsername(this.remoteDatabaseMetaData, this.lifetime);
    }

    @Override
    @NotNull
    public String getDatabaseProductVersion() {
        this.throwIfClosed();
        return this.remoteDatabaseMetaData.getDatabaseProductVersion();
    }

    @Override
    public int getMaxConnections() {
        this.throwIfClosed();
        return RdDatabaseMetadataExtKt.getMaxConnections(this.remoteDatabaseMetaData, this.lifetime);
    }

    @Override
    @NotNull
    public ResultSet getProcedures(@Nullable String catalog, @Nullable String schemaPattern, @Nullable String procedureNamePattern) {
        this.throwIfClosed();
        RdGetProceduresRequest request = new RdGetProceduresRequest(catalog, schemaPattern, procedureNamePattern);
        ResultSetInitializationData rdResultSet = RdDatabaseMetadataExtKt.executeQuery(this.remoteDatabaseMetaData, this.lifetime, request, this.remoteDatabaseMetaData.getGetProcedures(), this.rdModel);
        return JdbcFactory.DefaultImpls.createResultSet$default(this.jdbcFactory, this.lifetime, rdResultSet, null, 4, null);
    }

    @Override
    @NotNull
    public ResultSet getProcedureColumns(@Nullable String catalog, @Nullable String schemaPattern, @Nullable String procedureNamePattern, @Nullable String columnNamePattern) {
        this.throwIfClosed();
        RdGetProcedureColumnsRequest request = new RdGetProcedureColumnsRequest(catalog, schemaPattern, procedureNamePattern, columnNamePattern);
        ResultSetInitializationData rdResultSet = RdDatabaseMetadataExtKt.executeQuery(this.remoteDatabaseMetaData, this.lifetime, request, this.remoteDatabaseMetaData.getGetProcedureColumns(), this.rdModel);
        return JdbcFactory.DefaultImpls.createResultSet$default(this.jdbcFactory, this.lifetime, rdResultSet, null, 4, null);
    }

    @Override
    @NotNull
    public ResultSet getTables(@Nullable String catalog, @Nullable String schemaPattern, @Nullable String tableNamePattern, @Nullable String[] types) {
        this.throwIfClosed();
        RdGetTablesRequest request = new RdGetTablesRequest(catalog, schemaPattern, tableNamePattern, types);
        ResultSetInitializationData rdResultSet = RdDatabaseMetadataExtKt.executeQuery(this.remoteDatabaseMetaData, this.lifetime, request, this.remoteDatabaseMetaData.getGetTables(), this.rdModel);
        return JdbcFactory.DefaultImpls.createResultSet$default(this.jdbcFactory, this.lifetime, rdResultSet, null, 4, null);
    }

    @Override
    @NotNull
    public ResultSet getSchemas() {
        return this.getSchemas(null, null);
    }

    @Override
    @NotNull
    public ResultSet getSchemas(@Nullable String catalog, @Nullable String schemaPattern) {
        this.throwIfClosed();
        RdGetSchemasRequest request = new RdGetSchemasRequest(catalog, schemaPattern);
        ResultSetInitializationData rdResultSet = RdDatabaseMetadataExtKt.executeQuery(this.remoteDatabaseMetaData, this.lifetime, request, this.remoteDatabaseMetaData.getGetSchemas(), this.rdModel);
        return JdbcFactory.DefaultImpls.createResultSet$default(this.jdbcFactory, this.lifetime, rdResultSet, null, 4, null);
    }

    @Override
    @NotNull
    public ResultSet getCatalogs() {
        this.throwIfClosed();
        ResultSetInitializationData rdResultSet = RdDatabaseMetadataExtKt.executeQuery(this.remoteDatabaseMetaData, this.lifetime, Unit.INSTANCE, this.remoteDatabaseMetaData.getGetCatalogs(), this.rdModel);
        return JdbcFactory.DefaultImpls.createResultSet$default(this.jdbcFactory, this.lifetime, rdResultSet, null, 4, null);
    }

    @Override
    @NotNull
    public ResultSet getTableTypes() {
        this.throwIfClosed();
        ResultSetInitializationData rdResultSet = RdDatabaseMetadataExtKt.executeQuery(this.remoteDatabaseMetaData, this.lifetime, Unit.INSTANCE, this.remoteDatabaseMetaData.getGetTableTypes(), this.rdModel);
        return JdbcFactory.DefaultImpls.createResultSet$default(this.jdbcFactory, this.lifetime, rdResultSet, null, 4, null);
    }

    @Override
    @NotNull
    public ResultSet getColumns(@Nullable String catalog, @Nullable String schemaPattern, @Nullable String tableNamePattern, @Nullable String columnNamePattern) {
        this.throwIfClosed();
        RdGetColumnsRequest request = new RdGetColumnsRequest(catalog, schemaPattern, tableNamePattern, columnNamePattern);
        ResultSetInitializationData rdResultSet = RdDatabaseMetadataExtKt.executeQuery(this.remoteDatabaseMetaData, this.lifetime, request, this.remoteDatabaseMetaData.getGetColumns(), this.rdModel);
        return JdbcFactory.DefaultImpls.createResultSet$default(this.jdbcFactory, this.lifetime, rdResultSet, null, 4, null);
    }

    @Override
    @NotNull
    public ResultSet getColumnPrivileges(@Nullable String catalog, @Nullable String schema, @Nullable String table, @Nullable String columnNamePattern) {
        this.throwIfClosed();
        RdGetColumnPrivilegesRequest request = new RdGetColumnPrivilegesRequest(catalog, schema, table, columnNamePattern);
        ResultSetInitializationData rdResultSet = RdDatabaseMetadataExtKt.executeQuery(this.remoteDatabaseMetaData, this.lifetime, request, this.remoteDatabaseMetaData.getGetColumnPrivileges(), this.rdModel);
        return JdbcFactory.DefaultImpls.createResultSet$default(this.jdbcFactory, this.lifetime, rdResultSet, null, 4, null);
    }

    @Override
    @NotNull
    public ResultSet getTablePrivileges(@Nullable String catalog, @Nullable String schemaPattern, @Nullable String tableNamePattern) {
        this.throwIfClosed();
        RdGetTablePrivilegesRequest request = new RdGetTablePrivilegesRequest(catalog, schemaPattern, tableNamePattern);
        ResultSetInitializationData rdResultSet = RdDatabaseMetadataExtKt.executeQuery(this.remoteDatabaseMetaData, this.lifetime, request, this.remoteDatabaseMetaData.getGetTablePrivileges(), this.rdModel);
        return JdbcFactory.DefaultImpls.createResultSet$default(this.jdbcFactory, this.lifetime, rdResultSet, null, 4, null);
    }

    @Override
    @NotNull
    public ResultSet getBestRowIdentifier(@Nullable String catalog, @Nullable String schema, @Nullable String table, int scope2, boolean nullable2) {
        this.throwIfClosed();
        RdGetBestRowIdentifierRequest request = new RdGetBestRowIdentifierRequest(catalog, schema, table, scope2, nullable2);
        ResultSetInitializationData rdResultSet = RdDatabaseMetadataExtKt.executeQuery(this.remoteDatabaseMetaData, this.lifetime, request, this.remoteDatabaseMetaData.getGetBestRowIdentifier(), this.rdModel);
        return JdbcFactory.DefaultImpls.createResultSet$default(this.jdbcFactory, this.lifetime, rdResultSet, null, 4, null);
    }

    @Override
    @NotNull
    public ResultSet getVersionColumns(@Nullable String catalog, @Nullable String schema, @Nullable String table) {
        this.throwIfClosed();
        RdGetVersionColumnsRequest request = new RdGetVersionColumnsRequest(catalog, schema, table);
        ResultSetInitializationData rdResultSet = RdDatabaseMetadataExtKt.executeQuery(this.remoteDatabaseMetaData, this.lifetime, request, this.remoteDatabaseMetaData.getGetVersionColumns(), this.rdModel);
        return JdbcFactory.DefaultImpls.createResultSet$default(this.jdbcFactory, this.lifetime, rdResultSet, null, 4, null);
    }

    @Override
    @NotNull
    public ResultSet getPrimaryKeys(@Nullable String catalog, @Nullable String schema, @Nullable String table) {
        this.throwIfClosed();
        RdGetKeysRequest request = new RdGetKeysRequest(catalog, schema, table);
        ResultSetInitializationData rdResultSet = RdDatabaseMetadataExtKt.executeQuery(this.remoteDatabaseMetaData, this.lifetime, request, this.remoteDatabaseMetaData.getGetPrimaryKeys(), this.rdModel);
        return JdbcFactory.DefaultImpls.createResultSet$default(this.jdbcFactory, this.lifetime, rdResultSet, null, 4, null);
    }

    @Override
    @NotNull
    public ResultSet getImportedKeys(@Nullable String catalog, @Nullable String schema, @Nullable String table) {
        this.throwIfClosed();
        RdGetKeysRequest request = new RdGetKeysRequest(catalog, schema, table);
        ResultSetInitializationData rdResultSet = RdDatabaseMetadataExtKt.executeQuery(this.remoteDatabaseMetaData, this.lifetime, request, this.remoteDatabaseMetaData.getGetImportedKeys(), this.rdModel);
        return JdbcFactory.DefaultImpls.createResultSet$default(this.jdbcFactory, this.lifetime, rdResultSet, null, 4, null);
    }

    @Override
    @NotNull
    public ResultSet getExportedKeys(@Nullable String catalog, @Nullable String schema, @Nullable String table) {
        this.throwIfClosed();
        RdGetKeysRequest request = new RdGetKeysRequest(catalog, schema, table);
        ResultSetInitializationData rdResultSet = RdDatabaseMetadataExtKt.executeQuery(this.remoteDatabaseMetaData, this.lifetime, request, this.remoteDatabaseMetaData.getGetExportedKeys(), this.rdModel);
        return JdbcFactory.DefaultImpls.createResultSet$default(this.jdbcFactory, this.lifetime, rdResultSet, null, 4, null);
    }

    @Override
    @NotNull
    public ResultSet getCrossReference(@Nullable String parentCatalog, @Nullable String parentSchema, @Nullable String parentTable, @Nullable String foreignCatalog, @Nullable String foreignSchema, @Nullable String foreignTable) {
        this.throwIfClosed();
        RdGetCrossReferenceRequest request = new RdGetCrossReferenceRequest(parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
        ResultSetInitializationData rdResultSet = RdDatabaseMetadataExtKt.executeQuery(this.remoteDatabaseMetaData, this.lifetime, request, this.remoteDatabaseMetaData.getGetCrossReference(), this.rdModel);
        return JdbcFactory.DefaultImpls.createResultSet$default(this.jdbcFactory, this.lifetime, rdResultSet, null, 4, null);
    }

    @Override
    @NotNull
    public ResultSet getTypeInfo() {
        this.throwIfClosed();
        ResultSetInitializationData rdResultSet = RdDatabaseMetadataExtKt.executeQuery(this.remoteDatabaseMetaData, this.lifetime, Unit.INSTANCE, this.remoteDatabaseMetaData.getGetTypeInfo(), this.rdModel);
        return JdbcFactory.DefaultImpls.createResultSet$default(this.jdbcFactory, this.lifetime, rdResultSet, null, 4, null);
    }

    @Override
    @NotNull
    public ResultSet getIndexInfo(@Nullable String catalog, @Nullable String schema, @Nullable String table, boolean unique, boolean approximate) {
        this.throwIfClosed();
        RdGetIndexInfoRequest request = new RdGetIndexInfoRequest(catalog, schema, table, unique, approximate);
        ResultSetInitializationData rdResultSet = RdDatabaseMetadataExtKt.executeQuery(this.remoteDatabaseMetaData, this.lifetime, request, this.remoteDatabaseMetaData.getGetIndexInfo(), this.rdModel);
        return JdbcFactory.DefaultImpls.createResultSet$default(this.jdbcFactory, this.lifetime, rdResultSet, null, 4, null);
    }

    @Override
    @NotNull
    public ResultSet getUDTs(@Nullable String catalog, @Nullable String schemaPattern, @Nullable String typeNamePattern, @Nullable int[] types) {
        this.throwIfClosed();
        RdGetUDTsRequest request = new RdGetUDTsRequest(catalog, schemaPattern, typeNamePattern, types);
        ResultSetInitializationData rdResultSet = RdDatabaseMetadataExtKt.executeQuery(this.remoteDatabaseMetaData, this.lifetime, request, this.remoteDatabaseMetaData.getGetUDTs(), this.rdModel);
        return JdbcFactory.DefaultImpls.createResultSet$default(this.jdbcFactory, this.lifetime, rdResultSet, null, 4, null);
    }

    @Override
    @NotNull
    public Connection getConnection() {
        this.throwIfClosed();
        return this.connection;
    }

    @Override
    @NotNull
    public ResultSet getSuperTypes(@Nullable String catalog, @Nullable String schemaPattern, @Nullable String typeNamePattern) {
        this.throwIfClosed();
        RdGetSuperTypesRequest request = new RdGetSuperTypesRequest(catalog, schemaPattern, typeNamePattern);
        ResultSetInitializationData rdResultSet = RdDatabaseMetadataExtKt.executeQuery(this.remoteDatabaseMetaData, this.lifetime, request, this.remoteDatabaseMetaData.getGetSuperTypes(), this.rdModel);
        return JdbcFactory.DefaultImpls.createResultSet$default(this.jdbcFactory, this.lifetime, rdResultSet, null, 4, null);
    }

    @Override
    @NotNull
    public ResultSet getSuperTables(@Nullable String catalog, @Nullable String schemaPattern, @Nullable String tableNamePattern) {
        this.throwIfClosed();
        RdGetSuperTablesRequest request = new RdGetSuperTablesRequest(catalog, schemaPattern, tableNamePattern);
        ResultSetInitializationData rdResultSet = RdDatabaseMetadataExtKt.executeQuery(this.remoteDatabaseMetaData, this.lifetime, request, this.remoteDatabaseMetaData.getGetSuperTables(), this.rdModel);
        return JdbcFactory.DefaultImpls.createResultSet$default(this.jdbcFactory, this.lifetime, rdResultSet, null, 4, null);
    }

    @Override
    @NotNull
    public ResultSet getAttributes(@Nullable String catalog, @Nullable String schemaPattern, @Nullable String typeNamePattern, @Nullable String attributeNamePattern) {
        this.throwIfClosed();
        RdGetAttributesRequest request = new RdGetAttributesRequest(catalog, schemaPattern, typeNamePattern, attributeNamePattern);
        ResultSetInitializationData rdResultSet = RdDatabaseMetadataExtKt.executeQuery(this.remoteDatabaseMetaData, this.lifetime, request, this.remoteDatabaseMetaData.getGetAttributes(), this.rdModel);
        return JdbcFactory.DefaultImpls.createResultSet$default(this.jdbcFactory, this.lifetime, rdResultSet, null, 4, null);
    }

    @Override
    public int getDatabaseMajorVersion() {
        this.throwIfClosed();
        return this.remoteDatabaseMetaData.getDatabaseMajorVersion();
    }

    @Override
    public int getDatabaseMinorVersion() {
        this.throwIfClosed();
        return this.remoteDatabaseMetaData.getDatabaseMinorVersion();
    }

    @Override
    @NotNull
    public ResultSet getClientInfoProperties() {
        this.throwIfClosed();
        ResultSetInitializationData rdResultSet = RdDatabaseMetadataExtKt.executeQuery(this.remoteDatabaseMetaData, this.lifetime, Unit.INSTANCE, this.remoteDatabaseMetaData.getGetClientInfoProperties(), this.rdModel);
        return JdbcFactory.DefaultImpls.createResultSet$default(this.jdbcFactory, this.lifetime, rdResultSet, null, 4, null);
    }

    @Override
    @NotNull
    public ResultSet getFunctions(@Nullable String catalog, @Nullable String schemaPattern, @Nullable String functionNamePattern) {
        this.throwIfClosed();
        RdGetFunctionsRequest request = new RdGetFunctionsRequest(catalog, schemaPattern, functionNamePattern);
        ResultSetInitializationData rdResultSet = RdDatabaseMetadataExtKt.executeQuery(this.remoteDatabaseMetaData, this.lifetime, request, this.remoteDatabaseMetaData.getGetFunctions(), this.rdModel);
        return JdbcFactory.DefaultImpls.createResultSet$default(this.jdbcFactory, this.lifetime, rdResultSet, null, 4, null);
    }

    @Override
    @NotNull
    public ResultSet getFunctionColumns(@Nullable String catalog, @Nullable String schemaPattern, @Nullable String functionNamePattern, @Nullable String columnNamePattern) {
        this.throwIfClosed();
        RdGetFunctionColumnsRequest request = new RdGetFunctionColumnsRequest(catalog, schemaPattern, functionNamePattern, columnNamePattern);
        ResultSetInitializationData rdResultSet = RdDatabaseMetadataExtKt.executeQuery(this.remoteDatabaseMetaData, this.lifetime, request, this.remoteDatabaseMetaData.getGetFunctionColumns(), this.rdModel);
        return JdbcFactory.DefaultImpls.createResultSet$default(this.jdbcFactory, this.lifetime, rdResultSet, null, 4, null);
    }

    @Override
    @NotNull
    public ResultSet getPseudoColumns(@Nullable String catalog, @Nullable String schemaPattern, @Nullable String tableNamePattern, @Nullable String columnNamePattern) {
        this.throwIfClosed();
        RdGetPseudoColumnsRequest request = new RdGetPseudoColumnsRequest(catalog, schemaPattern, tableNamePattern, columnNamePattern);
        ResultSetInitializationData rdResultSet = RdDatabaseMetadataExtKt.executeQuery(this.remoteDatabaseMetaData, this.lifetime, request, this.remoteDatabaseMetaData.getGetPseudoColumns(), this.rdModel);
        return JdbcFactory.DefaultImpls.createResultSet$default(this.jdbcFactory, this.lifetime, rdResultSet, null, 4, null);
    }

    private final void throwIfClosed() {
        if (!RLifetimeKt.isAlive(this.lifetime)) {
            throw ExceptionsKt.connectionClosed();
        }
    }
}

