/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.views;

import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomizedDataContext;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.TokenType;
import com.jetbrains.dpa.views.CustomEditorHighlighter;
import com.jetbrains.dpa.views.DetailsViewControlKt;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.ui.bindable.ViewBinder;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rider.languages.fileTypes.csharp.CSharpTextAttributeKeys;
import com.jetbrains.rider.model.BeIssueDetails;
import com.jetbrains.rider.model.IssueDetailsData;
import com.jetbrains.rider.model.IssueDetailsScrollTo;
import com.jetbrains.rider.model.IssueInfoHighlightingId;
import com.jetbrains.rider.model.IssueInfoHiglighting;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0000*\u00020\u0002*\n\b\u0001\u0010\u0003 \u0000*\u00020\u00042\b\u0012\u0004\u0012\u00020\u00020\u0005B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\u000bJ%\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00028\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&\u00a2\u0006\u0002\u0010\u0012J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u0011H\u0002\u00a8\u0006'"}, d2={"Lcom/jetbrains/dpa/views/IssueDetailsViewControl;", "TViewModel", "Lcom/jetbrains/rider/model/BeIssueDetails;", "TIssueDetailsData", "Lcom/jetbrains/rider/model/IssueDetailsData;", "Lcom/jetbrains/rd/ui/bindable/ViewBinder;", "<init>", "()V", "getCustomIssueParagraph", "", "data", "(Lcom/jetbrains/rider/model/IssueDetailsData;)Ljava/lang/String;", "addCustomIssueHighlightings", "", "highlighter", "Lcom/jetbrains/dpa/views/CustomEditorHighlighter;", "offset", "", "(Lcom/jetbrains/rider/model/IssueDetailsData;Lcom/jetbrains/dpa/views/CustomEditorHighlighter;I)V", "createRenderer", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "icon", "Ljavax/swing/Icon;", "viewModel", "bind", "Ljavax/swing/JComponent;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "addIssueInfoHighlightings", "markupModel", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "scrollView", "scrollTo", "Lcom/jetbrains/rider/model/IssueDetailsScrollTo;", "Lcom/intellij/openapi/editor/ex/EditorEx;", "customInfoLine", "stacktraceLine", "intellij.rider.plugins.dpa"})
@SourceDebugExtension(value={"SMAP\nIssueDetailsViewControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IssueDetailsViewControl.kt\ncom/jetbrains/dpa/views/IssueDetailsViewControl\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,200:1\n1104#2,3:201\n*S KotlinDebug\n*F\n+ 1 IssueDetailsViewControl.kt\ncom/jetbrains/dpa/views/IssueDetailsViewControl\n*L\n100#1:201,3\n*E\n"})
public abstract class IssueDetailsViewControl<TViewModel extends BeIssueDetails, TIssueDetailsData extends IssueDetailsData>
implements ViewBinder<BeIssueDetails> {
    @NotNull
    public abstract String getCustomIssueParagraph(@NotNull TIssueDetailsData var1);

    public abstract void addCustomIssueHighlightings(@NotNull TIssueDetailsData var1, @NotNull CustomEditorHighlighter var2, int var3);

    private final EditorCustomElementRenderer createRenderer(Editor editor, Icon icon, BeIssueDetails viewModel) {
        PresentationFactory factory = new PresentationFactory(editor);
        InlayPresentation[] inlayPresentationArray = new InlayPresentation[]{factory.icon(icon), PresentationFactory.inset$default((PresentationFactory)factory, (InlayPresentation)factory.smallText("Explain with AI"), (int)0, (int)0, (int)2, (int)0, (int)22, null)};
        InlayPresentation basePresentation = factory.referenceOnHover(factory.roundWithBackgroundAndSmallInset(factory.seq(inlayPresentationArray)), (arg_0, arg_1) -> IssueDetailsViewControl.createRenderer$lambda$0(viewModel, arg_0, arg_1));
        Cursor cursor = Cursor.getPredefinedCursor(12);
        Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"getPredefinedCursor(...)");
        InlayPresentation presentation = factory.withCursorOnHover(basePresentation, cursor);
        return (EditorCustomElementRenderer)new PresentationRenderer(presentation);
    }

    @NotNull
    public JComponent bind(@NotNull BeIssueDetails viewModel, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Project project = ProjectUtilKt.toProject((RdProjectId)viewModel.getProjectId());
        ConsoleViewImpl console = DetailsViewControlKt.createDetailsConsoleView(lifetime, project, (Function0<Unit>)((Function0)() -> IssueDetailsViewControl.bind$lambda$0(viewModel)));
        Editor editor = console.getEditor();
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        EditorEx editor2 = (EditorEx)editor;
        EditorHyperlinkSupport editorHyperlinkSupport = EditorHyperlinkSupport.get((Editor)((Editor)editor2));
        Intrinsics.checkNotNullExpressionValue((Object)editorHyperlinkSupport, (String)"get(...)");
        EditorHyperlinkSupport editorHyperlinkSupport2 = editorHyperlinkSupport;
        Ref.IntRef customInfoLine = new Ref.IntRef();
        Ref.IntRef stacktraceLine = new Ref.IntRef();
        Ref.ObjectRef explainWithAiInlay = new Ref.ObjectRef();
        viewModel.getData().view(lifetime, (arg_0, arg_1) -> IssueDetailsViewControl.bind$lambda$1(explainWithAiInlay, editor2, this, customInfoLine, stacktraceLine, editorHyperlinkSupport2, console, viewModel, arg_0, arg_1));
        viewModel.getScrollTo().view(lifetime, (arg_0, arg_1) -> IssueDetailsViewControl.bind$lambda$2(this, editor2, customInfoLine, stacktraceLine, arg_0, arg_1));
        viewModel.getWordWrap().view(lifetime, (arg_0, arg_1) -> IssueDetailsViewControl.bind$lambda$3(editor2, arg_0, arg_1));
        DataContext dataContext = CustomizedDataContext.withProvider((DataContext)DataManager.getInstance().getDataContext((Component)console), arg_0 -> IssueDetailsViewControl.bind$lambda$4(project, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"withProvider(...)");
        DataContext dataContext2 = dataContext;
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        AnAction prevAction = actionsManager.createPrevOccurenceAction((OccurenceNavigator)console);
        viewModel.getStacktracePrevious().advise(lifetime, arg_0 -> IssueDetailsViewControl.bind$lambda$5(prevAction, dataContext2, arg_0));
        AnAction nextAction = actionsManager.createNextOccurenceAction((OccurenceNavigator)console);
        viewModel.getStacktraceNext().advise(lifetime, arg_0 -> IssueDetailsViewControl.bind$lambda$6(nextAction, dataContext2, arg_0));
        return console.getComponent();
    }

    private final void addIssueInfoHighlightings(IssueDetailsData data, MarkupModelEx markupModel, int offset) {
        TextAttributes boldTextAttributes = new TextAttributes();
        boldTextAttributes.setFontType(1);
        TextAttributes italicTextAttributes = new TextAttributes();
        italicTextAttributes.setFontType(2);
        for (IssueInfoHiglighting highlighting : data.getInfoHighlightings()) {
            switch (WhenMappings.$EnumSwitchMapping$0[highlighting.getIssueInfoHiglightingId().ordinal()]) {
                case 1: {
                    RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(CSharpTextAttributeKeys.INSTANCE.getCLASS(), offset + highlighting.getFrom(), offset + highlighting.getTo(), 1000, HighlighterTargetArea.EXACT_RANGE);
                    Unit unit = rangeHighlighter;
                    Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
                    break;
                }
                case 2: {
                    RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(offset + highlighting.getFrom(), offset + highlighting.getTo(), 1000, italicTextAttributes, HighlighterTargetArea.EXACT_RANGE);
                    Unit unit = rangeHighlighter;
                    Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
                    break;
                }
                case 3: {
                    RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(CSharpTextAttributeKeys.INSTANCE.getNUMBER(), offset + highlighting.getFrom(), offset + highlighting.getTo(), 1000, HighlighterTargetArea.EXACT_RANGE);
                    Unit unit = rangeHighlighter;
                    Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
                    break;
                }
                case 4: {
                    RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(offset + highlighting.getFrom(), offset + highlighting.getTo(), 1000, boldTextAttributes, HighlighterTargetArea.EXACT_RANGE);
                    Unit unit = rangeHighlighter;
                    Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
                    break;
                }
                case 5: {
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    private final void scrollView(IssueDetailsScrollTo scrollTo, EditorEx editor, int customInfoLine, int stacktraceLine) {
        int vOffset = switch (WhenMappings.$EnumSwitchMapping$1[scrollTo.ordinal()]) {
            case 1 -> 0;
            case 2 -> customInfoLine * editor.getLineHeight();
            case 3 -> stacktraceLine * editor.getLineHeight();
            case 4 -> editor.getDocument().getLineCount() * editor.getLineHeight();
            default -> throw new NoWhenBranchMatchedException();
        };
        editor.getScrollingModel().scroll(0, vOffset);
    }

    private static final void createRenderer$lambda$0(BeIssueDetails $viewModel, MouseEvent mouseEvent, Point point) {
        $viewModel.getExplainWithAi().fire((Object)Unit.INSTANCE);
    }

    private static final Unit bind$lambda$0(BeIssueDetails $viewModel) {
        $viewModel.getStacktraceLinkNavigated().fire((Object)Unit.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$1(Ref.ObjectRef $explainWithAiInlay, EditorEx $editor, IssueDetailsViewControl this$0, Ref.IntRef $customInfoLine, Ref.IntRef $stacktraceLine, EditorHyperlinkSupport $editorHyperlinkSupport, ConsoleViewImpl $console, BeIssueDetails $viewModel, Lifetime lifetime, IssueDetailsData data) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<unused var>");
        if ($explainWithAiInlay.element != null) {
            Object object = $explainWithAiInlay.element;
            Intrinsics.checkNotNull((Object)object);
            Disposer.dispose((Disposable)((Disposable)object));
        }
        MarkupModelEx markupModelEx = $editor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"getMarkupModel(...)");
        MarkupModelEx markupModel = markupModelEx;
        markupModel.removeAllHighlighters();
        if (data == null) {
            $editor.getDocument().setText((CharSequence)"");
            return Unit.INSTANCE;
        }
        CustomEditorHighlighter highlighter = new CustomEditorHighlighter((Document)$editor.getDocument());
        $editor.setHighlighter((EditorHighlighter)highlighter);
        String customIssueText = this$0.getCustomIssueParagraph(data);
        $editor.getDocument().setText((CharSequence)(data.getIssueType() + ": " + data.getIssueTypeDescription() + "\n" + data.getInfo() + "\n" + customIssueText));
        int issueTypeLineLength = data.getIssueType().length() + 2 + data.getIssueTypeDescription().length() + 1;
        int issueInfoLength = data.getInfo().length() + 1;
        int customInfoOffset = issueTypeLineLength + issueInfoLength;
        CharSequence $this$count$iv = data.getInfo();
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(it == '\n')) continue;
            ++count$iv;
        }
        int infoLinesCount = count$iv;
        $customInfoLine.element = 2 + (infoLinesCount + 1) - 1;
        $stacktraceLine.element = $editor.getDocument().getLineCount() - 1;
        $editorHyperlinkSupport.createHyperlink(0, data.getIssueType().length(), null, new HyperlinkInfo($viewModel){
            final /* synthetic */ BeIssueDetails $viewModel;
            {
                this.$viewModel = $viewModel;
            }

            public void navigate(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                this.$viewModel.getIssueHelpLinkNavigate().fire((Object)Unit.INSTANCE);
            }

            public boolean includeInOccurenceNavigation() {
                return false;
            }
        });
        this$0.addIssueInfoHighlightings(data, markupModel, issueTypeLineLength);
        highlighter.append(0, customInfoOffset, TokenType.DUMMY_HOLDER, new TextAttributes());
        this$0.addCustomIssueHighlightings(data, highlighter, customInfoOffset);
        String string = data.getStacktrace();
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"NORMAL_OUTPUT");
        $console.print(string, consoleViewContentType);
        $console.flushDeferredText();
        this$0.scrollView((IssueDetailsScrollTo)InterfacesKt.valueOrDefault((IOptProperty)$viewModel.getScrollTo(), (Object)IssueDetailsScrollTo.customInfo), $editor, $customInfoLine.element, $stacktraceLine.element);
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$2(IssueDetailsViewControl this$0, EditorEx $editor, Ref.IntRef $customInfoLine, Ref.IntRef $stacktraceLine, Lifetime lifetime, IssueDetailsScrollTo scrollTo) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)scrollTo, (String)"scrollTo");
        this$0.scrollView(scrollTo, $editor, $customInfoLine.element, $stacktraceLine.element);
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$3(EditorEx $editor, Lifetime lifetime, boolean wrap) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<unused var>");
        $editor.getSettings().setUseSoftWraps(wrap);
        return Unit.INSTANCE;
    }

    private static final Object bind$lambda$4(Project $project, String dataId) {
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return $project;
        }
        return null;
    }

    private static final Unit bind$lambda$5(AnAction $prevAction, DataContext $dataContext, Unit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"<unused var>");
        AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)$prevAction, null, (String)"unknown", (DataContext)$dataContext);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromAnAction(...)");
        AnActionEvent actionEvent = anActionEvent;
        $prevAction.actionPerformed(actionEvent);
        return Unit.INSTANCE;
    }

    private static final Unit bind$lambda$6(AnAction $nextAction, DataContext $dataContext, Unit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"<unused var>");
        AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)$nextAction, null, (String)"unknown", (DataContext)$dataContext);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromAnAction(...)");
        AnActionEvent actionEvent = anActionEvent;
        $nextAction.actionPerformed(actionEvent);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[IssueInfoHighlightingId.values().length];
            try {
                nArray[IssueInfoHighlightingId.TypeName.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IssueInfoHighlightingId.MetricContext.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IssueInfoHighlightingId.Metric.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IssueInfoHighlightingId.Caption.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IssueInfoHighlightingId.Text.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[IssueDetailsScrollTo.values().length];
            try {
                nArray[IssueDetailsScrollTo.info.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IssueDetailsScrollTo.customInfo.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IssueDetailsScrollTo.stacktrace.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IssueDetailsScrollTo.end.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

