/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.views;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CustomEditorHighlighter
implements EditorHighlighter {
    private final List<Element> myPieces;
    private final Document myDocument;

    public CustomEditorHighlighter(Document document) {
        this.myDocument = document;
        this.myPieces = new ArrayList<Element>();
    }

    public CustomEditorHighlighter append(int start2, int end, IElementType elementType, TextAttributes attributes) {
        this.addElement(new Element(start2, end, elementType, attributes));
        return this;
    }

    public CustomEditorHighlighter append(HighlighterIterator iterator, int additionalOffset) {
        while (!iterator.atEnd()) {
            this.addElement(new Element(iterator.getStart() + additionalOffset, iterator.getEnd() + additionalOffset, iterator.getTokenType(), iterator.getTextAttributes()));
            iterator.advance();
        }
        return this;
    }

    private void addElement(@NotNull Element element) {
        if (element == null) {
            CustomEditorHighlighter.$$$reportNull$$$0(0);
        }
        this.myPieces.add(element);
    }

    @NotNull
    public HighlighterIterator createIterator(int startOffset) {
        int index = Collections.binarySearch(this.myPieces, new Element(startOffset, 0, null, null), Comparator.comparingInt(Element::getStart));
        if (index < 0) {
            index = Math.max(-index - 2, 0);
        }
        return new ProxyIterator(this.myDocument, index);
    }

    public void setEditor(@NotNull HighlighterClient editor) {
        if (editor == null) {
            CustomEditorHighlighter.$$$reportNull$$$0(1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/dpa/views/CustomEditorHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setEditor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Element {
        private final int myStart;
        private final int myEnd;
        private final IElementType myElementType;
        private final TextAttributes myAttributes;

        private Element(int start2, int end, IElementType elementType, TextAttributes attributes) {
            this.myStart = start2;
            this.myEnd = end;
            this.myElementType = elementType;
            this.myAttributes = attributes;
        }

        public int getStart() {
            return this.myStart;
        }

        public int getEnd() {
            return this.myEnd;
        }

        public IElementType getElementType() {
            return this.myElementType;
        }

        public TextAttributes getAttributes() {
            return this.myAttributes;
        }
    }

    private final class ProxyIterator
    implements HighlighterIterator {
        private final Document myDocument;
        private int myIdx;

        private ProxyIterator(Document document, int idx) {
            this.myDocument = document;
            this.myIdx = idx;
        }

        public TextAttributes getTextAttributes() {
            return CustomEditorHighlighter.this.myPieces.get(this.myIdx).getAttributes();
        }

        public int getStart() {
            return CustomEditorHighlighter.this.myPieces.get(this.myIdx).getStart();
        }

        public int getEnd() {
            return CustomEditorHighlighter.this.myPieces.get(this.myIdx).getEnd();
        }

        public IElementType getTokenType() {
            return CustomEditorHighlighter.this.myPieces.get(this.myIdx).getElementType();
        }

        public void advance() {
            if (this.myIdx < CustomEditorHighlighter.this.myPieces.size()) {
                ++this.myIdx;
            }
        }

        public void retreat() {
            if (this.myIdx > -1) {
                --this.myIdx;
            }
        }

        public boolean atEnd() {
            return this.myIdx < 0 || this.myIdx >= CustomEditorHighlighter.this.myPieces.size();
        }

        public Document getDocument() {
            return this.myDocument;
        }
    }
}

