/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring.view;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.TokenType;
import com.jetbrains.dpa.monitoring.MonitoringStatistics;
import com.jetbrains.dpa.monitoring.MonitoringToolBundle;
import com.jetbrains.dpa.monitoring.view.MonitoringDetailsFile;
import com.jetbrains.dpa.views.CustomEditorHighlighter;
import com.jetbrains.dpa.views.DetailsViewControlKt;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rider.languages.fileTypes.csharp.CSharpTextAttributeKeys;
import com.jetbrains.rider.model.DpaModel_PregeneratedKt;
import com.jetbrains.rider.model.IssueInfoHighlightingId;
import com.jetbrains.rider.model.IssueInfoHiglighting;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 '2\u00020\u00012\u00020\u0002:\u0001'B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u0012\u001a\u00020\bH\u0016J\b\u0010\u0013\u001a\u00020\bH\u0016J\u0019\u0010\u0014\u001a\u00130\u0015\u00a2\u0006\u000e\b\u0016\u0012\n\b\u0017\u0012\u0006\b\n0\u00188\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\u0010\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\n2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010$\u001a\u00020\nH\u0016J\b\u0010%\u001a\u00020&H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/jetbrains/dpa/monitoring/view/MonitoringDetailsWindow;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "data", "Lcom/jetbrains/dpa/monitoring/view/MonitoringDetailsFile;", "<init>", "(Lcom/jetbrains/dpa/monitoring/view/MonitoringDetailsFile;)V", "windowComponent", "Ljavax/swing/JComponent;", "addIssueInfoHighlightings", "", "markupModel", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "offset", "", "addCustomIssueHighlightings", "highlighter", "Lcom/jetbrains/dpa/views/CustomEditorHighlighter;", "getComponent", "getPreferredFocusedComponent", "getName", "", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Title", "setState", "state", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "isModified", "", "isValid", "addPropertyChangeListener", "listener", "Ljava/beans/PropertyChangeListener;", "removePropertyChangeListener", "dispose", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "intellij.rider.plugins.dpa"})
public final class MonitoringDetailsWindow
extends UserDataHolderBase
implements FileEditor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MonitoringDetailsFile data;
    @NotNull
    private final JComponent windowComponent;
    @NotNull
    private static final FileType sqlFileType;

    public MonitoringDetailsWindow(@NotNull MonitoringDetailsFile data) {
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        this.data = data;
        ConsoleViewImpl console = DetailsViewControlKt.createDetailsConsoleView(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this)), this.data.getProject(), (Function0<Unit>)((Function0)() -> MonitoringDetailsWindow._init_$lambda$0(this)));
        Editor editor = console.getEditor();
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        EditorEx editor2 = (EditorEx)editor;
        EditorHyperlinkSupport editorHyperlinkSupport = EditorHyperlinkSupport.get((Editor)((Editor)editor2));
        Intrinsics.checkNotNullExpressionValue((Object)editorHyperlinkSupport, (String)"get(...)");
        EditorHyperlinkSupport editorHyperlinkSupport2 = editorHyperlinkSupport;
        CustomEditorHighlighter highlighter = new CustomEditorHighlighter((Document)editor2.getDocument());
        editor2.setHighlighter((EditorHighlighter)highlighter);
        String customIssueText = this.data.getArgs().getCommandText() + this.data.getArgs().getConnectionString() + "\n\n";
        String text = this.data.getArgs().getIssueType() + ": " + this.data.getArgs().getIssueTypeDescription() + "\n" + this.data.getArgs().getInfo() + "\n" + MonitoringToolBundle.Companion.message("dpa.monitoring.details.navigate.caused", new Object[0]) + " " + this.data.getArgs().getMethod() + "\n\n" + customIssueText;
        editor2.getDocument().setText((CharSequence)text);
        int issueTypeLineLength = this.data.getArgs().getIssueType().length() + 2 + this.data.getArgs().getIssueTypeDescription().length() + 1;
        int issueInfoLength = this.data.getArgs().getInfo().length() + 1;
        int navigateLength = MonitoringToolBundle.Companion.message("dpa.monitoring.details.navigate.caused", new Object[0]).length() + 1 + this.data.getArgs().getMethod().length();
        int navigateActionOffset = issueTypeLineLength + issueInfoLength + navigateLength - this.data.getArgs().getMethod().length();
        int customInfoOffset = 2 + issueTypeLineLength + issueInfoLength + navigateLength;
        editorHyperlinkSupport2.createHyperlink(0, this.data.getArgs().getIssueType().length(), null, new HyperlinkInfo(){

            public void navigate(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                MonitoringStatistics.Companion.getInstance(data.getProject()).onActionDetailsHelp(data.getArgs().getStatisticsId());
                DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getShowHelp().fire((Object)data.getArgs().getHelpKeyword());
            }

            public boolean includeInOccurenceNavigation() {
                return false;
            }
        });
        editorHyperlinkSupport2.createHyperlink(navigateActionOffset, navigateActionOffset + this.data.getArgs().getMethod().length(), null, new HyperlinkInfo(){

            public void navigate(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                MonitoringStatistics.Companion.getInstance(data.getProject()).onActionDetailsNavigateTo(data.getArgs().getStatisticsId());
                DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getNavigateTo().fire((Object)data.getArgs().getMethod());
            }

            public boolean includeInOccurenceNavigation() {
                return false;
            }
        });
        MarkupModelEx markupModelEx = editor2.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"getMarkupModel(...)");
        MarkupModelEx markupModel = markupModelEx;
        this.addIssueInfoHighlightings(this.data, markupModel, issueTypeLineLength);
        highlighter.append(0, customInfoOffset, TokenType.DUMMY_HOLDER, new TextAttributes());
        this.addCustomIssueHighlightings(this.data, highlighter, customInfoOffset);
        String string = this.data.getArgs().getStacktrace();
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"NORMAL_OUTPUT");
        console.print(string, consoleViewContentType);
        console.flushDeferredText();
        this.windowComponent = console.getComponent();
    }

    private final void addIssueInfoHighlightings(MonitoringDetailsFile data, MarkupModelEx markupModel, int offset) {
        TextAttributes boldTextAttributes = new TextAttributes();
        boldTextAttributes.setFontType(1);
        TextAttributes italicTextAttributes = new TextAttributes();
        italicTextAttributes.setFontType(2);
        for (IssueInfoHiglighting highlighting : data.getArgs().getInfoHighlightings()) {
            switch (WhenMappings.$EnumSwitchMapping$0[highlighting.getIssueInfoHiglightingId().ordinal()]) {
                case 1: {
                    RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(CSharpTextAttributeKeys.INSTANCE.getCLASS(), offset + highlighting.getFrom(), offset + highlighting.getTo(), 1000, HighlighterTargetArea.EXACT_RANGE);
                    Unit unit = rangeHighlighter;
                    Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
                    break;
                }
                case 2: {
                    RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(offset + highlighting.getFrom(), offset + highlighting.getTo(), 1000, italicTextAttributes, HighlighterTargetArea.EXACT_RANGE);
                    Unit unit = rangeHighlighter;
                    Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
                    break;
                }
                case 3: {
                    RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(CSharpTextAttributeKeys.INSTANCE.getNUMBER(), offset + highlighting.getFrom(), offset + highlighting.getTo(), 1000, HighlighterTargetArea.EXACT_RANGE);
                    Unit unit = rangeHighlighter;
                    Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
                    break;
                }
                case 4: {
                    RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(offset + highlighting.getFrom(), offset + highlighting.getTo(), 1000, boldTextAttributes, HighlighterTargetArea.EXACT_RANGE);
                    Unit unit = rangeHighlighter;
                    Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"addRangeHighlighter(...)");
                    break;
                }
                case 5: {
                    Unit unit = Unit.INSTANCE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    public final void addCustomIssueHighlightings(@NotNull MonitoringDetailsFile data, @NotNull CustomEditorHighlighter highlighter, int offset) {
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        if (!StringsKt.isBlank((CharSequence)data.getArgs().getCommandText()) && sqlFileType != UnknownFileType.INSTANCE) {
            EditorHighlighter editorHighlighter = HighlighterFactory.createHighlighter((FileType)sqlFileType, (EditorColorsScheme)EditorColorsManager.getInstance().getGlobalScheme(), (Project)data.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)editorHighlighter, (String)"createHighlighter(...)");
            EditorHighlighter editorHighlighter2 = editorHighlighter;
            editorHighlighter2.setText((CharSequence)data.getArgs().getCommandText());
            highlighter.append(editorHighlighter2.createIterator(0), offset);
        }
    }

    @NotNull
    public JComponent getComponent() {
        return this.windowComponent;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return this.windowComponent;
    }

    @NotNull
    public String getName() {
        return "MonitoringDetailsWindow";
    }

    public void setState(@NotNull FileEditorState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
    }

    public void dispose() {
    }

    @NotNull
    public VirtualFile getFile() {
        return (VirtualFile)this.data;
    }

    private static final Unit _init_$lambda$0(MonitoringDetailsWindow this$0) {
        MonitoringStatistics.Companion.getInstance(this$0.data.getProject()).onActionCallstackNavigateTo(this$0.data.getArgs().getStatisticsId());
        return Unit.INSTANCE;
    }

    static {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByExtension("sql");
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileTypeByExtension(...)");
        sqlFileType = fileType;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/dpa/monitoring/view/MonitoringDetailsWindow$Companion;", "", "<init>", "()V", "sqlFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "intellij.rider.plugins.dpa"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IssueInfoHighlightingId.values().length];
            try {
                nArray[IssueInfoHighlightingId.TypeName.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IssueInfoHighlightingId.MetricContext.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IssueInfoHighlightingId.Metric.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IssueInfoHighlightingId.Caption.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IssueInfoHighlightingId.Text.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

