/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring.sessions;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.impl.ProcessListUtil;
import com.intellij.ide.ActivityTracker;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.system.OS;
import com.jetbrains.dpa.monitoring.ProcessInfo;
import com.jetbrains.dpa.monitoring.services.MonitoringHost;
import com.jetbrains.dpa.monitoring.services.SessionsController;
import com.jetbrains.dpa.monitoring.sessions.MemoryProfilingSession;
import com.jetbrains.dpa.monitoring.sessions.PerformanceProfilingSession;
import com.jetbrains.dpa.monitoring.sessions.Session;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.IPropertyView;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.OptProperty;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.PropertyCombinatorsKt;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.debugger.attach.util.AvailableDebuggersUtilKt;
import com.jetbrains.rider.model.DesktopClrRuntime;
import com.jetbrains.rider.model.DpaModel;
import com.jetbrains.rider.model.DpaModel_PregeneratedKt;
import com.jetbrains.rider.model.GenericCoreClrRuntime;
import com.jetbrains.rider.model.MonitoringStartMode;
import com.jetbrains.rider.model.MonoRuntime;
import com.jetbrains.rider.model.ProcessRuntimeInformation;
import com.jetbrains.rider.model.ProtocolSession;
import com.jetbrains.rider.model.ProtocolSessionState;
import com.jetbrains.rider.model.UwpCoreClrRuntime;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 I2\u00020\u0001:\u0004IJKLBE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0016\u0010:\u001a\u00020;2\u0006\u0010\r\u001a\u00020\u000eH\u0082@\u00a2\u0006\u0002\u0010<J\u0016\u0010=\u001a\u00020;2\u0006\u0010\r\u001a\u00020\u000eH\u0082@\u00a2\u0006\u0002\u0010<J\u001a\u0010>\u001a\u00020;2\b\u0010?\u001a\u0004\u0018\u00010@2\u0006\u0010\u001e\u001a\u00020\u001cH\u0002J\b\u0010A\u001a\u00020;H\u0002J\u000e\u0010B\u001a\u00020;2\u0006\u0010C\u001a\u00020\u001cJ\b\u0010D\u001a\u00020;H\u0002J\b\u0010E\u001a\u00020;H\u0002J\u0006\u0010F\u001a\u00020;J\u0006\u0010G\u001a\u00020;J\b\u0010H\u001a\u00020;H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001dR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001c0\"\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010#R\u0011\u0010$\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010 R\u0014\u0010/\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0014\u00101\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00100R\u0014\u00102\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00100R\u0014\u00103\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00100R\u0014\u00104\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00100R\u0014\u00105\u001a\b\u0012\u0004\u0012\u00020706X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000209X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/jetbrains/dpa/monitoring/sessions/Session;", "", "project", "Lcom/intellij/openapi/project/Project;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "protocolSessionPromise", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lcom/jetbrains/rider/model/ProtocolSession;", "pid", "", "mode", "Lcom/jetbrains/dpa/monitoring/sessions/Session$Mode;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/process/ProcessHandler;Lorg/jetbrains/concurrency/AsyncPromise;ILcom/jetbrains/dpa/monitoring/sessions/Session$Mode;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lkotlinx/coroutines/CoroutineScope;)V", "getPid", "()I", "getMode", "()Lcom/jetbrains/dpa/monitoring/sessions/Session$Mode;", "state", "Lcom/jetbrains/rd/util/reactive/IProperty;", "Lcom/jetbrains/dpa/monitoring/sessions/Session$State;", "isRunning", "Lcom/jetbrains/rd/util/reactive/IPropertyView;", "", "()Lcom/jetbrains/rd/util/reactive/IPropertyView;", "uiActivated", "getUiActivated", "()Lcom/jetbrains/rd/util/reactive/IProperty;", "isAllowedToStart", "Lcom/jetbrains/rd/util/reactive/IOptPropertyView;", "()Lcom/jetbrains/rd/util/reactive/IOptPropertyView;", "performanceProfilingSession", "Lcom/jetbrains/dpa/monitoring/sessions/PerformanceProfilingSession;", "getPerformanceProfilingSession", "()Lcom/jetbrains/dpa/monitoring/sessions/PerformanceProfilingSession;", "memoryProfilingSession", "Lcom/jetbrains/dpa/monitoring/sessions/MemoryProfilingSession;", "getMemoryProfilingSession", "()Lcom/jetbrains/dpa/monitoring/sessions/MemoryProfilingSession;", "processInfoProperty", "Lcom/jetbrains/dpa/monitoring/ProcessInfo;", "getProcessInfoProperty", "isProfilingRunning", "()Z", "isStackTraceCollectingAvailable", "isMemoryProfilingAvailable", "isSamplingProfilingAvailable", "isTimelineProfilingAvailable", "applicationKindProperty", "Lcom/jetbrains/rd/util/reactive/Property;", "Lcom/jetbrains/dpa/monitoring/sessions/Session$ApplicationKind;", "processingLifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "detectApplicationKind", "", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fixProcessInfoOnLinux", "updateState", "startMode", "Lcom/jetbrains/rider/model/MonitoringStartMode;", "start", "stop", "willBeDestroyed", "pause", "restart", "activate", "discard", "setState", "Companion", "State", "Mode", "ApplicationKind", "intellij.rider.plugins.dpa"})
@SourceDebugExtension(value={"SMAP\nSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Session.kt\ncom/jetbrains/dpa/monitoring/sessions/Session\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,247:1\n1#2:248\n1400#3,2:249\n1761#4,3:251\n1761#4,3:254\n1761#4,3:257\n13#5:260\n13#6:261\n*S KotlinDebug\n*F\n+ 1 Session.kt\ncom/jetbrains/dpa/monitoring/sessions/Session\n*L\n133#1:249,2\n150#1:251,3\n152#1:254,3\n154#1:257,3\n31#1:260\n31#1:261\n*E\n"})
public final class Session {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ProcessHandler processHandler;
    @NotNull
    private final AsyncPromise<ProtocolSession> protocolSessionPromise;
    private final int pid;
    @NotNull
    private final Mode mode;
    @NotNull
    private IProperty<State> state;
    @NotNull
    private final IPropertyView<Boolean> isRunning;
    @NotNull
    private final IProperty<Boolean> uiActivated;
    @NotNull
    private final IOptPropertyView<Boolean> isAllowedToStart;
    @NotNull
    private final PerformanceProfilingSession performanceProfilingSession;
    @NotNull
    private final MemoryProfilingSession memoryProfilingSession;
    @NotNull
    private final IProperty<ProcessInfo> processInfoProperty;
    @NotNull
    private final Property<ApplicationKind> applicationKindProperty;
    @NotNull
    private final LifetimeDefinition processingLifetimeDefinition;
    @NotNull
    private static final Logger logger;

    /*
     * WARNING - void declaration
     */
    public Session(@NotNull Project project, @NotNull ProcessHandler processHandler, @NotNull AsyncPromise<ProtocolSession> protocolSessionPromise, int pid, @NotNull Mode mode, @NotNull Lifetime lifetime, @NotNull CoroutineScope coroutineScope) {
        void $this$_init__u24lambda_u240;
        LifetimeDefinition lifetimeDefinition;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        Intrinsics.checkNotNullParameter(protocolSessionPromise, (String)"protocolSessionPromise");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.processHandler = processHandler;
        this.protocolSessionPromise = protocolSessionPromise;
        this.pid = pid;
        this.mode = mode;
        this.state = (IProperty)new Property((Object)State.Disabled);
        this.isRunning = PropertyCombinatorsKt.map((IPropertyView)((IPropertyView)this.state), Session::isRunning$lambda$0);
        this.uiActivated = (IProperty)new Property((Object)false);
        this.applicationKindProperty = new Property((Object)ApplicationKind.Native);
        logger.trace("init processHandler:" + this.processHandler + " pid:" + this.pid + " mode:" + this.mode);
        DpaModel model = DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)this.project));
        LifetimeDefinition lifetimeDefinition2 = lifetimeDefinition = lifetime.createNested();
        Session session = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.setId((Object)("session processing for processHandler:" + this.processHandler + " pid:" + this.pid));
        session.processingLifetimeDefinition = lifetimeDefinition;
        MonitoringStartMode monitoringStartMode = (MonitoringStartMode)model.getMonitoringStartMode().getValueOrNull();
        this.isAllowedToStart = (IOptPropertyView)new OptProperty((Object)(switch (monitoringStartMode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[monitoringStartMode.ordinal()]) {
            case 1 -> false;
            case 2 -> true;
            case 3 -> {
                if (this.mode == Mode.Debug) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        }));
        ProcessInfo processInfo = ProcessInfo.Companion.create(this.pid);
        if (processInfo == null) {
            throw new IllegalStateException("Failed to collect process information for " + this.pid);
        }
        ProcessInfo processInfo2 = processInfo;
        this.processInfoProperty = (IProperty)new Property((Object)processInfo2);
        this.memoryProfilingSession = new MemoryProfilingSession((Lifetime)this.processingLifetimeDefinition, this.project, this.pid, processInfo2.getProcessName());
        this.performanceProfilingSession = new PerformanceProfilingSession((Lifetime)this.processingLifetimeDefinition, this.project, this.pid, processInfo2.getProcessName(), (IProperty<ApplicationKind>)((IProperty)this.applicationKindProperty));
        this.memoryProfilingSession.isUnderProfiling().advise((Lifetime)this.processingLifetimeDefinition, arg_0 -> Session._init_$lambda$1(this, arg_0));
        this.performanceProfilingSession.isUnderProfiling().advise((Lifetime)this.processingLifetimeDefinition, arg_0 -> Session._init_$lambda$2(this, arg_0));
        this.performanceProfilingSession.getCanStop().advise((Lifetime)this.processingLifetimeDefinition, arg_0 -> Session._init_$lambda$3(this, arg_0));
        this.state.advise((Lifetime)this.processingLifetimeDefinition, arg_0 -> Session._init_$lambda$4(this, arg_0));
        model.getMonitoringStartMode().advise((Lifetime)this.processingLifetimeDefinition, arg_0 -> Session._init_$lambda$5(this, arg_0));
        SourceExKt.adviseUntil((ISource)((ISource)this.uiActivated), (Lifetime)((Lifetime)this.processingLifetimeDefinition), arg_0 -> Session._init_$lambda$6(this, model, arg_0));
        if (BoolPropertyExKt.getHasTrueValue(this.isAllowedToStart)) {
            BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, lifetime, null){
                int label;
                final /* synthetic */ Session this$0;
                final /* synthetic */ Lifetime $lifetime;
                {
                    this.this$0 = $receiver;
                    this.$lifetime = $lifetime;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = this.this$0.detectApplicationKind(this.$lifetime, (Continuation<? super Unit>)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            if (OS.CURRENT == OS.Linux) {
                BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, lifetime, null){
                    int label;
                    final /* synthetic */ Session this$0;
                    final /* synthetic */ Lifetime $lifetime;
                    {
                        this.this$0 = $receiver;
                        this.$lifetime = $lifetime;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                Object object2 = this.this$0.fixProcessInfoOnLinux(this.$lifetime, (Continuation<? super Unit>)((Continuation)this));
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }
    }

    public final int getPid() {
        return this.pid;
    }

    @NotNull
    public final Mode getMode() {
        return this.mode;
    }

    @NotNull
    public final IPropertyView<Boolean> isRunning() {
        return this.isRunning;
    }

    @NotNull
    public final IProperty<Boolean> getUiActivated() {
        return this.uiActivated;
    }

    @NotNull
    public final IOptPropertyView<Boolean> isAllowedToStart() {
        return this.isAllowedToStart;
    }

    @NotNull
    public final PerformanceProfilingSession getPerformanceProfilingSession() {
        return this.performanceProfilingSession;
    }

    @NotNull
    public final MemoryProfilingSession getMemoryProfilingSession() {
        return this.memoryProfilingSession;
    }

    @NotNull
    public final IProperty<ProcessInfo> getProcessInfoProperty() {
        return this.processInfoProperty;
    }

    private final boolean isProfilingRunning() {
        return (Boolean)this.memoryProfilingSession.isUnderProfiling().getValue() != false || (Boolean)this.performanceProfilingSession.isUnderProfiling().getValue() != false;
    }

    private final boolean isStackTraceCollectingAvailable() {
        return this.state.getValue() == State.Ready && !this.isProfilingRunning() && this.applicationKindProperty.getValue() == ApplicationKind.NetCore;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isMemoryProfilingAvailable() {
        if (this.state.getValue() != State.Ready) return false;
        if (this.isProfilingRunning()) return false;
        ApplicationKind it = (ApplicationKind)((Object)this.applicationKindProperty.getValue());
        boolean bl = false;
        if (it == ApplicationKind.NetCore) return true;
        if (it != ApplicationKind.NetFramework) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSamplingProfilingAvailable() {
        if (this.state.getValue() != State.Ready) return false;
        if (this.isProfilingRunning()) return false;
        ApplicationKind it = (ApplicationKind)((Object)this.applicationKindProperty.getValue());
        boolean bl = false;
        if (it == ApplicationKind.NetCore) return true;
        if (it != ApplicationKind.NetFramework) return false;
        return true;
    }

    private final boolean isTimelineProfilingAvailable() {
        return this.state.getValue() == State.Ready && !this.isProfilingRunning() && (SystemInfo.isWindows || this.applicationKindProperty.getValue() == ApplicationKind.NetCore);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private final Object detectApplicationKind(Lifetime lifetime, Continuation<? super Unit> $completion) {
        block34: {
            block33: {
                block30: {
                    if (!($completion instanceof detectApplicationKind.1)) ** GOTO lbl-1000
                    var15_3 = $completion;
                    if ((var15_3.label & -2147483648) != 0) {
                        var15_3.label -= -2147483648;
                    } else lbl-1000:
                    // 2 sources

                    {
                        $continuation = new ContinuationImpl(this, $completion){
                            Object L$0;
                            Object L$1;
                            Object L$2;
                            /* synthetic */ Object result;
                            final /* synthetic */ Session this$0;
                            int label;
                            {
                                this.this$0 = this$0;
                                super($completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object $result) {
                                this.result = $result;
                                this.label |= Integer.MIN_VALUE;
                                return Session.access$detectApplicationKind(this.this$0, null, (Continuation)this);
                            }
                        };
                    }
                    $result = $continuation.result;
                    var16_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch ($continuation.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            try {
                                v0 = ProcessListUtil.getProcessList();
                                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getProcessList(...)");
                                $this$firstOrNull$iv /* !! */  = (com.intellij.execution.process.ProcessInfo)v0;
                                $i$f$firstOrNull = false;
                                for (Object element$iv : $this$firstOrNull$iv /* !! */ ) {
                                    it = (com.intellij.execution.process.ProcessInfo)element$iv;
                                    $i$a$-firstOrNull-Session$detectApplicationKind$processInfo$1 = false;
                                    if (!(it.getPid() == this.pid)) continue;
                                    v1 = element$iv;
                                    ** GOTO lbl25
                                }
                                v1 = null;
lbl25:
                                // 2 sources

                                $this$firstOrNull$iv /* !! */  = (com.intellij.execution.process.ProcessInfo)v1;
                            }
                            catch (Throwable e) {
                                Session.logger.warn("Unable to get process list", e);
                                $this$firstOrNull$iv /* !! */  = null;
                            }
                            if ((v2 /* !! */  = $this$firstOrNull$iv /* !! */ ) == null) {
                                it /* !! */  = $this$firstOrNull$iv /* !! */  = new com.intellij.execution.process.ProcessInfo(this.pid, "", "", "");
                                $i$a$-also-Session$detectApplicationKind$processInfo$2 = false;
                                Session.logger.warn("Unable to find process " + this.pid);
                                v2 /* !! */  = processInfo = $this$firstOrNull$iv /* !! */ ;
                            }
lbl36:
                            // 7 sources

                            while (RLifetimeKt.isAlive((Lifetime)lifetime) && Intrinsics.areEqual((Object)this.isAllowedToStart.getValueOrNull(), (Object)Boxing.boxBoolean((boolean)true))) {
                                $continuation.L$0 = lifetime;
                                $continuation.L$1 = processInfo;
                                $continuation.L$2 = null;
                                $continuation.label = 1;
                                v3 = AvailableDebuggersUtilKt.getAvailableRuntimes((com.intellij.execution.process.ProcessInfo)processInfo, (Project)this.project, (Continuation)$continuation);
                                ** if (v3 != var16_5) goto lbl46
lbl45:
                                // 1 sources

                                return var16_5;
lbl46:
                                // 1 sources

                                ** GOTO lbl55
                            }
                            break;
                        }
                        case 1: {
                            processInfo = (com.intellij.execution.process.ProcessInfo)$continuation.L$1;
                            lifetime = (Lifetime)$continuation.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v3 = $result;
lbl55:
                                // 2 sources

                                $this$firstOrNull$iv /* !! */  = (List)v3;
                                break;
                            }
                            catch (Throwable e) {
                                Session.logger.warn(e);
                                $continuation.L$0 = lifetime;
                                $continuation.L$1 = processInfo;
                                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)e);
                                $continuation.label = 2;
                                v4 = DelayKt.delay((long)5000L, (Continuation)$continuation);
                                if (v4 != var16_5) ** GOTO lbl36
                                return var16_5;
                            }
                        }
                        case 2: {
                            e = (Throwable)$continuation.L$2;
                            processInfo = (com.intellij.execution.process.ProcessInfo)$continuation.L$1;
                            lifetime = (Lifetime)$continuation.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v4 = $result;
                            ** GOTO lbl36
                        }
                    }
                    runtimes /* !! */  = $this$firstOrNull$iv /* !! */ ;
                    $this$firstOrNull$iv /* !! */  = (Iterable)runtimes /* !! */ ;
                    var12_28 = this.applicationKindProperty;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v5 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            it = (ProcessRuntimeInformation)element$iv;
                            $i$a$-any-Session$detectApplicationKind$2 = false;
                            if (!(it instanceof DesktopClrRuntime)) continue;
                            v5 = true;
                            break block30;
                        }
                        v5 = false;
                    }
                }
                var13_29 = v5;
                v6 = var12_28;
                if (var13_29) {
                    v7 = ApplicationKind.NetFramework;
                } else {
                    block31: {
                        $this$any$iv = (Iterable)runtimes /* !! */ ;
                        var12_28 = v6;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            v8 = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                it = (ProcessRuntimeInformation)element$iv;
                                $i$a$-any-Session$detectApplicationKind$3 = false;
                                if (!(it instanceof GenericCoreClrRuntime != false || it instanceof UwpCoreClrRuntime != false)) continue;
                                v8 = true;
                                break block31;
                            }
                            v8 = false;
                        }
                    }
                    var13_29 = v8;
                    v6 = var12_28;
                    if (var13_29) {
                        v7 = ApplicationKind.NetCore;
                    } else {
                        block32: {
                            $this$any$iv = (Iterable)runtimes /* !! */ ;
                            var12_28 = v6;
                            $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                v9 = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    it = (ProcessRuntimeInformation)element$iv;
                                    $i$a$-any-Session$detectApplicationKind$4 = false;
                                    if (!(it instanceof MonoRuntime)) continue;
                                    v9 = true;
                                    break block32;
                                }
                                v9 = false;
                            }
                        }
                        var13_29 = v9;
                        v6 = var12_28;
                        v7 = var13_29 != false ? ApplicationKind.Mono : ApplicationKind.Native;
                    }
                }
                v6.setValue((Object)v7);
                this.setState();
                if (this.applicationKindProperty.getValue() == ApplicationKind.Native) break block33;
                ActivityTracker.getInstance().inc();
                break block34;
            }
            $continuation.L$0 = lifetime;
            $continuation.L$1 = processInfo;
            $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)runtimes /* !! */ );
            $continuation.label = 3;
            v10 = DelayKt.delay((long)5000L, (Continuation)$continuation);
            if (v10 != var16_5) ** GOTO lbl36
            return var16_5;
            {
                case 3: {
                    runtimes /* !! */  = (com.intellij.execution.process.ProcessInfo)$continuation.L$2;
                    processInfo = (com.intellij.execution.process.ProcessInfo)$continuation.L$1;
                    lifetime = (Lifetime)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v10 = $result;
                    ** GOTO lbl36
                }
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Object fixProcessInfoOnLinux(Lifetime lifetime, Continuation<? super Unit> $completion) {
        if (!($completion instanceof fixProcessInfoOnLinux.1)) ** GOTO lbl-1000
        var7_3 = $completion;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                final /* synthetic */ Session this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return Session.access$fixProcessInfoOnLinux(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                attempts_count = 10;
                try {
                    i = 0;
                }
                catch (Throwable e) {
                    Session.logger.warn(e);
                    return Unit.INSTANCE;
                }
lbl20:
                // 2 sources

                while (true) {
                    if (RLifetimeKt.isNotAlive((Lifetime)lifetime) || !Intrinsics.areEqual((Object)this.isAllowedToStart.getValueOrNull(), (Object)Boxing.boxBoolean((boolean)true))) {
                        return Unit.INSTANCE;
                    }
                    Intrinsics.checkNotNull((Object)ProcessInfo.Companion.create(this.pid));
                    if (!Intrinsics.areEqual((Object)((ProcessInfo)this.processInfoProperty.getValue()).getCommandLine(), (Object)processInfo.getCommandLine())) {
                        this.processInfoProperty.set((Object)processInfo);
                        return Unit.INSTANCE;
                    }
                    $continuation.L$0 = lifetime;
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)processInfo);
                    $continuation.I$0 = attempts_count;
                    $continuation.I$1 = i;
                    $continuation.label = 1;
                    v0 = DelayKt.delay((long)500L, (Continuation)$continuation);
                    if (v0 == var8_5) {
                        return var8_5;
                    }
                    ** GOTO lbl44
                    break;
                }
            }
            case 1: {
                i = $continuation.I$1;
                attempts_count = $continuation.I$0;
                processInfo = (ProcessInfo)$continuation.L$1;
                lifetime = (Lifetime)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl44:
                    // 2 sources

                    if (i == attempts_count) return Unit.INSTANCE;
                    ++i;
                    ** continue;
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void updateState(MonitoringStartMode startMode, boolean uiActivated) {
        Boolean shouldBeActive = uiActivated ? (Boolean)this.isAllowedToStart.getValueOrNull() : Boolean.valueOf(false);
        logger.trace("shouldBeActive:" + shouldBeActive + " state:" + this.state.getValue() + " processHandler:" + this.processHandler + " pid:" + this.pid + " mode:" + startMode + " uiActivated: " + uiActivated);
        if (this.state.getValue() == State.Disabled && Intrinsics.areEqual((Object)shouldBeActive, (Object)true)) {
            this.start();
        } else if (this.state.getValue() == State.Paused && Intrinsics.areEqual((Object)shouldBeActive, (Object)true)) {
            this.restart();
            this.state.set((Object)State.Ready);
        } else if (this.state.getValue() == State.Ready && Intrinsics.areEqual((Object)shouldBeActive, (Object)false)) {
            this.pause();
            this.state.set((Object)State.Paused);
        }
    }

    private final void start() {
        logger.trace("start state:" + this.state.getValue() + " processHandler:" + this.processHandler + " pid:" + this.pid);
        this.state.set((Object)State.Ready);
        logger.trace("after initialization state:" + this.state.getValue() + " processHandler:" + this.processHandler + " pid:" + this.pid);
    }

    public final void stop(boolean willBeDestroyed) {
        logger.trace("stop state:" + this.state.getValue() + " processHandler:" + this.processHandler + " pid:" + this.pid);
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.processingLifetimeDefinition, (boolean)false, (int)1, null);
        this.state.set((Object)State.Stopped);
        this.setState();
    }

    private final void pause() {
    }

    private final void restart() {
    }

    public final void activate() {
        this.protocolSessionPromise.onSuccess(arg_0 -> Session.activate$lambda$1(arg_0 -> Session.activate$lambda$0(this, arg_0), arg_0));
    }

    public final void discard() {
        this.protocolSessionPromise.onSuccess(arg_0 -> Session.discard$lambda$1(arg_0 -> Session.discard$lambda$0(this, arg_0), arg_0));
    }

    private final void setState() {
        this.protocolSessionPromise.onSuccess(arg_0 -> Session.setState$lambda$1(arg_0 -> Session.setState$lambda$0(this, arg_0), arg_0));
    }

    private static final boolean isRunning$lambda$0(State it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return it == State.Ready;
    }

    private static final Unit _init_$lambda$1(Session this$0, boolean it) {
        this$0.setState();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(Session this$0, boolean it) {
        this$0.setState();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(Session this$0, boolean it) {
        this$0.setState();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(Session this$0, State it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        this$0.setState();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$5(Session this$0, MonitoringStartMode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        logger.trace("model.startMode changed  state:" + this$0.state.getValue() + " processHandler:" + this$0.processHandler + " pid:" + this$0.pid + " mode:" + it);
        this$0.updateState(it, (Boolean)this$0.uiActivated.getValue());
        return Unit.INSTANCE;
    }

    private static final boolean _init_$lambda$6(Session this$0, DpaModel $model, boolean isUiActivated) {
        logger.trace("uiActivated changed processHandler:" + this$0.processHandler + " pid:" + this$0.pid + " mode:" + this$0.uiActivated);
        this$0.updateState((MonitoringStartMode)$model.getMonitoringStartMode().getValueOrNull(), isUiActivated);
        return isUiActivated;
    }

    private static final Unit activate$lambda$0(Session this$0, ProtocolSession protocolSession) {
        Intrinsics.checkNotNullParameter((Object)protocolSession, (String)"protocolSession");
        if (Intrinsics.areEqual((Object)SessionsController.Companion.getInstance(this$0.project).getActiveSession().getValue(), (Object)this$0)) {
            MonitoringHost.Companion.getInstance(this$0.project).getModel().getActivateSession().fire((Object)protocolSession.getMediatorSessionId());
        }
        return Unit.INSTANCE;
    }

    private static final void activate$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit discard$lambda$0(Session this$0, ProtocolSession protocolSession) {
        Intrinsics.checkNotNullParameter((Object)protocolSession, (String)"protocolSession");
        MonitoringHost.Companion.getInstance(this$0.project).getModel().getDiscardSession().fire((Object)protocolSession.getMediatorSessionId());
        return Unit.INSTANCE;
    }

    private static final void discard$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit setState$lambda$0(Session this$0, ProtocolSession protocolSession) {
        Intrinsics.checkNotNullParameter((Object)protocolSession, (String)"protocolSession");
        protocolSession.getState().set((Object)new ProtocolSessionState(this$0.isStackTraceCollectingAvailable(), this$0.isMemoryProfilingAvailable(), this$0.isSamplingProfilingAvailable(), this$0.isTimelineProfilingAvailable(), ((Boolean)this$0.performanceProfilingSession.getCanStop().getValue()).booleanValue()));
        return Unit.INSTANCE;
    }

    private static final void setState$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(Session.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Session.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/dpa/monitoring/sessions/Session$ApplicationKind;", "", "<init>", "(Ljava/lang/String;I)V", "NetCore", "NetFramework", "Mono", "Native", "intellij.rider.plugins.dpa"})
    public static final class ApplicationKind
    extends Enum<ApplicationKind> {
        public static final /* enum */ ApplicationKind NetCore = new ApplicationKind();
        public static final /* enum */ ApplicationKind NetFramework = new ApplicationKind();
        public static final /* enum */ ApplicationKind Mono = new ApplicationKind();
        public static final /* enum */ ApplicationKind Native = new ApplicationKind();
        private static final /* synthetic */ ApplicationKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ApplicationKind[] values() {
            return (ApplicationKind[])$VALUES.clone();
        }

        public static ApplicationKind valueOf(String value) {
            return Enum.valueOf(ApplicationKind.class, value);
        }

        @NotNull
        public static EnumEntries<ApplicationKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = applicationKindArray = new ApplicationKind[]{ApplicationKind.NetCore, ApplicationKind.NetFramework, ApplicationKind.Mono, ApplicationKind.Native};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/dpa/monitoring/sessions/Session$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.dpa"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/dpa/monitoring/sessions/Session$Mode;", "", "<init>", "(Ljava/lang/String;I)V", "Run", "Debug", "intellij.rider.plugins.dpa"})
    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode Run = new Mode();
        public static final /* enum */ Mode Debug = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        public static Mode valueOf(String value) {
            return Enum.valueOf(Mode.class, value);
        }

        @NotNull
        public static EnumEntries<Mode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = modeArray = new Mode[]{Mode.Run, Mode.Debug};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/dpa/monitoring/sessions/Session$State;", "", "<init>", "(Ljava/lang/String;I)V", "Disabled", "Ready", "Paused", "Stopped", "intellij.rider.plugins.dpa"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State Disabled = new State();
        public static final /* enum */ State Ready = new State();
        public static final /* enum */ State Paused = new State();
        public static final /* enum */ State Stopped = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.Disabled, State.Ready, State.Paused, State.Stopped};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MonitoringStartMode.values().length];
            try {
                nArray[MonitoringStartMode.Disabled.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MonitoringStartMode.Always.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MonitoringStartMode.OnDebug.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

