/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring.sessions;

import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.dpa.DpaBackendModelHost;
import com.jetbrains.dpa.DpaExtension;
import com.jetbrains.dpa.monitoring.services.MonitoringHost;
import com.jetbrains.rd.framework.RdTaskResult;
import com.jetbrains.rd.ide.model.RdConfigurationAndPlatform;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.debugger.DebuggerWorkerProcessHandler;
import com.jetbrains.rider.model.AttachProcessArgs;
import com.jetbrains.rider.model.DpaModel_PregeneratedKt;
import com.jetbrains.rider.model.MonitoringStartMode;
import com.jetbrains.rider.model.ProcessResult;
import com.jetbrains.rider.model.ProcessStartedArgs;
import com.jetbrains.rider.model.ProtocolSession;
import com.jetbrains.rider.projectView.SolutionConfigurationManager;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 \u00052\u00020\u0001:\u0002\u0004\u0005B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/dpa/monitoring/sessions/ProtocolSessionFactory;", "", "<init>", "()V", "ProcessListenerAdapter", "Companion", "intellij.rider.plugins.dpa"})
public final class ProtocolSessionFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JL\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/dpa/monitoring/sessions/ProtocolSessionFactory$Companion;", "", "<init>", "()V", "startProtocolSession", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lcom/jetbrains/rider/model/ProtocolSession;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "debug", "", "isAutoAttach", "pid", "", "native", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "project", "Lcom/intellij/openapi/project/Project;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.dpa"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AsyncPromise<ProtocolSession> startProtocolSession(@NotNull Lifetime lifetime, boolean debug, boolean isAutoAttach, int pid, boolean bl, @NotNull ProcessHandler processHandler, @NotNull Project project, @NotNull Logger logger) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            AsyncPromise promise = new AsyncPromise();
            if (Intrinsics.areEqual((Object)processHandler.getUserData(DpaExtension.Companion.getIS_PROCESSED_KEY()), (Object)true)) {
                promise.cancel();
                return promise;
            }
            SolutionConfigurationManager manager = SolutionConfigurationManager.Companion.getInstance(project);
            RdConfigurationAndPlatform buildConfigurationId = manager.getActiveConfigurationAndPlatform();
            MonitoringStartMode startMode = (MonitoringStartMode)DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getMonitoringStartMode().getValueOrNull();
            if (startMode == null || startMode == MonitoringStartMode.Disabled) {
                logger.trace("monitoring is switched off");
                promise.cancel();
                return promise;
            }
            Boolean isBackendReady = (Boolean)DpaBackendModelHost.Companion.getInstance(project).getModel().getMonitoringReady().getValueOrNull();
            if (!Intrinsics.areEqual((Object)isBackendReady, (Object)true)) {
                logger.warn("backend is not ready");
                promise.cancel();
                return promise;
            }
            AttachProcessArgs request = new AttachProcessArgs(buildConfigurationId, debug, true, bl, pid, null, isAutoAttach);
            IOptPropertyView result = DpaBackendModelHost.Companion.getInstance(project).getModel().getProcessAttach().start(lifetime, (Object)request).getResult();
            SourceExKt.adviseOnce((ISource)((ISource)result), (Lifetime)lifetime, arg_0 -> Companion.startProtocolSession$lambda$0(debug, pid, processHandler, project, promise, logger, arg_0));
            return promise;
        }

        private static final Unit startProtocolSession$lambda$0(boolean $debug, int $pid, ProcessHandler $processHandler, Project $project, AsyncPromise $promise, Logger $logger, RdTaskResult it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            RdTaskResult rdTaskResult = it;
            if (rdTaskResult instanceof RdTaskResult.Success) {
                if (!$debug) {
                    ((ProcessResult)((RdTaskResult.Success)it).getValue()).getProcessListener().getStartNotified().fire((Object)new ProcessStartedArgs($pid, null));
                }
                $processHandler.addProcessListener((ProcessListener)new ProcessListenerAdapter($pid, ((ProcessResult)((RdTaskResult.Success)it).getValue()).getProcessListener()));
                long sessionId = ((ProcessResult)((RdTaskResult.Success)it).getValue()).getSessionId();
                ProtocolSession dpaSession = (ProtocolSession)MonitoringHost.Companion.getInstance($project).getModel().getSessions().get((Object)sessionId);
                if (dpaSession != null) {
                    $promise.setResult((Object)dpaSession);
                } else {
                    $promise.cancel();
                }
            } else if (rdTaskResult instanceof RdTaskResult.Fault) {
                $logger.warn((Throwable)((RdTaskResult.Fault)it).getError());
                $promise.setError((Throwable)((RdTaskResult.Fault)it).getError());
            } else if (rdTaskResult instanceof RdTaskResult.Cancelled) {
                $logger.info("DPA prepare for montioring was cancelled");
                $promise.cancel();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0012\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0014\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/dpa/monitoring/sessions/ProtocolSessionFactory$ProcessListenerAdapter;", "Lcom/intellij/execution/process/ProcessListener;", "pid", "", "processListener", "Lcom/jetbrains/rider/model/ProcessListener;", "<init>", "(ILcom/jetbrains/rider/model/ProcessListener;)V", "getPid", "()I", "getProcessListener", "()Lcom/jetbrains/rider/model/ProcessListener;", "processWillTerminate", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "willBeDestroyed", "", "processTerminated", "startNotified", "processNotStarted", "intellij.rider.plugins.dpa"})
    private static class ProcessListenerAdapter
    implements ProcessListener {
        private final int pid;
        @NotNull
        private final com.jetbrains.rider.model.ProcessListener processListener;

        public ProcessListenerAdapter(int pid, @NotNull com.jetbrains.rider.model.ProcessListener processListener) {
            Intrinsics.checkNotNullParameter((Object)processListener, (String)"processListener");
            this.pid = pid;
            this.processListener = processListener;
        }

        public final int getPid() {
            return this.pid;
        }

        @NotNull
        public final com.jetbrains.rider.model.ProcessListener getProcessListener() {
            return this.processListener;
        }

        public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.processListener.getProcessWillTerminate().fire((Object)willBeDestroyed);
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.processListener.getProcessTerminated().fire((Object)event.getExitCode());
        }

        public void startNotified(@NotNull ProcessEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ProcessHandler processHandler = event.getProcessHandler();
            Integer debuggerPid = null;
            if (processHandler instanceof DebuggerWorkerProcessHandler) {
                debuggerPid = ((DebuggerWorkerProcessHandler)processHandler).getPid();
            }
            this.processListener.getStartNotified().fire((Object)new ProcessStartedArgs(this.pid, debuggerPid));
        }

        public void processNotStarted() {
            this.processListener.getProcessNotStarted().fire((Object)Unit.INSTANCE);
        }
    }
}

