/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring.services;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.dpa.monitoring.services.MonitoringHost;
import com.jetbrains.dpa.monitoring.sessions.Session;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rider.model.MonitoringProtocolModel;
import com.jetbrains.rider.model.ProtocolSession;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J.\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u000eJ\u0010\u0010\u001d\u001a\u00020\u00192\b\u0010\u0010\u001a\u0004\u0018\u00010\u000eJ\u0006\u0010\u001e\u001a\u00020\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000RB\u0010\u001f\u001a6\u0012\u0004\u0012\u00020\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\"0!0 j\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\"0!`#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/jetbrains/dpa/monitoring/services/SessionsController;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "activeSession", "Lcom/jetbrains/rd/util/reactive/IProperty;", "Lcom/jetbrains/dpa/monitoring/sessions/Session;", "getActiveSession", "()Lcom/jetbrains/rd/util/reactive/IProperty;", "activeProcessHandler", "Lcom/intellij/execution/process/ProcessHandler;", "startSession", "processHandler", "protocolSessionPromise", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lcom/jetbrains/rider/model/ProtocolSession;", "pid", "", "mode", "Lcom/jetbrains/dpa/monitoring/sessions/Session$Mode;", "tryStopSession", "", "willBeDestroyed", "", "deleteSession", "activateSession", "resetActiveSession", "sessionsMap", "Ljava/util/LinkedHashMap;", "Lkotlin/Pair;", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "Lkotlin/collections/LinkedHashMap;", "Companion", "intellij.rider.plugins.dpa"})
@SourceDebugExtension(value={"SMAP\nSessionsController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionsController.kt\ncom/jetbrains/dpa/monitoring/services/SessionsController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,115:1\n1#2:116\n13#3:117\n13#4:118\n*S KotlinDebug\n*F\n+ 1 SessionsController.kt\ncom/jetbrains/dpa/monitoring/services/SessionsController\n*L\n20#1:117\n20#1:118\n*E\n"})
public final class SessionsController
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final IProperty<Session> activeSession;
    @Nullable
    private ProcessHandler activeProcessHandler;
    @NotNull
    private final LinkedHashMap<ProcessHandler, Pair<Session, LifetimeDefinition>> sessionsMap;
    @NotNull
    private static final Logger logger;

    public SessionsController(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        this.activeSession = (IProperty)new Property(null);
        this.sessionsMap = new LinkedHashMap();
    }

    @NotNull
    public final IProperty<Session> getActiveSession() {
        return this.activeSession;
    }

    @Nullable
    public final Session startSession(@NotNull ProcessHandler processHandler, @NotNull AsyncPromise<ProtocolSession> protocolSessionPromise, int pid, @NotNull Session.Mode mode) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        Intrinsics.checkNotNullParameter(protocolSessionPromise, (String)"protocolSessionPromise");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        logger.trace("startSession processHandler:" + processHandler + " pid:" + pid + " mode: " + mode);
        boolean bl2 = bl = !this.sessionsMap.containsKey(processHandler);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-SessionsController$startSession$22 = false;
            String $i$a$-assert-SessionsController$startSession$22 = "Session for processHandler:" + processHandler + " already exists";
            throw new AssertionError((Object)$i$a$-assert-SessionsController$startSession$22);
        }
        try {
            LifetimeDefinition $i$a$-assert-SessionsController$startSession$22;
            LifetimeDefinition $this$startSession_u24lambda_u241 = $i$a$-assert-SessionsController$startSession$22 = this.getServiceLifetime().createNested();
            boolean bl3 = false;
            $this$startSession_u24lambda_u241.setId((Object)("session for processHandler:" + processHandler + " pid:" + pid));
            LifetimeDefinition sessionLifetime = $i$a$-assert-SessionsController$startSession$22;
            Session session = new Session(this.project, processHandler, protocolSessionPromise, pid, mode, sessionLifetime.getLifetime(), this.coroutineScope);
            ((Map)this.sessionsMap).put(processHandler, new Pair((Object)session, (Object)sessionLifetime));
            if (Intrinsics.areEqual((Object)this.activeProcessHandler, (Object)processHandler)) {
                this.activateSession(processHandler);
            }
            return session;
        }
        catch (IllegalStateException e) {
            logger.warn("Failed to start monitoring session for " + processHandler, (Throwable)e);
            return null;
        }
        catch (RuntimeException e) {
            logger.warn("Failed to start monitoring session for " + processHandler, (Throwable)e);
            return null;
        }
    }

    public final void tryStopSession(@NotNull ProcessHandler processHandler, boolean willBeDestroyed) {
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        logger.trace("stopSession processHandler:" + processHandler);
        Pair<Session, LifetimeDefinition> session = this.sessionsMap.get(processHandler);
        if (session == null) {
            logger.trace("session not found for processHandler:" + processHandler);
            return;
        }
        ((Session)session.getFirst()).stop(willBeDestroyed);
    }

    public final void deleteSession(@NotNull ProcessHandler processHandler) {
        Pair session;
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        logger.trace("deleteSession processHandler:" + processHandler);
        if (Intrinsics.areEqual((Object)this.activeProcessHandler, (Object)processHandler)) {
            logger.trace("reset active session");
            this.activeProcessHandler = null;
            this.resetActiveSession();
        }
        if ((session = (Pair)this.sessionsMap.remove(processHandler)) == null) {
            logger.trace("session not found for processHandler:" + processHandler);
        } else {
            logger.trace("session removed for processHandler:" + processHandler);
            ((Session)session.getFirst()).discard();
            LifetimeDefinition.terminate$default((LifetimeDefinition)((LifetimeDefinition)session.getSecond()), (boolean)false, (int)1, null);
            if (Intrinsics.areEqual((Object)this.activeSession.getValue(), (Object)session.getFirst())) {
                this.resetActiveSession();
            }
        }
    }

    public final void activateSession(@Nullable ProcessHandler processHandler) {
        Session session;
        logger.trace("activateSession processHandler:" + processHandler);
        if (processHandler == null) {
            this.activeProcessHandler = null;
            this.resetActiveSession();
            return;
        }
        this.activeProcessHandler = processHandler;
        Pair<Session, LifetimeDefinition> pair = this.sessionsMap.get(processHandler);
        Session session2 = session = pair != null ? (Session)pair.getFirst() : null;
        if (session == null) {
            logger.trace("session not found for processHandler:" + processHandler);
            this.resetActiveSession();
            return;
        }
        logger.trace("set active session for pid:" + session.getPid());
        if (Intrinsics.areEqual((Object)session.isAllowedToStart().getValueOrNull(), (Object)true)) {
            this.activeSession.set((Object)session);
            session.activate();
        }
        session.getUiActivated().set((Object)true);
    }

    public final void resetActiveSession() {
        block0: {
            this.activeSession.set(null);
            MonitoringProtocolModel monitoringProtocolModel = MonitoringHost.Companion.getInstance(this.project).tryGetModel();
            if (monitoringProtocolModel == null || (monitoringProtocolModel = monitoringProtocolModel.getActivateSession()) == null) break block0;
            monitoringProtocolModel.fire((Object)-1L);
        }
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SessionsController.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        SessionsController.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/dpa/monitoring/services/SessionsController$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/dpa/monitoring/services/SessionsController;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.dpa"})
    @SourceDebugExtension(value={"SMAP\nSessionsController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SessionsController.kt\ncom/jetbrains/dpa/monitoring/services/SessionsController$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,115:1\n30#2,2:116\n*S KotlinDebug\n*F\n+ 1 SessionsController.kt\ncom/jetbrains/dpa/monitoring/services/SessionsController$Companion\n*L\n21#1:116,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SessionsController getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<SessionsController> serviceClass$iv = SessionsController.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (SessionsController)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

