/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring.services;

import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.GotItTooltip;
import com.jetbrains.dpa.DpaBackendModelHost;
import com.jetbrains.dpa.EtwHostInstaller;
import com.jetbrains.dpa.monitoring.MonitoringToolBundle;
import com.jetbrains.dpa.monitoring.services.ToolWindowActivationService;
import com.jetbrains.dpa.monitoring.view.MonitoringDetailsFile;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.IViewableMap;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rider.model.DpaRiderModel;
import com.jetbrains.rider.model.MonitoringProtocolModel;
import com.jetbrains.rider.model.OpenDetailsArgs;
import java.awt.Component;
import java.awt.Point;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010\b\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/dpa/monitoring/services/MonitoringHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getModel", "Lcom/jetbrains/rider/model/MonitoringProtocolModel;", "tryGetModel", "bindModel", "", "dpaBackendModel", "Lcom/jetbrains/rider/model/DpaRiderModel;", "Companion", "intellij.rider.plugins.dpa"})
@SourceDebugExtension(value={"SMAP\nMonitoringHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MonitoringHost.kt\ncom/jetbrains/dpa/monitoring/services/MonitoringHost\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,92:1\n13#2:93\n13#3:94\n*S KotlinDebug\n*F\n+ 1 MonitoringHost.kt\ncom/jetbrains/dpa/monitoring/services/MonitoringHost\n*L\n28#1:93\n28#1:94\n*E\n"})
public final class MonitoringHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger logger;

    public MonitoringHost(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final MonitoringProtocolModel getModel() {
        return (MonitoringProtocolModel)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)DpaBackendModelHost.Companion.getInstance(this.project).getModel().getMonitoring()));
    }

    @Nullable
    public final MonitoringProtocolModel tryGetModel() {
        DpaBackendModelHost dpaBackendModelHost = DpaBackendModelHost.Companion.getInstance(this.project);
        return dpaBackendModelHost != null && (dpaBackendModelHost = dpaBackendModelHost.getModel()) != null && (dpaBackendModelHost = dpaBackendModelHost.getMonitoring()) != null ? (MonitoringProtocolModel)dpaBackendModelHost.getValueOrNull() : null;
    }

    public final void bindModel(@NotNull DpaRiderModel dpaBackendModel) {
        Intrinsics.checkNotNullParameter((Object)dpaBackendModel, (String)"dpaBackendModel");
        MonitoringProtocolModel model = new MonitoringProtocolModel();
        model.getSessions().advise(this.getServiceLifetime(), MonitoringHost::bindModel$lambda$0);
        ToolWindowActivationService.Companion.getInstance(this.project);
        dpaBackendModel.getMonitoring().set((Object)model);
        dpaBackendModel.getInstallEtwService().advise(this.getServiceLifetime(), arg_0 -> MonitoringHost.bindModel$lambda$1(this, arg_0));
        model.getLocateFile().advise(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)), MonitoringHost::bindModel$lambda$2);
        model.getOpenDotTrace().advise(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)), arg_0 -> MonitoringHost.bindModel$lambda$3(this, arg_0));
        model.getActivateAia().advise(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)), arg_0 -> MonitoringHost.bindModel$lambda$4(this, arg_0));
        model.getShowFeedbackToolTip().advise(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)), arg_0 -> MonitoringHost.bindModel$lambda$5(this, model, arg_0));
        model.getOpenDetails().advise(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)), arg_0 -> MonitoringHost.bindModel$lambda$6(this, arg_0));
    }

    private static final Unit bindModel$lambda$0(IViewableMap.Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        logger.trace(event.toString());
        return Unit.INSTANCE;
    }

    private static final Unit bindModel$lambda$1(MonitoringHost this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        EtwHostInstaller.Companion.getInstance(this$0.project).installEtwUnderUAC();
        return Unit.INSTANCE;
    }

    private static final Unit bindModel$lambda$2(String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Path path = Paths.get(filename, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        RevealFileAction.openFile((Path)path);
        return Unit.INSTANCE;
    }

    private static final Unit bindModel$lambda$3(MonitoringHost this$0, String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this$0.project).getToolWindow("dotTrace Profiler");
        if (toolWindow != null) {
            toolWindow.show();
        }
        return Unit.INSTANCE;
    }

    private static final Unit bindModel$lambda$4(MonitoringHost this$0, Unit it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this$0.project).getToolWindow("AIAssistant");
            if (toolWindow == null) break block0;
            toolWindow.activate(MonitoringHost::bindModel$lambda$4$0);
        }
        return Unit.INSTANCE;
    }

    private static final void bindModel$lambda$4$0() {
    }

    private static final Unit bindModel$lambda$5(MonitoringHost this$0, MonitoringProtocolModel $model, Unit it) {
        ToolWindow toolWindow;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ToolWindow toolWindow2 = toolWindow = ToolWindowManager.Companion.getInstance(this$0.project).getToolWindow("Monitoring");
        boolean bl = toolWindow2 != null ? toolWindow2.isVisible() : false;
        if (bl) {
            GotItTooltip tooltip = GotItTooltip.withSecondaryButton$default((GotItTooltip)new GotItTooltip("monitoring.tooltip.feedback.id", MonitoringToolBundle.Companion.message("tooltip.feedback.text", new Object[0]), null, 4, null).withHeader(MonitoringToolBundle.Companion.message("tooltip.feedback.title", new Object[0])).withGotItButtonAction(() -> MonitoringHost.bindModel$lambda$5$0($model)).withButtonLabel(MonitoringToolBundle.Companion.message("tooltip.feedback.button.yes", new Object[0])), (String)MonitoringToolBundle.Companion.message("tooltip.feedback.button.no", new Object[0]), null, (int)2, null).withPosition(Balloon.Position.atLeft);
            JComponent jComponent = toolWindow.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            tooltip.show(jComponent, MonitoringHost::bindModel$lambda$5$1);
        }
        return Unit.INSTANCE;
    }

    private static final Unit bindModel$lambda$5$0(MonitoringProtocolModel $model) {
        $model.getOpenFeedbackUrl().fire((Object)Unit.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Point bindModel$lambda$5$1(Component it, Balloon balloon) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Intrinsics.checkNotNullParameter((Object)balloon, (String)"<unused var>");
        return new Point(0, it.getHeight() - 20);
    }

    private static final Unit bindModel$lambda$6(MonitoringHost this$0, OpenDetailsArgs args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        MonitoringDetailsFile file = new MonitoringDetailsFile(this$0.project, args);
        FileEditorManagerEx.Companion.getInstanceEx(this$0.project).openFile((VirtualFile)file, true, false);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MonitoringHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        MonitoringHost.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/dpa/monitoring/services/MonitoringHost$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/dpa/monitoring/services/MonitoringHost;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.dpa"})
    @SourceDebugExtension(value={"SMAP\nMonitoringHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MonitoringHost.kt\ncom/jetbrains/dpa/monitoring/services/MonitoringHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,92:1\n30#2,2:93\n*S KotlinDebug\n*F\n+ 1 MonitoringHost.kt\ncom/jetbrains/dpa/monitoring/services/MonitoringHost$Companion\n*L\n30#1:93,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MonitoringHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<MonitoringHost> serviceClass$iv = MonitoringHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (MonitoringHost)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

