/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring.listeners;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.UserDataHolder;
import com.jetbrains.dpa.DpaExtension;
import com.jetbrains.dpa.monitoring.listeners.MonitoringProcessTerminationListener;
import com.jetbrains.dpa.monitoring.services.MonitoringHost;
import com.jetbrains.dpa.monitoring.services.SessionsController;
import com.jetbrains.dpa.monitoring.sessions.ProtocolSessionFactory;
import com.jetbrains.dpa.monitoring.sessions.Session;
import com.jetbrains.dpa.utils.ProcessHandlerUtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IMutableViewableMap;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.IViewableMap;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.debugger.DebuggerWorkerProcessHandler;
import com.jetbrains.rider.model.ProtocolSession;
import com.jetbrains.rider.model.debuggerWorker.DebuggerSessionInfo;
import com.jetbrains.rider.model.debuggerWorker.DotNetDebuggerSessionModel;
import com.jetbrains.rider.run.DebuggerDataKeys;
import com.jetbrains.rider.run.ExternalConsoleProcessHandler;
import com.jetbrains.rider.run.configurations.unity.UnityAttachRunConfiguration;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH$J\b\u0010\f\u001a\u00020\tH$J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/dpa/monitoring/listeners/BasicMonitoringExecutionListener;", "Lcom/intellij/execution/ExecutionListener;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "isRunnerAllowed", "", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "isNative", "handleStartWithDpa", "", "protocolSession", "Lcom/jetbrains/rider/model/ProtocolSession;", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "processStarted", "executorId", "", "Companion", "intellij.rider.plugins.dpa"})
@SourceDebugExtension(value={"SMAP\nBasicMonitoringExecutionListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BasicMonitoringExecutionListener.kt\ncom/jetbrains/dpa/monitoring/listeners/BasicMonitoringExecutionListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,135:1\n1#2:136\n13#3:137\n13#4:138\n*S KotlinDebug\n*F\n+ 1 BasicMonitoringExecutionListener.kt\ncom/jetbrains/dpa/monitoring/listeners/BasicMonitoringExecutionListener\n*L\n38#1:137\n38#1:138\n*E\n"})
public abstract class BasicMonitoringExecutionListener
implements ExecutionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String DEBUG_EXECUTOR_ID = "Debug";
    @NotNull
    private static final String RUN_EXECUTOR_ID = "Run";

    public BasicMonitoringExecutionListener(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
    }

    protected abstract boolean isRunnerAllowed(@NotNull ProgramRunner<?> var1);

    protected abstract boolean isNative();

    /*
     * WARNING - void declaration
     */
    private final void handleStartWithDpa(ProtocolSession protocolSession, ExecutionEnvironment env, ProcessHandler processHandler) {
        Session.Mode mode = protocolSession.getDebug() ? Session.Mode.Debug : Session.Mode.Run;
        Integer pid = (Integer)protocolSession.getPid().getValue();
        if (pid != null) {
            void $this$handleStartWithDpa_u24lambda_u240;
            AsyncPromise asyncPromise;
            logger.trace("pid:" + pid + " mapped for processHandler:" + processHandler);
            AsyncPromise asyncPromise2 = asyncPromise = new AsyncPromise();
            ProcessHandler processHandler2 = processHandler;
            SessionsController sessionsController = SessionsController.Companion.getInstance(this.project);
            boolean bl = false;
            $this$handleStartWithDpa_u24lambda_u240.setResult((Object)protocolSession);
            Unit unit = Unit.INSTANCE;
            sessionsController.startSession(processHandler2, (AsyncPromise<ProtocolSession>)asyncPromise, pid, mode);
        } else {
            SourceExKt.adviseUntil((ISource)((ISource)protocolSession.getPid()), (Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)env)), arg_0 -> BasicMonitoringExecutionListener.handleStartWithDpa$lambda$1(this, processHandler, mode, protocolSession, arg_0));
        }
    }

    public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler processHandler) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        if (processHandler.isProcessTerminating() || processHandler.isProcessTerminated()) {
            return;
        }
        if (!Intrinsics.areEqual((Object)executorId, (Object)DEBUG_EXECUTOR_ID) && !Intrinsics.areEqual((Object)executorId, (Object)RUN_EXECUTOR_ID)) {
            return;
        }
        ProgramRunner programRunner = env.getRunner();
        Intrinsics.checkNotNullExpressionValue((Object)programRunner, (String)"getRunner(...)");
        if (!this.isRunnerAllowed(programRunner)) {
            return;
        }
        logger.trace("processStarted with executorId:" + executorId);
        processHandler.addProcessListener((ProcessListener)new MonitoringProcessTerminationListener(this.project, this.coroutineScope), LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)), null, (int)1, null));
        DataContext dataContext = env.getDataContext();
        boolean isAutoAttach = dataContext != null ? Intrinsics.areEqual((Object)dataContext.getData(DebuggerDataKeys.INSTANCE.getIS_AUTO_ATTACH()), (Object)true) : false;
        Long dpaSessionId = (Long)processHandler.getUserData(DpaExtension.Companion.getMONITORING_MODEL_KEY());
        if (dpaSessionId != null) {
            logger.trace("dpa session found");
            IMutableViewableMap sessions = MonitoringHost.Companion.getInstance(this.project).getModel().getSessions();
            ProtocolSession session = (ProtocolSession)sessions.get((Object)dpaSessionId);
            if (session != null) {
                this.handleStartWithDpa(session, env, processHandler);
            } else {
                SourceExKt.adviseUntil((ISource)((ISource)sessions), (Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)env)), arg_0 -> BasicMonitoringExecutionListener.processStarted$lambda$0(dpaSessionId, this, env, processHandler, arg_0));
            }
            return;
        }
        ProcessHandler processHandler2 = processHandler;
        if (processHandler2 instanceof BaseOSProcessHandler || processHandler2 instanceof ExternalConsoleProcessHandler) {
            logger.trace("normal run");
            Integer n = ProcessHandlerUtilKt.getProcessId(processHandler);
            Intrinsics.checkNotNull((Object)n);
            int pid = n;
            v3 = SessionsController.Companion.getInstance(this.project).startSession(processHandler, ProtocolSessionFactory.Companion.startProtocolSession(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)env)), false, isAutoAttach, pid, this.isNative(), processHandler, this.project, logger), pid, Session.Mode.Run);
        } else if (processHandler2 instanceof DebuggerWorkerProcessHandler) {
            Integer unityEditorPid;
            RunProfile runProfile = env.getRunProfile();
            UnityAttachRunConfiguration unityAttachRunConfiguration = runProfile instanceof UnityAttachRunConfiguration ? (UnityAttachRunConfiguration)runProfile : null;
            Integer n = unityEditorPid = unityAttachRunConfiguration != null ? unityAttachRunConfiguration.getUnityEditorPid() : null;
            if (unityEditorPid != null) {
                v3 = SessionsController.Companion.getInstance(this.project).startSession(processHandler, ProtocolSessionFactory.Companion.startProtocolSession(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)env)), false, isAutoAttach, unityEditorPid, true, processHandler, this.project, logger), unityEditorPid, Session.Mode.Debug);
            } else {
                ((DebuggerWorkerProcessHandler)processHandler).getWorkerModel().getActiveSession().advise(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)env)), arg_0 -> BasicMonitoringExecutionListener.processStarted$lambda$1(env, processHandler, this, isAutoAttach, arg_0));
                v3 = Unit.INSTANCE;
            }
        } else {
            return;
        }
    }

    private static final boolean handleStartWithDpa$lambda$1(BasicMonitoringExecutionListener this$0, ProcessHandler $processHandler, Session.Mode $mode, ProtocolSession $protocolSession, Integer pid) {
        if (pid != null) {
            BuildersKt.launch$default((CoroutineScope)this$0.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(pid, $processHandler, this$0, $mode, $protocolSession, null){
                int label;
                final /* synthetic */ Integer $pid;
                final /* synthetic */ ProcessHandler $processHandler;
                final /* synthetic */ BasicMonitoringExecutionListener this$0;
                final /* synthetic */ Session.Mode $mode;
                final /* synthetic */ ProtocolSession $protocolSession;
                {
                    this.$pid = $pid;
                    this.$processHandler = $processHandler;
                    this.this$0 = $receiver;
                    this.$mode = $mode;
                    this.$protocolSession = $protocolSession;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 */
                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            void $this$invokeSuspend_u24lambda_u240;
                            ResultKt.throwOnFailure((Object)$result);
                            BasicMonitoringExecutionListener.access$getLogger$cp().trace("pid:" + this.$pid + " mapped for processHandler:" + this.$processHandler);
                            AsyncPromise asyncPromise = new AsyncPromise();
                            ProtocolSession protocolSession = this.$protocolSession;
                            AsyncPromise asyncPromise2 = asyncPromise;
                            ProcessHandler processHandler = this.$processHandler;
                            SessionsController sessionsController = SessionsController.Companion.getInstance(BasicMonitoringExecutionListener.access$getProject$p(this.this$0));
                            boolean bl = false;
                            $this$invokeSuspend_u24lambda_u240.setResult((Object)protocolSession);
                            Unit unit = Unit.INSTANCE;
                            sessionsController.startSession(processHandler, (AsyncPromise<ProtocolSession>)asyncPromise, this.$pid, this.$mode);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
        return pid != null;
    }

    private static final boolean processStarted$lambda$0(Long $dpaSessionId, BasicMonitoringExecutionListener this$0, ExecutionEnvironment $env, ProcessHandler $processHandler, IViewableMap.Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Long l = $dpaSessionId;
        if (l != null && ((Number)event.getKey()).longValue() == l.longValue() && event.getNewValueOpt() != null) {
            Object object = event.getNewValueOpt();
            Intrinsics.checkNotNull((Object)object);
            this$0.handleStartWithDpa((ProtocolSession)object, $env, $processHandler);
            return true;
        }
        return false;
    }

    private static final Unit processStarted$lambda$1(ExecutionEnvironment $env, ProcessHandler $processHandler, BasicMonitoringExecutionListener this$0, boolean $isAutoAttach, DotNetDebuggerSessionModel it) {
        if (it == null) {
            return Unit.INSTANCE;
        }
        logger.trace("debug workerModel has active session");
        SourceExKt.adviseOnce((ISource)it.getTargetReady(), (Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)$env)), arg_0 -> BasicMonitoringExecutionListener.processStarted$lambda$1$0($processHandler, this$0, $env, $isAutoAttach, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit processStarted$lambda$1$0(ProcessHandler $processHandler, BasicMonitoringExecutionListener this$0, ExecutionEnvironment $env, boolean $isAutoAttach, DebuggerSessionInfo debuggerSessionInfo) {
        Intrinsics.checkNotNullParameter((Object)debuggerSessionInfo, (String)"debuggerSessionInfo");
        logger.trace("debug workerModel targetReady");
        if (debuggerSessionInfo.getProcessId() == -1) {
            logger.trace("Debug session does not provide target process pid");
            Integer pidFromUserData = (Integer)$processHandler.getUserData(DebuggerWorkerProcessHandler.Companion.getPID_KEY());
            if (pidFromUserData != null) {
                logger.trace("Find pid in user data: " + pidFromUserData);
                SessionsController.Companion.getInstance(this$0.project).startSession($processHandler, ProtocolSessionFactory.Companion.startProtocolSession(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)$env)), true, $isAutoAttach, pidFromUserData, false, $processHandler, this$0.project, logger), pidFromUserData, Session.Mode.Debug);
                return Unit.INSTANCE;
            }
            logger.trace("invalid pid=" + debuggerSessionInfo.getProcessId() + " received from debug workerModel, can't run monitoring");
            return Unit.INSTANCE;
        }
        SessionsController.Companion.getInstance(this$0.project).startSession($processHandler, ProtocolSessionFactory.Companion.startProtocolSession(UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)$env)), true, $isAutoAttach, debuggerSessionInfo.getProcessId(), false, $processHandler, this$0.project, logger), debuggerSessionInfo.getProcessId(), Session.Mode.Debug);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ Project access$getProject$p(BasicMonitoringExecutionListener $this) {
        return $this.project;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BasicMonitoringExecutionListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        BasicMonitoringExecutionListener.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/dpa/monitoring/listeners/BasicMonitoringExecutionListener$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "DEBUG_EXECUTOR_ID", "", "RUN_EXECUTOR_ID", "intellij.rider.plugins.dpa"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

