/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.jetbrains.dotCommon.externalAppToolWindow.RemoteProcessFactory;
import com.jetbrains.dotCommon.externalAppToolWindow.RemoteToolWindowFactory;
import com.jetbrains.dotCommon.externalAppToolWindow.ui.WindowTitle;
import com.jetbrains.dpa.DpaAvailabilityService;
import com.jetbrains.dpa.DpaBackendModelHost;
import com.jetbrains.dpa.IntegrationLevel;
import com.jetbrains.dpa.monitoring.EmptyPanel;
import com.jetbrains.dpa.monitoring.MonitoringLicense;
import com.jetbrains.dpa.monitoring.MonitoringToolBundle;
import com.jetbrains.dpa.monitoring.ProcessInfo;
import com.jetbrains.dpa.monitoring.actions.DataKeysKt;
import com.jetbrains.dpa.monitoring.actions.ProcessNameAction;
import com.jetbrains.rd.framework.base.RdBindableBase;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rider.model.DpaModel_PregeneratedKt;
import com.jetbrains.rider.model.DpaRiderModel;
import com.jetbrains.rider.model.MonitoringStartMode;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import icons.ReSharperIcons;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0013\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0006H\u0016J \u0010\u001d\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J(\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u0013H\u0016\u00a8\u0006\""}, d2={"Lcom/jetbrains/dpa/monitoring/MonitoringToolWindowFactory;", "Lcom/jetbrains/dotCommon/externalAppToolWindow/RemoteToolWindowFactory;", "Lcom/jetbrains/rider/model/DpaRiderModel;", "<init>", "()V", "isApplicable", "", "project", "Lcom/intellij/openapi/project/Project;", "onToolWindowTabCreated", "", "content", "Lcom/intellij/ui/content/Content;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "shouldBeAvailable", "getRemoteProcessFactory", "Lcom/jetbrains/dotCommon/externalAppToolWindow/RemoteProcessFactory;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getApplicationName", "", "getMainWindowsName", "", "Lcom/jetbrains/dotCommon/externalAppToolWindow/ui/WindowTitle;", "()[Lcom/jetbrains/dotCommon/externalAppToolWindow/ui/WindowTitle;", "getIconClassLoader", "Ljava/lang/ClassLoader;", "hideTabs", "createToolWindowContent", "beforeToolWindowCreation", "appModel", "processLifetime", "Companion", "intellij.rider.plugins.dpa"})
@SourceDebugExtension(value={"SMAP\nMonitoringToolWindowFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MonitoringToolWindowFactory.kt\ncom/jetbrains/dpa/monitoring/MonitoringToolWindowFactory\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,173:1\n30#2,2:174\n13#3:176\n13#4:177\n*S KotlinDebug\n*F\n+ 1 MonitoringToolWindowFactory.kt\ncom/jetbrains/dpa/monitoring/MonitoringToolWindowFactory\n*L\n79#1:174,2\n39#1:176\n39#1:177\n*E\n"})
public final class MonitoringToolWindowFactory
extends RemoteToolWindowFactory<DpaRiderModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;
    @NotNull
    public static final String TOOLWINDOW_ID = "Monitoring";
    @NotNull
    public static final String HelpKeyword = "Program-Monitoring";
    @Nullable
    private static MonitoringLicense license;

    public MonitoringToolWindowFactory() {
        super(MonitoringToolBundle.Companion.message("toolwindow.title", new Object[0]));
    }

    public boolean isApplicable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return DpaAvailabilityService.Companion.getAvailability().compareTo((Enum)IntegrationLevel.Monitoring) >= 0;
    }

    public void onToolWindowTabCreated(@NotNull Content content, @NotNull Project project, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        super.onToolWindowTabCreated(content, project, toolWindow);
        toolWindow.getComponent().putClientProperty(ToolWindowContentUi.DONT_HIDE_TOOLBAR_IN_HEADER, true);
        Property processInfoProperty = new Property(null);
        JComponent jComponent = toolWindow.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        UiUtils.putUserData((JComponent)jComponent, DataKeysKt.getSESSION_PROCESS_INFO_USER_DATA(), (Object)processInfoProperty);
        ProcessNameAction processNameAction = new ProcessNameAction((IProperty<ProcessInfo>)((IProperty)processInfoProperty));
        AnAction[] anActionArray = new AnAction[]{processNameAction};
        ((ToolWindowEx)toolWindow).setTabActions(anActionArray);
    }

    public boolean shouldBeAvailable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return true;
    }

    @NotNull
    public RemoteProcessFactory<DpaRiderModel> getRemoteProcessFactory(@NotNull Lifetime lifetime, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<DpaBackendModelHost> serviceClass$iv = DpaBackendModelHost.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return ((DpaBackendModelHost)((Object)object)).getProcessFactory();
    }

    @NotNull
    public String getApplicationName() {
        return "JetBrains.DPA.Protocol.Backend";
    }

    @NotNull
    public WindowTitle[] getMainWindowsName() {
        WindowTitle[] windowTitleArray = new WindowTitle[]{new WindowTitle(this.getApplicationName(), MonitoringToolBundle.Companion.message("toolwindow.title", new Object[0]), null)};
        return windowTitleArray;
    }

    @NotNull
    public ClassLoader getIconClassLoader() {
        ClassLoader classLoader = ReSharperIcons.DotProfiler.class.getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
        return classLoader;
    }

    public boolean hideTabs() {
        return true;
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        super.createToolWindowContent(project, toolWindow, lifetime);
        toolWindow.setHelpId(HelpKeyword);
        Content content = ContentFactory.getInstance().createContent((JComponent)new EmptyPanel(project), null, false);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content emptyContent = content;
        Content content2 = toolWindow.getContentManager().getContent(0);
        if (content2 == null) {
            content2 = emptyContent;
        }
        Content originalContent = content2;
        DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getMonitoringStartMode().advise(lifetime, arg_0 -> MonitoringToolWindowFactory.createToolWindowContent$lambda$0(toolWindow, emptyContent, originalContent, arg_0));
    }

    public void beforeToolWindowCreation(@NotNull DpaRiderModel appModel, @NotNull Project project, @NotNull ToolWindow toolWindow, @NotNull Lifetime processLifetime) {
        Intrinsics.checkNotNullParameter((Object)appModel, (String)"appModel");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Intrinsics.checkNotNullParameter((Object)processLifetime, (String)"processLifetime");
        super.beforeToolWindowCreation((RdBindableBase)appModel, project, toolWindow, processLifetime);
        license = new MonitoringLicense(appModel, processLifetime);
    }

    private static final Unit createToolWindowContent$lambda$0(ToolWindow $toolWindow, Content $emptyContent, Content $originalContent, MonitoringStartMode startMode) {
        Intrinsics.checkNotNullParameter((Object)startMode, (String)"startMode");
        $toolWindow.getContentManager().removeAllContents(false);
        if (startMode == MonitoringStartMode.Disabled) {
            $toolWindow.getContentManager().addContent($emptyContent);
        } else {
            $toolWindow.getContentManager().addContent($originalContent);
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MonitoringToolWindowFactory.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        MonitoringToolWindowFactory.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0010\b\u0002\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/dpa/monitoring/MonitoringToolWindowFactory$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "TOOLWINDOW_ID", "", "HelpKeyword", "license", "Lcom/jetbrains/dpa/monitoring/MonitoringLicense;", "getToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "project", "Lcom/intellij/openapi/project/Project;", "show", "", "runnable", "Lkotlin/Function0;", "intellij.rider.plugins.dpa"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        @Nullable
        public final ToolWindow getToolWindow(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return ToolWindowManager.Companion.getInstance(project).getToolWindow(MonitoringToolWindowFactory.TOOLWINDOW_ID);
        }

        public final void show(@NotNull Project project, @Nullable Function0<Unit> runnable) {
            block1: {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow(MonitoringToolWindowFactory.TOOLWINDOW_ID);
                    if (toolWindow == null || toolWindow.isVisible()) break block0;
                    Function0<Unit> function0 = runnable;
                    toolWindow.show(function0 != null ? () -> Companion.show$lambda$0(function0) : null);
                    break block1;
                }
                Function0<Unit> function0 = runnable;
                if (function0 == null) break block1;
                function0.invoke();
            }
        }

        public static /* synthetic */ void show$default(Companion companion, Project project, Function0 function0, int n, Object object) {
            if ((n & 2) != 0) {
                function0 = null;
            }
            companion.show(project, (Function0<Unit>)function0);
        }

        private static final void show$lambda$0(Function0 $tmp0) {
            $tmp0.invoke();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

