/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa.monitoring;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.dotCommon.externalAppToolWindow.license.CommonCheckLicense;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.model.DpaRiderModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/dpa/monitoring/MonitoringLicense;", "", "dpaRiderModel", "Lcom/jetbrains/rider/model/DpaRiderModel;", "appLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Lcom/jetbrains/rider/model/DpaRiderModel;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "PRODUCT_CODE", "", "checkLicense", "", "intellij.rider.plugins.dpa"})
@SourceDebugExtension(value={"SMAP\nMonitoringLicense.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MonitoringLicense.kt\ncom/jetbrains/dpa/monitoring/MonitoringLicense\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,35:1\n13#2:36\n13#3:37\n*S KotlinDebug\n*F\n+ 1 MonitoringLicense.kt\ncom/jetbrains/dpa/monitoring/MonitoringLicense\n*L\n12#1:36\n12#1:37\n*E\n"})
public final class MonitoringLicense {
    @NotNull
    private final DpaRiderModel dpaRiderModel;
    @NotNull
    private final Logger logger;
    @NotNull
    private final String PRODUCT_CODE;

    public MonitoringLicense(@NotNull DpaRiderModel dpaRiderModel, @NotNull Lifetime appLifetime) {
        Intrinsics.checkNotNullParameter((Object)dpaRiderModel, (String)"dpaRiderModel");
        Intrinsics.checkNotNullParameter((Object)appLifetime, (String)"appLifetime");
        this.dpaRiderModel = dpaRiderModel;
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MonitoringLicense.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.PRODUCT_CODE = "DPN";
        this.dpaRiderModel.getStartTrialLicense().advise(appLifetime, arg_0 -> MonitoringLicense._init_$lambda$0(this, arg_0));
        this.dpaRiderModel.getCheckLicense().advise(appLifetime, arg_0 -> MonitoringLicense._init_$lambda$1(this, arg_0));
        this.checkLicense();
    }

    private final void checkLicense() {
        Boolean isLicensed = CommonCheckLicense.INSTANCE.getIsLicensed(this.PRODUCT_CODE);
        this.logger.trace("updateLastIsLicensed, isLicensed: " + isLicensed + ", lastIsLicensed: " + this.dpaRiderModel.isLicensed().getValue());
        this.dpaRiderModel.isLicensed().setValue((Object)isLicensed);
    }

    private static final Unit _init_$lambda$0(MonitoringLicense this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CommonCheckLicense.INSTANCE.requestLicense(this$0.PRODUCT_CODE, null, true);
        this$0.checkLicense();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(MonitoringLicense this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.checkLicense();
        return Unit.INSTANCE;
    }
}

