/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.dpa.CollectorControllerModeService;
import com.jetbrains.dpa.DpaAvailabilityService;
import com.jetbrains.dpa.DpaBackendModelHost;
import com.jetbrains.dpa.EtwHostInstaller;
import com.jetbrains.dpa.Notificator;
import com.jetbrains.dpa.StackTracePresenter;
import com.jetbrains.dpa.ToolWindowFactory;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rider.model.DpaModel;
import com.jetbrains.rider.model.DpaModel_PregeneratedKt;
import com.jetbrains.rider.model.DpaStatistics;
import com.jetbrains.rider.model.MessageBoxParams;
import com.jetbrains.rider.model.MonitoringStartMode;
import com.jetbrains.rider.model.MonitoringStatistics;
import com.jetbrains.rider.model.StacktraceRequest;
import com.jetbrains.rider.model.ToolWindowTab;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/dpa/DpaHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "v", "", "enabled", "getEnabled", "()Z", "setEnabled", "(Z)V", "setupSubscriptions", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "model", "Lcom/jetbrains/rider/model/DpaModel;", "Companion", "ProtocolListener", "intellij.rider.plugins.dpa"})
@SourceDebugExtension(value={"SMAP\nDpaHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DpaHost.kt\ncom/jetbrains/dpa/DpaHost\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,70:1\n13#2:71\n13#3:72\n*S KotlinDebug\n*F\n+ 1 DpaHost.kt\ncom/jetbrains/dpa/DpaHost\n*L\n23#1:71\n23#1:72\n*E\n"})
public final class DpaHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger logger;

    public DpaHost(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public final boolean getEnabled() {
        return Intrinsics.areEqual((Object)DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)this.project)).getEnabled().getValueOrNull(), (Object)true);
    }

    public final void setEnabled(boolean v) {
        DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)this.project)).getSetEnabled().fire((Object)v);
    }

    public final void setupSubscriptions(@NotNull Lifetime lifetime, @NotNull DpaModel model) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        model.getActivateToolWindow().advise(lifetime, arg_0 -> DpaHost.setupSubscriptions$lambda$0(this, arg_0));
        model.getInstallEtwService().advise(lifetime, arg_0 -> DpaHost.setupSubscriptions$lambda$1(this, arg_0));
        model.getShowInsufficientResourceEtwNotification().advise(lifetime, arg_0 -> DpaHost.setupSubscriptions$lambda$2(this, arg_0));
        model.getShowStacktrace().advise(lifetime, arg_0 -> DpaHost.setupSubscriptions$lambda$3(this, arg_0));
        model.getShowMessage().advise(lifetime, DpaHost::setupSubscriptions$lambda$4);
        model.getMonitoringStartMode().advise(this.getServiceLifetime(), DpaHost::setupSubscriptions$lambda$5);
        model.getIntegrationLevel().set((Object)DpaAvailabilityService.Companion.getAvailability().getLevel());
        CollectorControllerModeService.Companion.getInstance(this.project).setupMode();
    }

    private static final Unit setupSubscriptions$lambda$0(DpaHost this$0, ToolWindowTab it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ToolWindowFactory.Companion.showTab(this$0.project, it);
        return Unit.INSTANCE;
    }

    private static final Unit setupSubscriptions$lambda$1(DpaHost this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        EtwHostInstaller.Companion.getInstance(this$0.project).installEtwUnderUAC();
        return Unit.INSTANCE;
    }

    private static final Unit setupSubscriptions$lambda$2(DpaHost this$0, Unit it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Notificator.Companion.showInsufficientResourceEtwNotification(this$0.project);
        return Unit.INSTANCE;
    }

    private static final Unit setupSubscriptions$lambda$3(DpaHost this$0, StacktraceRequest it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        StackTracePresenter.Companion.getInstance(this$0.project).showStackTrace(it.getTitle(), it.getStacktrace());
        return Unit.INSTANCE;
    }

    private static final Unit setupSubscriptions$lambda$4(MessageBoxParams it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Messages.showMessageDialog((String)it.getMessage(), (String)it.getTitle(), (Icon)UIUtil.getInformationIcon());
        return Unit.INSTANCE;
    }

    private static final Unit setupSubscriptions$lambda$5(MonitoringStartMode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        logger.trace("startMode changed:" + it);
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DpaHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        DpaHost.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/dpa/DpaHost$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/dpa/DpaHost;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.dpa"})
    @SourceDebugExtension(value={"SMAP\nDpaHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DpaHost.kt\ncom/jetbrains/dpa/DpaHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,70:1\n30#2,2:71\n*S KotlinDebug\n*F\n+ 1 DpaHost.kt\ncom/jetbrains/dpa/DpaHost$Companion\n*L\n25#1:71,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DpaHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<DpaHost> serviceClass$iv = DpaHost.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (DpaHost)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/dpa/DpaHost$ProtocolListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rider/model/DpaModel;", "<init>", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.rider.plugins.dpa"})
    public static final class ProtocolListener
    implements SolutionExtListener<DpaModel> {
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull DpaModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            IProperty iProperty = model.getToggleSoftWrapIcon();
            Icon icon = AllIcons.Actions.ToggleSoftWrap;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ToggleSoftWrap");
            iProperty.set((Object)UtilKt.toModel((Icon)icon));
            model.getStatistics().set((Object)new DpaStatistics());
            model.getMonitoringStatistics().set((Object)new MonitoringStatistics());
            Companion.getInstance(session.getProject()).setupSubscriptions(lifetime, model);
            DpaBackendModelHost.Companion.getInstance(session.getProject());
        }
    }
}

