/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.dpa;

import com.intellij.execution.configurations.CommandLineWithSuspendedProcessCallback;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.jetbrains.dotCommon.externalAppToolWindow.common.ObjectExtensionsKt;
import com.jetbrains.dpa.DpaAvailabilityService;
import com.jetbrains.dpa.DpaBackendModelHost;
import com.jetbrains.dpa.DpaBundle;
import com.jetbrains.dpa.DpaStatistics;
import com.jetbrains.dpa.IntegrationLevel;
import com.jetbrains.dpa.utils.ProcessHandlerUtilKt;
import com.jetbrains.rd.framework.IRdTask;
import com.jetbrains.rd.framework.RdTaskResult;
import com.jetbrains.rd.framework.impl.RdCall;
import com.jetbrains.rd.framework.impl.RpcTimeouts;
import com.jetbrains.rd.ide.model.RdConfigurationAndPlatform;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.diagnostics.StructuredLoggingKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IAsyncSignal;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rd.util.threading.SpinWait;
import com.jetbrains.rd.util.threading.SynchronousScheduler;
import com.jetbrains.rider.debugger.DebuggerWorkerProcessHandler;
import com.jetbrains.rider.model.AttachProcessArgs;
import com.jetbrains.rider.model.CollectorControllerMode;
import com.jetbrains.rider.model.CollectorSessionArgs;
import com.jetbrains.rider.model.DpaCancelReason;
import com.jetbrains.rider.model.DpaModel;
import com.jetbrains.rider.model.DpaModel_PregeneratedKt;
import com.jetbrains.rider.model.DpaRiderModel;
import com.jetbrains.rider.model.MonitoringStartMode;
import com.jetbrains.rider.model.ProcessResult;
import com.jetbrains.rider.model.ProcessStartedArgs;
import com.jetbrains.rider.model.RunType;
import com.jetbrains.rider.model.SessionResult;
import com.jetbrains.rider.model.StartingEnvironmentVars;
import com.jetbrains.rider.model.StartingProcessArgs;
import com.jetbrains.rider.model.debuggerWorker.DebuggerSessionInfo;
import com.jetbrains.rider.model.debuggerWorker.DotNetDebuggerSessionModel;
import com.jetbrains.rider.plugins.RiderBundledPluginHelpers;
import com.jetbrains.rider.projectView.SolutionConfigurationManager;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.protocol.ApplicationProtocolKt;
import com.jetbrains.rider.protocol.IProtocolHost;
import com.jetbrains.rider.protocol.IProtocolHostWithBackend;
import com.jetbrains.rider.run.DebuggerDataKeys;
import com.jetbrains.rider.run.PatchCommandLineExtension;
import com.jetbrains.rider.run.WinExternalConsoleProcessHandler;
import com.jetbrains.rider.run.WorkerRunInfo;
import com.jetbrains.rider.runtime.DotNetExecutable;
import com.jetbrains.rider.runtime.DotNetRuntime;
import com.jetbrains.rider.runtime.mono.MonoRuntimeType;
import com.jetbrains.rider.shared.run.FormatPreservingCommandLine;
import com.jetbrains.rider.shared.run.FormatPreservingPtyCommandLine;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeoutException;
import java.util.function.LongConsumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.ULong;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 52\u00020\u0001:\u000656789:B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010\u0010\u001a\u00020\u00112\u0014\b\u0001\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0002JD\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J,\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016JW\u0010*\u001a\u0002H+\"\u0004\b\u0000\u0010,\"\u0004\b\u0001\u0010+2\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u0002H,\u0012\u0004\u0012\u0002H+0.2\u0006\u0010/\u001a\u0002H,2\u0006\u00100\u001a\u00020\u00072\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u0002H+\u0012\u0004\u0012\u00020302\u00a2\u0006\u0002\u00104R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/jetbrains/dpa/DpaExtension;", "Lcom/jetbrains/rider/run/PatchCommandLineExtension;", "<init>", "()V", "dpaIsNotPreparedPrefix", "", "prepareCommandTimeouts", "Lcom/jetbrains/rd/framework/impl/RpcTimeouts;", "pathToDpaDebugInjector", "Lkotlin/Lazy;", "Ljava/io/File;", "pathToDebuggerDebugInjector", "probingPathsEnvVar", "Lcom/jetbrains/dpa/DpaExtension$ProbingPathsEnvVar;", "project", "Lcom/intellij/openapi/project/Project;", "getDpaEnvVars", "Lcom/jetbrains/dpa/DpaExtension$DpaEnvVars;", "environment", "", "enabledByUser", "", "debug", "isBackendReady", "patchDebugCommandLine", "Lorg/jetbrains/concurrency/Promise;", "Lcom/jetbrains/rider/run/WorkerRunInfo;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "workerRunInfo", "processInfo", "Lcom/intellij/execution/process/ProcessInfo;", "dotNetExecutable", "Lcom/jetbrains/rider/runtime/DotNetExecutable;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "patchRunCommandLine", "Lcom/intellij/execution/process/ProcessListener;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "dotNetRuntime", "Lcom/jetbrains/rider/runtime/DotNetRuntime;", "sync", "TRes", "TReq", "call", "Lcom/jetbrains/rd/framework/impl/RdCall;", "request", "timeouts", "onSuccessAfterTimeout", "Lkotlin/Function1;", "", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/framework/impl/RdCall;Ljava/lang/Object;Lcom/jetbrains/rd/framework/impl/RpcTimeouts;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "ProbingPathsEnvVar", "DpaEnvVars", "RunProcessListenerAdapter", "DebuggerAttachProcessListenerAdapter", "DebuggerStartProcessListenerAdapter", "intellij.rider.plugins.dpa"})
@SourceDebugExtension(value={"SMAP\nDpaExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DpaExtension.kt\ncom/jetbrains/dpa/DpaExtension\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 TaskInterfaces.kt\ncom/jetbrains/rd/framework/TaskInterfacesKt\n+ 4 SpinWait.kt\ncom/jetbrains/rd/util/threading/SpinWait$Companion\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 7 StructuredLogging.kt\ncom/jetbrains/rd/platform/diagnostics/StructuredLoggingKt\n+ 8 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,455:1\n82#2,3:456\n82#2,3:478\n82#2,3:481\n13#2:510\n95#3:459\n96#3:467\n23#4,7:460\n30#4,9:469\n1#5:468\n1563#6:484\n1634#6,3:485\n295#6,2:488\n774#6:490\n865#6,2:491\n144#7,5:493\n161#7,2:498\n150#7,9:500\n13#8:509\n*S KotlinDebug\n*F\n+ 1 DpaExtension.kt\ncom/jetbrains/dpa/DpaExtension\n*L\n79#1:456,3\n63#1:478,3\n70#1:481,3\n57#1:510\n444#1:459\n444#1:467\n444#1:460,7\n444#1:469,9\n444#1:468\n272#1:484\n272#1:485,3\n273#1:488,2\n276#1:490\n276#1:491,2\n388#1:493,5\n388#1:498,2\n388#1:500,9\n57#1:509\n*E\n"})
public final class DpaExtension
implements PatchCommandLineExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String dpaIsNotPreparedPrefix = DpaBundle.INSTANCE.message("dpa.extentions.dpa.is.not.prepared.prefix", new Object[0]);
    @NotNull
    private final RpcTimeouts prepareCommandTimeouts = new RpcTimeouts(3000L, 3000L);
    @NotNull
    private final Lazy<File> pathToDpaDebugInjector = LazyKt.lazy(() -> DpaExtension.pathToDpaDebugInjector$lambda$0(this));
    @NotNull
    private final Lazy<File> pathToDebuggerDebugInjector = LazyKt.lazy(() -> DpaExtension.pathToDebuggerDebugInjector$lambda$0(this));
    @NotNull
    private static final Key<Boolean> IS_PROCESSED_KEY = new Key("DpaExtension_IS_PROCESSED_KEY");
    @NotNull
    private static final Key<Long> MONITORING_MODEL_KEY = new Key("DpaExtension_MONITORING_MODEL_KEY");
    @NotNull
    private static final Logger logger;

    private final ProbingPathsEnvVar probingPathsEnvVar(Project project) {
        Logger $this$runAndLogException$iv = logger;
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            Logger $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            IProtocolHost iProtocolHost = ApplicationProtocolKt.getProtocolHost((Project)project);
            Object object = iProtocolHost instanceof IProtocolHostWithBackend ? (IProtocolHostWithBackend)iProtocolHost : null;
            if (object == null || (object = object.getResharperProcess()) == null || (object = object.getDotNetPluginsExtraDirs()) == null) {
                throw new Error(DpaBundle.INSTANCE.message("dpa.extentions.cant.get.plugin.extra.directories", new Object[0]));
            }
            Object paths = object;
            ProbingPathsEnvVar envVar = new ProbingPathsEnvVar("RIDER_PLUGIN_ADDITIONAL_PROBING_PATHS", (String)paths);
            DpaExtension.logger.trace(envVar.getKey() + ":" + envVar.getValue());
            return envVar;
        }
        catch (Throwable throwable) {
            return (ProbingPathsEnvVar)LoggerKt.getOrLogException((Object)Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable)), (Logger)$this$runAndLogException$iv);
        }
    }

    private final DpaEnvVars getDpaEnvVars(@NotNull Map<String, String> environment) {
        return new DpaEnvVars(environment.getOrDefault("JETBRAINS_DPA_MODE", ""), environment.getOrDefault("JETBRAINS_DPA_AGENT_ENABLE", ""), environment.getOrDefault("CORECLR_ENABLE_PROFILING", ""), environment.getOrDefault("COR_ENABLE_PROFILING", ""));
    }

    private final boolean enabledByUser(Project project, boolean debug) {
        DpaModel dpaModel = DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project));
        return Intrinsics.areEqual((Object)dpaModel.getEnabled().getValueOrNull(), (Object)true) || dpaModel.getMonitoringStartMode().getValueOrNull() == MonitoringStartMode.Always || dpaModel.getMonitoringStartMode().getValueOrNull() == MonitoringStartMode.OnDebug && debug;
    }

    private final boolean isBackendReady(Project project) {
        DpaRiderModel model = DpaBackendModelHost.Companion.getInstance(project).getModel();
        return (Boolean)model.getConnected().getValue() == true && (Intrinsics.areEqual((Object)model.getDpaReady().getValueOrNull(), (Object)true) || Intrinsics.areEqual((Object)model.getMonitoringReady().getValueOrNull(), (Object)true));
    }

    @NotNull
    public Promise<WorkerRunInfo> patchDebugCommandLine(@NotNull Lifetime lifetime, @NotNull WorkerRunInfo workerRunInfo, @Nullable ProcessInfo processInfo, @Nullable DotNetExecutable dotNetExecutable, @NotNull Project project, @Nullable DataContext dataContext) {
        IOptPropertyView iOptPropertyView;
        boolean isDiagnosticAttach;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)workerRunInfo, (String)"workerRunInfo");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (DpaAvailabilityService.Companion.getAvailability() == IntegrationLevel.Disabled || !this.enabledByUser(project, true) || !this.isBackendReady(project)) {
            DpaStatistics.Companion.getInstance(project).dpaCancelled(RunType.Debug, DpaCancelReason.DpaDisabled);
            logger.info("patchDebugCommandLine DPA and monitoring disabled");
            return Promises.resolvedPromise((Object)workerRunInfo);
        }
        File file = (File)this.pathToDpaDebugInjector.getValue();
        if (file == null) {
            return Promises.resolvedPromise((Object)workerRunInfo);
        }
        File dpaDebugInjector = file;
        File file2 = (File)this.pathToDebuggerDebugInjector.getValue();
        if (file2 == null) {
            return Promises.resolvedPromise((Object)workerRunInfo);
        }
        File debuggerDebugInjector = file2;
        ProbingPathsEnvVar probingPathsEnvVar = this.probingPathsEnvVar(project);
        if (probingPathsEnvVar == null) {
            return Promises.resolvedPromise((Object)workerRunInfo);
        }
        ProbingPathsEnvVar probingPaths = probingPathsEnvVar;
        AsyncPromise promise = new AsyncPromise();
        SolutionConfigurationManager manager = SolutionConfigurationManager.Companion.getInstance(project);
        RdConfigurationAndPlatform buildConfigurationId = manager.getActiveConfigurationAndPlatform();
        Map map = workerRunInfo.getCommandLine().getEnvironment();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvironment(...)");
        DpaEnvVars dpaEnvVars = this.getDpaEnvVars(map);
        LifetimeDefinition sessionLifetimeDefinition = UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)).createNested();
        ProcessInfo processInfo2 = processInfo;
        Integer pid = processInfo2 != null ? Integer.valueOf(processInfo2.getPid()) : null;
        DataContext dataContext2 = dataContext;
        boolean bl = isDiagnosticAttach = dataContext2 != null ? Intrinsics.areEqual((Object)dataContext2.getData(DebuggerDataKeys.INSTANCE.getIS_AUTO_ATTACH()), (Object)true) : false;
        if (pid == null) {
            String string = workerRunInfo.getCommandLine().getExePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExePath(...)");
            DotNetExecutable dotNetExecutable2 = dotNetExecutable;
            request = new StartingProcessArgs(buildConfigurationId, true, string, new StartingEnvironmentVars(dpaEnvVars.getDpaMode(), dpaEnvVars.getDpaAgentEnable(), dpaEnvVars.getClrEnableProfiling(), dpaEnvVars.getEnableProfiling()), null, ObjectExtensionsKt.falseIfNull((Boolean)(dotNetExecutable2 != null ? Boolean.valueOf(dotNetExecutable2.getAutoAttachToChildren()) : null)));
            logger.info("patchDebugCommandLine DPA backend request " + (StartingProcessArgs)request);
            iOptPropertyView = DpaBackendModelHost.Companion.getInstance(project).getModel().getProcessStarting().start(sessionLifetimeDefinition.getLifetime(), (Object)request).getResult();
        } else {
            request = new AttachProcessArgs(buildConfigurationId, true, false, false, pid.intValue(), workerRunInfo.getCommandLine().getExePath(), isDiagnosticAttach);
            logger.info("patchDebugCommandLine DPA backend request " + request);
            iOptPropertyView = DpaBackendModelHost.Companion.getInstance(project).getModel().getProcessAttach().start(sessionLifetimeDefinition.getLifetime(), (Object)request).getResult();
        }
        IOptPropertyView result = iOptPropertyView;
        SourceExKt.adviseOnce((ISource)((ISource)result), (Lifetime)lifetime, arg_0 -> DpaExtension.patchDebugCommandLine$lambda$0(workerRunInfo, pid, sessionLifetimeDefinition, promise, dpaDebugInjector, debuggerDebugInjector, project, isDiagnosticAttach, probingPaths, arg_0));
        return (Promise)promise;
    }

    @Nullable
    public ProcessListener patchRunCommandLine(@NotNull GeneralCommandLine commandLine, @NotNull DotNetRuntime dotNetRuntime, @Nullable DotNetExecutable dotNetExecutable, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)dotNetRuntime, (String)"dotNetRuntime");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (DpaAvailabilityService.Companion.getAvailability() == IntegrationLevel.Disabled || !this.enabledByUser(project, false) || !this.isBackendReady(project)) {
            DpaStatistics.Companion.getInstance(project).dpaCancelled(RunType.Run, DpaCancelReason.DpaDisabled);
            logger.info("patchRunCommandLine DPA and monitoring disabled");
            return null;
        }
        if (Intrinsics.areEqual((Object)dotNetRuntime.getType(), (Object)MonoRuntimeType.INSTANCE)) {
            DpaStatistics.Companion.getInstance(project).dpaCancelled(RunType.Run, DpaCancelReason.Mono);
            return null;
        }
        SolutionConfigurationManager manager = SolutionConfigurationManager.Companion.getInstance(project);
        RdConfigurationAndPlatform buildConfigurationId = manager.getActiveConfigurationAndPlatform();
        String string = commandLine.getExePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExePath(...)");
        String exePath = string;
        LifetimeDefinition sessionLifetimeDefinition = UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)project)).createNested();
        RunProcessListenerAdapter processListener = new RunProcessListenerAdapter();
        Function1 runDpaSession = arg_0 -> DpaExtension.patchRunCommandLine$lambda$0(sessionLifetimeDefinition, processListener, this, commandLine, buildConfigurationId, exePath, project, arg_0);
        CollectorControllerMode collectorMode = (CollectorControllerMode)InterfacesKt.valueOrDefault((IOptProperty)DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project)).getCollectorMode(), (Object)CollectorControllerMode.ETW);
        if (SystemInfo.isWindows && collectorMode == CollectorControllerMode.ETW) {
            LongConsumer runDpaSessionDelegate = arg_0 -> DpaExtension.patchRunCommandLine$lambda$4(runDpaSession, arg_0);
            if (commandLine instanceof CommandLineWithSuspendedProcessCallback) {
                ((CommandLineWithSuspendedProcessCallback)commandLine).withWinSuspendedProcessCallback(runDpaSessionDelegate);
            } else {
                commandLine.putUserData(WinExternalConsoleProcessHandler.Companion.getSUSPENDED_PROCESS_CALLBACK(), (Object)runDpaSessionDelegate);
            }
        } else {
            runDpaSession.invoke(null);
        }
        return processListener;
    }

    /*
     * WARNING - void declaration
     */
    public final <TReq, TRes> TRes sync(@NotNull Lifetime lifetime, @NotNull RdCall<TReq, TRes> call, TReq request, @NotNull RpcTimeouts timeouts, @NotNull Function1<? super TRes, Unit> onSuccessAfterTimeout) {
        boolean bl;
        IRdTask task;
        block5: {
            void this_$iv$iv;
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter(call, (String)"call");
            Intrinsics.checkNotNullParameter((Object)timeouts, (String)"timeouts");
            Intrinsics.checkNotNullParameter(onSuccessAfterTimeout, (String)"onSuccessAfterTimeout");
            IRdTask iRdTask = task = call.start(lifetime, request, (IScheduler)SynchronousScheduler.INSTANCE);
            long timeoutMs$iv = this.prepareCommandTimeouts.getErrorAwaitTimeMs();
            boolean $i$f$wait = false;
            SpinWait.Companion companion = SpinWait.Companion;
            Lifetime lifetime$iv$iv = Lifetime.Companion.getEternal();
            boolean $i$f$spinUntil = false;
            void var14_13 = this_$iv$iv;
            Duration duration = Duration.ofMillis(timeoutMs$iv);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(timeoutMs)");
            Duration duration$iv$iv$iv = duration;
            boolean $i$f$spinUntil2 = false;
            long start$iv$iv$iv = System.nanoTime();
            long spins$iv$iv$iv = 0L;
            while (true) {
                void $this$wait$iv;
                boolean bl2;
                boolean bl3 = false;
                boolean $this$wait_u24lambda_u241_u24lambda_u240$iv = bl2 = InterfacesKt.getHasValue((IOptPropertyView)$this$wait$iv.getResult());
                boolean bl4 = false;
                if (!$this$wait_u24lambda_u241_u24lambda_u240$iv) {
                    boolean bl5 = false;
                }
                if (bl2) break;
                if (!RLifetimeKt.isAlive((Lifetime)lifetime$iv$iv) || System.nanoTime() - start$iv$iv$iv > duration$iv$iv$iv.toNanos()) {
                    bl = false;
                    break block5;
                }
                long l = spins$iv$iv$iv;
                spins$iv$iv$iv = l + 1L;
                if (l < 100L) {
                    Thread.yield();
                    continue;
                }
                Thread.sleep(spins$iv$iv$iv / (long)100);
            }
            bl = true;
        }
        if (!bl) {
            SourceExKt.adviseOnce((ISource)((ISource)task.getResult()), (Lifetime)lifetime, arg_0 -> DpaExtension.sync$lambda$1(onSuccessAfterTimeout, arg_0));
            throw new TimeoutException("Sync execution of rpc `" + call + ".location` is timed out in " + timeouts.getErrorAwaitTimeMs() + " ms");
        }
        return (TRes)((RdTaskResult)InterfacesKt.getValueOrThrow((IOptPropertyView)task.getResult())).unwrap();
    }

    private static final File pathToDpaDebugInjector$lambda$0(DpaExtension this$0) {
        Object object;
        Logger $this$runAndLogException$iv = logger;
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            Logger $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            File file = RiderBundledPluginHelpers.Companion.getBundledPluginDotFile(this$0.getClass(), "JetBrains.DPA.DebugInjector.dll", DpaExtension.logger);
            if (file == null) {
                throw new Error(DpaBundle.INSTANCE.message("dpa.extentions.cant.find.dpa.debug.injector", new Object[0]));
            }
            object = Result.constructor-impl((Object)file);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (File)LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
    }

    private static final File pathToDebuggerDebugInjector$lambda$0(DpaExtension this$0) {
        Object object;
        Logger $this$runAndLogException$iv = logger;
        boolean $i$f$runAndLogException = false;
        Logger logger = $this$runAndLogException$iv;
        try {
            Logger $this$runAndLogException_u24lambda_u240$iv = logger;
            boolean bl = false;
            boolean bl2 = false;
            File file = RiderBundledPluginHelpers.Companion.getBundledPluginDotFile(this$0.getClass(), "JetBrains.Debugger.DebugInjector.dll", DpaExtension.logger);
            if (file == null) {
                throw new Error(DpaBundle.INSTANCE.message("dpa.extentions.cant.find.debugger.debug.injector", new Object[0]));
            }
            object = Result.constructor-impl((Object)file);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return (File)LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit patchDebugCommandLine$lambda$0(WorkerRunInfo $workerRunInfo, Integer $pid, LifetimeDefinition $sessionLifetimeDefinition, AsyncPromise $promise, File $dpaDebugInjector, File $debuggerDebugInjector, Project $project, boolean $isDiagnosticAttach, ProbingPathsEnvVar $probingPaths, RdTaskResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        RdTaskResult rdTaskResult = it;
        if (rdTaskResult instanceof RdTaskResult.Success) {
            if (((ProcessResult)((RdTaskResult.Success)it).getValue()).getSessionResult() == SessionResult.Success) {
                String detachEventName;
                List list;
                List $i$f$firstOrNull2;
                Object v1;
                Object element$iv;
                String[] $i$f$mapTo22;
                Object $this$firstOrNull$iv;
                List debugInjectorsPaths;
                GeneralCommandLine $this$patchDebugCommandLine_u24lambda_u240_u240;
                block23: {
                    void $this$mapTo$iv$iv;
                    GeneralCommandLine generalCommandLine;
                    $this$patchDebugCommandLine_u24lambda_u240_u240 = generalCommandLine = $workerRunInfo.getCommandLine();
                    boolean bl = false;
                    Object[] objectArray = new File[]{$dpaDebugInjector, $debuggerDebugInjector};
                    Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo22 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void file;
                        File file2 = (File)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(file.getAbsolutePath());
                    }
                    debugInjectorsPaths = (List)destination$iv$iv;
                    List list2 = $this$patchDebugCommandLine_u24lambda_u240_u240.getParametersList().getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getParameters(...)");
                    $this$firstOrNull$iv = list2;
                    boolean $i$f$firstOrNull2 = false;
                    $i$f$mapTo22 = $this$firstOrNull$iv.iterator();
                    while ($i$f$mapTo22.hasNext()) {
                        element$iv = $i$f$mapTo22.next();
                        String param = (String)element$iv;
                        boolean bl3 = false;
                        Intrinsics.checkNotNull((Object)param);
                        if (!StringsKt.startsWith$default((String)param, (String)"--plugins=", (boolean)false, (int)2, null)) continue;
                        v1 = element$iv;
                        break block23;
                    }
                    v1 = null;
                }
                String $i$f$map = v1;
                if ($i$f$map != null && ($this$firstOrNull$iv = StringsKt.substringAfter$default((String)$i$f$map, (String)"--plugins=", null, (int)2, null)) != null && ($i$f$firstOrNull2 = StringsKt.split$default((CharSequence)((CharSequence)$this$firstOrNull$iv), (String[])($i$f$mapTo22 = new String[]{";"}), (boolean)false, (int)0, (int)6, null)) != null) {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    element$iv = $i$f$firstOrNull2;
                    boolean $i$f$filter = false;
                    void bl3 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        String s = (String)element$iv$iv;
                        boolean bl = false;
                        boolean bl4 = ((CharSequence)s).length() > 0;
                        if (!bl4) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = CollectionsKt.emptyList();
                }
                List providedPlugins = list;
                Object str = "--plugins=" + CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)providedPlugins, (Iterable)debugInjectorsPaths), (CharSequence)";", null, null, (int)0, null, null, (int)62, null);
                boolean bl = false;
                String newPluginsStr = SystemInfo.isWindows && ($this$patchDebugCommandLine_u24lambda_u240_u240 instanceof FormatPreservingCommandLine || $this$patchDebugCommandLine_u24lambda_u240_u240 instanceof FormatPreservingPtyCommandLine) ? "\"" + (String)str + "\"" : str;
                $this$patchDebugCommandLine_u24lambda_u240_u240.getParametersList().replaceOrAppend("--plugins=", newPluginsStr);
                CollectorSessionArgs collectorSessionArgs = ((ProcessResult)((RdTaskResult.Success)it).getValue()).getCollectorSessionArgs();
                if (collectorSessionArgs != null) {
                    $this$patchDebugCommandLine_u24lambda_u240_u240.getParametersList().add("--dpa-flags=" + ULong.toString-impl((long)collectorSessionArgs.getFlags-s-VKNKU()));
                    if (collectorSessionArgs.getRefreshInterval() != null) {
                        $this$patchDebugCommandLine_u24lambda_u240_u240.getParametersList().add("--dpa-refresh-interval=" + collectorSessionArgs.getRefreshInterval());
                    }
                    if (!((str = (CharSequence)collectorSessionArgs.getCounterProviders()) == null || str.length() == 0)) {
                        $this$patchDebugCommandLine_u24lambda_u240_u240.getParametersList().add("--dpa-counters=" + collectorSessionArgs.getCounterProviders());
                    }
                    if (!((str = (CharSequence)collectorSessionArgs.getMetrics()) == null || str.length() == 0)) {
                        $this$patchDebugCommandLine_u24lambda_u240_u240.getParametersList().add("--dpa-metrics=" + collectorSessionArgs.getMetrics());
                        if (collectorSessionArgs.getMaxTimeSeries() != null) {
                            $this$patchDebugCommandLine_u24lambda_u240_u240.getParametersList().add("--dpa-max-time-series=" + collectorSessionArgs.getMaxTimeSeries());
                        }
                        if (collectorSessionArgs.getMaxHistograms() != null) {
                            $this$patchDebugCommandLine_u24lambda_u240_u240.getParametersList().add("--dpa-max-histograms=" + collectorSessionArgs.getMaxHistograms());
                        }
                    }
                }
                if (((ProcessResult)((RdTaskResult.Success)it).getValue()).getIgnoreProfiler()) {
                    $this$patchDebugCommandLine_u24lambda_u240_u240.getParametersList().add("--dpa-ignore-profiling");
                }
                if (!((ProcessResult)((RdTaskResult.Success)it).getValue()).getLimitSnapshotSize()) {
                    $this$patchDebugCommandLine_u24lambda_u240_u240.getParametersList().add("--dpa-unlimit-snapshot");
                }
                if ((detachEventName = ((ProcessResult)((RdTaskResult.Success)it).getValue()).getDetachEventName()) != null) {
                    $this$patchDebugCommandLine_u24lambda_u240_u240.getParametersList().add("--dpa-detach-event-name=" + detachEventName);
                }
                if (((ProcessResult)((RdTaskResult.Success)it).getValue()).getHandle() != 0L) {
                    $this$patchDebugCommandLine_u24lambda_u240_u240.getParametersList().add("--dpa-backend-pid=" + ((ProcessResult)((RdTaskResult.Success)it).getValue()).getPid());
                    $this$patchDebugCommandLine_u24lambda_u240_u240.getParametersList().add("--dpa-handle=" + ((ProcessResult)((RdTaskResult.Success)it).getValue()).getHandle());
                }
                $this$patchDebugCommandLine_u24lambda_u240_u240.getParametersList().add("--dpa-collector-mode=" + DpaModel_PregeneratedKt.getDpaModel((Solution)SolutionHostExtensionsKt.getSolution((Project)$project)).getCollectorMode().getValueOrNull());
                if ($isDiagnosticAttach) {
                    $this$patchDebugCommandLine_u24lambda_u240_u240.getParametersList().add("--dpa-is-auto-attach");
                }
                $this$patchDebugCommandLine_u24lambda_u240_u240.withEnvironment($probingPaths.getKey(), $probingPaths.getValue());
            }
            ProcessListener listener = $pid == null ? (ProcessListener)new DebuggerStartProcessListenerAdapter($sessionLifetimeDefinition.getLifetime(), ((ProcessResult)((RdTaskResult.Success)it).getValue()).getProcessListener(), (Function1<? super ProcessHandler, Unit>)((Function1)arg_0 -> DpaExtension.patchDebugCommandLine$lambda$0$1(it, arg_0)), (Function0<Unit>)((Function0)() -> DpaExtension.patchDebugCommandLine$lambda$0$2($sessionLifetimeDefinition))) : (ProcessListener)new DebuggerAttachProcessListenerAdapter($pid, ((ProcessResult)((RdTaskResult.Success)it).getValue()).getProcessListener(), (Function1<? super ProcessHandler, Unit>)((Function1)arg_0 -> DpaExtension.patchDebugCommandLine$lambda$0$3(it, arg_0)), (Function0<Unit>)((Function0)() -> DpaExtension.patchDebugCommandLine$lambda$0$4($sessionLifetimeDefinition)));
            $workerRunInfo.addProcessListener(listener);
            $promise.setResult((Object)$workerRunInfo);
        } else if (rdTaskResult instanceof RdTaskResult.Fault) {
            logger.warn((Throwable)((RdTaskResult.Fault)it).getError());
            LifetimeDefinition.terminate$default((LifetimeDefinition)$sessionLifetimeDefinition, (boolean)false, (int)1, null);
            $promise.setResult((Object)$workerRunInfo);
        } else if (rdTaskResult instanceof RdTaskResult.Cancelled) {
            logger.info("DPA prepare for debug was cancelled");
            LifetimeDefinition.terminate$default((LifetimeDefinition)$sessionLifetimeDefinition, (boolean)false, (int)1, null);
            $promise.setResult((Object)$workerRunInfo);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return Unit.INSTANCE;
    }

    private static final Unit patchDebugCommandLine$lambda$0$1(RdTaskResult<ProcessResult> $it, ProcessHandler ph) {
        ph.putUserData(IS_PROCESSED_KEY, (Object)true);
        ph.putUserData(MONITORING_MODEL_KEY, (Object)((ProcessResult)((RdTaskResult.Success)$it).getValue()).getSessionId());
        return Unit.INSTANCE;
    }

    private static final Unit patchDebugCommandLine$lambda$0$2(LifetimeDefinition sessionLifetimeDefinition) {
        LifetimeDefinition.terminate$default((LifetimeDefinition)sessionLifetimeDefinition, (boolean)false, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit patchDebugCommandLine$lambda$0$3(RdTaskResult<ProcessResult> $it, ProcessHandler ph) {
        ph.putUserData(IS_PROCESSED_KEY, (Object)true);
        ph.putUserData(MONITORING_MODEL_KEY, (Object)((ProcessResult)((RdTaskResult.Success)$it).getValue()).getSessionId());
        return Unit.INSTANCE;
    }

    private static final Unit patchDebugCommandLine$lambda$0$4(LifetimeDefinition sessionLifetimeDefinition) {
        LifetimeDefinition.terminate$default((LifetimeDefinition)sessionLifetimeDefinition, (boolean)false, (int)1, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit patchRunCommandLine$lambda$0(LifetimeDefinition sessionLifetimeDefinition, RunProcessListenerAdapter processListener, DpaExtension this$0, GeneralCommandLine $commandLine, RdConfigurationAndPlatform buildConfigurationId, String exePath, Project $project, Integer pid) {
        Object object;
        Logger logger = DpaExtension.logger;
        try {
            void $this$doCalculation_u24default$iv;
            ProcessResult processResult;
            Logger $this$patchRunCommandLine_u24lambda_u240_u24lambda_u241 = logger;
            boolean bl = false;
            Logger logger2 = DpaExtension.logger;
            String key$iv = "getHandleFromBackend";
            Object message$iv = null;
            boolean $i$f$doCalculation = false;
            boolean hadException$iv = false;
            long startTime$iv = System.nanoTime();
            try {
                boolean bl2 = false;
                Map map = $commandLine.getEnvironment();
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getEnvironment(...)");
                DpaEnvVars dpaEnvVars = this$0.getDpaEnvVars(map);
                StartingEnvironmentVars envVars = new StartingEnvironmentVars(dpaEnvVars.getDpaMode(), dpaEnvVars.getDpaAgentEnable(), dpaEnvVars.getClrEnableProfiling(), dpaEnvVars.getEnableProfiling());
                StartingProcessArgs request = new StartingProcessArgs(buildConfigurationId, false, exePath, envVars, pid, false);
                DpaExtension.logger.info("patchRunCommandLine DPA request DPA backend " + request);
                processResult = (ProcessResult)this$0.sync(sessionLifetimeDefinition.getLifetime(), DpaBackendModelHost.Companion.getInstance($project).getModel().getProcessStarting(), request, this$0.prepareCommandTimeouts, arg_0 -> DpaExtension.patchRunCommandLine$lambda$0$lambda$1$0$0(sessionLifetimeDefinition, arg_0));
            }
            catch (Throwable t$iv) {
                try {
                    String eventKind$iv = t$iv instanceof ProcessCanceledException || t$iv instanceof CancellationException ? "Cancelled" : "Exception";
                    hadException$iv = true;
                    StructuredLoggingKt.sendStructuredLog((Logger)$this$doCalculation_u24default$iv, (String)("<" + eventKind$iv + "> \"" + StructuredLoggingKt.getFullKey((String)key$iv) + "\" " + "" + " time=" + (long)((double)(System.nanoTime() - startTime$iv) / 1000000.0) + "ms\u200b\u200c\u200b"));
                    throw t$iv;
                }
                catch (Throwable throwable) {
                    if (!hadException$iv) {
                        StructuredLoggingKt.sendStructuredLog((Logger)$this$doCalculation_u24default$iv, (String)("<Measured> \"" + StructuredLoggingKt.getFullKey((String)key$iv) + "\" " + "" + " time=" + (long)((double)(System.nanoTime() - startTime$iv) / 1000000.0) + "ms\u200b\u200c\u200b"));
                    }
                    throw throwable;
                }
            }
            StructuredLoggingKt.sendStructuredLog((Logger)$this$doCalculation_u24default$iv, (String)("<Measured> \"" + StructuredLoggingKt.getFullKey((String)key$iv) + "\" " + "" + " time=" + (long)((double)(System.nanoTime() - startTime$iv) / 1000000.0) + "ms\u200b\u200c\u200b"));
            object = Result.constructor-impl((Object)processResult);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Object prepareForRunResult = object;
        if (Result.isFailure-impl((Object)prepareForRunResult)) {
            DpaExtension.logger.error("processStarting backend call", Result.exceptionOrNull-impl((Object)prepareForRunResult));
            LifetimeDefinition.terminate$default((LifetimeDefinition)sessionLifetimeDefinition, (boolean)false, (int)1, null);
            return Unit.INSTANCE;
        }
        object = prepareForRunResult;
        ResultKt.throwOnFailure((Object)object);
        ProcessResult processResult = (ProcessResult)object;
        processListener.initAdapter(processResult.getProcessListener(), (Function1<? super ProcessHandler, Unit>)((Function1)arg_0 -> DpaExtension.patchRunCommandLine$lambda$0$lambda$2(processResult, arg_0)), (Function0<Unit>)((Function0)() -> DpaExtension.patchRunCommandLine$lambda$0$lambda$3(sessionLifetimeDefinition)));
        return Unit.INSTANCE;
    }

    private static final Unit patchRunCommandLine$lambda$0$lambda$1$0$0(LifetimeDefinition $sessionLifetimeDefinition, ProcessResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        logger.info("patchRunCommandLine DPA request timeout action");
        it.getProcessListener().getProcessNotStarted().fire((Object)Unit.INSTANCE);
        LifetimeDefinition.terminate$default((LifetimeDefinition)$sessionLifetimeDefinition, (boolean)false, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit patchRunCommandLine$lambda$0$lambda$2(ProcessResult processResult, ProcessHandler ph) {
        ph.putUserData(IS_PROCESSED_KEY, (Object)true);
        ph.putUserData(MONITORING_MODEL_KEY, (Object)processResult.getSessionId());
        return Unit.INSTANCE;
    }

    private static final Unit patchRunCommandLine$lambda$0$lambda$3(LifetimeDefinition sessionLifetimeDefinition) {
        LifetimeDefinition.terminate$default((LifetimeDefinition)sessionLifetimeDefinition, (boolean)false, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final void patchRunCommandLine$lambda$4(Function1 $runDpaSession, long p) {
        $runDpaSession.invoke((Object)((int)p));
    }

    private static final Unit sync$lambda$1(Function1 $onSuccessAfterTimeout, RdTaskResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it instanceof RdTaskResult.Success) {
            $onSuccessAfterTimeout.invoke(((RdTaskResult.Success)it).getValue());
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DpaExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        DpaExtension.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/dpa/DpaExtension$Companion;", "", "<init>", "()V", "IS_PROCESSED_KEY", "Lcom/intellij/openapi/util/Key;", "", "getIS_PROCESSED_KEY", "()Lcom/intellij/openapi/util/Key;", "MONITORING_MODEL_KEY", "", "getMONITORING_MODEL_KEY", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.dpa"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Boolean> getIS_PROCESSED_KEY() {
            return IS_PROCESSED_KEY;
        }

        @NotNull
        public final Key<Long> getMONITORING_MODEL_KEY() {
            return MONITORING_MODEL_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0012\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u001d\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/dpa/DpaExtension$DebuggerAttachProcessListenerAdapter;", "Lcom/intellij/execution/process/ProcessListener;", "pid", "", "processListener", "Lcom/jetbrains/rider/model/ProcessListener;", "onStarted", "Lkotlin/Function1;", "Lcom/intellij/execution/process/ProcessHandler;", "", "onFinished", "Lkotlin/Function0;", "<init>", "(ILcom/jetbrains/rider/model/ProcessListener;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "getPid", "()I", "getProcessListener", "()Lcom/jetbrains/rider/model/ProcessListener;", "getOnStarted", "()Lkotlin/jvm/functions/Function1;", "getOnFinished", "()Lkotlin/jvm/functions/Function0;", "processWillTerminate", "event", "Lcom/intellij/execution/process/ProcessEvent;", "willBeDestroyed", "", "processTerminated", "startNotified", "processNotStarted", "intellij.rider.plugins.dpa"})
    private static class DebuggerAttachProcessListenerAdapter
    implements ProcessListener {
        private final int pid;
        @NotNull
        private final com.jetbrains.rider.model.ProcessListener processListener;
        @NotNull
        private final Function1<ProcessHandler, Unit> onStarted;
        @NotNull
        private final Function0<Unit> onFinished;

        public DebuggerAttachProcessListenerAdapter(int pid, @NotNull com.jetbrains.rider.model.ProcessListener processListener, @NotNull Function1<? super ProcessHandler, Unit> onStarted, @NotNull Function0<Unit> onFinished) {
            Intrinsics.checkNotNullParameter((Object)processListener, (String)"processListener");
            Intrinsics.checkNotNullParameter(onStarted, (String)"onStarted");
            Intrinsics.checkNotNullParameter(onFinished, (String)"onFinished");
            this.pid = pid;
            this.processListener = processListener;
            this.onStarted = onStarted;
            this.onFinished = onFinished;
        }

        public final int getPid() {
            return this.pid;
        }

        @NotNull
        public final com.jetbrains.rider.model.ProcessListener getProcessListener() {
            return this.processListener;
        }

        @NotNull
        public final Function1<ProcessHandler, Unit> getOnStarted() {
            return this.onStarted;
        }

        @NotNull
        public final Function0<Unit> getOnFinished() {
            return this.onFinished;
        }

        public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.processListener.getProcessWillTerminate().fire((Object)willBeDestroyed);
            if (!willBeDestroyed) {
                this.onFinished.invoke();
            }
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.processListener.getProcessTerminated().fire((Object)event.getExitCode());
            this.onFinished.invoke();
        }

        public void startNotified(@NotNull ProcessEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ProcessHandler processHandler = event.getProcessHandler();
            Integer debuggerPid = null;
            if (processHandler instanceof DebuggerWorkerProcessHandler) {
                debuggerPid = ((DebuggerWorkerProcessHandler)processHandler).getPid();
            }
            this.processListener.getStartNotified().fire((Object)new ProcessStartedArgs(this.pid, debuggerPid));
            ProcessHandler processHandler2 = event.getProcessHandler();
            Intrinsics.checkNotNullExpressionValue((Object)processHandler2, (String)"getProcessHandler(...)");
            this.onStarted.invoke((Object)processHandler2);
        }

        public void processNotStarted() {
            this.processListener.getProcessNotStarted().fire((Object)Unit.INSTANCE);
            this.onFinished.invoke();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0012\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u001d\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/dpa/DpaExtension$DebuggerStartProcessListenerAdapter;", "Lcom/intellij/execution/process/ProcessListener;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "processListener", "Lcom/jetbrains/rider/model/ProcessListener;", "onStarted", "Lkotlin/Function1;", "Lcom/intellij/execution/process/ProcessHandler;", "", "onFinished", "Lkotlin/Function0;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/model/ProcessListener;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getProcessListener", "()Lcom/jetbrains/rider/model/ProcessListener;", "getOnStarted", "()Lkotlin/jvm/functions/Function1;", "getOnFinished", "()Lkotlin/jvm/functions/Function0;", "processWillTerminate", "event", "Lcom/intellij/execution/process/ProcessEvent;", "willBeDestroyed", "", "processTerminated", "startNotified", "processNotStarted", "intellij.rider.plugins.dpa"})
    private static class DebuggerStartProcessListenerAdapter
    implements ProcessListener {
        @NotNull
        private final Lifetime lifetime;
        @NotNull
        private final com.jetbrains.rider.model.ProcessListener processListener;
        @NotNull
        private final Function1<ProcessHandler, Unit> onStarted;
        @NotNull
        private final Function0<Unit> onFinished;

        public DebuggerStartProcessListenerAdapter(@NotNull Lifetime lifetime, @NotNull com.jetbrains.rider.model.ProcessListener processListener, @NotNull Function1<? super ProcessHandler, Unit> onStarted, @NotNull Function0<Unit> onFinished) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)processListener, (String)"processListener");
            Intrinsics.checkNotNullParameter(onStarted, (String)"onStarted");
            Intrinsics.checkNotNullParameter(onFinished, (String)"onFinished");
            this.lifetime = lifetime;
            this.processListener = processListener;
            this.onStarted = onStarted;
            this.onFinished = onFinished;
        }

        @NotNull
        public final Lifetime getLifetime() {
            return this.lifetime;
        }

        @NotNull
        public final com.jetbrains.rider.model.ProcessListener getProcessListener() {
            return this.processListener;
        }

        @NotNull
        public final Function1<ProcessHandler, Unit> getOnStarted() {
            return this.onStarted;
        }

        @NotNull
        public final Function0<Unit> getOnFinished() {
            return this.onFinished;
        }

        public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.processListener.getProcessWillTerminate().fire((Object)willBeDestroyed);
            if (!willBeDestroyed) {
                this.onFinished.invoke();
            }
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.processListener.getProcessTerminated().fire((Object)event.getExitCode());
            this.onFinished.invoke();
        }

        public void startNotified(@NotNull ProcessEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ProcessHandler debuggerWorkerProcessHandler = event.getProcessHandler();
            if (debuggerWorkerProcessHandler instanceof DebuggerWorkerProcessHandler) {
                ((DebuggerWorkerProcessHandler)debuggerWorkerProcessHandler).getWorkerModel().getActiveSession().advise(this.lifetime, arg_0 -> DebuggerStartProcessListenerAdapter.startNotified$lambda$0(this, debuggerWorkerProcessHandler, arg_0));
            }
            ProcessHandler processHandler = event.getProcessHandler();
            Intrinsics.checkNotNullExpressionValue((Object)processHandler, (String)"getProcessHandler(...)");
            this.onStarted.invoke((Object)processHandler);
        }

        public void processNotStarted() {
            this.processListener.getProcessNotStarted().fire((Object)Unit.INSTANCE);
            this.onFinished.invoke();
        }

        private static final Unit startNotified$lambda$0(DebuggerStartProcessListenerAdapter this$0, ProcessHandler $debuggerWorkerProcessHandler, DotNetDebuggerSessionModel it) {
            if (it == null) {
                return Unit.INSTANCE;
            }
            SourceExKt.adviseOnce((ISource)it.getTargetReady(), (Lifetime)this$0.lifetime, arg_0 -> DebuggerStartProcessListenerAdapter.startNotified$lambda$0$0(this$0, $debuggerWorkerProcessHandler, arg_0));
            return Unit.INSTANCE;
        }

        private static final Unit startNotified$lambda$0$0(DebuggerStartProcessListenerAdapter this$0, ProcessHandler $debuggerWorkerProcessHandler, DebuggerSessionInfo debuggerSessionInfo) {
            Intrinsics.checkNotNullParameter((Object)debuggerSessionInfo, (String)"debuggerSessionInfo");
            if (debuggerSessionInfo.getProcessId() == -1) {
                return Unit.INSTANCE;
            }
            this$0.processListener.getStartNotified().fire((Object)new ProcessStartedArgs(debuggerSessionInfo.getProcessId(), ((DebuggerWorkerProcessHandler)$debuggerWorkerProcessHandler).getPid()));
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/dpa/DpaExtension$DpaEnvVars;", "", "dpaMode", "", "dpaAgentEnable", "clrEnableProfiling", "enableProfiling", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDpaMode", "()Ljava/lang/String;", "getDpaAgentEnable", "getClrEnableProfiling", "getEnableProfiling", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rider.plugins.dpa"})
    public static final class DpaEnvVars {
        @NotNull
        private final String dpaMode;
        @NotNull
        private final String dpaAgentEnable;
        @NotNull
        private final String clrEnableProfiling;
        @NotNull
        private final String enableProfiling;

        public DpaEnvVars(@NotNull String dpaMode, @NotNull String dpaAgentEnable, @NotNull String clrEnableProfiling, @NotNull String enableProfiling) {
            Intrinsics.checkNotNullParameter((Object)dpaMode, (String)"dpaMode");
            Intrinsics.checkNotNullParameter((Object)dpaAgentEnable, (String)"dpaAgentEnable");
            Intrinsics.checkNotNullParameter((Object)clrEnableProfiling, (String)"clrEnableProfiling");
            Intrinsics.checkNotNullParameter((Object)enableProfiling, (String)"enableProfiling");
            this.dpaMode = dpaMode;
            this.dpaAgentEnable = dpaAgentEnable;
            this.clrEnableProfiling = clrEnableProfiling;
            this.enableProfiling = enableProfiling;
        }

        @NotNull
        public final String getDpaMode() {
            return this.dpaMode;
        }

        @NotNull
        public final String getDpaAgentEnable() {
            return this.dpaAgentEnable;
        }

        @NotNull
        public final String getClrEnableProfiling() {
            return this.clrEnableProfiling;
        }

        @NotNull
        public final String getEnableProfiling() {
            return this.enableProfiling;
        }

        @NotNull
        public final String component1() {
            return this.dpaMode;
        }

        @NotNull
        public final String component2() {
            return this.dpaAgentEnable;
        }

        @NotNull
        public final String component3() {
            return this.clrEnableProfiling;
        }

        @NotNull
        public final String component4() {
            return this.enableProfiling;
        }

        @NotNull
        public final DpaEnvVars copy(@NotNull String dpaMode, @NotNull String dpaAgentEnable, @NotNull String clrEnableProfiling, @NotNull String enableProfiling) {
            Intrinsics.checkNotNullParameter((Object)dpaMode, (String)"dpaMode");
            Intrinsics.checkNotNullParameter((Object)dpaAgentEnable, (String)"dpaAgentEnable");
            Intrinsics.checkNotNullParameter((Object)clrEnableProfiling, (String)"clrEnableProfiling");
            Intrinsics.checkNotNullParameter((Object)enableProfiling, (String)"enableProfiling");
            return new DpaEnvVars(dpaMode, dpaAgentEnable, clrEnableProfiling, enableProfiling);
        }

        public static /* synthetic */ DpaEnvVars copy$default(DpaEnvVars dpaEnvVars, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = dpaEnvVars.dpaMode;
            }
            if ((n & 2) != 0) {
                string2 = dpaEnvVars.dpaAgentEnable;
            }
            if ((n & 4) != 0) {
                string3 = dpaEnvVars.clrEnableProfiling;
            }
            if ((n & 8) != 0) {
                string4 = dpaEnvVars.enableProfiling;
            }
            return dpaEnvVars.copy(string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "DpaEnvVars(dpaMode=" + this.dpaMode + ", dpaAgentEnable=" + this.dpaAgentEnable + ", clrEnableProfiling=" + this.clrEnableProfiling + ", enableProfiling=" + this.enableProfiling + ")";
        }

        public int hashCode() {
            int result = this.dpaMode.hashCode();
            result = result * 31 + this.dpaAgentEnable.hashCode();
            result = result * 31 + this.clrEnableProfiling.hashCode();
            result = result * 31 + this.enableProfiling.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DpaEnvVars)) {
                return false;
            }
            DpaEnvVars dpaEnvVars = (DpaEnvVars)other;
            if (!Intrinsics.areEqual((Object)this.dpaMode, (Object)dpaEnvVars.dpaMode)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.dpaAgentEnable, (Object)dpaEnvVars.dpaAgentEnable)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.clrEnableProfiling, (Object)dpaEnvVars.clrEnableProfiling)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.enableProfiling, (Object)dpaEnvVars.enableProfiling);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/dpa/DpaExtension$ProbingPathsEnvVar;", "", "key", "", "value", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getKey", "()Ljava/lang/String;", "getValue", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rider.plugins.dpa"})
    public static final class ProbingPathsEnvVar {
        @NotNull
        private final String key;
        @NotNull
        private final String value;

        public ProbingPathsEnvVar(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.key = key;
            this.value = value;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final String component1() {
            return this.key;
        }

        @NotNull
        public final String component2() {
            return this.value;
        }

        @NotNull
        public final ProbingPathsEnvVar copy(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new ProbingPathsEnvVar(key, value);
        }

        public static /* synthetic */ ProbingPathsEnvVar copy$default(ProbingPathsEnvVar probingPathsEnvVar, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = probingPathsEnvVar.key;
            }
            if ((n & 2) != 0) {
                string2 = probingPathsEnvVar.value;
            }
            return probingPathsEnvVar.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "ProbingPathsEnvVar(key=" + this.key + ", value=" + this.value + ")";
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = result * 31 + this.value.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProbingPathsEnvVar)) {
                return false;
            }
            ProbingPathsEnvVar probingPathsEnvVar = (ProbingPathsEnvVar)other;
            if (!Intrinsics.areEqual((Object)this.key, (Object)probingPathsEnvVar.key)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.value, (Object)probingPathsEnvVar.value);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0012\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00052\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u000bJ\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rH\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/dpa/DpaExtension$RunProcessListenerAdapter;", "Lcom/intellij/execution/process/ProcessListener;", "<init>", "()V", "myProcessListener", "Lcom/jetbrains/rider/model/ProcessListener;", "myOnStarted", "Lkotlin/Function1;", "Lcom/intellij/execution/process/ProcessHandler;", "", "myOnFinished", "Lkotlin/Function0;", "myInitialized", "", "initAdapter", "listener", "onStarted", "onFinished", "processWillTerminate", "event", "Lcom/intellij/execution/process/ProcessEvent;", "willBeDestroyed", "processTerminated", "startNotified", "processNotStarted", "intellij.rider.plugins.dpa"})
    private static class RunProcessListenerAdapter
    implements ProcessListener {
        private com.jetbrains.rider.model.ProcessListener myProcessListener;
        private Function1<? super ProcessHandler, Unit> myOnStarted;
        private Function0<Unit> myOnFinished;
        private boolean myInitialized;

        public final void initAdapter(@NotNull com.jetbrains.rider.model.ProcessListener listener, @NotNull Function1<? super ProcessHandler, Unit> onStarted, @NotNull Function0<Unit> onFinished) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            Intrinsics.checkNotNullParameter(onStarted, (String)"onStarted");
            Intrinsics.checkNotNullParameter(onFinished, (String)"onFinished");
            this.myProcessListener = listener;
            this.myOnStarted = onStarted;
            this.myOnFinished = onFinished;
            this.myInitialized = true;
        }

        public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
            block4: {
                com.jetbrains.rider.model.ProcessListener processListener;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (!this.myInitialized) {
                    return;
                }
                if (!willBeDestroyed) {
                    Function0<Unit> function0 = this.myOnFinished;
                    if (function0 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"myOnFinished");
                        function0 = null;
                    }
                    function0.invoke();
                }
                if ((processListener = this.myProcessListener) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myProcessListener");
                    processListener = null;
                }
                IAsyncSignal iAsyncSignal = processListener.getProcessWillTerminate();
                if (iAsyncSignal == null) break block4;
                iAsyncSignal.fire((Object)willBeDestroyed);
            }
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            block3: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (!this.myInitialized) {
                    return;
                }
                Function0<Unit> function0 = this.myOnFinished;
                if (function0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myOnFinished");
                    function0 = null;
                }
                function0.invoke();
                com.jetbrains.rider.model.ProcessListener processListener = this.myProcessListener;
                if (processListener == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myProcessListener");
                    processListener = null;
                }
                IAsyncSignal iAsyncSignal = processListener.getProcessTerminated();
                if (iAsyncSignal == null) break block3;
                iAsyncSignal.fire((Object)event.getExitCode());
            }
        }

        public void startNotified(@NotNull ProcessEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!this.myInitialized) {
                return;
            }
            com.jetbrains.rider.model.ProcessListener processListener = this.myProcessListener;
            if (processListener == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myProcessListener");
                processListener = null;
            }
            IAsyncSignal iAsyncSignal = processListener.getStartNotified();
            ProcessHandler processHandler = event.getProcessHandler();
            Intrinsics.checkNotNullExpressionValue((Object)processHandler, (String)"getProcessHandler(...)");
            Integer n = ProcessHandlerUtilKt.getProcessId(processHandler);
            Intrinsics.checkNotNull((Object)n);
            iAsyncSignal.fire((Object)new ProcessStartedArgs(n.intValue(), null));
            Function1<? super ProcessHandler, Unit> function1 = this.myOnStarted;
            if (function1 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myOnStarted");
                function1 = null;
            }
            ProcessHandler processHandler2 = event.getProcessHandler();
            Intrinsics.checkNotNullExpressionValue((Object)processHandler2, (String)"getProcessHandler(...)");
            function1.invoke((Object)processHandler2);
        }

        public void processNotStarted() {
            Function0<Unit> function0;
            if (!this.myInitialized) {
                return;
            }
            com.jetbrains.rider.model.ProcessListener processListener = this.myProcessListener;
            if (processListener == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myProcessListener");
                processListener = null;
            }
            IAsyncSignal iAsyncSignal = processListener.getProcessNotStarted();
            if (iAsyncSignal != null) {
                iAsyncSignal.fire((Object)Unit.INSTANCE);
            }
            if ((function0 = this.myOnFinished) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myOnFinished");
                function0 = null;
            }
            function0.invoke();
        }
    }
}

