/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rider.navbar;

import com.intellij.ide.ui.UISettings;
import com.intellij.lang.Language;
import com.intellij.model.Pointer;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataMap;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DataSnapshot;
import com.intellij.openapi.actionSystem.UiDataRule;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.navbar.backend.NavBarItem;
import com.intellij.platform.navbar.backend.impl.DefaultNavBarItem;
import com.intellij.psi.PsiFile;
import com.intellij.rider.features.navbar.backend.MemberNavBarItem;
import com.intellij.rider.navbar.EntityNavBarItem;
import com.intellij.rider.navbar.RiderNavbarMembersSupport;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.StructureTimestamp;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.fileStructure.FrontendFileStructureHost;
import com.jetbrains.rdclient.fileStructure.ProtocolStructureViewTreeElement;
import com.jetbrains.rider.editors.PlatformTextControlUtilsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0002J*\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/rider/navbar/RiderNavBarMemberItemDataRule;", "Lcom/intellij/openapi/actionSystem/UiDataRule;", "<init>", "()V", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "snapshot", "Lcom/intellij/openapi/actionSystem/DataSnapshot;", "navBarItem", "Lcom/intellij/model/Pointer;", "Lcom/intellij/platform/navbar/backend/NavBarItem;", "dataProvider", "Lcom/intellij/openapi/actionSystem/DataMap;", "lastNodeAtCaret", "Lcom/jetbrains/rdclient/fileStructure/ProtocolStructureViewTreeElement;", "lastDocumentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "getSymbolFromEditor", "Lcom/intellij/platform/navbar/backend/impl/DefaultNavBarItem;", "", "project", "Lcom/intellij/openapi/project/Project;", "shouldUsePreviousStructure", "", "documentId", "timestamp", "Lcom/jetbrains/rd/ide/model/StructureTimestamp;", "structure", "documentSynchronizer", "Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;", "intellij.rider.navbar.backend"})
public final class RiderNavBarMemberItemDataRule
implements UiDataRule {
    @Nullable
    private ProtocolStructureViewTreeElement lastNodeAtCaret;
    @Nullable
    private RdDocumentId lastDocumentId;

    public void uiDataSnapshot(@NotNull DataSink sink, @NotNull DataSnapshot snapshot) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        sink.lazyValue(NavBarItem.NAVBAR_ITEM_KEY, arg_0 -> RiderNavBarMemberItemDataRule.uiDataSnapshot$lambda$0(this, arg_0));
    }

    private final Pointer<? extends NavBarItem> navBarItem(DataMap dataProvider) {
        if (!UISettings.Companion.getInstance().getShowMembersInNavigationBar()) {
            return null;
        }
        DataKey dataKey = CommonDataKeys.PROJECT;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"PROJECT");
        Project project = (Project)dataProvider.get(dataKey);
        if (project == null) {
            return null;
        }
        Project project2 = project;
        DefaultNavBarItem<Object> defaultNavBarItem = this.getSymbolFromEditor(project2, dataProvider);
        return defaultNavBarItem != null ? defaultNavBarItem.createPointer() : null;
    }

    private final DefaultNavBarItem<Object> getSymbolFromEditor(Project project, DataMap dataProvider) {
        ProtocolStructureViewTreeElement nextChild;
        DataKey dataKey = CommonDataKeys.EDITOR;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"EDITOR");
        Editor editor = (Editor)dataProvider.get(dataKey);
        if (editor == null) {
            return null;
        }
        Editor editor2 = editor;
        PsiFile psiFile = PlatformTextControlUtilsKt.getPsiFile((Editor)editor2);
        PsiFile psiFile2 = psiFile;
        if (psiFile2 == null || (psiFile2 = psiFile2.getLanguage()) == null) {
            return null;
        }
        PsiFile language = psiFile2;
        if (RiderNavbarMembersSupport.INSTANCE.forLanguage((Language)language) == null) {
            return null;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        DocumentSynchronizer documentSynchronizer = DocumentExKt.getDocumentSynchronizer((Document)document, (Project)project);
        if (documentSynchronizer == null) {
            return null;
        }
        Triple triple = (Triple)FrontendFileStructureHost.Companion.getInstance(project).getStructureTree().getValueOrNull();
        if (triple == null) {
            return null;
        }
        Triple triple2 = triple;
        ProtocolStructureViewTreeElement structure = (ProtocolStructureViewTreeElement)triple2.component2();
        StructureTimestamp timestamp = (StructureTimestamp)triple2.component3();
        RdDocumentId currentDocumentId = documentSynchronizer.getDocumentId();
        if (this.shouldUsePreviousStructure(currentDocumentId, timestamp, structure, documentSynchronizer)) {
            ProtocolStructureViewTreeElement nodeAtCaret = this.lastNodeAtCaret;
            if (nodeAtCaret == null) {
                return null;
            }
            return new MemberNavBarItem(project, nodeAtCaret, psiFile);
        }
        int lastOffset = editor2.getCaretModel().getCurrentCaret().getOffset();
        ProtocolStructureViewTreeElement current = structure;
        block0: do {
            nextChild = null;
            for (ProtocolStructureViewTreeElement child : current.getChildren()) {
                boolean isNodeWithEmptyRange;
                TextRange range = child.getMyFakePsiNode().getRange();
                boolean bl = isNodeWithEmptyRange = range != null && range.contains(lastOffset);
                if (!isNodeWithEmptyRange && (range != null || !(!(child.getChildren().length == 0)))) continue;
                nextChild = child;
                continue block0;
            }
        } while (nextChild != null);
        if (current.getProtocolTreeNode().getId() == 0) {
            VirtualFile parentVirtualFile = psiFile.getVirtualFile();
            WorkspaceModel workspaceModel = WorkspaceModel.Companion.getInstance(project);
            Intrinsics.checkNotNull((Object)parentVirtualFile);
            ProjectModelEntity entity = (ProjectModelEntity)CollectionsKt.firstOrNull((List)WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)workspaceModel, (VirtualFile)parentVirtualFile, (Project)project));
            this.lastNodeAtCaret = null;
            if (entity != null) {
                return new EntityNavBarItem(project, entity);
            }
            return null;
        }
        this.lastNodeAtCaret = current;
        this.lastDocumentId = current.getDocumentId();
        return new MemberNavBarItem(project, current, psiFile);
    }

    private final boolean shouldUsePreviousStructure(RdDocumentId documentId, StructureTimestamp timestamp, ProtocolStructureViewTreeElement structure, DocumentSynchronizer documentSynchronizer) {
        boolean newStructureIsEmpty = structure.getChildren().length == 0;
        boolean previousStructureDocumentIdEqualsCurrentDocumentIdStructure = Intrinsics.areEqual((Object)this.lastDocumentId, (Object)documentId);
        StructureTimestamp structureTimestamp = timestamp;
        boolean newStructureDocumentIdEqualsCurrentDocumentIdStructure = Intrinsics.areEqual((Object)(structureTimestamp != null ? structureTimestamp.getDocumentId() : null), (Object)documentId);
        StructureTimestamp structureTimestamp2 = timestamp;
        boolean differentDocumentVersions = !Intrinsics.areEqual((Object)documentSynchronizer.getVersion(), (Object)(structureTimestamp2 != null ? structureTimestamp2.getVersion() : null));
        return previousStructureDocumentIdEqualsCurrentDocumentIdStructure && newStructureDocumentIdEqualsCurrentDocumentIdStructure && (newStructureIsEmpty || differentDocumentVersions);
    }

    private static final Pointer uiDataSnapshot$lambda$0(RiderNavBarMemberItemDataRule this$0, DataMap it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.navBarItem(it);
    }
}

