/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rider.features.navbar.backend;

import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.navigation.NavigationRequest;
import com.intellij.platform.backend.navigation.NavigationRequests;
import com.intellij.platform.navbar.backend.impl.DefaultNavBarItem;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rdclient.fileStructure.ProtocolFileStructureFakePsiElement;
import com.jetbrains.rdclient.fileStructure.ProtocolStructureViewTreeElement;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lcom/intellij/rider/features/navbar/backend/MemberNavBarItem;", "Lcom/intellij/platform/navbar/backend/impl/DefaultNavBarItem;", "Lcom/jetbrains/rdclient/fileStructure/ProtocolFileStructureFakePsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "node", "Lcom/jetbrains/rdclient/fileStructure/ProtocolStructureViewTreeElement;", "file", "Lcom/intellij/psi/PsiFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rdclient/fileStructure/ProtocolStructureViewTreeElement;Lcom/intellij/psi/PsiFile;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getNode", "()Lcom/jetbrains/rdclient/fileStructure/ProtocolStructureViewTreeElement;", "getFile", "()Lcom/intellij/psi/PsiFile;", "getIcon", "Ljavax/swing/Icon;", "getText", "", "forPopup", "", "getTextAttributes", "Lcom/intellij/ui/SimpleTextAttributes;", "navigateOnClick", "navigationRequest", "Lcom/intellij/platform/backend/navigation/NavigationRequest;", "weight", "", "intellij.rider.navbar.backend"})
public final class MemberNavBarItem
extends DefaultNavBarItem<ProtocolFileStructureFakePsiElement> {
    @NotNull
    private final Project project;
    @NotNull
    private final ProtocolStructureViewTreeElement node;
    @NotNull
    private final PsiFile file;

    public MemberNavBarItem(@NotNull Project project, @NotNull ProtocolStructureViewTreeElement node, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super((Object)node.getMyFakePsiNode());
        this.project = project;
        this.node = node;
        this.file = file;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ProtocolStructureViewTreeElement getNode() {
        return this.node;
    }

    @NotNull
    public final PsiFile getFile() {
        return this.file;
    }

    @Nullable
    public Icon getIcon() {
        IconModel iconModel = this.node.getProtocolTreeNode().getIcon();
        return iconModel != null ? UtilKt.fromModel((IconModel)iconModel) : null;
    }

    @NotNull
    public String getText(boolean forPopup) {
        return this.node.getProtocolTreeNode().getShortName();
    }

    @NotNull
    public SimpleTextAttributes getTextAttributes() {
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
        return simpleTextAttributes;
    }

    public boolean navigateOnClick() {
        return true;
    }

    @Nullable
    public NavigationRequest navigationRequest() {
        return NavigationRequests.Companion.getInstance().rawNavigationRequest(new Navigatable(this){
            final /* synthetic */ MemberNavBarItem this$0;
            {
                this.this$0 = $receiver;
            }

            public void navigate(boolean requestFocus) {
                this.this$0.getNode().navigate(requestFocus);
            }

            public boolean canNavigate() {
                return this.this$0.getNode().canNavigate();
            }

            public boolean canNavigateToSource() {
                return this.this$0.getNode().canNavigateToSource();
            }
        });
    }

    public int weight() {
        return 1;
    }
}

