/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unreal.toolWindow.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.plugins.unreal.model.LogMessageInfo;
import com.jetbrains.rider.plugins.unreal.model.VerbosityType;
import com.jetbrains.rider.plugins.unreal.toolWindow.log.UnrealLogPanelSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u0014\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\b\u0010\u0016\u001a\u00020\u0010H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\nJ\u001a\u0010\u001d\u001a\u00020\u00102\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\u0013J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\nH\u0002J\u000e\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\nJ\u0016\u0010 \u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010!\u001a\u00020\u0018J\u000e\u0010\"\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000ej\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u0012\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\u00130\u000ej\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100\u0013`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/rider/plugins/unreal/toolWindow/log/UnrealLogFilter;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "settings", "Lcom/jetbrains/rider/plugins/unreal/toolWindow/log/UnrealLogPanelSettings;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/plugins/unreal/toolWindow/log/UnrealLogPanelSettings;)V", "categories", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "selectedCategories", "filterChangedListeners", "Ljava/util/ArrayList;", "Lkotlin/Function0;", "", "Lkotlin/collections/ArrayList;", "onCategoryAddedListeners", "Lkotlin/Function1;", "addFilterChangedListener", "listener", "onFilterChanged", "isMessageAllowed", "", "message", "Lcom/jetbrains/rider/plugins/unreal/model/LogMessageInfo;", "addCategory", "category", "addOnCategoryAddedListener", "fireOnCategoryAdded", "isCategorySelected", "toggleCategory", "state", "toggleAllCategories", "intellij.rider.plugins.unreal.link"})
@SourceDebugExtension(value={"SMAP\nUnrealLogFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnrealLogFilter.kt\ncom/jetbrains/rider/plugins/unreal/toolWindow/log/UnrealLogFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1869#2,2:97\n1869#2,2:99\n*S KotlinDebug\n*F\n+ 1 UnrealLogFilter.kt\ncom/jetbrains/rider/plugins/unreal/toolWindow/log/UnrealLogFilter\n*L\n25#1:97,2\n73#1:99,2\n*E\n"})
public final class UnrealLogFilter {
    @NotNull
    private final UnrealLogPanelSettings settings;
    @NotNull
    private final HashSet<String> categories;
    @NotNull
    private final HashSet<String> selectedCategories;
    @NotNull
    private final ArrayList<Function0<Unit>> filterChangedListeners;
    @NotNull
    private final ArrayList<Function1<String, Unit>> onCategoryAddedListeners;

    public UnrealLogFilter(@NotNull Lifetime lifetime, @NotNull UnrealLogPanelSettings settings) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)settings), (String)"settings");
        this.settings = settings;
        this.categories = new HashSet();
        this.selectedCategories = new HashSet();
        this.filterChangedListeners = new ArrayList();
        this.onCategoryAddedListeners = new ArrayList();
        Disposable disposable = LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null);
        this.settings.addSettingsChangedListener(() -> UnrealLogFilter._init_$lambda$0(this), disposable);
    }

    public final void addFilterChangedListener(@NotNull Function0<Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.filterChangedListeners.add(listener);
    }

    private final void onFilterChanged() {
        Iterable $this$forEach$iv = this.filterChangedListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    public final boolean isMessageAllowed(@NotNull LogMessageInfo message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        VerbosityType verbosity = message.getType();
        if (verbosity == VerbosityType.Error && !this.settings.getShowErrors()) {
            return false;
        }
        if (verbosity == VerbosityType.Warning && !this.settings.getShowWarnings()) {
            return false;
        }
        if (verbosity != VerbosityType.Error && verbosity != VerbosityType.Warning && !this.settings.getShowMessages()) {
            return false;
        }
        String category = message.getCategory().getData();
        return this.selectedCategories.contains(category);
    }

    public final void addCategory(@NotNull String category) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        if (!this.categories.add(category)) {
            return;
        }
        boolean isSelected = this.settings.getShowAllCategories();
        if (isSelected) {
            this.selectedCategories.add(category);
        }
        this.fireOnCategoryAdded(category);
    }

    public final void addOnCategoryAddedListener(@NotNull Function1<? super String, Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.onCategoryAddedListeners.add(listener);
    }

    private final void fireOnCategoryAdded(String category) {
        Iterable $this$forEach$iv = this.onCategoryAddedListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 it = (Function1)element$iv;
            boolean bl = false;
            it.invoke((Object)category);
        }
    }

    public final boolean isCategorySelected(@NotNull String category) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        return this.selectedCategories.contains(category);
    }

    public final void toggleCategory(@NotNull String category, boolean state) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        boolean bl = state ? this.selectedCategories.add(category) : this.selectedCategories.remove(category);
        this.onFilterChanged();
    }

    public final void toggleAllCategories(boolean state) {
        this.selectedCategories.clear();
        if (state) {
            this.selectedCategories.addAll((Collection<String>)this.categories);
        }
    }

    private static final void _init_$lambda$0(UnrealLogFilter this$0) {
        this$0.onFilterChanged();
    }
}

