/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unreal.debugger.frames;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.rider.plugins.unreal.debugger.frames.BlueprintFrameMessagesKt;
import com.jetbrains.rider.plugins.unreal.debugger.frames.UnrealFrameBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u0003H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/plugins/unreal/debugger/frames/BlueprintFrame;", "Lcom/jetbrains/rider/plugins/unreal/debugger/frames/UnrealFrameBase;", "baseFrameEqualityObject", "", "objectName", "", "functionDisplayName", "functionFullName", "<init>", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getEqualityObject", "customizePresentation", "", "component", "Lcom/intellij/ui/ColoredTextContainer;", "intellij.rider.plugins.unreal.link"})
public final class BlueprintFrame
extends UnrealFrameBase {
    @NotNull
    private final Object baseFrameEqualityObject;
    @NotNull
    private final String objectName;
    @NotNull
    private final String functionDisplayName;
    @NotNull
    private final String functionFullName;

    public BlueprintFrame(@NotNull Object baseFrameEqualityObject, @NlsSafe @NotNull String objectName, @NlsSafe @NotNull String functionDisplayName, @NlsSafe @NotNull String functionFullName) {
        Intrinsics.checkNotNullParameter((Object)baseFrameEqualityObject, (String)"baseFrameEqualityObject");
        Intrinsics.checkNotNullParameter((Object)objectName, (String)"objectName");
        Intrinsics.checkNotNullParameter((Object)functionDisplayName, (String)"functionDisplayName");
        Intrinsics.checkNotNullParameter((Object)functionFullName, (String)"functionFullName");
        this.baseFrameEqualityObject = baseFrameEqualityObject;
        this.objectName = objectName;
        this.functionDisplayName = functionDisplayName;
        this.functionFullName = functionFullName;
    }

    @NotNull
    public Object getEqualityObject() {
        Pair pair = Pair.create((Object)this.baseFrameEqualityObject, (Object)(this.objectName + this.functionDisplayName + this.functionFullName));
        Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"create(...)");
        return pair;
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        component.append(BlueprintFrameMessagesKt.getBlueprintTitlePrefix(), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        component.append(this.objectName + ": ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        component.append(this.functionDisplayName + " ", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        component.append(" " + this.functionFullName, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
    }
}

