/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unreal.debugger.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.jetbrains.rider.UnrealLinkBundle;
import com.jetbrains.rider.plugins.unreal.actions.ActionsUtilsKt;
import com.jetbrains.rider.plugins.unreal.toolWindow.log.UnrealLogPanelSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H'J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H&J\u0018\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0005H\u0016J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0005H&R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/plugins/unreal/debugger/actions/UnrealToggleBaseAction;", "Lcom/intellij/openapi/project/DumbAwareToggleAction;", "<init>", "()V", "value", "", "isVisible", "()Z", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isHostAvailable", "getToggleActionText", "", "settings", "Lcom/jetbrains/rider/plugins/unreal/toolWindow/log/UnrealLogPanelSettings;", "isSelected", "getIsSelected", "setSelected", "selected", "setSelectedAction", "intellij.rider.plugins.unreal.link"})
public abstract class UnrealToggleBaseAction
extends DumbAwareToggleAction {
    private boolean isVisible = true;

    public final boolean isVisible() {
        return this.isVisible;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        if (!Registry.Companion.is("rider.cpp.enable.debugger.unreal.blueprint-callstack") || !SystemInfo.isWindows) {
            e.getPresentation().setEnabledAndVisible(false);
            this.isVisible = e.getPresentation().isVisible();
            return;
        }
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        if (!this.isHostAvailable(e)) {
            return;
        }
        e.getPresentation().setEnabledAndVisible(true);
        UnrealLogPanelSettings settings = UnrealLogPanelSettings.Companion.getInstance(project2);
        e.getPresentation().setText(UnrealLinkBundle.message(this.getToggleActionText(settings), new Object[0]));
        this.isVisible = e.getPresentation().isVisible();
    }

    private final boolean isHostAvailable(AnActionEvent e) {
        return ActionsUtilsKt.getUnrealHost(e) != null;
    }

    @NlsActions.ActionText
    @NotNull
    public abstract String getToggleActionText(@NotNull UnrealLogPanelSettings var1);

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return false;
        }
        Project project2 = project;
        UnrealLogPanelSettings settings = UnrealLogPanelSettings.Companion.getInstance(project2);
        return this.getIsSelected(settings);
    }

    public abstract boolean getIsSelected(@NotNull UnrealLogPanelSettings var1);

    public void setSelected(@NotNull AnActionEvent e, boolean selected) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        UnrealLogPanelSettings settings = UnrealLogPanelSettings.Companion.getInstance(project2);
        this.setSelectedAction(settings, selected);
        XDebuggerUtilImpl.rebuildAllSessionsViews((Project)e.getProject());
    }

    public abstract void setSelectedAction(@NotNull UnrealLogPanelSettings var1, boolean var2);
}

