/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.unreal.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.NlsActions;
import com.jetbrains.rider.UnrealLinkBundle;
import com.jetbrains.rider.plugins.unreal.UnrealHost;
import com.jetbrains.rider.plugins.unreal.actions.ActionsUtilsKt;
import com.jetbrains.rider.plugins.unreal.model.ConnectionInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/plugins/unreal/actions/ProtocolStatus;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionText", "", "host", "Lcom/jetbrains/rider/plugins/unreal/UnrealHost;", "intellij.rider.plugins.unreal.link"})
public final class ProtocolStatus
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        e.getPresentation().setEnabled(false);
        UnrealHost unrealHost = ActionsUtilsKt.getUnrealHost(e);
        if (unrealHost == null) {
            return;
        }
        UnrealHost host = unrealHost;
        e.getPresentation().setVisible(true);
        e.getPresentation().setText(this.getActionText(host));
    }

    @NlsActions.ActionText
    @NotNull
    public final String getActionText(@NotNull UnrealHost host) {
        String string;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        if (host.isConnectedToUnrealEditor()) {
            ConnectionInfo info = host.getConnectionInfo();
            if (info != null) {
                Object[] objectArray = new Object[]{info.getProjectName(), info.getExecutableName(), String.valueOf(info.getProcessId())};
                string = UnrealLinkBundle.message("action.RiderLink.ProtocolStatus.connected.ex.text", objectArray);
            } else {
                string = UnrealLinkBundle.message("action.RiderLink.ProtocolStatus.connected.text", new Object[0]);
            }
        } else {
            string = UnrealLinkBundle.message("action.RiderLink.ProtocolStatus.disconnected.text", new Object[0]);
        }
        return string;
    }
}

