/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util.labels;

import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1LabelSelectorRequirement;
import io.kubernetes.client.util.labels.EqualityMatcher;
import io.kubernetes.client.util.labels.LabelMatcher;
import io.kubernetes.client.util.labels.SetMatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class LabelSelector
implements Predicate<Map<String, String>> {
    public static final String LABEL_SELECTOR_OP_IN = "In";
    public static final String LABEL_SELECTOR_OP_NOT_IN = "NotIn";
    public static final String LABEL_SELECTOR_OP_EXISTS = "Exists";
    public static final String LABEL_SELECTOR_OP_DOES_NOT_EXIST = "DoesNotExist";
    private LabelMatcher[] labelMatchers;

    LabelSelector(LabelMatcher ... matchers) {
        this.labelMatchers = matchers;
    }

    public static LabelSelector and(LabelMatcher ... matchers) {
        return new LabelSelector(matchers);
    }

    public static LabelSelector empty() {
        return LabelSelector.and(new LabelMatcher[0]);
    }

    public static LabelSelector parse(V1LabelSelector ps) throws IllegalArgumentException {
        int matcherNum = 0;
        if (ps.getMatchLabels() != null) {
            matcherNum = ps.getMatchLabels().size();
        }
        if (ps.getMatchExpressions() != null) {
            matcherNum = ps.getMatchExpressions().size();
        }
        ArrayList<LabelMatcher> matchers = new ArrayList<LabelMatcher>(matcherNum);
        if (ps.getMatchLabels() != null) {
            for (Map.Entry entry : ps.getMatchLabels().entrySet()) {
                EqualityMatcher m = EqualityMatcher.equal((String)entry.getKey(), (String)entry.getValue());
                matchers.add(m);
            }
        }
        if (ps.getMatchExpressions() != null) {
            block13: for (V1LabelSelectorRequirement v1LabelSelectorRequirement : ps.getMatchExpressions()) {
                switch (v1LabelSelectorRequirement.getOperator()) {
                    case "In": {
                        matchers.add(SetMatcher.in(v1LabelSelectorRequirement.getKey(), v1LabelSelectorRequirement.getValues().toArray(new String[0])));
                        continue block13;
                    }
                    case "NotIn": {
                        matchers.add(SetMatcher.notIn(v1LabelSelectorRequirement.getKey(), v1LabelSelectorRequirement.getValues().toArray(new String[0])));
                        continue block13;
                    }
                    case "Exists": {
                        matchers.add(SetMatcher.exists(v1LabelSelectorRequirement.getKey()));
                        continue block13;
                    }
                    case "DoesNotExist": {
                        matchers.add(SetMatcher.notExists(v1LabelSelectorRequirement.getKey()));
                        continue block13;
                    }
                }
                throw new IllegalArgumentException(v1LabelSelectorRequirement.getOperator() + " is not a valid pod selector operator");
            }
        }
        return LabelSelector.and(matchers.toArray(matchers.toArray(new LabelMatcher[0])));
    }

    @Override
    public boolean test(Map<String, String> labels) {
        return Arrays.stream(this.labelMatchers).allMatch(matcher -> matcher.test((String)labels.get(matcher.getKey())));
    }

    public String toString() {
        return Arrays.stream(this.labelMatchers).map(m -> m.toString()).collect(Collectors.joining(","));
    }
}

