/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.statistics;

import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.CidrRunConfigurationWithFrameworkInfo;
import com.jetbrains.cidr.statistics.CidrCollectorUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrTestingFrameworkProjectUsagesCollector
extends ProjectUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("cidr.testingFrameworks", 3);
    private static final EventId2<String, Integer> TEST_RUN_CONFIGURATION = GROUP.registerEvent("test.run.configuration", (EventField)CidrCollectorUtil.FRAMEWORK_ID_FIELD, (EventField)EventFields.Count);

    protected boolean requiresReadAccess() {
        return true;
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        if (project == null) {
            CidrTestingFrameworkProjectUsagesCollector.$$$reportNull$$$0(0);
        }
        Object2IntOpenHashMap data = new Object2IntOpenHashMap();
        List configurationsList = RunManager.getInstance((Project)project).getAllConfigurationsList();
        for (RunConfiguration runConfiguration : configurationsList) {
            ProgressManager.checkCanceled();
            String name = CidrTestingFrameworkProjectUsagesCollector.getFrameworkId(runConfiguration);
            if (name == null) continue;
            data.mergeInt((Object)name, 1, Integer::sum);
        }
        Set set = ContainerUtil.map2Set((Collection)data.keySet(), arg_0 -> CidrTestingFrameworkProjectUsagesCollector.lambda$getMetrics$0((Object2IntMap)data, arg_0));
        if (set == null) {
            CidrTestingFrameworkProjectUsagesCollector.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Nullable
    public static String getFrameworkId(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            CidrTestingFrameworkProjectUsagesCollector.$$$reportNull$$$0(2);
        }
        if (runConfiguration instanceof CidrRunConfigurationWithFrameworkInfo) {
            return ((CidrRunConfigurationWithFrameworkInfo)runConfiguration).getFrameworkId();
        }
        return null;
    }

    public EventLogGroup getGroup() {
        return GROUP;
    }

    private static /* synthetic */ MetricEvent lambda$getMetrics$0(Object2IntMap data, String o) {
        return TEST_RUN_CONFIGURATION.metric((Object)o, (Object)data.getInt((Object)o));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/statistics/CidrTestingFrameworkProjectUsagesCollector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/statistics/CidrTestingFrameworkProjectUsagesCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFrameworkId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

