/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.stepFilters;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcessConfigurator;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrVisualStudioLocator;
import com.jetbrains.cidr.execution.debugger.stepFilters.FunctionStepFilterAction;
import com.jetbrains.cidr.execution.debugger.stepFilters.FunctionStepFilterRule;
import com.jetbrains.cidr.execution.debugger.stepFilters.NonUserFileStepFilterRule;
import com.jetbrains.cidr.execution.debugger.stepFilters.NonUserModuleStepFilterRule;
import com.jetbrains.cidr.execution.debugger.stepFilters.StepFilterRule;
import com.jetbrains.cidr.execution.debugger.stepFilters.StepFiltersLogger;
import com.jetbrains.cidr.execution.debugger.stepFilters.StepFiltersProvider;
import com.jetbrains.cidr.execution.debugger.stepFilters.StepFiltersProviderContext;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001eB+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\r\u001a\u00020\u000eJ\"\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0012J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u0016*\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001e\u0010\u001a\u001a\u00020\u0010*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00162\b\u0010\u001d\u001a\u0004\u0018\u00010\u0016H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/cidr/execution/debugger/stepFilters/StepFiltersManager;", "", "stepFilters", "", "Lcom/jetbrains/cidr/execution/debugger/stepFilters/StepFilterRule;", "userLogger", "Lcom/jetbrains/cidr/execution/debugger/stepFilters/StepFiltersLogger;", "loadingTimeMs", "", "<init>", "(Ljava/util/List;Lcom/jetbrains/cidr/execution/debugger/stepFilters/StepFiltersLogger;J)V", "getLoadingTimeMs", "()J", "getStepFiltersNumber", "", "canStepInto", "", "modulePath", "", "filePath", "function", "normalizeFunctionName", "", "subSequenceAfterLast", "delimiter", "", "matchesFile", "Lkotlin/text/Regex;", "path", "name", "StepFiltersLoader", "intellij.cidr.debugger.core"})
@SourceDebugExtension(value={"SMAP\nStepFiltersManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StepFiltersManager.kt\ncom/jetbrains/cidr/execution/debugger/stepFilters/StepFiltersManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,118:1\n60#2,5:119\n60#2,5:124\n60#2,5:129\n*S KotlinDebug\n*F\n+ 1 StepFiltersManager.kt\ncom/jetbrains/cidr/execution/debugger/stepFilters/StepFiltersManager\n*L\n35#1:119,5\n45#1:124,5\n60#1:129,5\n*E\n"})
public final class StepFiltersManager {
    @NotNull
    private final List<StepFilterRule> stepFilters;
    @Nullable
    private final StepFiltersLogger userLogger;
    private final long loadingTimeMs;

    public StepFiltersManager(@NotNull List<? extends StepFilterRule> stepFilters, @Nullable StepFiltersLogger userLogger, long loadingTimeMs) {
        Intrinsics.checkNotNullParameter(stepFilters, (String)"stepFilters");
        this.stepFilters = stepFilters;
        this.userLogger = userLogger;
        this.loadingTimeMs = loadingTimeMs;
    }

    public /* synthetic */ StepFiltersManager(List list, StepFiltersLogger stepFiltersLogger, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            stepFiltersLogger = null;
        }
        if ((n & 4) != 0) {
            l = 0L;
        }
        this(list, stepFiltersLogger, l);
    }

    public final long getLoadingTimeMs() {
        return this.loadingTimeMs;
    }

    public final int getStepFiltersNumber() {
        return this.stepFilters.size();
    }

    public final boolean canStepInto(@Nullable String modulePath, @Nullable String filePath, @NotNull String function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        String string = modulePath;
        CharSequence moduleName = string != null ? this.subSequenceAfterLast(string, '/') : null;
        String string2 = filePath;
        CharSequence fileName = string2 != null ? this.subSequenceAfterLast(string2, '/') : null;
        CharSequence fixedFunction = this.normalizeFunctionName(function);
        for (StepFilterRule stepFilter : this.stepFilters) {
            StepFilterRule stepFilterRule = stepFilter;
            if (stepFilterRule instanceof NonUserModuleStepFilterRule) {
                if (modulePath == null || ((NonUserModuleStepFilterRule)stepFilter).getCompanyName() != null || !this.matchesFile(((NonUserModuleStepFilterRule)stepFilter).getModuleRegex(), modulePath, moduleName)) continue;
                Function0 lazyLogMessage = () -> StepFiltersManager.canStepInto$lambda$0(modulePath, stepFilter);
                Logger logger = CidrDebuggerLog.LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                Logger $this$debug_u24default$iv = logger;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    $this$debug_u24default$iv.debug((String)lazyLogMessage.invoke(), e$iv);
                }
                StepFiltersLogger stepFiltersLogger = this.userLogger;
                if (stepFiltersLogger != null) {
                    stepFiltersLogger.verbose((Function0<String>)lazyLogMessage);
                }
                return false;
            }
            if (stepFilterRule instanceof NonUserFileStepFilterRule) {
                if (filePath == null || !this.matchesFile(((NonUserFileStepFilterRule)stepFilter).getFileRegex(), filePath, fileName)) continue;
                Function0 lazyLogMessage = () -> StepFiltersManager.canStepInto$lambda$1(filePath, stepFilter);
                Logger logger = CidrDebuggerLog.LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                Logger $this$debug_u24default$iv = logger;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    $this$debug_u24default$iv.debug((String)lazyLogMessage.invoke(), e$iv);
                }
                StepFiltersLogger stepFiltersLogger = this.userLogger;
                if (stepFiltersLogger != null) {
                    stepFiltersLogger.verbose((Function0<String>)lazyLogMessage);
                }
                return false;
            }
            if (stepFilterRule instanceof FunctionStepFilterRule) {
                if (((FunctionStepFilterRule)stepFilter).getModuleRegex() != null && modulePath == null || !((FunctionStepFilterRule)stepFilter).getFunctionName().matches(fixedFunction)) continue;
                if (((FunctionStepFilterRule)stepFilter).getModuleRegex() != null) {
                    Regex regex = ((FunctionStepFilterRule)stepFilter).getModuleRegex();
                    String string3 = modulePath;
                    Intrinsics.checkNotNull((Object)string3);
                    if (!this.matchesFile(regex, string3, moduleName)) continue;
                }
                Function0 lazyLogMessage = () -> StepFiltersManager.canStepInto$lambda$2(stepFilter, modulePath, function);
                Logger logger = CidrDebuggerLog.LOG;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LOG");
                Logger $this$debug_u24default$iv = logger;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    $this$debug_u24default$iv.debug((String)lazyLogMessage.invoke(), e$iv);
                }
                StepFiltersLogger stepFiltersLogger = this.userLogger;
                if (stepFiltersLogger != null) {
                    stepFiltersLogger.verbose((Function0<String>)lazyLogMessage);
                }
                return ((FunctionStepFilterRule)stepFilter).getAction() == FunctionStepFilterAction.StepInto;
            }
            throw new NoWhenBranchMatchedException();
        }
        return true;
    }

    private final CharSequence normalizeFunctionName(String function) {
        int endIndex;
        boolean bl;
        String anonymousPrefix1 = "(anonymous namespace)::";
        String anonymousPrefix2 = "`anonymous namespace'::";
        int anonymousPrefixLength = 23;
        boolean bl2 = bl = anonymousPrefix1.length() == anonymousPrefixLength && anonymousPrefix2.length() == anonymousPrefixLength;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int startIndex = StringsKt.startsWith$default((String)function, (String)anonymousPrefix1, (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)function, (String)anonymousPrefix2, (boolean)false, (int)2, null) ? anonymousPrefixLength : 0;
        int n = endIndex = StringsKt.endsWith$default((CharSequence)function, (char)')', (boolean)false, (int)2, null) ? StringsKt.lastIndexOf$default((CharSequence)function, (char)'(', (int)0, (boolean)false, (int)6, null) : function.length();
        if (endIndex == -1) {
            endIndex = function.length();
        }
        if (startIndex == 0 && endIndex == function.length()) {
            return function;
        }
        return function.subSequence(startIndex, endIndex);
    }

    private final CharSequence subSequenceAfterLast(CharSequence $this$subSequenceAfterLast, char delimiter) {
        int lastIndex = StringsKt.lastIndexOf$default((CharSequence)$this$subSequenceAfterLast, (char)delimiter, (int)0, (boolean)false, (int)6, null);
        if (lastIndex == -1) {
            return null;
        }
        return $this$subSequenceAfterLast.subSequence(lastIndex + 1, $this$subSequenceAfterLast.length());
    }

    private final boolean matchesFile(Regex $this$matchesFile, CharSequence path, CharSequence name) {
        return name != null && $this$matchesFile.matches(name) || $this$matchesFile.matches(path);
    }

    private static final String canStepInto$lambda$0(String $modulePath, StepFilterRule $stepFilter) {
        return "Skipping stepping into '" + $modulePath + "' because module step filter matched: " + $stepFilter;
    }

    private static final String canStepInto$lambda$1(String $filePath, StepFilterRule $stepFilter) {
        return "Skipping stepping into '" + $filePath + "' because file step filter matched: " + $stepFilter;
    }

    private static final String canStepInto$lambda$2(StepFilterRule $stepFilter, String $modulePath, String $function) {
        Object modulePrefix = ((FunctionStepFilterRule)$stepFilter).getModuleRegex() == null ? "" : "[" + $modulePath + "]";
        return "Function '" + (String)modulePrefix + $function + "' matched with function step filter: " + $stepFilter;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/execution/debugger/stepFilters/StepFiltersManager$StepFiltersLoader;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcessConfigurator;", "<init>", "()V", "configure", "", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "intellij.cidr.debugger.core"})
    public static final class StepFiltersLoader
    implements CidrDebugProcessConfigurator {
        @Override
        public void configure(@NotNull CidrDebugProcess process) {
            Intrinsics.checkNotNullParameter((Object)process, (String)"process");
            if (!Registry.Companion.is("cidr.debugger.stepFilters") || process.getSession().isMixedMode()) {
                return;
            }
            CoroutineScope coroutineScope = process.getCoroutineScope();
            Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"getCoroutineScope(...)");
            BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(process, null){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                long J$0;
                int label;
                final /* synthetic */ CidrDebugProcess $process;
                {
                    this.$process = $process;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var18_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = CidrDebuggerSettings.getInstance();
                            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getInstance(...)");
                            debuggerSettings = v0;
                            v1 = debuggerSettings.getSteppingRulesDiagnosticsLevel();
                            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getSteppingRulesDiagnosticsLevel(...)");
                            userLogger = new StepFiltersLogger(this.$process, v1);
                            startTime = System.nanoTime();
                            vsRoot = CidrVisualStudioLocator.Companion.getVisualStudioRoot(this.$process);
                            v2 = this.$process.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"<get-project>(...)");
                            context = new StepFiltersProviderContext(v2, vsRoot, userLogger);
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)debuggerSettings);
                            this.L$1 = userLogger;
                            this.L$2 = SpillingKt.nullOutSpilledVariable((Object)vsRoot);
                            this.L$3 = SpillingKt.nullOutSpilledVariable((Object)context);
                            this.J$0 = startTime;
                            this.label = 1;
                            v3 = StepFiltersProvider.Companion.getAllStepFilters(context, (Continuation<? super List<? extends StepFilterRule>>)((Continuation)this));
                            if (v3 == var18_2) {
                                return var18_2;
                            }
                            ** GOTO lbl34
                        }
                        case 1: {
                            startTime = this.J$0;
                            context = (StepFiltersProviderContext)this.L$3;
                            vsRoot = (Path)this.L$2;
                            userLogger = (StepFiltersLogger)this.L$1;
                            debuggerSettings = (CidrDebuggerSettings)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl34:
                            // 2 sources

                            stepFilters = (List)v3;
                            endTime = System.nanoTime();
                            elapsedMs = (endTime - startTime) / 1000000L;
                            v4 = CidrDebuggerLog.LOG;
                            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"LOG");
                            $this$debug_u24default$iv = v4;
                            e$iv = null;
                            $i$f$debug = false;
                            if ($this$debug_u24default$iv.isDebugEnabled()) {
                                var17_17 = $this$debug_u24default$iv;
                                $i$a$-debug$default-StepFiltersManager$StepFiltersLoader$configure$1$1 = false;
                                var17_17.debug("Loading step filters took " + elapsedMs + " ms", e$iv);
                            }
                            manager = new StepFiltersManager(stepFilters, userLogger, elapsedMs);
                            this.$process.setStepFiltersManager(manager);
                            userLogger.verbose((Function0<String>)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$1(), ()Ljava/lang/String;)());
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }

                private static final String invokeSuspend$lambda$1() {
                    return "Step filters are initialized";
                }
            }), (int)3, null);
        }
    }
}

