/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory.disasm;

import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.cidr.execution.debugger.backend.LLInstruction;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolOffset;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressSpace;
import com.jetbrains.cidr.execution.debugger.memory.BaseDocRegion;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryData;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDoc;
import com.jetbrains.cidr.execution.debugger.memory.DocRegion;
import com.jetbrains.cidr.execution.debugger.memory.disasm.AbstractDisasmDataProvider;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0014\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013H\u0014J\u0014\u0010\u0014\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u0013H\u0014J\"\u0010\u0015\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012j\u0002`\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0017H\u0014J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\fH\u0014J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u0019H\u0014R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/disasm/CidrDisasmRegion;", "Lcom/jetbrains/cidr/execution/debugger/memory/BaseDocRegion;", "Lcom/jetbrains/cidr/execution/debugger/backend/LLInstruction;", "document", "Lcom/intellij/openapi/editor/ex/DocumentEx;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "dataRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion$Completed$Loaded;", "<init>", "(Lcom/intellij/openapi/editor/ex/DocumentEx;Lcom/intellij/openapi/util/TextRange;Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion$Completed$Loaded;)V", "nrHeaderLines", "", "getNrHeaderLines", "()I", "renderHeader", "", "buffer", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "renderFooter", "renderEntry", "dataEntry", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataEntry;", "getAddressForLineNumberInsideRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "lineNumber", "getLineNumberInsideRegion", "address", "Companion", "intellij.cidr.debugger.core"})
@SourceDebugExtension(value={"SMAP\nCidrDisasmRegion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrDisasmRegion.kt\ncom/jetbrains/cidr/execution/debugger/memory/disasm/CidrDisasmRegion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1788#2,4:67\n*S KotlinDebug\n*F\n+ 1 CidrDisasmRegion.kt\ncom/jetbrains/cidr/execution/debugger/memory/disasm/CidrDisasmRegion\n*L\n49#1:67,4\n*E\n"})
public final class CidrDisasmRegion
extends BaseDocRegion<LLInstruction> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public CidrDisasmRegion(@NotNull DocumentEx document, @NotNull TextRange textRange, @NotNull CidrMemoryData.DataRegion.Completed.Loaded<LLInstruction> dataRegion) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Intrinsics.checkNotNullParameter(dataRegion, (String)"dataRegion");
        super(document, textRange, dataRegion);
    }

    private final int getNrHeaderLines() {
        return CidrDisasmRegion.Companion.getFunctionOffset(this.getData()) != null ? 2 : 0;
    }

    @Override
    protected void renderHeader(@NotNull Appendable buffer) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            LLSymbolOffset lLSymbolOffset = CidrDisasmRegion.Companion.getFunctionOffset(this.getData());
            if (lLSymbolOffset == null) break block0;
            LLSymbolOffset functionOffset = lLSymbolOffset;
            boolean bl = false;
            buffer.append('\n');
            buffer.append(functionOffset + ":\n");
        }
    }

    @Override
    protected void renderFooter(@NotNull Appendable buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer.append('\n');
    }

    @Override
    protected void renderEntry(@NotNull Appendable buffer, @NotNull CidrMemoryData.DataEntry<LLInstruction> dataEntry) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter(dataEntry, (String)"dataEntry");
        int instructionCommentIndent = 34;
        String instruction = StringsKt.replace$default((String)StringsKt.replace$default((String)dataEntry.getValue().getDisassembly(), (String)"\t", (String)" ", (boolean)false, (int)4, null), (String)"\n", (String)"", (boolean)false, (int)4, null);
        buffer.append("\t" + StringsKt.padEnd$default((String)instruction, (int)(instructionCommentIndent - 2), (char)'\u0000', (int)2, null) + "\n");
    }

    @Override
    @Nullable
    protected Address getAddressForLineNumberInsideRegion(int lineNumber) {
        if (this.getNrHeaderLines() > 0 && lineNumber == 0 || !(this.getData() instanceof AbstractDisasmDataProvider.DisasmBlock)) {
            return null;
        }
        int idx = RangesKt.coerceAtLeast((int)(lineNumber - this.getNrHeaderLines()), (int)0);
        if (idx >= ((AbstractDisasmDataProvider.DisasmBlock)this.getData()).getEntries().size()) {
            return null;
        }
        return ((AbstractDisasmDataProvider.DisasmBlock)this.getData()).getEntries().get(idx).getAddress();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int getLineNumberInsideRegion(@NotNull Address address) {
        int n;
        void $this$count$iv;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Iterable iterable = this.getData().getEntries();
        int n2 = this.getNrHeaderLines();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                CidrMemoryData.DataEntry it = (CidrMemoryData.DataEntry)element$iv;
                boolean bl = false;
                if (!(it.getAddress().compareTo(address) < 0) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int n3 = n;
        return n2 + n3;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004JH\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00060\u0010H\u0016R\"\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/disasm/CidrDisasmRegion$Companion;", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryDoc$DocRegionFactory;", "Lcom/jetbrains/cidr/execution/debugger/backend/LLInstruction;", "<init>", "()V", "createDocRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/DocRegion;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/ex/DocumentEx;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "dataRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion$Completed$Loaded;", "reallocatedSpace", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace;", "functionOffset", "Lcom/jetbrains/cidr/execution/debugger/backend/LLSymbolOffset;", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$Data;", "getFunctionOffset", "(Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$Data;)Lcom/jetbrains/cidr/execution/debugger/backend/LLSymbolOffset;", "intellij.cidr.debugger.core"})
    public static final class Companion
    implements CidrMemoryDoc.DocRegionFactory<LLInstruction> {
        private Companion() {
        }

        @Override
        @NotNull
        public DocRegion<LLInstruction> createDocRegion(@NotNull Project project, @NotNull DocumentEx document, @NotNull TextRange textRange, @NotNull CidrMemoryData.DataRegion.Completed.Loaded<LLInstruction> dataRegion, @NotNull AddressSpace<DocRegion<LLInstruction>> reallocatedSpace) {
            CidrDisasmRegion cidrDisasmRegion;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
            Intrinsics.checkNotNullParameter(dataRegion, (String)"dataRegion");
            Intrinsics.checkNotNullParameter(reallocatedSpace, (String)"reallocatedSpace");
            CidrDisasmRegion $this$createDocRegion_u24lambda_u240 = cidrDisasmRegion = new CidrDisasmRegion(document, textRange, dataRegion);
            boolean bl = false;
            $this$createDocRegion_u24lambda_u240.render(reallocatedSpace);
            return cidrDisasmRegion;
        }

        private final LLSymbolOffset getFunctionOffset(CidrMemoryData.Data<LLInstruction> $this$functionOffset) {
            AbstractDisasmDataProvider.DisasmBlock disasmBlock = $this$functionOffset instanceof AbstractDisasmDataProvider.DisasmBlock ? (AbstractDisasmDataProvider.DisasmBlock)$this$functionOffset : null;
            return disasmBlock != null ? disasmBlock.getFunctionOffset() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

