/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.frame.ImmediateFullValueEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.impl.ui.visualizedtext.VisualizedTextPopupUtil;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrFrameTypeDecorator;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrElementValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrFullValueEvaluatorProvider;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrMemberValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValueDescription;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CachedDebuggerResult;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRendererExtension;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRendererUtils;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValueRenderer {
    public static final int MAX_FULL_VALUE_LENGTH = 0x100000;
    private static final Pattern SWIFT_DESCRIPTION_PATTERN = Pattern.compile("( *((\u25bf .*)|(- .*? : .*?))(\n|$))*");
    @NotNull
    protected final CidrPhysicalValue myValue;
    @NotNull
    private final CachedDebuggerResult<CidrValueDescription> myValueCache;
    @NotNull
    private final CachedDebuggerResult<Boolean> myMayHaveChildrenCache;
    @NotNull
    private final CachedDebuggerResult<Integer> myChildrenCountCache;

    public ValueRenderer(@NotNull CidrPhysicalValue value) {
        if (value == null) {
            ValueRenderer.$$$reportNull$$$0(0);
        }
        this.myValueCache = new CachedDebuggerResult();
        this.myMayHaveChildrenCache = new CachedDebuggerResult();
        this.myChildrenCountCache = new CachedDebuggerResult();
        this.myValue = value;
    }

    @NotNull
    public CidrPhysicalValue getValue() {
        CidrPhysicalValue cidrPhysicalValue = this.myValue;
        if (cidrPhysicalValue == null) {
            ValueRenderer.$$$reportNull$$$0(1);
        }
        return cidrPhysicalValue;
    }

    @NotNull
    public String getChildEvaluationExpression(@NotNull CidrPhysicalValue child, boolean lvalue) {
        CidrPhysicalValue cidrPhysicalValue;
        boolean hasArrowSyntax;
        LLValue childVar;
        Long address;
        if (child == null) {
            ValueRenderer.$$$reportNull$$$0(2);
        }
        LLValueData varData = this.myValue.getPreparedVarData();
        boolean isSynthetic = varData.isSynthetic();
        if (lvalue && isSynthetic && (address = (childVar = child.getVar()).getAddress()) != null && ValueRenderer.isValueOfPrimitiveType(childVar)) {
            String string = "(*(" + childVar.getType() + "*)(0x" + Long.toHexString(address) + "))";
            if (string == null) {
                ValueRenderer.$$$reportNull$$$0(3);
            }
            return string;
        }
        String fullExpression = child.getVar().getFullExpression();
        if (fullExpression != null) {
            String string = fullExpression;
            if (string == null) {
                ValueRenderer.$$$reportNull$$$0(4);
            }
            return string;
        }
        boolean isPointer = varData.isPointer();
        boolean bl = hasArrowSyntax = !this.myValue.isSwiftContext() && !this.myValue.isRustContext();
        if (child.getName().matches("\\[\\w+\\]")) {
            String string = this.getChildEvaluationExpression(child, "", this.myValue);
            if (string == null) {
                ValueRenderer.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (hasArrowSyntax && isPointer) {
            String string = this.getChildEvaluationExpression(child, "->", this.myValue);
            if (string == null) {
                ValueRenderer.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (hasArrowSyntax && (cidrPhysicalValue = this.myValue) instanceof CidrElementValue) {
            CidrElementValue value = (CidrElementValue)cidrPhysicalValue;
            if (value.getIndex() == 0) {
                String string = this.getChildEvaluationExpression(child, "->", value.getContainer());
                if (string == null) {
                    ValueRenderer.$$$reportNull$$$0(7);
                }
                return string;
            }
        } else if (this.myValue instanceof CidrMemberValue) {
            CidrPhysicalValue parent = ((CidrMemberValue)this.myValue).getParent();
            if (this.isSuperNode()) {
                String string = parent.getPreparedRenderer().getChildEvaluationExpression(child, lvalue);
                if (string == null) {
                    ValueRenderer.$$$reportNull$$$0(8);
                }
                return string;
            }
        }
        String string = this.getChildEvaluationExpression(child, ".", this.myValue);
        if (string == null) {
            ValueRenderer.$$$reportNull$$$0(9);
        }
        return string;
    }

    private boolean isSuperNode() {
        LLValue var = this.myValue.getVar();
        return var.getType().equals(var.getName());
    }

    protected LLValueData messageSendToSelfData(String selectorAndArgs, String returnType, EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        return context.getData(this.messageSendToSelf(selectorAndArgs, returnType, context));
    }

    protected LLValue messageSendToSelf(String selectorAndArgs, String returnType, EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        return context.messageSend(this.myValue.getVar(), selectorAndArgs, returnType);
    }

    @Nullable
    public Icon getIcon(boolean hasChildren) {
        return hasChildren ? AllIcons.Debugger.Value : AllIcons.Debugger.Db_primitive;
    }

    @NotNull
    public StringBuilder getConsoleDescription(@NotNull EvaluationContext context) throws ExecutionException {
        if (context == null) {
            ValueRenderer.$$$reportNull$$$0(10);
        }
        StringBuilder builder = new StringBuilder();
        try {
            boolean hasChildren;
            String value = this.computeValueDescription(context).getValue();
            if (this.myValue.isRichValueDescriptionEnabled(context)) {
                value = ValueRendererUtils.extractString(value);
            }
            builder.append("(").append(this.myValue.getType()).append((") " + value).trim());
            if (this.shouldPrintChildrenConsoleDescription() && (hasChildren = this.computeMayHaveChildren(context))) {
                builder.append("\n");
                this.printChildrenConsoleDescription(context, builder);
            }
        }
        catch (DebuggerCommandException e) {
            ValueRenderer.appendConsoleError(builder, this.toString());
        }
        StringBuilder stringBuilder = builder;
        if (stringBuilder == null) {
            ValueRenderer.$$$reportNull$$$0(11);
        }
        return stringBuilder;
    }

    protected boolean shouldPrintChildrenConsoleDescription() {
        return false;
    }

    private void printChildrenConsoleDescription(EvaluationContext context, StringBuilder builder) throws ExecutionException, DebuggerCommandException {
        builder.append("{\n");
        ConsoleDescriptionNode container = new ConsoleDescriptionNode(builder, context);
        try {
            this.computeChildren(context, container);
        }
        catch (ExecutionRuntimeException e) {
            throw e.cause;
        }
        finally {
            builder.append("}");
        }
    }

    private static void appendConsoleError(StringBuilder builder, @NotNull String errorMessage) {
        if (errorMessage == null) {
            ValueRenderer.$$$reportNull$$$0(12);
        }
        builder.append("error: ").append(errorMessage);
    }

    @NotNull
    public String getDisplayType() {
        return ValueRenderer.getDisplayType(this.getValue());
    }

    @NotNull
    public static String getDisplayType(@NotNull CidrPhysicalValue value) {
        if (value == null) {
            ValueRenderer.$$$reportNull$$$0(13);
        }
        if (!Registry.is((String)"cidr.debugger.frameTypeDecorator", (boolean)true)) {
            String string = ValueRendererUtils.shortenTemplateType(value.getVar().getDisplayType());
            if (string == null) {
                ValueRenderer.$$$reportNull$$$0(14);
            }
            return string;
        }
        CidrFrameTypeDecorator frameTypeDecorator = value.getFrame().getFrameTypeDecorator();
        String string = frameTypeDecorator.getValueDisplayType(value, true);
        if (string == null) {
            ValueRenderer.$$$reportNull$$$0(15);
        }
        return string;
    }

    protected String getChildEvaluationExpression(CidrPhysicalValue child, String separator, CidrPhysicalValue parent) {
        String childVarName;
        boolean cast;
        ValueRendererExtension extension = ValueRendererExtension.getExtension(parent.getFrame().getFrame().getLanguage());
        if (extension != null) {
            return extension.getChildEvaluationExpression(child, separator, parent);
        }
        Object parentRefExpression = parent.getEvaluationExpression();
        boolean bl = cast = parent.getVar().getTypeClass() == LLValue.TypeClass.OBJC_POINTER;
        if (cast) {
            parentRefExpression = "((" + parent.getType() + ")(" + (String)parentRefExpression + "))";
        }
        return (childVarName = child.getVar().getName()).isBlank() ? parentRefExpression : (String)parentRefExpression + separator + childVarName;
    }

    @NotNull
    public CidrValueDescription computeValueDescription(final @NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            ValueRenderer.$$$reportNull$$$0(16);
        }
        CidrValueDescription cidrValueDescription = this.myValueCache.getResult(new CachedDebuggerResult.NotNullCalculator<CidrValueDescription>(){

            @Override
            @NotNull
            public CidrValueDescription calculate() throws ExecutionException, DebuggerCommandException {
                LLValueData data = ValueRenderer.this.myValue.getVarData(context);
                String warning = data.getWarning();
                if (data.isNullPointer()) {
                    LLValue var = ValueRenderer.this.getValue().getVar();
                    boolean objc = var.getTypeClass() == LLValue.TypeClass.OBJC_POINTER || "id".equals(var.getType()) && ValueRenderer.this.getValue().isObjectiveCContext();
                    return new CidrValueDescription(objc ? "nil" : "NULL", null, null, warning);
                }
                if (ValueRenderer.this.myValue.isSwiftVoid()) {
                    return new CidrValueDescription("", null, null, warning);
                }
                Pair<String, XFullValueEvaluator> result = ValueRenderer.this.doComputeValueAndEvaluator(context);
                String value = (String)result.first;
                XFullValueEvaluator evaluator = (XFullValueEvaluator)result.second;
                if (value.equals("{...}")) {
                    return new CidrValueDescription("", evaluator, null, warning);
                }
                String pointerAddress = null;
                CidrDebugProcess process = ValueRenderer.this.myValue.getProcess();
                if (!((Boolean)CidrValue.DO_NOT_SHOW_ADDRESSES.get((UserDataHolder)process, (Object)false)).booleanValue() && !((Boolean)CidrValue.DO_NOT_SHOW_ADDRESSES.get((UserDataHolder)process.getProject(), (Object)false)).booleanValue() && (pointerAddress = data.getPointerOrNull()) != null) {
                    value = StringUtil.trimStart((String)value, (String)pointerAddress).stripLeading();
                    pointerAddress = LLValueData.getPresentablePointer(pointerAddress);
                }
                return new CidrValueDescription(value, evaluator, pointerAddress, warning);
            }
        });
        if (cidrValueDescription == null) {
            ValueRenderer.$$$reportNull$$$0(17);
        }
        return cidrValueDescription;
    }

    @NotNull
    protected Pair<String, XFullValueEvaluator> doComputeValueAndEvaluator(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            ValueRenderer.$$$reportNull$$$0(18);
        }
        Pair<String, XFullValueEvaluator> pair = this.doComputeValueAndEvaluator(context, this.myValue.getPresentationVar(), this.myValue.getPresentationVarData(context));
        if (pair == null) {
            ValueRenderer.$$$reportNull$$$0(19);
        }
        return pair;
    }

    @NotNull
    protected Pair<String, XFullValueEvaluator> doComputeValueAndEvaluator(@NotNull EvaluationContext context, LLValue var, LLValueData data) throws ExecutionException, DebuggerCommandException {
        XFullValueEvaluator customEvaluator;
        if (context == null) {
            ValueRenderer.$$$reportNull$$$0(20);
        }
        String value = null;
        XFullValueEvaluator evaluator = null;
        String description = StringUtil.trim((String)data.getDescription());
        boolean isRichDescriptionEnabled = this.getValue().isRichValueDescriptionEnabled(context);
        if (isRichDescriptionEnabled && this.visualizeRichStrings(description)) {
            if (data.hasLongerDescription()) {
                evaluator = this.createFullDescriptionEvaluator(var, 0x100000, fetchedDescription -> {
                    String stringContent = ValueRendererUtils.extractRichValueStringContent(fetchedDescription);
                    return stringContent != null ? stringContent : ValueRendererUtils.extractString(fetchedDescription);
                });
            } else {
                String stringContent = ValueRendererUtils.extractRichValueStringContent(description);
                boolean canVisualize = stringContent != null && VisualizedTextPopupUtil.isVisualizable((String)stringContent);
                evaluator = canVisualize ? new ImmediateFullValueEvaluator(stringContent) : null;
            }
            value = StringUtil.first((String)description, (int)1000, (boolean)false);
        }
        if (value == null && description != null) {
            if (this.myValue.getLanguage() == DebuggerDriver.StandardDebuggerLanguage.SWIFT) {
                description = StringUtil.unescapeStringCharacters((String)description);
            }
            if (!this.ignoreDescription(description = description.trim())) {
                boolean hasLongerDescription = data.hasLongerDescription();
                if (hasLongerDescription) {
                    evaluator = this.createFullDescriptionEvaluator(var, 0x100000, fetchedDescription -> {
                        if (isRichDescriptionEnabled) {
                            return ValueRendererUtils.extractString(fetchedDescription);
                        }
                        return fetchedDescription;
                    });
                }
                value = StringUtil.first((String)description, (int)1000, (boolean)false);
            }
        }
        if (value == null) {
            description = this.doComputeFallbackValue(context, var, data);
            if (description.length() > 1000) {
                String fullValue = isRichDescriptionEnabled ? ValueRendererUtils.extractString(description) : description;
                evaluator = new ImmediateFullValueEvaluator(fullValue);
            }
            value = StringUtil.first((String)description, (int)1000, (boolean)false);
        }
        if ((customEvaluator = CidrFullValueEvaluatorProvider.getEvaluatorFromExtensions(context, this.myValue)) != null) {
            evaluator = customEvaluator;
        }
        Pair pair = Pair.create(value, (Object)evaluator);
        if (pair == null) {
            ValueRenderer.$$$reportNull$$$0(21);
        }
        return pair;
    }

    private boolean visualizeRichStrings(@Nullable String description) {
        return description != null && !this.ignoreDescription(description) && Registry.is((String)"cidr.debugger.visualizeRichStrings");
    }

    protected boolean ignoreDescription(@NotNull String description) {
        DebuggerDriver.DebuggerLanguage language;
        if (description == null) {
            ValueRenderer.$$$reportNull$$$0(22);
        }
        return (language = this.myValue.getLanguage()) == DebuggerDriver.StandardDebuggerLanguage.OBJC && StringUtil.containsLineBreak((CharSequence)description) || language == DebuggerDriver.StandardDebuggerLanguage.SWIFT && SWIFT_DESCRIPTION_PATTERN.matcher(description).matches();
    }

    @NotNull
    protected String doComputeFallbackValue(@NotNull EvaluationContext context, @NotNull LLValue var, @NotNull LLValueData data) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            ValueRenderer.$$$reportNull$$$0(23);
        }
        if (var == null) {
            ValueRenderer.$$$reportNull$$$0(24);
        }
        if (data == null) {
            ValueRenderer.$$$reportNull$$$0(25);
        }
        String string = data.getValue();
        if (string == null) {
            ValueRenderer.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    private XFullValueEvaluator createFullDescriptionEvaluator(final @NotNull LLValue value, final int size, final @NotNull Function<String, String> descriptionProc) {
        if (value == null) {
            ValueRenderer.$$$reportNull$$$0(27);
        }
        if (descriptionProc == null) {
            ValueRenderer.$$$reportNull$$$0(28);
        }
        return new XFullValueEvaluator(){

            public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                if (callback == null) {
                    2.$$$reportNull$$$0(0);
                }
                ValueRenderer.this.getValue().getProcess().postCommand(driver -> {
                    if (callback.isObsolete()) {
                        return;
                    }
                    try {
                        String description = driver.getDescription(value, size);
                        description = (String)descriptionProc.apply(StringUtil.notNullize((String)description));
                        callback.evaluated(description);
                    }
                    catch (DebuggerCommandException e) {
                        callback.errorOccurred(e.getMessage());
                    }
                    catch (ExecutionException e) {
                        callback.errorOccurred(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)));
                        throw e;
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer$2", "startEvaluation"));
            }
        };
    }

    public boolean computeMayHaveChildren(final @NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        Integer result;
        if (context == null) {
            ValueRenderer.$$$reportNull$$$0(29);
        }
        if (this.mayHaveChildrenViaChildrenCount() && (result = this.computeChildrenCount(context)) != null) {
            return result > 0;
        }
        return this.myMayHaveChildrenCache.getResult(new CachedDebuggerResult.NotNullCalculator<Boolean>(){

            @Override
            @NotNull
            public Boolean calculate() throws ExecutionException, DebuggerCommandException {
                LLValueData data = ValueRenderer.this.myValue.getVarData(context);
                Boolean bl = data.isNullPointer() && !ValueRenderer.this.myValue.isGroupValue() || ValueRenderer.this.myValue.isSwiftVoid() ? false : data.mayHaveChildren();
                if (bl == null) {
                    3.$$$reportNull$$$0(0);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer$3", "calculate"));
            }
        });
    }

    protected boolean mayHaveChildrenViaChildrenCount() {
        return false;
    }

    @Nullable
    protected Integer computeChildrenCount(final @NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            ValueRenderer.$$$reportNull$$$0(30);
        }
        return this.myChildrenCountCache.getResult(new CachedDebuggerResult.Calculator<Integer>(){

            @Override
            @Nullable
            public Integer calculate() throws ExecutionException, DebuggerCommandException {
                LLValueData data = ValueRenderer.this.myValue.getVarData(context);
                return data.isNullPointer() && !ValueRenderer.this.myValue.isGroupValue() || ValueRenderer.this.myValue.isSwiftVoid() ? Integer.valueOf(0) : ValueRenderer.this.doComputeChildrenCount(context);
            }
        });
    }

    @Nullable
    protected Integer doComputeChildrenCount(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            ValueRenderer.$$$reportNull$$$0(31);
        }
        return context.getChildrenCount(this.myValue.getPresentationVar());
    }

    public final void computeChildren(@NotNull EvaluationContext context, @NotNull XCompositeNode container) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            ValueRenderer.$$$reportNull$$$0(32);
        }
        if (container == null) {
            ValueRenderer.$$$reportNull$$$0(33);
        }
        if (!this.computeMayHaveChildren(context)) {
            container.addChildren(XValueChildrenList.EMPTY, true);
            return;
        }
        this.doComputeChildren(context, container, 0, null);
    }

    protected int getBatchSize() {
        return ValueRenderer.getPositiveNumberFromRegistry("cidr.debugger.value.maxChildren", 50);
    }

    private static int getPositiveNumberFromRegistry(@NotNull String key, int defaultValue) {
        int value;
        if (key == null) {
            ValueRenderer.$$$reportNull$$$0(34);
        }
        if ((value = Registry.intValue((String)key, (int)defaultValue)) <= 0) {
            CidrDebuggerLog.LOG.warn(key + " must be a positive number, falling back to default value: " + defaultValue);
            value = defaultValue;
        }
        return value;
    }

    protected void doComputeChildren(@NotNull EvaluationContext context, @NotNull XCompositeNode container, int fromIndex, @Nullable Integer totalCount) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            ValueRenderer.$$$reportNull$$$0(35);
        }
        if (container == null) {
            ValueRenderer.$$$reportNull$$$0(36);
        }
        LLValue var = this.myValue.getPresentationVar();
        DebuggerDriver.ResultList<LLValue> result = context.getVariableChildren(var, fromIndex, this.getBatchSize());
        this.addChildrenTo(result.list, context, container, fromIndex, this.areChildrenModifiable(var, this.myValue.getPresentationVarData(context)));
        if (result.hasMore && !result.list.isEmpty()) {
            int nextIndex = fromIndex + result.list.size();
            this.tooManyChildren(context, container, nextIndex, totalCount);
        }
    }

    protected void tooManyChildren(@NotNull EvaluationContext context, @NotNull XCompositeNode container, int nextIndex, @Nullable Integer totalCount) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            ValueRenderer.$$$reportNull$$$0(37);
        }
        if (container == null) {
            ValueRenderer.$$$reportNull$$$0(38);
        }
        if (totalCount == null && (totalCount = this.computeChildrenCount(context)) == null) {
            totalCount = -1;
        }
        Integer finalTotalCount = totalCount;
        container.tooManyChildren(totalCount == -1 ? -1 : totalCount - nextIndex, () -> this.getValue().getProcess().postCommand(driver -> CidrPhysicalValue.invokeRenderChildren(container, () -> this.doComputeChildren(context, container, nextIndex, finalTotalCount))));
    }

    protected void addChildrenTo(@NotNull List<LLValue> children, @NotNull EvaluationContext context, @NotNull XCompositeNode container, int startIndex, boolean modifiable) throws ExecutionException, DebuggerCommandException {
        if (children == null) {
            ValueRenderer.$$$reportNull$$$0(39);
        }
        if (context == null) {
            ValueRenderer.$$$reportNull$$$0(40);
        }
        if (container == null) {
            ValueRenderer.$$$reportNull$$$0(41);
        }
        SmartList values = new SmartList();
        for (LLValue each : children) {
            if (container.isObsolete()) {
                return;
            }
            boolean isChildModifiable = modifiable || this.isChildModifiable(each);
            values.add(new CidrMemberValue(each, this.myValue, isChildModifiable));
        }
        CidrValue.addAllTo((Collection<CidrValue>)values, container);
    }

    protected boolean areChildrenModifiable(@NotNull LLValue var, @NotNull LLValueData data) {
        if (var == null) {
            ValueRenderer.$$$reportNull$$$0(42);
        }
        if (data == null) {
            ValueRenderer.$$$reportNull$$$0(43);
        }
        return !data.isSynthetic();
    }

    protected boolean isChildModifiable(@NotNull LLValue var) {
        if (var == null) {
            ValueRenderer.$$$reportNull$$$0(44);
        }
        return var.getAddress() != null && ValueRenderer.isValueOfPrimitiveType(var);
    }

    private static boolean isValueOfPrimitiveType(@NotNull LLValue var) {
        LLValue.TypeClass typeClass;
        if (var == null) {
            ValueRenderer.$$$reportNull$$$0(45);
        }
        return (typeClass = var.getTypeClass()) == LLValue.TypeClass.BUILTIN || typeClass == LLValue.TypeClass.POINTER;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 6, 7, 8, 9, 11, 14, 15, 17, 19, 21, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 10: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 24: 
            case 42: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 25: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionProc";
                break;
            }
            case 33: 
            case 36: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildEvaluationExpression";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleDescription";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "computeValueDescription";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "doComputeValueAndEvaluator";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "doComputeFallbackValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 26: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChildEvaluationExpression";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleDescription";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "appendConsoleError";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "computeValueDescription";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doComputeValueAndEvaluator";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "ignoreDescription";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "doComputeFallbackValue";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createFullDescriptionEvaluator";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "computeMayHaveChildren";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "computeChildrenCount";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "doComputeChildrenCount";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getPositiveNumberFromRegistry";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "doComputeChildren";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "tooManyChildren";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "addChildrenTo";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "areChildrenModifiable";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isChildModifiable";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isValueOfPrimitiveType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 6, 7, 8, 9, 11, 14, 15, 17, 19, 21, 26 -> new IllegalStateException(string);
        };
    }

    private static class ConsoleDescriptionNode
    implements XCompositeNode {
        private final StringBuilder myBuilder;
        private final EvaluationContext myContext;

        ConsoleDescriptionNode(StringBuilder builder, EvaluationContext context) {
            this.myBuilder = builder;
            this.myContext = context;
        }

        public void addChildren(@NotNull XValueChildrenList children, boolean last) {
            if (children == null) {
                ConsoleDescriptionNode.$$$reportNull$$$0(0);
            }
            for (int i = 0; i < children.size(); ++i) {
                String name = children.getName(i);
                this.myBuilder.append("\t").append(name).append(" = ");
                try {
                    String shiftedChildren = ((CidrValue)children.getValue(i)).getConsoleDescription(this.myContext).replace("\n", "\n\t");
                    this.myBuilder.append(shiftedChildren);
                }
                catch (DebuggerCommandException e) {
                    this.setErrorMessage(e.getMessage());
                }
                catch (ExecutionException e) {
                    throw new ExecutionRuntimeException(e);
                }
                this.myBuilder.append("\n");
            }
        }

        public void tooManyChildren(int remaining) {
            this.myBuilder.append("\t...");
            if (remaining > 0) {
                this.myBuilder.append(remaining).append(" more\n");
            }
        }

        public void setErrorMessage(@NotNull String errorMessage) {
            if (errorMessage == null) {
                ConsoleDescriptionNode.$$$reportNull$$$0(1);
            }
            ValueRenderer.appendConsoleError(this.myBuilder, errorMessage);
        }

        public void setErrorMessage(@NotNull String errorMessage, @Nullable XDebuggerTreeNodeHyperlink link) {
            if (errorMessage == null) {
                ConsoleDescriptionNode.$$$reportNull$$$0(2);
            }
            this.setErrorMessage(errorMessage);
        }

        public void setMessage(@NotNull String message, @Nullable Icon icon, @NotNull SimpleTextAttributes attributes, @Nullable XDebuggerTreeNodeHyperlink link) {
            if (message == null) {
                ConsoleDescriptionNode.$$$reportNull$$$0(3);
            }
            if (attributes == null) {
                ConsoleDescriptionNode.$$$reportNull$$$0(4);
            }
        }

        public void setAlreadySorted(boolean alreadySorted) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRenderer$ConsoleDescriptionNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addChildren";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setErrorMessage";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setMessage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ExecutionRuntimeException
    extends RuntimeException {
        ExecutionException cause;

        ExecutionRuntimeException(ExecutionException exception) {
            this.cause = exception;
        }
    }
}

