/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.InternalIgnoreDependencyViolation;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValueModifier;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrMemberValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValueModifier;
import com.jetbrains.cidr.execution.debugger.evaluation.ValueRendererFactory;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NSManagedObjectValueRenderer
extends ValueRenderer {
    private static final Key<Boolean> IS_NS_MANAGED_OBJECT = Key.create((String)"IS_NS_MANAGED_OBJECT");
    private volatile LLValue myEntityCache;
    protected final String myClassName;
    private static Pattern MANAGED_OBJECT_PATTERN = Pattern.compile(".+<x-coredata://.+", 32);

    protected NSManagedObjectValueRenderer(@NotNull CidrPhysicalValue value, EvaluationContext context) throws ExecutionException, DebuggerCommandException, NotApplicableException {
        if (value == null) {
            NSManagedObjectValueRenderer.$$$reportNull$$$0(0);
        }
        super(value);
        String type = this.myValue.getVar().getType();
        Boolean isNSManagedObject = context.getCachedTypeInfo(type, IS_NS_MANAGED_OBJECT);
        if (isNSManagedObject == null) {
            String className = StringUtil.trimEnd((String)type.trim(), (String)"*").trim();
            isNSManagedObject = this.isManagedObjectClass(className) || this.matchesManagedObjectPattern(StringUtil.notNullize((String)value.getVarData(context).getDescription())) && context.isKindOfClass("NSManagedObject", this.getValue().getVar());
            context.putCachedTypeInfo(type, IS_NS_MANAGED_OBJECT, isNSManagedObject);
        }
        if (!isNSManagedObject.booleanValue()) {
            throw new NotApplicableException();
        }
        this.myClassName = this.determineClassName(context);
    }

    protected boolean matchesManagedObjectPattern(@NotNull String description) {
        if (description == null) {
            NSManagedObjectValueRenderer.$$$reportNull$$$0(1);
        }
        return MANAGED_OBJECT_PATTERN.matcher(description).matches();
    }

    @NotNull
    protected String determineClassName(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            NSManagedObjectValueRenderer.$$$reportNull$$$0(2);
        }
        String string = context.stringFromNSString(context.messageSend(this.getEntity(context), "managedObjectClassName"));
        if (string == null) {
            NSManagedObjectValueRenderer.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public String getChildEvaluationExpression(@NotNull CidrPhysicalValue child, boolean lvalue) {
        if (child == null) {
            NSManagedObjectValueRenderer.$$$reportNull$$$0(4);
        }
        if (lvalue) {
            if (child instanceof KeyedValue) {
                String string = "(id)[" + this.myValue.getEvaluationExpression() + " valueForKey:@\"" + child.getName() + "\"]";
                if (string == null) {
                    NSManagedObjectValueRenderer.$$$reportNull$$$0(5);
                }
                return string;
            }
            String string = "(" + this.myValue.getEvaluationExpression(true) + ")->" + child.getName();
            if (string == null) {
                NSManagedObjectValueRenderer.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (child instanceof KeyedValue) {
            String string = "(id)[" + this.myValue.getEvaluationExpression() + " " + child.getName() + "]";
            if (string == null) {
                NSManagedObjectValueRenderer.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = "((" + this.myClassName + " *)(" + this.myValue.getEvaluationExpression() + "))->" + child.getName();
        if (string == null) {
            NSManagedObjectValueRenderer.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDisplayType() {
        String string = this.myClassName + " *";
        if (string == null) {
            NSManagedObjectValueRenderer.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public Icon getIcon(boolean hasChildren) {
        return AllIcons.Debugger.Db_db_object;
    }

    @Override
    @NotNull
    protected Pair<String, XFullValueEvaluator> doComputeValueAndEvaluator(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        if (context == null) {
            NSManagedObjectValueRenderer.$$$reportNull$$$0(10);
        }
        LLValue entity = this.getEntity(context);
        String entityName = context.stringFromNSString(context.messageSend(entity, "name"));
        String objectID = context.messageSendData(this.messageSendToSelf("objectID", "id", context), "URIRepresentation", "void*").getPresentableValue();
        String result = "entity: " + entityName + (this.messageSendToSelfData("isFault", "unsigned char", context).isTrue() ? "(Fault) " : " ") + objectID;
        Pair pair = Pair.create((Object)result, null);
        if (pair == null) {
            NSManagedObjectValueRenderer.$$$reportNull$$$0(11);
        }
        return pair;
    }

    @NotNull
    private LLValue getEntity(EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        LLValue lLValue = this.myEntityCache != null ? this.myEntityCache : (this.myEntityCache = this.messageSendToSelf("entity", "id", context));
        if (lLValue == null) {
            NSManagedObjectValueRenderer.$$$reportNull$$$0(12);
        }
        return lLValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doComputeChildren(@NotNull EvaluationContext context, @NotNull XCompositeNode container, int fromIndex, @Nullable Integer totalCount) throws ExecutionException, DebuggerCommandException {
        LLValueData keyData;
        LLValue key;
        LLValueData keyData2;
        if (context == null) {
            NSManagedObjectValueRenderer.$$$reportNull$$$0(13);
        }
        if (container == null) {
            NSManagedObjectValueRenderer.$$$reportNull$$$0(14);
        }
        LLValue entity = this.getEntity(context);
        LLValue attrDict = context.messageSend(entity, "attributesByName");
        LLValue attrKeys = context.messageSend(attrDict, "keyEnumerator");
        String managedObjectClassName = this.myClassName;
        SmartList values = new SmartList();
        while (!(keyData2 = context.getData(key = context.messageSend(attrKeys, "nextObject"))).isFalse()) {
            LLValue attrVal = this.messageSendToSelf("valueForKey:" + keyData2.getPointer(), "id", context);
            String name = context.stringFromNSString(key);
            values.add(new KeyedValue(attrVal, name, managedObjectClassName));
        }
        LLValue relDict = context.messageSend(entity, "relationshipsByName");
        LLValue relKeys = context.messageSend(relDict, "keyEnumerator");
        while (!(keyData = context.getData(key = context.messageSend(relKeys, "nextObject"))).isFalse()) {
            LLValue relVal = this.messageSendToSelf("valueForKey:" + keyData.getPointer(), "id", context);
            String name = context.stringFromNSString(key);
            values.add(new KeyedValue(relVal, name, managedObjectClassName));
        }
        try {
            if (!this.isManagedObjectClass(managedObjectClassName)) {
                LLValue intermediate;
                LLValue typed = context.evaluate(this.valueCastedToManagedObject(this.myValue.getVarData(context)));
                List children = context.getVariableChildren((LLValue)typed, (int)0, (int)context.getChildrenCount((LLValue)typed).intValue()).list;
                if (!children.isEmpty() && typed.getType().equals(managedObjectClassName + "_" + managedObjectClassName + "_ *") && (intermediate = (LLValue)((Object)ContainerUtil.find(children, child -> child.getName().equals(managedObjectClassName)))) != null) {
                    children = context.getVariableChildren((LLValue)intermediate, (int)0, (int)context.getChildrenCount((LLValue)intermediate).intValue()).list;
                }
                for (LLValue child2 : children) {
                    if (this.isManagedObjectClass(child2.getName())) continue;
                    values.add(new IVarValue(this, child2, managedObjectClassName));
                }
            }
        }
        finally {
            CidrValue.addAllTo((Collection<CidrValue>)values, container);
        }
    }

    protected String valueCastedToManagedObject(LLValueData data) throws DebuggerCommandException {
        return EvaluationContext.cast(data.getPointer(), this.myClassName + "*");
    }

    protected boolean isManagedObjectClass(@NotNull String className) {
        if (className == null) {
            NSManagedObjectValueRenderer.$$$reportNull$$$0(15);
        }
        return className.equals("NSManagedObject");
    }

    protected void invokeSetValue(@NotNull Pair<LLValue, String> valuePair, @NotNull EvaluationContext evaluationContext, @NotNull LLValueData parentVarData, @NotNull String keyName) throws ExecutionException, DebuggerCommandException {
        if (valuePair == null) {
            NSManagedObjectValueRenderer.$$$reportNull$$$0(16);
        }
        if (evaluationContext == null) {
            NSManagedObjectValueRenderer.$$$reportNull$$$0(17);
        }
        if (parentVarData == null) {
            NSManagedObjectValueRenderer.$$$reportNull$$$0(18);
        }
        if (keyName == null) {
            NSManagedObjectValueRenderer.$$$reportNull$$$0(19);
        }
        evaluationContext.messageSend(parentVarData, " setValue:((id)" + evaluationContext.convertToRValue(parentVarData, valuePair) + ") forKey:@\"" + keyName + "\"", "void");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 6, 7, 8, 9, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSManagedObjectValueRenderer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuePair";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentVarData";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSManagedObjectValueRenderer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "determineClassName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildEvaluationExpression";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "doComputeValueAndEvaluator";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "matchesManagedObjectPattern";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "determineClassName";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getChildEvaluationExpression";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doComputeValueAndEvaluator";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doComputeChildren";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isManagedObjectClass";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "invokeSetValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 6, 7, 8, 9, 11, 12 -> new IllegalStateException(string);
        };
    }

    protected static class NotApplicableException
    extends Exception {
        protected NotApplicableException() {
        }
    }

    private class KeyedValue
    extends NSManagedObjectMemberValue {
        KeyedValue(LLValue attrVal, String displayName, String className) {
            super(attrVal, displayName, className);
        }

        @Override
        public XValueModifier getModifier() {
            return new KeyedValueModifier(this);
        }
    }

    private class IVarValue
    extends NSManagedObjectMemberValue {
        IVarValue(NSManagedObjectValueRenderer nSManagedObjectValueRenderer, LLValue attrVal, String className) {
            super(attrVal, className);
        }

        @Override
        @NotNull
        protected ValueRenderer doCreateRenderer(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
            if (context == null) {
                IVarValue.$$$reportNull$$$0(0);
            }
            return new IVarValueRenderer(this, this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSManagedObjectValueRenderer$IVarValue", "doCreateRenderer"));
        }

        private final class IVarValueRenderer
        extends ValueRenderer {
            private IVarValueRenderer(@NotNull IVarValue iVarValue, NSManagedObjectMemberValue value) {
                if (value == null) {
                    IVarValueRenderer.$$$reportNull$$$0(0);
                }
                super(value);
            }

            @Override
            protected boolean areChildrenModifiable(@NotNull LLValue var, @NotNull LLValueData data) {
                if (var == null) {
                    IVarValueRenderer.$$$reportNull$$$0(1);
                }
                if (data == null) {
                    IVarValueRenderer.$$$reportNull$$$0(2);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "var";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "data";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSManagedObjectValueRenderer$IVarValue$IVarValueRenderer";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "areChildrenModifiable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private class KeyedValueModifier
    extends CidrValueModifier {
        KeyedValueModifier(KeyedValue value) {
            super(value);
        }

        @Override
        protected void setValue(@NotNull String origExpr, @NotNull Pair<LLValue, String> valuePair, @NotNull XValueModifier.XModificationCallback callback, @NotNull DebuggerDriver driver) throws DebuggerCommandException, ExecutionException {
            if (origExpr == null) {
                KeyedValueModifier.$$$reportNull$$$0(0);
            }
            if (valuePair == null) {
                KeyedValueModifier.$$$reportNull$$$0(1);
            }
            if (callback == null) {
                KeyedValueModifier.$$$reportNull$$$0(2);
            }
            if (driver == null) {
                KeyedValueModifier.$$$reportNull$$$0(3);
            }
            EvaluationContext evaluationContext = this.getValue().createEvaluationContext(driver, null);
            try {
                LLValueData parentVarData = ((KeyedValue)this.getValue()).getParent().getVarData(evaluationContext);
                NSManagedObjectValueRenderer.this.invokeSetValue(valuePair, evaluationContext, parentVarData, this.getValue().getName());
                callback.valueModified();
            }
            catch (ExecutionException e) {
                callback.errorOccurred(CidrDebuggerBundle.message("debug.assign.error.cannotAssignExpression", origExpr, this.getValue().getName()));
                CidrDebuggerLog.LOG.debug(e.getMessage());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "origExpr";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "valuePair";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "callback";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "driver";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSManagedObjectValueRenderer$KeyedValueModifier";
            objectArray[2] = "setValue";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private abstract class NSManagedObjectMemberValue
    extends CidrMemberValue {
        private final String myClassName;

        NSManagedObjectMemberValue(LLValue attrVal, String className) {
            super(attrVal, NSManagedObjectValueRenderer.this.myValue, true);
            this.myClassName = className;
        }

        NSManagedObjectMemberValue(LLValue attrVal, String displayName, String className) {
            super(attrVal, displayName, NSManagedObjectValueRenderer.this.myValue, true);
            this.myClassName = className;
        }

        @Override
        @NotNull
        protected CompletableFuture<XSourcePosition> doComputePositionAsync(@NotNull XSourcePosition position, @NotNull ProgressIndicator indicator) {
            if (position == null) {
                NSManagedObjectMemberValue.$$$reportNull$$$0(0);
            }
            if (indicator == null) {
                NSManagedObjectMemberValue.$$$reportNull$$$0(1);
            }
            if (NSManagedObjectValueRenderer.this.isManagedObjectClass(this.myClassName)) {
                CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                if (completableFuture == null) {
                    NSManagedObjectMemberValue.$$$reportNull$$$0(2);
                }
                return completableFuture;
            }
            XSourcePosition sourcePosition = (XSourcePosition)ReadAction.compute(() -> this.getTypesHelper().resolveProperty(this, this.myClassName));
            CompletableFuture<XSourcePosition> completableFuture = CompletableFuture.completedFuture(sourcePosition);
            if (completableFuture == null) {
                NSManagedObjectMemberValue.$$$reportNull$$$0(3);
            }
            return completableFuture;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSManagedObjectValueRenderer$NSManagedObjectMemberValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSManagedObjectValueRenderer$NSManagedObjectMemberValue";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doComputePositionAsync";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doComputePositionAsync";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    @InternalIgnoreDependencyViolation
    public static final class Factory
    implements ValueRendererFactory {
        @Override
        @Nullable
        public ValueRenderer createRenderer(@NotNull ValueRendererFactory.FactoryContext context) throws ExecutionException, DebuggerCommandException {
            if (context == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (!context.getSettings().isCocoaRenderersEnabled() || !context.getSettings().isCoreDataRenderersEnabled()) {
                return null;
            }
            CidrPhysicalValue value = context.getPhysicalValue();
            if (value.getVar().getTypeClass() != LLValue.TypeClass.OBJC_POINTER) {
                return null;
            }
            if (context.getLLValueData().isSynthetic()) {
                return null;
            }
            try {
                return new NSManagedObjectValueRenderer(context.getPhysicalValue(), context.getEvaluationContext());
            }
            catch (DebuggerCommandException | NotApplicableException e) {
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSManagedObjectValueRenderer$Factory", "createRenderer"));
        }
    }
}

