/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.PlatformUtils;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.jetbrains.cidr.PluginUtils;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerMessagesProvider;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrExceptionBreakpointPropertiesPanel;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrExceptionBreakpointType
extends XBreakpointType<XBreakpoint<Properties>, Properties> {
    public CidrExceptionBreakpointType() {
        this(CidrDebuggerMessagesProvider.getExceptionBreakpointDisplayText());
    }

    private CidrExceptionBreakpointType(@Nls String title) {
        super("CidrExceptionBreakpoint", title);
    }

    public String getDisplayText(XBreakpoint<Properties> breakpoint) {
        Properties properties = (Properties)breakpoint.getProperties();
        if (properties == null) {
            return CidrDebuggerBundle.message("debug.exception.breakpoint.invalid", new Object[0]);
        }
        Properties.Type thrown = properties.getWhenThrown();
        Properties.Type caught = properties.getWhenCaught();
        if (thrown != null && caught != null) {
            return CidrDebuggerBundle.message("debug.exception.breakpoint.when.summary.thrownAndCaught.label", thrown.getSummaryFragment(), caught.getSummaryFragment());
        }
        if (thrown != null) {
            return CidrDebuggerBundle.message("debug.exception.breakpoint.when.summary.thrown.label", thrown.getSummaryFragment());
        }
        if (caught != null) {
            return CidrDebuggerBundle.message("debug.exception.breakpoint.when.summary.caught.label", caught.getSummaryFragment());
        }
        return CidrDebuggerBundle.message("debug.exception.breakpoint", new Object[0]);
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon = AllIcons.Debugger.Db_exception_breakpoint;
        if (icon == null) {
            CidrExceptionBreakpointType.$$$reportNull$$$0(0);
        }
        return icon;
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon = AllIcons.Debugger.Db_disabled_exception_breakpoint;
        if (icon == null) {
            CidrExceptionBreakpointType.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public Icon getInactiveDependentIcon() {
        Icon icon = AllIcons.Debugger.Db_exception_breakpoint;
        if (icon == null) {
            CidrExceptionBreakpointType.$$$reportNull$$$0(2);
        }
        return icon;
    }

    public Properties createProperties() {
        return new Properties();
    }

    public XBreakpoint<Properties> createDefaultBreakpoint(@NotNull XBreakpointType.XBreakpointCreator<Properties> creator) {
        if (creator == null) {
            CidrExceptionBreakpointType.$$$reportNull$$$0(3);
        }
        XBreakpoint breakpoint = creator.createBreakpoint((XBreakpointProperties)this.createProperties());
        breakpoint.setEnabled(false);
        return breakpoint;
    }

    public XBreakpointCustomPropertiesPanel<XBreakpoint<Properties>> createCustomPropertiesPanel(@NotNull Project project) {
        if (project == null) {
            CidrExceptionBreakpointType.$$$reportNull$$$0(4);
        }
        return new CidrExceptionBreakpointPropertiesPanel();
    }

    public XBreakpoint<Properties> addBreakpoint(Project project, JComponent parentComponent) {
        return XDebuggerManager.getInstance((Project)project).getBreakpointManager().addBreakpoint((XBreakpointType)this, (XBreakpointProperties)new Properties());
    }

    public boolean isAddBreakpointButtonVisible() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/breakpoints/CidrExceptionBreakpointType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInactiveDependentIcon";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/breakpoints/CidrExceptionBreakpointType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultBreakpoint";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCustomPropertiesPanel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4 -> new IllegalArgumentException(string);
        };
    }

    public static class Properties
    extends XBreakpointProperties<Properties> {
        @Attribute(value="thrown")
        @Nullable
        private Type myWhenThrown;
        @Attribute(value="caught")
        @Nullable
        private Type myWhenCaught;

        public Properties() {
            this(Type.ANY_EXCEPTION, null);
        }

        public Properties(@Nullable Type whenThrown, @Nullable Type whenCaught) {
            this.myWhenThrown = whenThrown;
            this.myWhenCaught = whenCaught;
        }

        @Nullable
        public Type getWhenThrown() {
            return this.myWhenThrown;
        }

        public void setWhenThrown(@Nullable Type whenThrown) {
            this.myWhenThrown = whenThrown;
        }

        public boolean updateWhenThrown(@Nullable Type whenThrown) {
            if (this.myWhenThrown == whenThrown) {
                return false;
            }
            this.setWhenThrown(whenThrown);
            return true;
        }

        @Nullable
        public Type getWhenCaught() {
            return this.myWhenCaught;
        }

        public void setWhenCaught(@Nullable Type stopOnCaught) {
            this.myWhenCaught = stopOnCaught;
        }

        public boolean updateWhenCaught(@Nullable Type stopOnCaught) {
            if (this.myWhenCaught == stopOnCaught) {
                return false;
            }
            this.setWhenCaught(stopOnCaught);
            return true;
        }

        @NotNull
        public Properties getState() {
            Properties properties = this;
            if (properties == null) {
                Properties.$$$reportNull$$$0(0);
            }
            return properties;
        }

        public void loadState(@NotNull Properties state) {
            if (state == null) {
                Properties.$$$reportNull$$$0(1);
            }
            this.myWhenThrown = state.myWhenThrown;
            this.myWhenCaught = state.myWhenCaught;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/breakpoints/CidrExceptionBreakpointType$Properties";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/breakpoints/CidrExceptionBreakpointType$Properties";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "loadState";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }

        public static enum Type {
            ANY_EXCEPTION(CidrDebuggerBundle.messagePointer("debug.exception.breakpoint.when.any.label", new Object[0]), CidrDebuggerBundle.messagePointer("debug.exception.breakpoint.when.any.fragment", new Object[0])),
            OBJC_EXCEPTION((Supplier)CidrDebuggerBundle.messagePointer("debug.exception.breakpoint.when.objc.label", new Object[0]), (Supplier)CidrDebuggerBundle.messagePointer("debug.exception.breakpoint.when.objc.fragment", new Object[0])){

                @Override
                public boolean isAvailable() {
                    return SystemInfo.isMac;
                }
            }
            ,
            SWIFT_EXCEPTION((Supplier)CidrDebuggerBundle.messagePointer("debug.exception.breakpoint.when.swift.label", new Object[0]), (Supplier)CidrDebuggerBundle.messagePointer("debug.exception.breakpoint.when.swift.fragment", new Object[0])){

                @Override
                public boolean isAvailable() {
                    return SystemInfo.isMac && PluginUtils.hasAppCode();
                }
            }
            ,
            KN_EXCEPTION((Supplier)CidrDebuggerBundle.messagePointer("debug.exception.breakpoint.when.kn.label", new Object[0]), (Supplier)CidrDebuggerBundle.messagePointer("debug.exception.breakpoint.when.kn.fragment", new Object[0])){

                @Override
                public boolean isAvailable() {
                    boolean kotlinInstalled = PluginManagerCore.isPluginInstalled((PluginId)PluginId.getId((String)"org.jetbrains.kotlin"));
                    boolean kmmASInstalled = PluginManagerCore.isPluginInstalled((PluginId)PluginId.getId((String)"com.jetbrains.kmm"));
                    return PlatformUtils.isIdeaUltimate() && kotlinInstalled || SystemInfo.isMac && kmmASInstalled;
                }
            };

            @NotNull
            private final @NotNull Supplier<@NlsContexts.RadioButton @NotNull String> myLabelSupplier;
            @NotNull
            private final @NotNull Supplier<@Nls @NotNull String> mySummaryFragmentSupplier;

            private Type(Supplier<String> labelSupplier, Supplier<String> summaryFragmentSupplier) {
                if (labelSupplier == null) {
                    Type.$$$reportNull$$$0(0);
                }
                if (summaryFragmentSupplier == null) {
                    Type.$$$reportNull$$$0(1);
                }
                this.myLabelSupplier = labelSupplier;
                this.mySummaryFragmentSupplier = summaryFragmentSupplier;
            }

            @NlsContexts.ListItem
            @NotNull
            public String getLabel() {
                String string = this.myLabelSupplier.get();
                if (string == null) {
                    Type.$$$reportNull$$$0(2);
                }
                return string;
            }

            @Nls
            @NotNull
            public String getSummaryFragment() {
                String string = this.mySummaryFragmentSupplier.get();
                if (string == null) {
                    Type.$$$reportNull$$$0(3);
                }
                return string;
            }

            public boolean isAvailable() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "labelSupplier";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "summaryFragmentSupplier";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/execution/debugger/breakpoints/CidrExceptionBreakpointType$Properties$Type";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/execution/debugger/breakpoints/CidrExceptionBreakpointType$Properties$Type";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLabel";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSummaryFragment";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3 -> new IllegalStateException(string);
                };
            }
        }
    }
}

