/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.ui.MessageType;
import com.intellij.util.containers.FactoryMap;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.jetbrains.cidr.execution.debugger.CidrBreakpointStatisticKind;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrEvaluatorHelper;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLCodepoint;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrBreakpointPropertiesWithHitCount;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrCodePointHandlerBase<T extends XBreakpoint<?>, C extends LLCodepoint>
extends XBreakpointHandler<T> {
    protected final CidrDebugProcess myProcess;
    private final Map<Integer, C> myIdToCodepoint;
    private final Map<T, List<Integer>> myBreakpointToIds;
    private final Map<Integer, T> myIdToBreakpoint;
    private final Map<T, @Nls String> myBreakpointToError;
    @Nullable
    private T myPendingBreakpoint;
    @Nullable
    private final CidrBreakpointStatisticKind myStatisticKind;

    public CidrCodePointHandlerBase(CidrDebugProcess process, @NotNull Class<? extends XBreakpointType<T, ?>> type, @Nullable CidrBreakpointStatisticKind statisticKind) {
        if (type == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(0);
        }
        super(type);
        this.myIdToCodepoint = new HashMap<Integer, C>();
        this.myBreakpointToIds = FactoryMap.create(key -> new ArrayList());
        this.myIdToBreakpoint = new HashMap<Integer, T>();
        this.myBreakpointToError = new HashMap<T, String>();
        this.myProcess = process;
        this.myStatisticKind = statisticKind;
        this.myProcess.getSession().addSessionListener(new XDebugSessionListener(){

            public void beforeSessionResume() {
                CidrCodePointHandlerBase.this.clearBreakpointErrors();
            }
        });
    }

    public CidrCodePointHandlerBase(CidrDebugProcess process, @NotNull Class<? extends XBreakpointType<T, ?>> type) {
        if (type == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(1);
        }
        this(process, type, null);
    }

    public void registerBreakpoint(@NotNull T breakpoint) {
        if (breakpoint == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(2);
        }
        long threadId = this.myProcess.getCurrentThreadId();
        int frameIndex = this.myProcess.getCurrentFrameIndex();
        CidrDebuggerLog.LOG.debug("Register breakpoint " + String.valueOf(breakpoint) + ", thread " + threadId + ", frame " + frameIndex);
        this.reportBreakpointStatistics(breakpoint);
        this.myProcess.postCommand(driver -> this.doRegisterBreakpoint(driver, breakpoint, threadId, frameIndex));
    }

    public void unregisterBreakpoint(@NotNull T breakpoint, boolean temporary) {
        if (breakpoint == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(3);
        }
        CidrDebuggerLog.LOG.debug("Unregister breakpoint " + String.valueOf(breakpoint));
        this.myProcess.postCommand(driver -> this.doUnregisterBreakpoint(driver, breakpoint));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void doRegisterBreakpoint(@NotNull DebuggerDriver driver, @NotNull T breakpoint, long threadId, int n) throws ExecutionException {
        Collection<C> added;
        Map<T, List<Integer>> map;
        block17: {
            Map<T, List<Integer>> map2;
            if (driver == null) {
                CidrCodePointHandlerBase.$$$reportNull$$$0(4);
            }
            if (breakpoint == null) {
                CidrCodePointHandlerBase.$$$reportNull$$$0(5);
            }
            try {
                void frameIndex;
                map = this.myBreakpointToIds;
                synchronized (map) {
                    CidrDebuggerLog.LOG.assertTrue(this.myPendingBreakpoint == null, (Object)"Contract violation: there should be no two calls to 'doRegisterBreakpoint' simultaneously from different threads.");
                    this.myPendingBreakpoint = breakpoint;
                }
                added = this.addCodepointsInBackend(driver, breakpoint, threadId, (int)frameIndex);
                if (!added.isEmpty()) break block17;
                map2 = this.myBreakpointToIds;
            }
            catch (Throwable throwable) {
                Map<T, List<Integer>> map3 = this.myBreakpointToIds;
                synchronized (map3) {
                    CidrDebuggerLog.LOG.assertTrue(this.myPendingBreakpoint == breakpoint, (Object)"Contract violation: there should be no two calls to 'doRegisterBreakpoint' simultaneously from different threads.");
                    this.myPendingBreakpoint = null;
                }
                throw throwable;
            }
            synchronized (map2) {
                CidrDebuggerLog.LOG.assertTrue(this.myPendingBreakpoint == breakpoint, (Object)"Contract violation: there should be no two calls to 'doRegisterBreakpoint' simultaneously from different threads.");
                this.myPendingBreakpoint = null;
            }
            return;
        }
        this.registerCodepointsMapping(breakpoint, added);
        map = this.myBreakpointToIds;
        synchronized (map) {
            CidrDebuggerLog.LOG.assertTrue(this.myPendingBreakpoint == breakpoint, (Object)"Contract violation: there should be no two calls to 'doRegisterBreakpoint' simultaneously from different threads.");
            this.myPendingBreakpoint = null;
        }
    }

    protected void doUnregisterBreakpoint(@NotNull DebuggerDriver driver, @NotNull T breakpoint) throws ExecutionException {
        List<Integer> idsToRemove;
        if (driver == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(6);
        }
        if (breakpoint == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(7);
        }
        if ((idsToRemove = this.getCodepointIds(breakpoint)).isEmpty()) {
            return;
        }
        try {
            this.removeCodepointsInBackend(driver, idsToRemove, breakpoint);
        }
        catch (DebuggerCommandException e) {
            throw new ExecutionException((Throwable)e);
        }
        List<Integer> unregisteredIds = this.unregisterCodepointsMapping(breakpoint);
        CidrDebuggerLog.LOG.assertTrue(unregisteredIds.equals(idsToRemove), (Object)"Registered codepoints were changed while we were unregistering them.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerCodepointsMapping(@NotNull T breakpoint, @NotNull Collection<C> addedCodepoints) {
        if (breakpoint == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(8);
        }
        if (addedCodepoints == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(9);
        }
        Map<T, List<Integer>> map = this.myBreakpointToIds;
        synchronized (map) {
            List<Integer> codepointIds = this.myBreakpointToIds.get(breakpoint);
            for (LLCodepoint codepoint : addedCodepoints) {
                int id = codepoint.getId();
                if (this.myIdToBreakpoint.containsKey(id)) continue;
                this.myIdToCodepoint.put(id, codepoint);
                codepointIds.add(id);
                this.myIdToBreakpoint.put(id, breakpoint);
                if (!CidrDebuggerLog.LOG.isDebugEnabled()) continue;
                CidrDebuggerLog.LOG.debug("Registered breakpoint with id " + id + ". Breakpoint: " + String.valueOf(breakpoint) + ", codepoint: " + String.valueOf(codepoint) + ".");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    protected List<Integer> unregisterCodepointsMapping(@NotNull T breakpoint) {
        List<Integer> idsToUnregister;
        if (breakpoint == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(10);
        }
        Map<T, List<Integer>> map = this.myBreakpointToIds;
        synchronized (map) {
            this.myBreakpointToError.remove(breakpoint);
            idsToUnregister = this.myBreakpointToIds.remove(breakpoint);
            if (idsToUnregister == null) {
                List<Integer> list = Collections.emptyList();
                // MONITOREXIT @DISABLED, blocks:[2, 6] lbl10 : MonitorExitStatement: MONITOREXIT : var3_2
                if (list == null) {
                    CidrCodePointHandlerBase.$$$reportNull$$$0(11);
                }
                return list;
            }
            for (Integer id : idsToUnregister) {
                LLCodepoint codepoint = (LLCodepoint)this.myIdToCodepoint.remove(id);
                this.myIdToBreakpoint.remove(id);
                if (!CidrDebuggerLog.LOG.isDebugEnabled()) continue;
                CidrDebuggerLog.LOG.debug("Unregistered breakpoint with id " + id + ". Breakpoint: " + String.valueOf(breakpoint) + ", codepoint: " + String.valueOf(codepoint) + ".");
            }
        }
        List<Integer> list = Collections.unmodifiableList(idsToUnregister);
        if (list == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(12);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerCodepoint(@NotNull C codepoint, BiPredicate<@NotNull T, @NotNull C> areTheSame) {
        if (codepoint == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(13);
        }
        Map<T, List<Integer>> map = this.myBreakpointToIds;
        synchronized (map) {
            T breakpoint = this.getXBreakpoint(((LLCodepoint)codepoint).getId());
            if (breakpoint != null) {
                return;
            }
            if (this.myPendingBreakpoint != null && areTheSame.test(this.myPendingBreakpoint, codepoint)) {
                this.registerCodepointsMapping(this.myPendingBreakpoint, Collections.singletonList(codepoint));
            } else {
                CidrDebuggerLog.LOG.info("Debugger created new codepoint but IDE doesn't know anything about it: " + String.valueOf(codepoint));
            }
        }
    }

    protected abstract Collection<C> addCodepointsInBackend(@NotNull DebuggerDriver var1, @NotNull T var2, long var3, int var5) throws ExecutionException;

    protected void removeCodepointsInBackend(@NotNull DebuggerDriver driver, @NotNull List<Integer> ids, @NotNull T breakpoint) throws ExecutionException, DebuggerCommandException {
        if (driver == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(14);
        }
        if (ids == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(15);
        }
        if (breakpoint == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(16);
        }
        driver.removeCodepoints(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T getXBreakpoint(int id) {
        Map<T, List<Integer>> map = this.myBreakpointToIds;
        synchronized (map) {
            return (T)((XBreakpoint)this.myIdToBreakpoint.get(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public C getCodepoint(int id) {
        Map<T, List<Integer>> map = this.myBreakpointToIds;
        synchronized (map) {
            return (C)((LLCodepoint)this.myIdToCodepoint.get(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCodepoint(int id, @NotNull C codepoint) {
        if (codepoint == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(17);
        }
        Map<T, List<Integer>> map = this.myBreakpointToIds;
        synchronized (map) {
            this.myIdToCodepoint.replace(id, codepoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected List<Integer> getCodepointIds(@NotNull T breakpoint) {
        if (breakpoint == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(18);
        }
        Map<T, List<Integer>> map = this.myBreakpointToIds;
        // MONITORENTER : map
        if (!this.myBreakpointToIds.containsKey(breakpoint)) {
            List<Integer> list = Collections.emptyList();
            // MONITOREXIT : map
            if (list != null) return list;
            CidrCodePointHandlerBase.$$$reportNull$$$0(19);
            return list;
        }
        List<Integer> list = Collections.unmodifiableList(this.myBreakpointToIds.get(breakpoint));
        // MONITOREXIT : map
        if (list != null) return list;
        CidrCodePointHandlerBase.$$$reportNull$$$0(20);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setBreakpointError(int id, @NotNull @Nls String error) {
        T breakpoint;
        if (error == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(21);
        }
        Map<T, List<Integer>> map = this.myBreakpointToIds;
        synchronized (map) {
            breakpoint = this.getXBreakpoint(id);
            if (breakpoint == null) {
                return false;
            }
            this.myBreakpointToError.put(breakpoint, error);
        }
        this.setErrorPresentation((XBreakpoint<?>)breakpoint, error);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearBreakpointErrors() {
        Map<T, List<Integer>> map = this.myBreakpointToIds;
        synchronized (map) {
            this.myBreakpointToError.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @Nls
    protected String getError(@NotNull T breakpoint) {
        if (breakpoint == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(22);
        }
        Map<T, List<Integer>> map = this.myBreakpointToIds;
        synchronized (map) {
            return this.myBreakpointToError.get(breakpoint);
        }
    }

    protected void setErrorPresentation(@NotNull XBreakpoint<?> breakpoint, @Nls @NotNull String error) {
        if (breakpoint == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(23);
        }
        if (error == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(24);
        }
        if (breakpoint instanceof XLineBreakpoint) {
            XLineBreakpoint lineBreakpoint = (XLineBreakpoint)breakpoint;
            this.myProcess.getSession().updateBreakpointPresentation(lineBreakpoint, AllIcons.Debugger.Db_invalid_breakpoint, error);
        } else {
            this.myProcess.getSession().reportMessage(error, MessageType.ERROR);
        }
    }

    @Nullable
    protected String convertCondition(@NotNull T breakpoint) {
        XExpression conditionExpression;
        if (breakpoint == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(25);
        }
        if ((conditionExpression = breakpoint.getConditionExpression()) == null) {
            return null;
        }
        String condition = conditionExpression.getExpression();
        String conversion = (String)WriteAction.computeAndWait(() -> {
            try {
                return CidrEvaluatorHelper.getInstance().convertExpression(this.myProcess, condition, breakpoint.getSourcePosition());
            }
            catch (CidrEvaluatorHelper.ConversionException e) {
                if (breakpoint instanceof XLineBreakpoint) {
                    this.myProcess.getSession().setBreakpointInvalid((XLineBreakpoint)breakpoint, e.getMessage());
                }
                return null;
            }
        });
        if (conversion != null) {
            return conversion;
        }
        return condition;
    }

    private void reportBreakpointStatistics(@NotNull T breakpoint) {
        if (breakpoint == null) {
            CidrCodePointHandlerBase.$$$reportNull$$$0(26);
        }
        if (this.myStatisticKind == null) {
            return;
        }
        boolean withHitCount = false;
        XBreakpointProperties xBreakpointProperties = breakpoint.getProperties();
        if (xBreakpointProperties instanceof CidrBreakpointPropertiesWithHitCount) {
            CidrBreakpointPropertiesWithHitCount hitCountProperties = (CidrBreakpointPropertiesWithHitCount)xBreakpointProperties;
            withHitCount = hitCountProperties.getHitCountEnabled();
        }
        this.myProcess.getAggregatedSessionStatistics().handleNewBreakpoint(this.myStatisticKind, breakpoint.getSuspendPolicy() == SuspendPolicy.NONE, breakpoint.isLogMessage(), breakpoint.isLogStack(), breakpoint.getLogExpressionObject() != null, breakpoint.getConditionExpression() != null, withHitCount);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 16: 
            case 18: 
            case 22: 
            case 23: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 4: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedCodepoints";
                break;
            }
            case 11: 
            case 12: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/breakpoints/CidrCodePointHandlerBase";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codepoint";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/breakpoints/CidrCodePointHandlerBase";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "unregisterCodepointsMapping";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodepointIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerBreakpoint";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "unregisterBreakpoint";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doRegisterBreakpoint";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doUnregisterBreakpoint";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerCodepointsMapping";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "unregisterCodepointsMapping";
                break;
            }
            case 11: 
            case 12: 
            case 19: 
            case 20: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerCodepoint";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeCodepointsInBackend";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateCodepoint";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCodepointIds";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setBreakpointError";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getError";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setErrorPresentation";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "convertCondition";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "reportBreakpointStatistics";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 19, 20 -> new IllegalStateException(string);
        };
    }
}

