/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBBundle;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\t\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0000\u001a\u001c\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0000\u001a\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\n\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0007\u001a\b\u0010\u0012\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u000fH\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"LLDB_FRONTEND_TEMP_FILES", "Lcom/intellij/openapi/util/Key;", "", "Ljava/nio/file/Path;", "registerTempFile", "", "cmd", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "tempFile", "deleteTempFiles", "registerTempFilesCleanupOnExit", "processHandler", "Lcom/intellij/execution/process/BaseProcessHandler;", "initCustomLinuxLldb", "customLldbPath", "", "initCustomMacLldb", "findSystemLldb", "getXcodeSelectPath", "findLLDBFramework", "path", "getAbsoluteLldbPath", "lldbPathString", "intellij.cidr.debugger.core"})
public final class CustomLLDBSupportKt {
    @NotNull
    private static Key<List<Path>> LLDB_FRONTEND_TEMP_FILES;

    private static final void registerTempFile(GeneralCommandLine cmd, Path tempFile) {
        List tempFiles = (List)cmd.getUserData(LLDB_FRONTEND_TEMP_FILES);
        if (tempFiles == null) {
            tempFiles = new ArrayList();
            cmd.putUserData(LLDB_FRONTEND_TEMP_FILES, (Object)tempFiles);
        }
        tempFiles.add(tempFile);
    }

    public static final void deleteTempFiles(@Nullable GeneralCommandLine cmd) {
        if (cmd == null) {
            return;
        }
        List list = (List)cmd.getUserData(LLDB_FRONTEND_TEMP_FILES);
        if (list == null) {
            return;
        }
        List tempFiles = list;
        for (Path tempFile : tempFiles) {
            try {
                FileUtil.deleteRecursively((Path)tempFile);
            }
            catch (IOException e) {
                CidrDebuggerLog.LOG.warn("Cannot delete temp file " + tempFile, (Throwable)e);
            }
        }
        cmd.putUserData(LLDB_FRONTEND_TEMP_FILES, null);
    }

    public static final void registerTempFilesCleanupOnExit(@NotNull GeneralCommandLine cmd, @NotNull BaseProcessHandler<?> processHandler) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter(processHandler, (String)"processHandler");
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(cmd){
            final /* synthetic */ GeneralCommandLine $cmd;
            {
                this.$cmd = $cmd;
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                CustomLLDBSupportKt.deleteTempFiles(this.$cmd);
            }

            public void processNotStarted() {
                CustomLLDBSupportKt.deleteTempFiles(this.$cmd);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void initCustomLinuxLldb(@NotNull GeneralCommandLine cmd, @NotNull String customLldbPath) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)customLldbPath, (String)"customLldbPath");
        CidrDebuggerLog.LOG.debug("Initializing custom lldb: '" + customLldbPath + "'");
        if (StringsKt.isBlank((CharSequence)customLldbPath)) {
            throw new ExecutionException(LLDBBundle.message("error.customLldb.lldbPathIsEmpty", new Object[0]));
        }
        try {
            Path path;
            Path lldbPath = CustomLLDBSupportKt.getAbsoluteLldbPath(customLldbPath);
            CidrDebuggerLog.LOG.debug("Absolute lldb path: '" + lldbPath + "'");
            Path lldbServerPath = lldbPath.resolveSibling("lldb-server");
            Path lldbLibDir = lldbPath.getParent().resolveSibling("lib");
            CidrDebuggerLog.LOG.debug("Search for liblldb in " + lldbLibDir);
            Object[] objectArray = (Object[])Files.list(lldbLibDir);
            Throwable throwable = null;
            try {
                Stream libs = (Stream)objectArray;
                boolean bl = false;
                path = libs.filter(arg_0 -> CustomLLDBSupportKt.initCustomLinuxLldb$lambda$0$1(CustomLLDBSupportKt::initCustomLinuxLldb$lambda$0$0, arg_0)).findFirst().orElse(null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)objectArray, (Throwable)throwable);
            }
            Path libLldbPath = path;
            if (libLldbPath == null) {
                CidrDebuggerLog.LOG.debug("liblldb is not found in " + lldbLibDir);
                objectArray = new Object[]{((Object)lldbLibDir.toAbsolutePath()).toString()};
                throw new ExecutionException(LLDBBundle.message("error.customLldb.libLldbIsNotFound", objectArray));
            }
            CidrDebuggerLog.LOG.debug("Found liblldb: " + libLldbPath);
            Path resolvedLibLldb = libLldbPath.toRealPath(new LinkOption[0]);
            Path ldLibraryPath = FileUtil.createTempDirectory((String)"lldb_lib", null).toPath();
            Files.createSymbolicLink(ldLibraryPath.resolve("liblldb.so"), resolvedLibLldb, new FileAttribute[0]);
            Intrinsics.checkNotNull((Object)ldLibraryPath);
            CustomLLDBSupportKt.registerTempFile(cmd, ldLibraryPath);
            CidrDebuggerLog.LOG.debug("LLDBFrontend LD_LIBRARY_PATH=" + ldLibraryPath);
            cmd.getEnvironment().put("LD_LIBRARY_PATH", ((Object)ldLibraryPath.toAbsolutePath()).toString());
            if (Files.exists(lldbServerPath, new LinkOption[0])) {
                CidrDebuggerLog.LOG.debug("LLDBFrontend LLDB_DEBUGSERVER_PATH=" + lldbServerPath.toAbsolutePath());
                cmd.getEnvironment().put("LLDB_DEBUGSERVER_PATH", ((Object)lldbServerPath.toAbsolutePath()).toString());
            } else {
                CidrDebuggerLog.LOG.debug("lldb-server is not found in " + lldbPath.getParent());
            }
        }
        catch (Exception e) {
            throw new ExecutionException(LLDBBundle.message("error.customLldb.failedToConfigureCustomLldb", new Object[0]), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void initCustomMacLldb(@NotNull GeneralCommandLine cmd, @NotNull String customLldbPath) throws ExecutionException {
        Path dyldFrameworkPath;
        block17: {
            Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
            Intrinsics.checkNotNullParameter((Object)customLldbPath, (String)"customLldbPath");
            CidrDebuggerLog.LOG.debug("Initializing custom lldb: '" + customLldbPath + "'");
            if (StringsKt.isBlank((CharSequence)customLldbPath)) {
                throw new ExecutionException(LLDBBundle.message("error.customLldb.lldbPathIsEmpty", new Object[0]));
            }
            dyldFrameworkPath = null;
            try {
                Path libLldb;
                Path lldbPath = CustomLLDBSupportKt.getAbsoluteLldbPath(customLldbPath);
                CidrDebuggerLog.LOG.debug("Absolute lldb path: '" + lldbPath + "'");
                if (Files.isDirectory(lldbPath, new LinkOption[0])) {
                    CidrDebuggerLog.LOG.debug(lldbPath + " is a directory, search for LLDB.framework");
                    dyldFrameworkPath = CustomLLDBSupportKt.findLLDBFramework(lldbPath);
                    break block17;
                }
                if (Intrinsics.areEqual((Object)"/usr/bin/lldb", (Object)((Object)lldbPath).toString())) {
                    CidrDebuggerLog.LOG.debug("Search for LLDB.framework in the currently selected Xcode");
                    Path xcodeSelectPath = CustomLLDBSupportKt.getXcodeSelectPath();
                    CidrDebuggerLog.LOG.debug("Xcode path: " + xcodeSelectPath);
                    if (Files.isDirectory(xcodeSelectPath, new LinkOption[0])) {
                        dyldFrameworkPath = CustomLLDBSupportKt.findLLDBFramework(xcodeSelectPath);
                    } else {
                        CidrDebuggerLog.LOG.debug("Xcode path is not a directory");
                    }
                    break block17;
                }
                if (Files.isDirectory(lldbPath.resolveSibling("LLDB.framework"), new LinkOption[0])) {
                    dyldFrameworkPath = lldbPath.getParent();
                    CidrDebuggerLog.LOG.debug("Found LLDB.framework at " + dyldFrameworkPath);
                    break block17;
                }
                Path libDir = lldbPath.getParent().getParent().resolve("lib");
                CidrDebuggerLog.LOG.debug("Search for liblldb in " + libDir);
                Object object = libDir.resolve("liblldb.dylib");
                Path it = object;
                boolean bl = false;
                Path path = libLldb = Files.exists(it, new LinkOption[0]) ? object : null;
                if (libLldb == null) {
                    Path path2;
                    object = Files.list(libDir);
                    Throwable throwable = null;
                    try {
                        Stream libs = (Stream)object;
                        boolean bl2 = false;
                        path2 = libs.filter(arg_0 -> CustomLLDBSupportKt.initCustomMacLldb$lambda$1$1(CustomLLDBSupportKt::initCustomMacLldb$lambda$1$0, arg_0)).findFirst().orElse(null);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
                    }
                    libLldb = path2;
                }
                if (libLldb != null) {
                    CidrDebuggerLog.LOG.debug("Found liblldb: " + libLldb);
                    dyldFrameworkPath = FileUtil.createTempDirectory((String)"lldb_framework_dir", null).toPath();
                    object = dyldFrameworkPath;
                    Intrinsics.checkNotNull((Object)object);
                    CustomLLDBSupportKt.registerTempFile(cmd, (Path)object);
                    Path lldbFrameworkDir = Files.createDirectory(dyldFrameworkPath.resolve("LLDB.framework"), new FileAttribute[0]);
                    Files.createSymbolicLink(lldbFrameworkDir.resolve("LLDB"), libLldb, new FileAttribute[0]);
                } else {
                    CidrDebuggerLog.LOG.debug("Liblldb is not found in " + libDir);
                }
            }
            catch (Exception e) {
                throw new ExecutionException(LLDBBundle.message("error.customLldb.failedToConfigureCustomLldb", new Object[0]), (Throwable)e);
            }
        }
        if (dyldFrameworkPath == null) {
            CidrDebuggerLog.LOG.debug("Failed to compute custom DYLD_FRAMEWORK_PATH");
            throw new ExecutionException(LLDBBundle.message("error.customLldb.lldbFrameworkIsNotFound", new Object[0]));
        }
        CidrDebuggerLog.LOG.debug("LLDBFrontend DYLD_FRAMEWORK_PATH=" + dyldFrameworkPath);
        cmd.getEnvironment().put("DYLD_FRAMEWORK_PATH", ((Object)dyldFrameworkPath.toAbsolutePath()).toString());
    }

    @RequiresBackgroundThread
    @Nullable
    public static final Path findSystemLldb() throws ExecutionException, InvalidPathException {
        Path xcodeSelectPath;
        if (SystemInfo.isMac && CustomLLDBSupportKt.findLLDBFramework(xcodeSelectPath = CustomLLDBSupportKt.getXcodeSelectPath()) != null) {
            return xcodeSelectPath;
        }
        Path lldb = Path.of("/usr/bin/lldb", new String[0]);
        if (Files.isExecutable(lldb)) {
            return lldb;
        }
        try {
            Comparable<File> comparable = PathEnvironmentVariableUtil.findInPath((String)"lldb");
            return comparable != null && (comparable = ((File)comparable).toPath()) != null ? comparable.toRealPath(new LinkOption[0]) : null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static final Path getXcodeSelectPath() throws ExecutionException, InvalidPathException {
        String[] stringArray = new String[]{"/usr/bin/xcrun", "xcode-select", "--print-path"};
        ProcessOutput result = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(stringArray));
        String string = result.getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        Path path = Path.of(StringsKt.removeSuffix((String)((Object)StringsKt.trim((CharSequence)string)).toString(), (CharSequence)"/Contents/Developer"), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        return path;
    }

    private static final Path findLLDBFramework(Path path) {
        Path lldbFramework = path.resolve("Contents/SharedFrameworks/LLDB.framework");
        if (Files.exists(lldbFramework, new LinkOption[0])) {
            return lldbFramework.getParent();
        }
        lldbFramework = path.resolve("Library/PrivateFrameworks/LLDB.framework");
        if (Files.exists(lldbFramework, new LinkOption[0])) {
            return lldbFramework.getParent();
        }
        return null;
    }

    private static final Path getAbsoluteLldbPath(String lldbPathString) throws IOException {
        Path lldbPath = Path.of(lldbPathString, new String[0]);
        if (lldbPath.isAbsolute()) {
            Path path = lldbPath.toRealPath(new LinkOption[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toRealPath(...)");
            return path;
        }
        File findInPath = PathEnvironmentVariableUtil.findInPath((String)lldbPathString);
        if (findInPath == null) {
            throw new IOException("Cannot find " + lldbPathString + " in PATH");
        }
        Path path = findInPath.toPath().toRealPath(new LinkOption[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toRealPath(...)");
        return path;
    }

    private static final boolean initCustomLinuxLldb$lambda$0$0(Path it) {
        return StringsKt.startsWith$default((String)((Object)it.getFileName()).toString(), (String)"liblldb.so.", (boolean)false, (int)2, null);
    }

    private static final boolean initCustomLinuxLldb$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean initCustomMacLldb$lambda$1$0(Path it) {
        String fileName = ((Object)it.getFileName()).toString();
        return StringsKt.startsWith$default((String)fileName, (String)"liblldb.", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)fileName, (String)".dylib", (boolean)false, (int)2, null);
    }

    private static final boolean initCustomMacLldb$lambda$1$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Key key = Key.create((String)"LLDBFrontend.tempFiles");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        LLDB_FRONTEND_TEMP_FILES = key;
    }
}

