/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbCommandExecutor;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0001\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GdbCommandExecutorService;", "", "parentScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getParentScope", "()Lkotlinx/coroutines/CoroutineScope;", "createExecutor", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GdbCommandExecutor;", "debugProcessName", "", "Companion", "intellij.cidr.debugger.core"})
@ApiStatus.Internal
public final class GdbCommandExecutorService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope parentScope;
    @NotNull
    private static final AtomicLong executorCounter = new AtomicLong(0L);

    public GdbCommandExecutorService(@NotNull CoroutineScope parentScope) {
        Intrinsics.checkNotNullParameter((Object)parentScope, (String)"parentScope");
        this.parentScope = parentScope;
    }

    @NotNull
    public final CoroutineScope getParentScope() {
        return this.parentScope;
    }

    @NotNull
    public final GdbCommandExecutor createExecutor(@NotNull String debugProcessName) {
        Intrinsics.checkNotNullParameter((Object)debugProcessName, (String)"debugProcessName");
        return new GdbCommandExecutor(this.parentScope, "GdbCommandExecutor " + executorCounter.incrementAndGet() + " (" + debugProcessName + ")");
    }

    @JvmStatic
    @NotNull
    public static final GdbCommandExecutorService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GdbCommandExecutorService$Companion;", "", "<init>", "()V", "executorCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "getExecutorCounter", "()Ljava/util/concurrent/atomic/AtomicLong;", "getInstance", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GdbCommandExecutorService;", "intellij.cidr.debugger.core"})
    @SourceDebugExtension(value={"SMAP\nGdbCommandExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GdbCommandExecutor.kt\ncom/jetbrains/cidr/execution/debugger/backend/gdb/GdbCommandExecutorService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,55:1\n42#2,3:56\n*S KotlinDebug\n*F\n+ 1 GdbCommandExecutor.kt\ncom/jetbrains/cidr/execution/debugger/backend/gdb/GdbCommandExecutorService$Companion\n*L\n21#1:56,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AtomicLong getExecutorCounter() {
            return executorCounter;
        }

        @JvmStatic
        @NotNull
        public final GdbCommandExecutorService getInstance() {
            boolean $i$f$service = false;
            Class<GdbCommandExecutorService> serviceClass$iv = GdbCommandExecutorService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (GdbCommandExecutorService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

