/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.dap;

import com.jetbrains.cidr.execution.debugger.backend.dap.DapPathMapping;
import com.jetbrains.cidr.execution.debugger.backend.dap.DebuggerPath;
import com.jetbrains.cidr.execution.debugger.backend.dap.IdePath;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fJ\u0015\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0016\u0010\u0013J\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/dap/DapPathMapper;", "", "<init>", "()V", "mappings", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lcom/jetbrains/cidr/execution/debugger/backend/dap/DapPathMapping;", "addPathMapping", "", "index", "", "fromDebuggerPath", "", "toIdePath", "mapToIdePath", "Lcom/jetbrains/cidr/execution/debugger/backend/dap/IdePath;", "debuggerPath", "Lcom/jetbrains/cidr/execution/debugger/backend/dap/DebuggerPath;", "mapToIdePath-1azDEqo", "(Ljava/lang/String;)Ljava/lang/String;", "mapToDebuggerPath", "idePath", "mapToDebuggerPath-rdrMZHk", "intellij.cidr.debugger.dap"})
public final class DapPathMapper {
    @NotNull
    private final CopyOnWriteArrayList<DapPathMapping> mappings = new CopyOnWriteArrayList();

    public final void addPathMapping(int index, @NotNull String fromDebuggerPath, @NotNull String toIdePath) {
        Intrinsics.checkNotNullParameter((Object)fromDebuggerPath, (String)"fromDebuggerPath");
        Intrinsics.checkNotNullParameter((Object)toIdePath, (String)"toIdePath");
        int indexInBonds = RangesKt.coerceIn((int)index, (int)0, (int)this.mappings.size());
        this.mappings.add(indexInBonds, new DapPathMapping(fromDebuggerPath, toIdePath));
    }

    @NotNull
    public final String mapToIdePath-1azDEqo(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"$v$c$com-jetbrains-cidr-execution-debugger-backend-dap-DebuggerPath$-debuggerPath$0");
        String idePath = this.mapToIdePath(string);
        return IdePath.constructor-impl(idePath);
    }

    @NotNull
    public final String mapToIdePath(@NotNull String debuggerPath) {
        Intrinsics.checkNotNullParameter((Object)debuggerPath, (String)"debuggerPath");
        Iterator<DapPathMapping> iterator = this.mappings.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<DapPathMapping> iterator2 = iterator;
        while (iterator2.hasNext()) {
            DapPathMapping mapping = iterator2.next();
            String idePath = mapping.mapToIdePath(debuggerPath);
            if (idePath == null) continue;
            return idePath;
        }
        return debuggerPath;
    }

    @NotNull
    public final String mapToDebuggerPath-rdrMZHk(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"$v$c$com-jetbrains-cidr-execution-debugger-backend-dap-IdePath$-idePath$0");
        String debuggerPath = this.mapToDebuggerPath(string);
        return DebuggerPath.constructor-impl(debuggerPath);
    }

    @NotNull
    public final String mapToDebuggerPath(@NotNull String idePath) {
        Intrinsics.checkNotNullParameter((Object)idePath, (String)"idePath");
        String debuggerPath = idePath;
        int maxIdePathLength = 0;
        Iterator<DapPathMapping> iterator = this.mappings.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<DapPathMapping> iterator2 = iterator;
        while (iterator2.hasNext()) {
            DapPathMapping mapping = iterator2.next();
            String mappedDebuggerPath = mapping.mapToDebuggerPath(idePath);
            if (mappedDebuggerPath == null || mapping.getMyIdePath().length() <= maxIdePathLength) continue;
            debuggerPath = mappedDebuggerPath;
            maxIdePathLength = mapping.getMyIdePath().length();
        }
        return debuggerPath;
    }
}

