/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.dap;

import com.jetbrains.cidr.execution.debugger.backend.dap.CidrConcurrentMessageProcessor;
import com.jetbrains.cidr.execution.debugger.backend.dap.CidrStreamMessageProducer;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.debug.services.IDebugProtocolServer;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.MessageIssueHandler;
import org.eclipse.lsp4j.jsonrpc.MessageProducer;
import org.eclipse.lsp4j.jsonrpc.RemoteEndpoint;
import org.eclipse.lsp4j.jsonrpc.debug.DebugLauncher;
import org.eclipse.lsp4j.jsonrpc.json.ConcurrentMessageProcessor;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\u0006H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0014\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/dap/CidrDebugLauncherBuilder;", "Lorg/eclipse/lsp4j/jsonrpc/debug/DebugLauncher$Builder;", "Lorg/eclipse/lsp4j/debug/services/IDebugProtocolServer;", "<init>", "()V", "create", "Lorg/eclipse/lsp4j/jsonrpc/Launcher;", "createMessageProcessor", "Lorg/eclipse/lsp4j/jsonrpc/json/ConcurrentMessageProcessor;", "reader", "Lorg/eclipse/lsp4j/jsonrpc/MessageProducer;", "messageConsumer", "Lorg/eclipse/lsp4j/jsonrpc/MessageConsumer;", "remoteProxy", "intellij.cidr.debugger.dap"})
public final class CidrDebugLauncherBuilder
extends DebugLauncher.Builder<IDebugProtocolServer> {
    @Nullable
    public Launcher<IDebugProtocolServer> create() {
        if (this.input == null) {
            throw new IllegalStateException("Input stream must be configured.");
        }
        if (this.output == null) {
            throw new IllegalStateException("Output stream must be configured.");
        }
        if (this.localServices == null) {
            throw new IllegalStateException("Local service must be configured.");
        }
        if (this.remoteInterfaces == null) {
            throw new IllegalStateException("Remote interface must be configured.");
        }
        MessageJsonHandler jsonHandler = this.createJsonHandler();
        RemoteEndpoint remoteEndpoint = this.createRemoteEndpoint(jsonHandler);
        IDebugProtocolServer remoteProxy = (IDebugProtocolServer)this.createProxy(remoteEndpoint);
        InputStream inputStream = this.input;
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"input");
        Intrinsics.checkNotNull((Object)jsonHandler);
        Intrinsics.checkNotNull((Object)remoteEndpoint);
        CidrStreamMessageProducer reader = new CidrStreamMessageProducer(inputStream, jsonHandler, (MessageIssueHandler)remoteEndpoint);
        MessageConsumer messageConsumer = this.wrapMessageConsumer((MessageConsumer)remoteEndpoint);
        MessageProducer messageProducer = (MessageProducer)reader;
        Intrinsics.checkNotNull((Object)messageConsumer);
        Intrinsics.checkNotNull((Object)remoteProxy);
        ConcurrentMessageProcessor msgProcessor = this.createMessageProcessor(messageProducer, messageConsumer, remoteProxy);
        ExecutorService executorService = this.executorService;
        if (executorService == null) {
            executorService = Executors.newCachedThreadPool();
        }
        ExecutorService execService = executorService;
        return this.createLauncher(execService, remoteProxy, remoteEndpoint, msgProcessor);
    }

    @NotNull
    protected ConcurrentMessageProcessor createMessageProcessor(@NotNull MessageProducer reader, @NotNull MessageConsumer messageConsumer, @NotNull IDebugProtocolServer remoteProxy) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)messageConsumer, (String)"messageConsumer");
        Intrinsics.checkNotNullParameter((Object)remoteProxy, (String)"remoteProxy");
        return new CidrConcurrentMessageProcessor(reader, messageConsumer);
    }
}

