/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.util.io.BaseOutputReader;
import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.TrivialInstaller;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.LocalHost;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggerDriverConfiguration
extends UserDataHolderBase {
    private volatile String myDebugProcessName = "";

    @NotNull
    @NlsSafe
    public abstract String getDriverName();

    public boolean isAttachSupported() {
        return true;
    }

    public boolean isDetachSupported() {
        return false;
    }

    @NotNull
    public abstract DebuggerDriver createDriver(@NotNull DebuggerDriver.Handler var1, @NotNull ArchitectureType var2) throws ExecutionException;

    @NotNull
    public abstract GeneralCommandLine createDriverCommandLine(@NotNull DebuggerDriver var1, @NotNull ArchitectureType var2) throws ExecutionException;

    @NotNull
    public Installer createInstaller(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            DebuggerDriverConfiguration.$$$reportNull$$$0(0);
        }
        return new TrivialInstaller(commandLine);
    }

    protected static void setupCommonParameters(@NotNull GeneralCommandLine result) {
        if (result == null) {
            DebuggerDriverConfiguration.$$$reportNull$$$0(1);
        }
        result.setCharset(StandardCharsets.UTF_8);
    }

    @Contract(value="null -> null")
    public String convertToLocalPath(@Nullable String absolutePath) {
        return absolutePath;
    }

    @Contract(value="null -> null")
    public String convertToEnvPath(@Nullable String localPath) {
        return localPath;
    }

    public boolean isElevated() {
        return false;
    }

    public boolean emulateTerminal() {
        return false;
    }

    public boolean isContinueAfterAttachNeeded() {
        return true;
    }

    @ApiStatus.Experimental
    public boolean canChangeContinueAfterAttach() {
        return false;
    }

    @ApiStatus.Experimental
    public void setContinueAfterAttachNeeded(@Nullable Boolean value) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public BaseProcessHandler<?> createDebugProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        OSProcessHandler handler;
        HostMachine host;
        if (commandLine == null) {
            DebuggerDriverConfiguration.$$$reportNull$$$0(2);
        }
        if ((host = this.getHostMachine()).isRemote() || this.isElevated()) {
            BaseProcessHandler<?> baseProcessHandler = host.createProcessBuilder().withElevated(this.isElevated()).withRunDebugEnvSetup(true).build(commandLine);
            if (baseProcessHandler == null) {
                DebuggerDriverConfiguration.$$$reportNull$$$0(3);
            }
            return baseProcessHandler;
        }
        OSProcessHandler oSProcessHandler = handler = new OSProcessHandler(commandLine){

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                BaseOutputReader.Options options = BaseOutputReader.Options.BLOCKING;
                if (options == null) {
                    1.$$$reportNull$$$0(0);
                }
                return options;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriverConfiguration$1", "readerOptions"));
            }
        };
        if (oSProcessHandler == null) {
            DebuggerDriverConfiguration.$$$reportNull$$$0(4);
        }
        return oSProcessHandler;
    }

    @NotNull
    public HostMachine getHostMachine() {
        LocalHost localHost = LocalHost.INSTANCE;
        if (localHost == null) {
            DebuggerDriverConfiguration.$$$reportNull$$$0(5);
        }
        return localHost;
    }

    public abstract EvaluationContext createEvaluationContext(@NotNull DebuggerDriver var1, @Nullable Expirable var2, @NotNull LLThread var3, @NotNull LLFrame var4, @NotNull UserDataHolderEx var5);

    @Nullable
    public abstract Language getConsoleLanguage();

    @Deprecated
    public boolean supportsArrayEvaluation() {
        return false;
    }

    @Deprecated
    public boolean isCodeFragmentEvaluationSupported() {
        return false;
    }

    @NotNull
    public String getDesignator() {
        String string = ((Object)((Object)this)).getClass().getName();
        if (string == null) {
            DebuggerDriverConfiguration.$$$reportNull$$$0(6);
        }
        return string;
    }

    @ApiStatus.Experimental
    @NotNull
    public String getDebugProcessName() {
        String string = this.myDebugProcessName;
        if (string == null) {
            DebuggerDriverConfiguration.$$$reportNull$$$0(7);
        }
        return string;
    }

    @ApiStatus.Internal
    public void setDebugProcessName(@NotNull String debugProcessName) {
        if (debugProcessName == null) {
            DebuggerDriverConfiguration.$$$reportNull$$$0(8);
        }
        this.myDebugProcessName = debugProcessName;
    }

    @ApiStatus.Internal
    @Nullable
    public Path getCrashDumpPath() {
        return null;
    }

    @ApiStatus.Experimental
    public boolean enableInstructionBreakpointAdjustment() {
        return false;
    }

    @ApiStatus.Experimental
    public boolean showNonZeroExitCodeWarningAfterDisconnect() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriverConfiguration";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcessName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/DebuggerDriverConfiguration";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDebugProcessHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostMachine";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDesignator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugProcessName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createInstaller";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setupCommonParameters";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createDebugProcessHandler";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setDebugProcessName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

