/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.actions;

import com.intellij.openapi.util.Expirable;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.actions.CidrByteArrayImageDescriptor;
import com.jetbrains.cidr.execution.debugger.actions.CidrCreateImageException;
import com.jetbrains.cidr.execution.debugger.actions.CidrImageDataType;
import com.jetbrains.cidr.execution.debugger.actions.CidrImageDescriptor;
import com.jetbrains.cidr.execution.debugger.actions.CidrImageShape;
import com.jetbrains.cidr.execution.debugger.actions.CidrImageViewer;
import com.jetbrains.cidr.execution.debugger.actions.CidrImageViewerKt;
import com.jetbrains.cidr.execution.debugger.actions.CidrImageViewerProvider;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLMemoryHunk;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015J \u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/CidrOpenCVMatImageViewer;", "Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageViewer;", "value", "Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue;)V", "matrixExpression", "", "Lorg/jetbrains/annotations/NotNull;", "useAsFullValueEvaluator", "", "getUseAsFullValueEvaluator", "()Z", "getImageDescriptor", "Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageDescriptor;", "debugProcess", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "expirable", "Lcom/intellij/openapi/util/Expirable;", "shape", "Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageShape;", "(Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;Lcom/intellij/openapi/util/Expirable;Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageShape;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createImage", "driver", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;", "evalCtx", "Lcom/jetbrains/cidr/execution/debugger/backend/EvaluationContext;", "CVDepth", "Companion", "intellij.cidr.debugger.core"})
public final class CidrOpenCVMatImageViewer
implements CidrImageViewer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String matrixExpression;
    private static final int CV_CN_MAX = 512;
    private static final int CV_CN_SHIFT = 3;
    private static final int CV_DEPTH_MAX = 8;
    private static final int CV_MAT_DEPTH_MASK = 7;
    private static final int CV_MAT_CN_MASK = 4088;

    public CidrOpenCVMatImageViewer(@NotNull CidrPhysicalValue value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        String string = value.getEvaluationExpression();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEvaluationExpression(...)");
        this.matrixExpression = string;
    }

    @Override
    public boolean getUseAsFullValueEvaluator() {
        return true;
    }

    @Override
    @Nullable
    public Object getImageDescriptor(@NotNull CidrDebugProcess debugProcess, @NotNull Expirable expirable, @NotNull CidrImageShape shape, @NotNull Continuation<? super CidrImageDescriptor> $completion) {
        CidrStackFrame frame = CidrImageViewerKt.getCurrentFrame(debugProcess);
        return debugProcess.getDebuggerCommandExecutor().executeCommandSuspend(false, false, expirable, (Function3)new Function3<CoroutineScope, DebuggerDriver, Continuation<? super CidrImageDescriptor>, Object>(debugProcess, expirable, frame, this, shape, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ CidrDebugProcess $debugProcess;
            final /* synthetic */ Expirable $expirable;
            final /* synthetic */ CidrStackFrame $frame;
            final /* synthetic */ CidrOpenCVMatImageViewer this$0;
            final /* synthetic */ CidrImageShape $shape;
            {
                this.$debugProcess = $debugProcess;
                this.$expirable = $expirable;
                this.$frame = $frame;
                this.this$0 = $receiver;
                this.$shape = $shape;
                super(3, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                DebuggerDriver debuggerDriver = (DebuggerDriver)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void driver;
                        ResultKt.throwOnFailure((Object)$result);
                        EvaluationContext evaluationContext = this.$debugProcess.createEvaluationContext((DebuggerDriver)driver, this.$expirable, this.$frame);
                        Intrinsics.checkNotNullExpressionValue((Object)evaluationContext, (String)"createEvaluationContext(...)");
                        EvaluationContext evalCtx = evaluationContext;
                        return CidrOpenCVMatImageViewer.access$createImage(this.this$0, (DebuggerDriver)driver, evalCtx, this.$shape);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(CoroutineScope p1, DebuggerDriver p2, Continuation<? super CidrImageDescriptor> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    private final CidrImageDescriptor createImage(DebuggerDriver driver, EvaluationContext evalCtx, CidrImageShape shape) {
        Object flags;
        CidrImageShape cidrImageShape;
        String string = CidrDebuggerBundle.message("action.CIDR.Debugger.ViewAsImage.unsupportedFormat", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String unsupported = string;
        String matrix = this.matrixExpression;
        LLValueData lLValueData = evalCtx.evaluateData("(void*)" + matrix + ".data");
        Intrinsics.checkNotNullExpressionValue((Object)lLValueData, (String)"evaluateData(...)");
        LLValueData data = lLValueData;
        Address dataStart = data.getPointerAddress();
        if (dataStart == null) {
            String string2 = CidrDebuggerBundle.message("action.CIDR.Debugger.ViewAsImage.failedToGetDataAddress", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            throw new CidrCreateImageException(string2);
        }
        if (!Intrinsics.areEqual((Object)shape, (Object)CidrImageShape.Companion.getDEFAULT())) {
            cidrImageShape = shape;
        } else {
            LLValueData lLValueData2 = evalCtx.evaluateData(matrix + ".flags");
            Intrinsics.checkNotNullExpressionValue((Object)lLValueData2, (String)"evaluateData(...)");
            flags = lLValueData2;
            String string3 = flags.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getValue(...)");
            Integer n = StringsKt.toIntOrNull((String)string3);
            if (n == null) {
                throw new CidrCreateImageException();
            }
            int flagsValue = n;
            CVDepth depth = Companion.getCVMatDepthFromFlags(flagsValue);
            if (depth == CVDepth.CV_16F) {
                throw new CidrCreateImageException(unsupported);
            }
            int channels = Companion.getCVMatChannelsFromFlags(flagsValue);
            String string4 = evalCtx.evaluateData(matrix + ".rows").getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getValue(...)");
            Integer n2 = StringsKt.toIntOrNull((String)string4);
            if (n2 == null) {
                throw new CidrCreateImageException(unsupported);
            }
            int rows = n2;
            String string5 = evalCtx.evaluateData(matrix + ".cols").getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getValue(...)");
            Integer n3 = StringsKt.toIntOrNull((String)string5);
            if (n3 == null) {
                throw new CidrCreateImageException(unsupported);
            }
            int cols = n3;
            if (rows <= 0 || cols <= 0) {
                String string6 = CidrDebuggerBundle.message("debug.imageViewer.wrongDimensions", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
                throw new CidrCreateImageException(string6);
            }
            String string7 = evalCtx.evaluateData(matrix + ".step.buf[0]").getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getValue(...)");
            Integer n4 = StringsKt.toIntOrNull((String)string7);
            if (n4 == null) {
                throw new CidrCreateImageException(unsupported);
            }
            int rowSizeBytes = n4;
            String string8 = evalCtx.evaluateData(matrix + ".step.buf[1]").getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getValue(...)");
            Integer n5 = StringsKt.toIntOrNull((String)string8);
            if (n5 == null) {
                throw new CidrCreateImageException(unsupported);
            }
            int pixelSizeBytes = n5;
            CidrImageDataType dataType = switch (WhenMappings.$EnumSwitchMapping$0[depth.ordinal()]) {
                case 1 -> CidrImageDataType.Uint8;
                case 2 -> CidrImageDataType.Int8;
                case 3 -> CidrImageDataType.Uint16;
                case 4 -> CidrImageDataType.Int16;
                case 5 -> CidrImageDataType.Int32;
                case 6 -> CidrImageDataType.Float32;
                case 7 -> CidrImageDataType.Float64;
                case 8 -> throw new CidrCreateImageException(unsupported);
                default -> throw new NoWhenBranchMatchedException();
            };
            cidrImageShape = new CidrImageShape(cols, rows, channels, dataType, rowSizeBytes, pixelSizeBytes);
        }
        CidrImageShape actualShape = cidrImageShape;
        flags = new int[]{1, 2, 3, 4};
        if (!ArraysKt.contains((int[])flags, (int)actualShape.getChannelsCount())) {
            throw new CidrCreateImageException(unsupported);
        }
        if (actualShape.getImageSizeBytes() > CidrImageViewerProvider.Companion.getMaxImageSizeBytes()) {
            String string9 = CidrDebuggerBundle.message("action.CIDR.Debugger.ViewAsImage.tooBig", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"message(...)");
            throw new CidrCreateImageException(string9);
        }
        List<LLMemoryHunk> list = driver.dumpMemory(AddressUtil.toRange(dataStart, actualShape.getImageSizeBytes()));
        Intrinsics.checkNotNullExpressionValue(list, (String)"dumpMemory(...)");
        List<LLMemoryHunk> memory = list;
        byte[] byArray = CidrImageViewerKt.access$convertToByteArray(memory);
        if (byArray == null) {
            throw new CidrCreateImageException(unsupported);
        }
        byte[] dataBytes = byArray;
        Object[] objectArray = new Object[]{matrix};
        String string10 = CidrDebuggerBundle.message("opencv.image.title", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"message(...)");
        String title = string10;
        return new CidrByteArrayImageDescriptor(actualShape, title, dataStart, dataBytes);
    }

    public static final /* synthetic */ CidrImageDescriptor access$createImage(CidrOpenCVMatImageViewer $this, DebuggerDriver driver, EvaluationContext evalCtx, CidrImageShape shape) {
        return $this.createImage(driver, evalCtx, shape);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/CidrOpenCVMatImageViewer$CVDepth;", "", "<init>", "(Ljava/lang/String;I)V", "CV_8U", "CV_8S", "CV_16U", "CV_16S", "CV_32S", "CV_32F", "CV_64F", "CV_16F", "intellij.cidr.debugger.core"})
    public static final class CVDepth
    extends Enum<CVDepth> {
        public static final /* enum */ CVDepth CV_8U = new CVDepth();
        public static final /* enum */ CVDepth CV_8S = new CVDepth();
        public static final /* enum */ CVDepth CV_16U = new CVDepth();
        public static final /* enum */ CVDepth CV_16S = new CVDepth();
        public static final /* enum */ CVDepth CV_32S = new CVDepth();
        public static final /* enum */ CVDepth CV_32F = new CVDepth();
        public static final /* enum */ CVDepth CV_64F = new CVDepth();
        public static final /* enum */ CVDepth CV_16F = new CVDepth();
        private static final /* synthetic */ CVDepth[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CVDepth[] values() {
            return (CVDepth[])$VALUES.clone();
        }

        public static CVDepth valueOf(String value) {
            return Enum.valueOf(CVDepth.class, value);
        }

        @NotNull
        public static EnumEntries<CVDepth> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = cVDepthArray = new CVDepth[]{CVDepth.CV_8U, CVDepth.CV_8S, CVDepth.CV_16U, CVDepth.CV_16S, CVDepth.CV_32S, CVDepth.CV_32F, CVDepth.CV_64F, CVDepth.CV_16F};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/CidrOpenCVMatImageViewer$Companion;", "", "<init>", "()V", "CV_CN_MAX", "", "CV_CN_SHIFT", "CV_DEPTH_MAX", "CV_MAT_DEPTH_MASK", "CV_MAT_CN_MASK", "getCVMatChannelsFromFlags", "flags", "getCVMatDepthFromFlags", "Lcom/jetbrains/cidr/execution/debugger/actions/CidrOpenCVMatImageViewer$CVDepth;", "intellij.cidr.debugger.core"})
    @SourceDebugExtension(value={"SMAP\nCidrImageViewer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrImageViewer.kt\ncom/jetbrains/cidr/execution/debugger/actions/CidrOpenCVMatImageViewer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,984:1\n1#2:985\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final int getCVMatChannelsFromFlags(int flags) {
            return ((flags & 0xFF8) >> 3) + 1;
        }

        @NotNull
        public final CVDepth getCVMatDepthFromFlags(int flags) {
            Object v0;
            block2: {
                int depth = flags & 7;
                if (!(0 <= depth ? depth < CVDepth.getEntries().size() : false)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                Iterable iterable = (Iterable)CVDepth.getEntries();
                for (Object t : iterable) {
                    CVDepth it = (CVDepth)((Object)t);
                    boolean bl = false;
                    if (!(it.ordinal() == depth)) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            Intrinsics.checkNotNull(v0);
            return v0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CVDepth.values().length];
            try {
                nArray[CVDepth.CV_8U.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CVDepth.CV_8S.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CVDepth.CV_16U.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CVDepth.CV_16S.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CVDepth.CV_32S.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CVDepth.CV_32F.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CVDepth.CV_64F.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CVDepth.CV_16F.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

